/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EditAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        List files2 = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        EditAction.editFilesAndShowErrors(project, files2);
    }

    public static void editFilesAndShowErrors(Project project, List<? extends VirtualFile> files2) {
        ArrayList exceptions = new ArrayList();
        EditAction.editFiles(project, files2, exceptions);
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"edit.errors", (Object[])new Object[0]));
        }
    }

    public static void editFiles(Project project, List<? extends VirtualFile> files2, List<? super VcsException> exceptions) {
        ChangesUtil.processVirtualFilesByVcs((Project)project, files2, (vcs, items) -> {
            EditFileProvider provider = vcs.getEditFileProvider();
            if (provider != null) {
                try {
                    provider.editFiles(VfsUtil.toVirtualFileArray((Collection)items));
                }
                catch (VcsException e1) {
                    exceptions.add(e1);
                }
                for (VirtualFile file2 : items) {
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file2);
                    FileStatusManager.getInstance((Project)project).fileStatusChanged(file2);
                }
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        List files2;
        if (e == null) {
            EditAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (files2 = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY)) != null && !files2.isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/EditAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

