/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public static boolean isScratchesMergedIntoProjectTab() {
        return Registry.is((String)"ide.scratch.in.project.view") && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public ScratchProjectViewPane(final Project project) {
        super(project);
        ScratchProjectViewPane.registerUpdaters(project, this, new Runnable(){
            AbstractProjectViewPane updateTarget;

            @Override
            public void run() {
                if (this.updateTarget == null) {
                    AbstractProjectViewPane abstractProjectViewPane = this.updateTarget = !ScratchProjectViewPane.isScratchesMergedIntoProjectTab() ? ScratchProjectViewPane.this : ProjectView.getInstance(project).getProjectViewPaneById("ProjectPane");
                }
                if (this.updateTarget != null) {
                    this.updateTarget.updateFromRoot(true);
                }
            }
        });
    }

    @Override
    @NotNull
    public String getTitle() {
        if (ID == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(1);
        }
        return ID;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Scope.Scratches;
        if (icon == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        MyTreeStructure myTreeStructure = new MyTreeStructure(this.myProject);
        if (myTreeStructure == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(3);
        }
        return myTreeStructure;
    }

    @Override
    public int getWeight() {
        return 11;
    }

    private static void registerUpdaters(@NotNull Project project, @NotNull Disposable disposable, final @NotNull Runnable onUpdate) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(5);
        }
        if (onUpdate == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(6);
        }
        final String scratchPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)PathManager.getScratchPath()));
        project.getMessageBus().connect(disposable).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean update;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean bl = update = JBIterable.from(events).find(e -> {
                    VirtualFile parent;
                    VirtualFile file2 = e.getFile();
                    VirtualFile virtualFile = parent = file2 == null ? null : file2.getParent();
                    if (parent == null) {
                        return false;
                    }
                    return ScratchUtil.isScratch(parent) || file2.isDirectory() && parent.getPath().startsWith(scratchPath);
                }) != null;
                if (update) {
                    onUpdate.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/scratch/ScratchProjectViewPane$2", "after"));
            }
        });
        for (RootType rootType : RootType.getAllRootTypes()) {
            if (rootType.isHidden()) continue;
            rootType.registerTreeUpdater(project, disposable, onUpdate);
        }
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        ProjectViewSelectInTarget projectViewSelectInTarget = new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                if (!vFile.isInLocalFileSystem()) {
                    return false;
                }
                return ScratchFileService.getInstance().getRootType(vFile) != null;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
        if (projectViewSelectInTarget == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(7);
        }
        return projectViewSelectInTarget;
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootType) {
        VirtualFile virtualFile;
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(8);
        }
        if (rootType == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(9);
        }
        return (virtualFile = ScratchProjectViewPane.getVirtualFile(rootType)) == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull RootType rootType) {
        if (rootType == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(10);
        }
        String path = ScratchFileService.getInstance().getRootPath(rootType);
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Override
    public boolean isInitiallyVisible() {
        return !ScratchProjectViewPane.isScratchesMergedIntoProjectTab();
    }

    @NotNull
    public static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(12);
        }
        MyProjectNode myProjectNode = new MyProjectNode(project, settings);
        if (myProjectNode == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(13);
        }
        return myProjectNode;
    }

    @Nullable
    private static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull RootType rootType, @NotNull ViewSettings settings) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(14);
        }
        if (rootType == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(16);
        }
        if (rootType.isHidden()) {
            return null;
        }
        MyRootNode node = new MyRootNode(project, rootType, settings);
        return node.isEmpty() ? null : node;
    }

    private static void customizePresentation(@NotNull BasePsiNode node, @NotNull PresentationData data) {
        Icon icon;
        MyRootNode rootNode;
        if (node == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(17);
        }
        if (data == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(18);
        }
        VirtualFile file2 = (VirtualFile)ObjectUtils.notNull((Object)node.getVirtualFile());
        Project project = (Project)ObjectUtils.notNull((Object)node.getProject());
        AbstractTreeNode parent = node.getParent();
        MyRootNode myRootNode = parent instanceof MyRootNode ? (MyRootNode)parent : (rootNode = parent instanceof PsiDirectoryNode ? (MyRootNode)((PsiDirectoryNode)parent).getFilter() : null);
        if (rootNode == null) {
            return;
        }
        RootType rootType = rootNode.getRootType();
        String name = rootType.substituteName(project, file2);
        if (name != null) {
            data.setPresentableText(name);
        }
        if ((icon = rootType.substituteIcon(project, file2)) != null) {
            data.setIcon(icon);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructure";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectInTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerUpdaters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project, @NotNull RootType type, ViewSettings settings) {
            if (type == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            super(project, (Object)type, settings);
        }

        @NotNull
        public RootType getRootType() {
            RootType rootType = (RootType)ObjectUtils.notNull((Object)this.getValue());
            if (rootType == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return rootType;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            return ScratchFileService.getInstance().getRootType(file2) == this.getValue();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchProjectViewPane.getVirtualFile(this.getRootType());
        }

        @NotNull
        public Collection<VirtualFile> getRoots() {
            VirtualFile root = this.getVirtualFile();
            Set<VirtualFile> set = root == null ? EMPTY_ROOTS : Collections.singleton(root);
            if (set == null) {
                MyRootNode.$$$reportNull$$$0(3);
            }
            return set;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            Collection<AbstractTreeNode> collection = MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(4);
            }
            return collection;
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyRootNode.$$$reportNull$$$0(5);
            }
            presentation.setIcon(AllIcons.Nodes.Folder);
            presentation.setPresentableText(this.getRootType().getDisplayName());
        }

        public boolean canRepresent(Object element) {
            return Comparing.equal((Object)this.getDirectory(), (Object)element);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project = (Project)ObjectUtils.notNull((Object)this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            if (item == null) {
                MyRootNode.$$$reportNull$$$0(6);
            }
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode> getDirectoryChildrenImpl(final @NotNull Project project, @Nullable PsiDirectory directory, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter) {
            if (project == null) {
                MyRootNode.$$$reportNull$$$0(7);
            }
            if (settings == null) {
                MyRootNode.$$$reportNull$$$0(8);
            }
            if (filter == null) {
                MyRootNode.$$$reportNull$$$0(9);
            }
            final ArrayList result2 = ContainerUtil.newArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (filter.shouldShow(element)) {
                        if (element instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project, (PsiDirectory)element, settings, filter){

                                @Override
                                public Collection<AbstractTreeNode> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }

                                @Override
                                protected void updateImpl(@NotNull PresentationData data) {
                                    if (data == null) {
                                        MyRootNode.1.$$$reportNull$$$0(0);
                                    }
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1$1", "updateImpl"));
                                }
                            });
                        } else if (element instanceof PsiFile) {
                            result2.add(new PsiFileNode(project, (PsiFile)element, settings){

                                @Override
                                public Comparable getTypeSortKey() {
                                    PsiFile value = (PsiFile)this.getValue();
                                    Language language = value == null ? null : value.getLanguage();
                                    LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }

                                @Override
                                protected void updateImpl(@NotNull PresentationData data) {
                                    if (data == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1$2", "updateImpl"));
                                }
                            });
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1", "execute"));
                }
            };
            Collection collection = (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> MyRootNode.lambda$getDirectoryChildrenImpl$0(directory, (PsiElementProcessor)processor2, result2));
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(10);
            }
            return collection;
        }

        private static /* synthetic */ List lambda$getDirectoryChildrenImpl$0(PsiDirectory directory, PsiElementProcessor processor2, List result2) {
            if (directory == null || !directory.isValid()) {
                return Collections.emptyList();
            }
            directory.processChildren(processor2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldShow";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project, ViewSettings settings) {
            super(project, (Object)"Scratches and Consoles", settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProjectNode.$$$reportNull$$$0(0);
            }
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list2 = ContainerUtil.newArrayList();
            for (RootType rootType : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull((Collection)list2, (Object)ScratchProjectViewPane.createRootNode(this.getProject(), rootType, this.getSettings()));
            }
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyProjectNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyProjectNode.$$$reportNull$$$0(2);
            }
            presentation.setPresentableText((String)this.getValue());
            presentation.setIcon(AllIcons.Scope.Scratches);
        }

        public boolean canRepresent(Object element) {
            VirtualFile virtualFile;
            PsiElement item = element instanceof PsiElement ? (PsiElement)element : null;
            VirtualFile virtualFile2 = virtualFile = item == null ? null : PsiUtilCore.getVirtualFile((PsiElement)item);
            if (virtualFile == null) {
                return false;
            }
            return Comparing.equal((String)virtualFile.getPath(), (String)FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(@NotNull Project project) {
            if (project == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            super(project, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
            if (project == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                MyTreeStructure.$$$reportNull$$$0(2);
            }
            return ScratchProjectViewPane.createRootNode(project, settings);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyTreeStructure";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyStructureProvider
    implements TreeStructureProvider,
    DumbAware {
        @NotNull
        public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
            Project project;
            if (parent == null) {
                MyStructureProvider.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                MyStructureProvider.$$$reportNull$$$0(1);
            }
            Project project2 = project = parent instanceof ProjectViewProjectNode ? parent.getProject() : null;
            if (project == null || !ScratchProjectViewPane.isScratchesMergedIntoProjectTab()) {
                Collection<AbstractTreeNode> collection = children2;
                if (collection == null) {
                    MyStructureProvider.$$$reportNull$$$0(2);
                }
                return collection;
            }
            if (children2.isEmpty() && JBIterable.from((Iterable)RootType.getAllRootTypes()).filterMap(o -> ScratchProjectViewPane.createRootNode(project, o, settings)).isEmpty()) {
                Collection<AbstractTreeNode> collection = children2;
                if (collection == null) {
                    MyStructureProvider.$$$reportNull$$$0(3);
                }
                return collection;
            }
            ArrayList<AbstractTreeNode> list2 = new ArrayList<AbstractTreeNode>(children2.size() + 1);
            list2.addAll(children2);
            list2.add(ScratchProjectViewPane.createRootNode(project, settings));
            ArrayList<AbstractTreeNode> arrayList = list2;
            if (arrayList == null) {
                MyStructureProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Nullable
        public Object getData(@NotNull Collection<AbstractTreeNode> selected, @NotNull String dataId) {
            AbstractTreeNode single;
            if (selected == null) {
                MyStructureProvider.$$$reportNull$$$0(5);
            }
            if (dataId == null) {
                MyStructureProvider.$$$reportNull$$$0(6);
            }
            if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (single = (AbstractTreeNode)JBIterable.from(selected).single()) instanceof MyRootNode) {
                VirtualFile file2 = ((MyRootNode)single).getVirtualFile();
                Project project = single.getProject();
                return file2 == null || project == null ? null : PsiManager.getInstance((Project)project).findDirectory(file2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyStructureProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyStructureProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "modify";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

