/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import org.jetbrains.annotations.NotNull;

public class RemoveUnnecessaryBackslashQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.remove.unnecessary.backslash", new Object[0]);
        if (string == null) {
            RemoveUnnecessaryBackslashQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement problemElement;
        if (project == null) {
            RemoveUnnecessaryBackslashQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            RemoveUnnecessaryBackslashQuickFix.$$$reportNull$$$0(2);
        }
        if ((problemElement = descriptor2.getPsiElement()) != null) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)problemElement, (Class[])PythonEnterHandler.IMPLICIT_WRAP_CLASSES);
            RemoveUnnecessaryBackslashQuickFix.removeBackSlash(parent);
        }
    }

    public static void removeBackSlash(PsiElement parent) {
        if (parent != null) {
            Stack stack = new Stack();
            if (parent instanceof PyParenthesizedExpression) {
                stack.push((Object)((PyParenthesizedExpression)parent).getContainedExpression());
            } else {
                stack.push((Object)parent);
            }
            while (!stack.isEmpty()) {
                PsiElement el = (PsiElement)stack.pop();
                PsiWhiteSpace[] children = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)el, PsiWhiteSpace.class);
                if (children != null) {
                    for (PsiWhiteSpace psiWhiteSpace : children) {
                        if (!psiWhiteSpace.getText().contains("\\")) continue;
                        psiWhiteSpace.delete();
                    }
                }
                for (PsiWhiteSpace psiWhiteSpace : el.getChildren()) {
                    stack.push((Object)psiWhiteSpace);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RemoveUnnecessaryBackslashQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RemoveUnnecessaryBackslashQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

