/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import org.jetbrains.annotations.NonNls;

public class PyCharmInitialConfigurator {
    @NonNls
    private static final String DISPLAYED_PROPERTY = "PyCharm.initialConfigurationShown";

    public PyCharmInitialConfigurator(MessageBus bus, final PropertiesComponent propertiesComponent, FileTypeManager fileTypeManager) {
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration", "true");
            EditorSettingsExternalizable.getInstance().setVirtualSpace(false);
        }
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration.V2")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration.V2", true);
            CodeStyleSettings settings = CodeStyle.getDefaultSettings();
            settings.getCommonSettings((Language)PythonLanguage.getInstance()).ALIGN_MULTILINE_PARAMETERS_IN_CALLS = true;
        }
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration.V3")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration.V3", "true");
            String ignoredFilesList = fileTypeManager.getIgnoredFilesList();
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> FileTypeManager.getInstance().setIgnoredFilesList(ignoredFilesList + ";*$py.class")));
        }
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration.V4")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration.V4", true);
            PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP = false;
        }
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration.V5")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration.V5", true);
            CodeInsightSettings.getInstance().REFORMAT_ON_PASTE = 1;
        }
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration.V6")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration.V6", true);
            CodeInsightSettings.getInstance().INDENT_TO_CARET_ON_PASTE = true;
        }
        if (!propertiesComponent.getBoolean("PyCharm.InitialConfiguration.V7")) {
            propertiesComponent.setValue("PyCharm.InitialConfiguration.V7", true);
        }
        PyCharmInitialConfigurator.disableRunAnything();
        if (!propertiesComponent.isValueSet(DISPLAYED_PROPERTY)) {
            bus.connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void welcomeScreenDisplayed() {
                    ApplicationManager.getApplication().invokeLater(() -> propertiesComponent.setValue(PyCharmInitialConfigurator.DISPLAYED_PROPERTY, "true"));
                }
            });
        }
        Registry.get((String)"ide.ssh.one.time.password").setValue(true);
    }

    private static void disableRunAnything() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ActionManager manager = ActionManager.getInstance();
            DefaultActionGroup group = (DefaultActionGroup)ObjectUtils.tryCast((Object)manager.getAction("ToolbarRunGroup"), DefaultActionGroup.class);
            AnAction runAnythingAction = manager.getAction("RunAnything");
            if (group != null && runAnythingAction != null) {
                group.remove(runAnythingAction);
            }
            manager.unregisterAction("RunAnything");
        }, ModalityState.any());
    }
}

