/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.render;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RendererRegistry {
    private static final Log log = PlatformUtil.getLog(RendererRegistry.class);
    public static final String DEFAULT_RENDER = "OsmAnd";
    public static final String DEFAULT_RENDER_FILE_PATH = "default.render.xml";
    public static final String TOURING_VIEW = "Touring view (contrast and details)";
    public static final String WINTER_SKI_RENDER = "Winter and ski";
    public static final String NAUTICAL_RENDER = "Nautical";
    private RenderingRulesStorage defaultRender = null;
    private RenderingRulesStorage currentSelectedRender = null;
    private Map<String, File> externalRenderers = new LinkedHashMap<String, File>();
    private Map<String, String> internalRenderers = new LinkedHashMap<String, String>();
    private Map<String, RenderingRulesStorage> renderers = new LinkedHashMap<String, RenderingRulesStorage>();
    private IRendererLoadedEventListener rendererLoadedEventListener;
    private OsmWindow app;

    public RendererRegistry(OsmWindow app) {
        this.app = app;
        this.internalRenderers.put(DEFAULT_RENDER, DEFAULT_RENDER_FILE_PATH);
        this.internalRenderers.put(TOURING_VIEW, "Touring-view_(more-contrast-and-details).render.xml");
        this.internalRenderers.put("UniRS", "UniRS.render.xml");
        this.internalRenderers.put("LightRS", "LightRS.render.xml");
        this.internalRenderers.put(NAUTICAL_RENDER, "nautical.render.xml");
        this.internalRenderers.put(WINTER_SKI_RENDER, "skimap.render.xml");
    }

    public RenderingRulesStorage defaultRender() {
        if (this.defaultRender == null) {
            this.defaultRender = this.getRenderer(DEFAULT_RENDER);
        }
        return this.defaultRender;
    }

    public RenderingRulesStorage getRenderer(String name) {
        if (this.renderers.containsKey(name)) {
            return this.renderers.get(name);
        }
        if (!this.hasRender(name)) {
            return null;
        }
        try {
            RenderingRulesStorage r = this.loadRenderer(name, new LinkedHashMap<String, RenderingRulesStorage>(), new LinkedHashMap<String, String>());
            this.renderers.put(name, r);
            return r;
        }
        catch (IOException e) {
            log.error((Object)"Error loading renderer", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Error loading renderer", (Throwable)e);
        }
        return null;
    }

    private boolean hasRender(String name) {
        return this.externalRenderers.containsKey(name) || this.internalRenderers.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderingRulesStorage loadRenderer(String name, final Map<String, RenderingRulesStorage> loadedRenderers, final Map<String, String> renderingConstants) throws IOException, XmlPullParserException {
        InputStream is = this.getInputStream(name);
        if (is == null) {
            return null;
        }
        try {
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            while ((tok = parser.next()) != 1) {
                String tagName;
                if (tok != 2 || !(tagName = parser.getName()).equals("renderingConstant") || renderingConstants.containsKey(parser.getAttributeValue("", "name"))) continue;
                renderingConstants.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
            }
        }
        finally {
            is.close();
        }
        is = this.getInputStream(name);
        RenderingRulesStorage main = new RenderingRulesStorage(name, renderingConstants);
        loadedRenderers.put(name, main);
        try {
            main.parseRulesFromXmlInputStream(is, new RenderingRulesStorage.RenderingRulesStorageResolver(){

                @Override
                public RenderingRulesStorage resolve(String name, RenderingRulesStorage.RenderingRulesStorageResolver ref) throws XmlPullParserException {
                    if (loadedRenderers.containsKey(name)) {
                        log.warn((Object)("Circular dependencies found " + name));
                    }
                    RenderingRulesStorage dep = null;
                    try {
                        dep = RendererRegistry.this.loadRenderer(name, loadedRenderers, renderingConstants);
                    }
                    catch (IOException e) {
                        log.warn((Object)("Dependent renderer not found : " + e.getMessage()), (Throwable)e);
                    }
                    if (dep == null) {
                        log.warn((Object)("Dependent renderer not found : " + name));
                    }
                    return dep;
                }
            });
        }
        finally {
            is.close();
        }
        if (this.rendererLoadedEventListener != null) {
            this.rendererLoadedEventListener.onRendererLoaded(name, main, this.getInputStream(name));
        }
        return main;
    }

    public InputStream getInputStream(String name) throws FileNotFoundException {
        InputStream is;
        if ("default".equalsIgnoreCase(name)) {
            name = DEFAULT_RENDER;
        }
        if (this.externalRenderers.containsKey(name)) {
            is = new FileInputStream(this.externalRenderers.get(name));
        } else if (this.internalRenderers.containsKey(name)) {
            File fl = this.getFileForInternalStyle(name);
            if (fl.exists()) {
                is = new FileInputStream(fl);
            } else {
                this.copyFileForInternalStyle(name);
                is = this.app.getResource("rendering_styles/" + this.internalRenderers.get(name));
            }
        } else {
            throw new IllegalArgumentException("Not found " + name);
        }
        return is;
    }

    public void copyFileForInternalStyle(String name) {
        try {
            FileOutputStream fout = new FileOutputStream(this.getFileForInternalStyle(name));
            Algorithms.streamCopy(this.app.getResource("rendering_styles/" + this.internalRenderers.get(name)), fout);
            fout.close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getInternalRenderers() {
        return this.internalRenderers;
    }

    public File getFileForInternalStyle(String name) {
        if (!this.internalRenderers.containsKey(name)) {
            return new File(this.app.getAppPath("rendering_styles/"), "style.render.xml");
        }
        File fl = new File(this.app.getAppPath("rendering_styles/"), this.internalRenderers.get(name));
        return fl;
    }

    public void initRenderers(IProgress progress) {
        RenderingRulesStorage obj;
        File[] lf;
        File file = this.app.getAppPath("rendering_styles/");
        file.mkdirs();
        LinkedHashMap<String, File> externalRenderers = new LinkedHashMap<String, File>();
        if (file.exists() && file.canRead() && (lf = file.listFiles()) != null) {
            for (File f : lf) {
                if (f == null || !f.getName().endsWith(".render.xml") || this.internalRenderers.containsValue(f.getName())) continue;
                String name = f.getName().substring(0, f.getName().length() - ".render.xml".length());
                externalRenderers.put(name, f);
            }
        }
        this.externalRenderers = externalRenderers;
        String r = this.app.getSettings().RENDERER.get();
        if (r != null && (obj = this.getRenderer(r)) != null) {
            this.setCurrentSelectedRender(obj);
        }
    }

    public Collection<String> getRendererNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(DEFAULT_RENDER);
        names.addAll(this.internalRenderers.keySet());
        names.addAll(this.externalRenderers.keySet());
        return names;
    }

    public RenderingRulesStorage getCurrentSelectedRenderer() {
        if (this.currentSelectedRender == null) {
            return this.defaultRender();
        }
        return this.currentSelectedRender;
    }

    public void setCurrentSelectedRender(RenderingRulesStorage currentSelectedRender) {
        this.currentSelectedRender = currentSelectedRender;
    }

    public void setRendererLoadedEventListener(IRendererLoadedEventListener listener) {
        this.rendererLoadedEventListener = listener;
    }

    public IRendererLoadedEventListener getRendererLoadedEventListener() {
        return this.rendererLoadedEventListener;
    }

    public static interface IRendererLoadedEventListener {
        public void onRendererLoaded(String var1, RenderingRulesStorage var2, InputStream var3);
    }
}

