/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.common.IncompleteSourceWithMetadataException;
import org.logstash.config.ir.CompiledPipeline;
import org.logstash.execution.AbstractPipelineExt;
import org.logstash.execution.queue.QueueWriter;
import org.logstash.ext.JRubyWrappedWriteClientExt;
import org.logstash.plugins.PluginFactoryExt;

@JRubyClass(name={"JavaBasePipeline"})
public final class JavaBasePipelineExt
extends AbstractPipelineExt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(JavaBasePipelineExt.class);
    private CompiledPipeline lirExecution;
    private RubyArray inputs;
    private RubyArray filters;
    private RubyArray outputs;

    public JavaBasePipelineExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=4)
    public JavaBasePipelineExt initialize(ThreadContext context, IRubyObject[] args) throws IncompleteSourceWithMetadataException, NoSuchAlgorithmException {
        this.initialize(context, args[0], args[1], args[2]);
        this.lirExecution = new CompiledPipeline(this.lir, new PluginFactoryExt.Plugins(context.runtime, RubyUtil.PLUGIN_FACTORY_CLASS).init(this.lir, new PluginFactoryExt.Metrics(context.runtime, RubyUtil.PLUGIN_METRIC_FACTORY_CLASS).initialize(context, this.pipelineId(), (IRubyObject)this.metric()), new PluginFactoryExt.ExecutionContext(context.runtime, RubyUtil.EXECUTION_CONTEXT_FACTORY_CLASS).initialize(context, args[3], (IRubyObject)this, this.dlqWriter(context)), RubyUtil.FILTER_DELEGATOR_CLASS));
        this.inputs = RubyArray.newArray((Ruby)context.runtime, this.lirExecution.inputs());
        this.filters = RubyArray.newArray((Ruby)context.runtime, this.lirExecution.filters());
        this.outputs = RubyArray.newArray((Ruby)context.runtime, this.lirExecution.outputs());
        if (this.getSetting(context, "config.debug").isTrue() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiled pipeline code for pipeline {} : {}", (Object)this.pipelineId(), (Object)this.lir.getGraph().toString());
        }
        return this;
    }

    @JRubyMethod(name={"lir_execution"})
    public IRubyObject lirExecution(ThreadContext context) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.lirExecution);
    }

    @JRubyMethod
    public RubyArray inputs() {
        return this.inputs;
    }

    @JRubyMethod
    public RubyArray filters() {
        return this.filters;
    }

    @JRubyMethod
    public RubyArray outputs() {
        return this.outputs;
    }

    @JRubyMethod(name={"reloadable?"})
    public RubyBoolean isReloadable(ThreadContext context) {
        return this.isConfiguredReloadable(context).isTrue() && this.reloadablePlugins(context).isTrue() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"reloadable_plugins?"})
    public RubyBoolean reloadablePlugins(ThreadContext context) {
        return this.nonReloadablePlugins(context).isEmpty() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"non_reloadable_plugins"})
    public RubyArray nonReloadablePlugins(ThreadContext context) {
        RubyArray result = RubyArray.newArray((Ruby)context.runtime);
        Stream.of(this.inputs, this.outputs, this.filters).flatMap(plugins -> plugins.stream()).filter(plugin -> !plugin.callMethod(context, "reloadable?").isTrue()).forEach(arg_0 -> ((RubyArray)result).add(arg_0));
        return result;
    }

    public QueueWriter getQueueWriter(String inputName) {
        return new JRubyWrappedWriteClientExt(RubyUtil.RUBY, RubyUtil.WRAPPED_WRITE_CLIENT_CLASS).initialize(RubyUtil.RUBY.getCurrentContext(), new IRubyObject[]{this.inputQueueClient(), this.pipelineId().convertToString().intern(), this.metric(), RubyUtil.RUBY.newSymbol(inputName)});
    }
}

