"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;

var _public = require("../../../embeddable_api/public");

var _actions = require("../actions");

var _embeddable = require("../embeddable");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Plugin =
/*#__PURE__*/
function () {
  function Plugin(initializerContext) {
    _classCallCheck(this, Plugin);
  }

  _createClass(Plugin, [{
    key: "setup",
    value: function setup(core, plugins) {
      plugins.embeddable.addAction(new _actions.ExpandPanelAction());
      plugins.embeddable.attachAction({
        triggerId: _public.CONTEXT_MENU_TRIGGER,
        actionId: _actions.EXPAND_PANEL_ACTION
      });
    }
  }, {
    key: "start",
    value: function start(core, plugins) {
      plugins.embeddable.addEmbeddableFactory(new _embeddable.DashboardContainerFactory({
        capabilities: core.application.capabilities.dashboard
      }));
    }
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return Plugin;
}();

exports.Plugin = Plugin;