import { unsafeMonoidArray } from './Monoid';
import { none, some } from './Option';
import { max as maxOrd, min as minOrd } from './Ord';
import { identity } from './function';
import { foldMap } from './Foldable';
import { applyFirst } from './Apply';
export function getFoldableComposition(F, G) {
    return {
        reduce: (fga, b, f) => F.reduce(fga, b, (b, ga) => G.reduce(ga, b, f)),
        foldMap: M => {
            const foldMapF = F.foldMap(M);
            const foldMapG = G.foldMap(M);
            return (fa, f) => foldMapF(fa, ga => foldMapG(ga, f));
        },
        foldr: (fa, b, f) => F.foldr(fa, b, (ga, b) => G.foldr(ga, b, f))
    };
}
export function fold(M, F) {
    return fa => F.reduce(fa, M.empty, M.concat);
}
export function foldM(M, F) {
    return (fa, b, f) => F.reduce(fa, M.of(b), (mb, a) => M.chain(mb, b => f(b, a)));
}
export function sequence_(M, F) {
    const traverseMF = traverse_(M, F);
    return fa => traverseMF(fa, identity);
}
export function oneOf(P, F) {
    return fga => F.reduce(fga, P.zero(), P.alt);
}
export function intercalate(M, F) {
    return (sep, fm) => {
        const go = ({ init, acc }, x) => init ? { init: false, acc: x } : { init: false, acc: M.concat(M.concat(acc, sep), x) };
        return F.reduce(fm, { init: true, acc: M.empty }, go).acc;
    };
}
export function sum(S, F) {
    return fa => F.reduce(fa, S.zero, S.add);
}
export function product(S, F) {
    return fa => F.reduce(fa, S.one, S.mul);
}
export function elem(S, F) {
    return (a, fa) => F.reduce(fa, false, (b, x) => b || S.equals(x, a));
}
export function findFirst(F) {
    return (fa, p) => F.reduce(fa, none, (b, a) => {
        if (b.isNone() && p(a)) {
            return some(a);
        }
        else {
            return b;
        }
    });
}
export function min(O, F) {
    const minO = minOrd(O);
    return fa => F.reduce(fa, none, (b, a) => (b.isNone() ? some(a) : some(minO(b.value, a))));
}
export function max(O, F) {
    const maxO = maxOrd(O);
    return fa => F.reduce(fa, none, (b, a) => (b.isNone() ? some(a) : some(maxO(b.value, a))));
}
export function toArray(F) {
    const foldMapF = foldMap(F, unsafeMonoidArray);
    return fa => foldMapF(fa, a => [a]);
}
export function traverse_(M, F) {
    const toArrayF = toArray(F);
    const applyFirstM = applyFirst(M);
    const initialValue = M.of(undefined);
    return (fa, f) => toArrayF(fa).reduce((mu, a) => applyFirstM(mu, f(a)), initialValue);
}
export function member(S, F) {
    return elem(S, F);
}
