import { getApplicativeComposition } from './Applicative';
import { either, left as eitherLeft, right as eitherRight } from './Either';
export function fold(F) {
    return (left, right, fa) => F.map(fa, e => (e.isLeft() ? left(e.value) : right(e.value)));
}
export function getEitherT2v(M) {
    const applicativeComposition = getApplicativeComposition(M, either);
    return Object.assign({}, applicativeComposition, { chain: (fa, f) => M.chain(fa, e => (e.isLeft() ? M.of(eitherLeft(e.value)) : f(e.value))) });
}
/** @deprecated */
// tslint:disable-next-line: deprecation
export function chain(F) {
    return (f, fa) => F.chain(fa, e => (e.isLeft() ? F.of(eitherLeft(e.value)) : f(e.value)));
}
/** @deprecated */
// tslint:disable-next-line: deprecation
export function getEitherT(M) {
    const applicativeComposition = getApplicativeComposition(M, either);
    return Object.assign({}, applicativeComposition, { 
        // tslint:disable-next-line: deprecation
        chain: chain(M) });
}
/** @deprecated */
export function right(F) {
    return (fa) => F.map(fa, eitherRight);
}
/** @deprecated */
export function left(F) {
    return (fl) => F.map(fl, eitherLeft);
}
/** @deprecated */
export function fromEither(F) {
    return F.of;
}
/** @deprecated */
export function mapLeft(F) {
    return f => fa => F.map(fa, e => e.mapLeft(f));
}
/** @deprecated */
export function bimap(F) {
    return (fa, f, g) => F.map(fa, e => e.bimap(f, g));
}
