"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var simple_noise_1 = require("./simple_noise");
var DataGenerator = /** @class */ (function () {
    function DataGenerator(frequency) {
        if (frequency === void 0) { frequency = 500; }
        this.generator = new simple_noise_1.Simple1DNoise();
        this.frequency = frequency;
    }
    DataGenerator.prototype.generateSimpleSeries = function (totalPoints, group) {
        var _this = this;
        if (totalPoints === void 0) { totalPoints = 50; }
        if (group === void 0) { group = 1; }
        var dataPoints = new Array(totalPoints).fill(0).map(function (value, i) {
            return {
                x: i,
                y: 3 + Math.sin(i / _this.frequency) + _this.generator.getValue(i),
                g: group,
            };
        });
        return dataPoints;
    };
    DataGenerator.prototype.generateGroupedSeries = function (totalPoints, totalGroups) {
        var _this = this;
        if (totalPoints === void 0) { totalPoints = 50; }
        if (totalGroups === void 0) { totalGroups = 2; }
        var groups = new Array(totalGroups).fill(0).map(function (group, i) {
            return _this.generateSimpleSeries(totalPoints, i);
        });
        return groups.reduce(function (acc, curr) { return __spread(acc, curr); });
    };
    return DataGenerator;
}());
exports.DataGenerator = DataGenerator;
//# sourceMappingURL=data_generator.js.map