"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../utils/commons");
var light_theme_1 = require("./light_theme");
exports.BaseThemeTypes = Object.freeze({
    Light: 'light',
    Dark: 'dark',
});
exports.DEFAULT_GRID_LINE_CONFIG = {
    stroke: 'red',
    strokeWidth: 1,
    opacity: 1,
};
exports.DEFAULT_ANNOTATION_LINE_STYLE = {
    line: {
        stroke: '#000',
        strokeWidth: 3,
        opacity: 1,
    },
    details: {
        fontSize: 10,
        fontFamily: "'Open Sans', Helvetica, Arial, sans-serif",
        fontStyle: 'normal',
        fill: 'gray',
        padding: 0,
    },
};
exports.DEFAULT_ANNOTATION_RECT_STYLE = {
    stroke: '#e5e5e5',
    strokeWidth: 1,
    opacity: 0.5,
    fill: '#e5e5e5',
};
function mergeWithDefaultGridLineConfig(config) {
    var strokeWidth = config.strokeWidth != null ? config.strokeWidth : exports.DEFAULT_GRID_LINE_CONFIG.strokeWidth;
    var opacity = config.opacity != null ? config.opacity : exports.DEFAULT_GRID_LINE_CONFIG.opacity;
    return {
        stroke: config.stroke || exports.DEFAULT_GRID_LINE_CONFIG.stroke,
        dash: config.dash || exports.DEFAULT_GRID_LINE_CONFIG.dash,
        strokeWidth: strokeWidth,
        opacity: opacity,
    };
}
exports.mergeWithDefaultGridLineConfig = mergeWithDefaultGridLineConfig;
function mergeWithDefaultAnnotationLine(config) {
    var defaultLine = exports.DEFAULT_ANNOTATION_LINE_STYLE.line;
    var defaultDetails = exports.DEFAULT_ANNOTATION_LINE_STYLE.details;
    var mergedConfig = __assign({}, exports.DEFAULT_ANNOTATION_LINE_STYLE);
    if (!config) {
        return mergedConfig;
    }
    if (config.line) {
        mergedConfig.line = __assign({}, defaultLine, config.line);
    }
    if (config.details) {
        mergedConfig.details = __assign({}, defaultDetails, config.details);
    }
    return mergedConfig;
}
exports.mergeWithDefaultAnnotationLine = mergeWithDefaultAnnotationLine;
function mergeWithDefaultAnnotationRect(config) {
    if (!config) {
        return exports.DEFAULT_ANNOTATION_RECT_STYLE;
    }
    return __assign({}, exports.DEFAULT_ANNOTATION_RECT_STYLE, config);
}
exports.mergeWithDefaultAnnotationRect = mergeWithDefaultAnnotationRect;
function mergeWithDefaultTheme(theme, defaultTheme) {
    if (defaultTheme === void 0) { defaultTheme = light_theme_1.LIGHT_THEME; }
    return commons_1.mergePartial(defaultTheme, theme);
}
exports.mergeWithDefaultTheme = mergeWithDefaultTheme;
//# sourceMappingURL=theme.js.map