"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function formatNonStackedDataSeriesValues(dataseries, scaleToExtent) {
    var len = dataseries.length;
    var i;
    var formattedValues = [];
    for (i = 0; i < len; i++) {
        var formattedValue = formatNonStackedDataValues(dataseries[i], scaleToExtent);
        formattedValues.push(formattedValue);
    }
    return formattedValues;
}
exports.formatNonStackedDataSeriesValues = formatNonStackedDataSeriesValues;
function formatNonStackedDataValues(dataSeries, scaleToExtent) {
    var len = dataSeries.data.length;
    var i;
    var formattedValues = {
        key: dataSeries.key,
        specId: dataSeries.specId,
        seriesColorKey: dataSeries.seriesColorKey,
        data: [],
    };
    for (i = 0; i < len; i++) {
        var data = dataSeries.data[i];
        var x = data.x, y1 = data.y1, datum = data.datum;
        var y0 = void 0;
        if (y1 === null) {
            y0 = null;
        }
        else {
            if (scaleToExtent) {
                y0 = data.y0 ? data.y0 : y1;
            }
            else {
                y0 = data.y0 ? data.y0 : 0;
            }
        }
        var formattedValue = {
            x: x,
            y1: y1,
            y0: y0,
            initialY1: y1,
            initialY0: data.y0 == null || y1 === null ? null : data.y0,
            datum: datum,
        };
        formattedValues.data.push(formattedValue);
    }
    return formattedValues;
}
exports.formatNonStackedDataValues = formatNonStackedDataValues;
//# sourceMappingURL=nonstacked_series_utils.js.map