/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Image;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonCollectors;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class ImageryInfo
extends TileSourceInfo
implements Comparable<ImageryInfo>,
Attributed {
    private String origName;
    private String langName;
    private boolean defaultEntry;
    private String eulaAcceptanceRequired;
    private ImageryType imageryType = ImageryType.WMS;
    private double pixelPerDegree;
    private int defaultMaxZoom;
    private int defaultMinZoom;
    private ImageryBounds bounds;
    private List<String> serverProjections = Collections.emptyList();
    private String description;
    private String langDescription;
    private String attributionText;
    private String permissionReferenceURL;
    private String attributionLinkURL;
    private String attributionImage;
    private String attributionImageURL;
    private String termsOfUseText;
    private String termsOfUseURL;
    private String countryCode = "";
    private String date;
    private boolean bestMarked;
    private boolean overlay;
    private Collection<String> oldIds;
    private List<ImageryInfo> mirrors;
    private String icon;
    private boolean isGeoreferenceValid;
    private List<DefaultLayer> defaultLayers = new ArrayList<DefaultLayer>();
    private Map<String, String> customHttpHeaders = new ConcurrentHashMap<String, String>();
    private boolean transparent = true;
    private int minimumTileExpire = (int)TimeUnit.MILLISECONDS.toSeconds(TMSCachedTileLoaderJob.MINIMUM_EXPIRES.get());
    private ImageryCategory category;
    private String categoryOriginalString;
    private static final Map<String, String> localizedCountriesCache = new HashMap<String, String>();

    public ImageryInfo() {
    }

    public ImageryInfo(String name) {
        super(name);
    }

    public ImageryInfo(String name, String url) {
        this(name);
        this.setExtendedUrl(url);
    }

    public ImageryInfo(String name, String url, String eulaAcceptanceRequired) {
        this(name);
        this.setExtendedUrl(url);
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public ImageryInfo(String name, String url, String type, String eulaAcceptanceRequired, String cookies) {
        this(name);
        this.setExtendedUrl(url);
        ImageryType t = ImageryType.fromString(type);
        this.cookies = cookies;
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
        if (t != null) {
            this.imageryType = t;
        } else if (type != null && !type.isEmpty()) {
            throw new IllegalArgumentException("unknown type: " + type);
        }
    }

    public ImageryInfo(String name, String url, String type, String eulaAcceptanceRequired, String cookies, String id) {
        this(name, url, type, eulaAcceptanceRequired, cookies);
        this.setId(id);
    }

    public ImageryInfo(ImageryPreferenceEntry e) {
        super(e.name, e.url, e.id);
        CheckParameterUtil.ensureParameterNotNull(e.name, "name");
        CheckParameterUtil.ensureParameterNotNull(e.url, "url");
        this.description = e.description;
        this.cookies = e.cookies;
        this.eulaAcceptanceRequired = e.eula;
        this.imageryType = ImageryType.fromString(e.type);
        if (this.imageryType == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this.pixelPerDegree = e.pixel_per_eastnorth;
        this.defaultMaxZoom = e.max_zoom;
        this.defaultMinZoom = e.min_zoom;
        if (e.bounds != null) {
            this.bounds = new ImageryBounds(e.bounds, ",");
            if (e.shapes != null) {
                try {
                    for (String s : e.shapes.split(";")) {
                        this.bounds.addShape(new Shape(s, ","));
                    }
                }
                catch (IllegalArgumentException ex) {
                    Logging.warn(ex);
                }
            }
        }
        if (e.projections != null && !e.projections.isEmpty()) {
            this.serverProjections = Arrays.asList(e.projections.split(","));
        }
        this.attributionText = e.attribution_text;
        this.attributionLinkURL = e.attribution_url;
        this.permissionReferenceURL = e.permission_reference_url;
        this.attributionImage = e.logo_image;
        this.attributionImageURL = e.logo_url;
        this.date = e.date;
        this.bestMarked = e.bestMarked;
        this.overlay = e.overlay;
        this.termsOfUseText = e.terms_of_use_text;
        this.termsOfUseURL = e.terms_of_use_url;
        this.countryCode = e.country_code;
        this.icon = e.icon;
        if (e.noTileHeaders != null) {
            this.noTileHeaders = e.noTileHeaders.toMap();
        }
        if (e.noTileChecksums != null) {
            this.noTileChecksums = e.noTileChecksums.toMap();
        }
        this.setTileSize(e.tileSize);
        this.metadataHeaders = e.metadataHeaders;
        this.isGeoreferenceValid = e.valid_georeference;
        this.modTileFeatures = e.modTileFeatures;
        if (e.default_layers != null) {
            try (JsonReader jsonReader = Json.createReader(new StringReader(e.default_layers));){
                this.defaultLayers = jsonReader.readArray().stream().map(x -> DefaultLayer.fromJson((JsonObject)x, this.imageryType)).collect(Collectors.toList());
            }
        }
        this.customHttpHeaders = e.customHttpHeaders;
        this.transparent = e.transparent;
        this.minimumTileExpire = e.minimumTileExpire;
        this.category = ImageryCategory.fromString(e.category);
    }

    public ImageryInfo(ImageryInfo i) {
        super(i.name, i.url, i.id);
        this.noTileHeaders = i.noTileHeaders;
        this.noTileChecksums = i.noTileChecksums;
        this.minZoom = i.minZoom;
        this.maxZoom = i.maxZoom;
        this.cookies = i.cookies;
        this.tileSize = i.tileSize;
        this.metadataHeaders = i.metadataHeaders;
        this.modTileFeatures = i.modTileFeatures;
        this.origName = i.origName;
        this.langName = i.langName;
        this.defaultEntry = i.defaultEntry;
        this.eulaAcceptanceRequired = null;
        this.imageryType = i.imageryType;
        this.pixelPerDegree = i.pixelPerDegree;
        this.defaultMaxZoom = i.defaultMaxZoom;
        this.defaultMinZoom = i.defaultMinZoom;
        this.bounds = i.bounds;
        this.serverProjections = i.serverProjections;
        this.description = i.description;
        this.langDescription = i.langDescription;
        this.attributionText = i.attributionText;
        this.permissionReferenceURL = i.permissionReferenceURL;
        this.attributionLinkURL = i.attributionLinkURL;
        this.attributionImage = i.attributionImage;
        this.attributionImageURL = i.attributionImageURL;
        this.termsOfUseText = i.termsOfUseText;
        this.termsOfUseURL = i.termsOfUseURL;
        this.countryCode = i.countryCode;
        this.date = i.date;
        this.bestMarked = i.bestMarked;
        this.overlay = i.overlay;
        this.icon = i.icon;
        this.isGeoreferenceValid = i.isGeoreferenceValid;
        this.defaultLayers = i.defaultLayers;
        this.customHttpHeaders = i.customHttpHeaders;
        this.transparent = i.transparent;
        this.minimumTileExpire = i.minimumTileExpire;
        this.category = i.category;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.imageryType});
    }

    public boolean equalsPref(ImageryInfo other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && Objects.equals(this.modTileFeatures, other.modTileFeatures) && Objects.equals(this.bestMarked, other.bestMarked) && Objects.equals(this.overlay, other.overlay) && Objects.equals(this.isGeoreferenceValid, other.isGeoreferenceValid) && Objects.equals(this.cookies, other.cookies) && Objects.equals(this.eulaAcceptanceRequired, other.eulaAcceptanceRequired) && Objects.equals((Object)this.imageryType, (Object)other.imageryType) && Objects.equals(this.defaultMaxZoom, other.defaultMaxZoom) && Objects.equals(this.defaultMinZoom, other.defaultMinZoom) && Objects.equals(this.bounds, other.bounds) && Objects.equals(this.serverProjections, other.serverProjections) && Objects.equals(this.attributionText, other.attributionText) && Objects.equals(this.attributionLinkURL, other.attributionLinkURL) && Objects.equals(this.permissionReferenceURL, other.permissionReferenceURL) && Objects.equals(this.attributionImageURL, other.attributionImageURL) && Objects.equals(this.attributionImage, other.attributionImage) && Objects.equals(this.termsOfUseText, other.termsOfUseText) && Objects.equals(this.termsOfUseURL, other.termsOfUseURL) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.date, other.date) && Objects.equals(this.icon, other.icon) && Objects.equals(this.description, other.description) && Objects.equals(this.noTileHeaders, other.noTileHeaders) && Objects.equals(this.noTileChecksums, other.noTileChecksums) && Objects.equals(this.metadataHeaders, other.metadataHeaders) && Objects.equals(this.defaultLayers, other.defaultLayers) && Objects.equals(this.customHttpHeaders, other.customHttpHeaders) && Objects.equals(this.transparent, other.transparent) && Objects.equals(this.minimumTileExpire, other.minimumTileExpire) && Objects.equals((Object)this.category, (Object)other.category);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageryInfo that = (ImageryInfo)o;
        return this.imageryType == that.imageryType && Objects.equals(this.url, that.url);
    }

    public static String getLocalizedCountry(String countryCode) {
        return localizedCountriesCache.computeIfAbsent(countryCode, code -> new Locale("en", (String)code).getDisplayCountry());
    }

    public String toString() {
        return "ImageryInfo{" + "name='" + this.name + '\'' + ", countryCode='" + this.countryCode + '\'' + ", localizedCountry='" + ImageryInfo.getLocalizedCountry(this.countryCode) + '\'' + ", url='" + this.url + '\'' + ", imageryType=" + (Object)((Object)this.imageryType) + '}';
    }

    @Override
    public int compareTo(ImageryInfo in) {
        int i = this.countryCode.compareTo(in.countryCode);
        if (i == 0) {
            i = this.name.toLowerCase(Locale.ENGLISH).compareTo(in.name.toLowerCase(Locale.ENGLISH));
        }
        if (i == 0) {
            i = this.url.compareTo(in.url);
        }
        if (i == 0) {
            i = Double.compare(this.pixelPerDegree, in.pixelPerDegree);
        }
        return i;
    }

    public boolean equalsBaseValues(ImageryInfo in) {
        return this.url.equals(in.url);
    }

    public void setPixelPerDegree(double ppd) {
        this.pixelPerDegree = ppd;
    }

    public void setDefaultMaxZoom(int defaultMaxZoom) {
        this.defaultMaxZoom = defaultMaxZoom;
    }

    public void setDefaultMinZoom(int defaultMinZoom) {
        this.defaultMinZoom = defaultMinZoom;
    }

    public void setBounds(ImageryBounds b) {
        this.bounds = b;
    }

    public ImageryBounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean requiresAttribution() {
        return this.attributionText != null || this.attributionLinkURL != null || this.attributionImage != null || this.termsOfUseText != null || this.termsOfUseURL != null;
    }

    @Override
    public String getAttributionText(int zoom, ICoordinate topLeft, ICoordinate botRight) {
        return this.attributionText;
    }

    @Override
    public String getAttributionLinkURL() {
        return this.attributionLinkURL;
    }

    public String getPermissionReferenceURL() {
        return this.permissionReferenceURL;
    }

    @Override
    public Image getAttributionImage() {
        ImageIcon i = ImageProvider.getIfAvailable(this.attributionImage);
        if (i != null) {
            return i.getImage();
        }
        return null;
    }

    public String getAttributionImageRaw() {
        return this.attributionImage;
    }

    @Override
    public String getAttributionImageURL() {
        return this.attributionImageURL;
    }

    @Override
    public String getTermsOfUseText() {
        return this.termsOfUseText;
    }

    @Override
    public String getTermsOfUseURL() {
        return this.termsOfUseURL;
    }

    public void setAttributionText(String text) {
        this.attributionText = text;
    }

    public void setAttributionImageURL(String url) {
        this.attributionImageURL = url;
    }

    public void setAttributionImage(String res) {
        this.attributionImage = res;
    }

    public void setAttributionLinkURL(String url) {
        this.attributionLinkURL = url;
    }

    public void setPermissionReferenceURL(String url) {
        this.permissionReferenceURL = url;
    }

    public void setTermsOfUseText(String text) {
        this.termsOfUseText = text;
    }

    public void setTermsOfUseURL(String text) {
        this.termsOfUseURL = text;
    }

    public void setExtendedUrl(String url) {
        CheckParameterUtil.ensureParameterNotNull(url);
        this.url = url;
        this.imageryType = ImageryType.WMS;
        this.defaultMaxZoom = 0;
        this.defaultMinZoom = 0;
        for (ImageryType type : ImageryType.values()) {
            Matcher m = Pattern.compile(type.getTypeString() + "(?:\\[(?:(\\d+)[,-])?(\\d+)\\])?:(.*)").matcher(url);
            if (!m.matches()) continue;
            this.url = m.group(3);
            this.imageryType = type;
            if (m.group(2) != null) {
                this.defaultMaxZoom = Integer.parseInt(m.group(2));
            }
            if (m.group(1) == null) break;
            this.defaultMinZoom = Integer.parseInt(m.group(1));
            break;
        }
        if (this.serverProjections.isEmpty()) {
            this.serverProjections = new ArrayList<String>();
            Matcher m = Pattern.compile(".*\\{PROJ\\(([^)}]+)\\)\\}.*").matcher(url.toUpperCase(Locale.ENGLISH));
            if (m.matches()) {
                for (String p : m.group(1).split(",")) {
                    this.serverProjections.add(p);
                }
            }
        }
    }

    public String getOriginalName() {
        return this.origName != null ? this.origName : this.name;
    }

    public void setName(String language, String name) {
        boolean isdefault = LanguageInfo.getJOSMLocaleCode(null).equals(language);
        if (LanguageInfo.isBetterLanguage(this.langName, language)) {
            this.name = isdefault ? I18n.tr(name, new Object[0]) : name;
            this.langName = language;
        }
        if (this.origName == null || isdefault) {
            this.origName = name;
        }
    }

    public void clearId() {
        if (this.id != null) {
            TreeSet<String> newAddedIds = new TreeSet<String>(Config.getPref().getList("imagery.layers.addedIds"));
            newAddedIds.add(this.id);
            Config.getPref().putList("imagery.layers.addedIds", new ArrayList<String>(newAddedIds));
        }
        this.setId(null);
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(boolean defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    @Override
    public int getMaxZoom() {
        return this.defaultMaxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.defaultMinZoom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String language, String description) {
        boolean isdefault = LanguageInfo.getJOSMLocaleCode(null).equals(language);
        if (LanguageInfo.isBetterLanguage(this.langDescription, language)) {
            this.description = isdefault ? I18n.tr(description, new Object[0]) : description;
            this.langDescription = language;
        }
    }

    public static Collection<String> getActiveIds() {
        List<ImageryPreferenceEntry> entries;
        ArrayList<String> ids = new ArrayList<String>();
        IPreferences pref = Config.getPref();
        if (pref != null && (entries = StructUtils.getListOfStructs(pref, "imagery.entries", null, ImageryPreferenceEntry.class)) != null) {
            for (ImageryPreferenceEntry prefEntry : entries) {
                if (prefEntry.id == null || prefEntry.id.isEmpty()) continue;
                ids.add(prefEntry.id);
            }
            Collections.sort(ids);
        }
        return ids;
    }

    public String getToolTipText() {
        String desc;
        StringBuilder res = new StringBuilder(this.getName());
        boolean html = false;
        String dateStr = this.getDate();
        if (dateStr != null && !dateStr.isEmpty()) {
            res.append("<br>").append(I18n.tr("Date of imagery: {0}", dateStr));
            html = true;
        }
        if (this.category != null && this.category.getDescription() != null) {
            res.append("<br>").append(I18n.tr("Imagery category: {0}", this.category.getDescription()));
            html = true;
        }
        if (this.bestMarked) {
            res.append("<br>").append(I18n.tr("This imagery is marked as best in this region in other editors.", new Object[0]));
            html = true;
        }
        if (this.overlay) {
            res.append("<br>").append(I18n.tr("This imagery is an overlay.", new Object[0]));
            html = true;
        }
        if ((desc = this.getDescription()) != null && !desc.isEmpty()) {
            res.append("<br>").append(Utils.escapeReservedCharactersHTML(desc));
            html = true;
        }
        if (html) {
            res.insert(0, "<html>").append("</html>");
        }
        return res.toString();
    }

    public String getEulaAcceptanceRequired() {
        return this.eulaAcceptanceRequired;
    }

    public void setEulaAcceptanceRequired(String eulaAcceptanceRequired) {
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<String> getServerProjections() {
        return Collections.unmodifiableList(this.serverProjections);
    }

    public void setServerProjections(Collection<String> serverProjections) {
        CheckParameterUtil.ensureParameterNotNull(serverProjections, "serverProjections");
        this.serverProjections = new ArrayList<String>(serverProjections);
    }

    public String getExtendedUrl() {
        return this.imageryType.getTypeString() + (this.defaultMaxZoom != 0 ? '[' + (this.defaultMinZoom != 0 ? Integer.toString(this.defaultMinZoom) + ',' : "") + this.defaultMaxZoom + ']' : "") + ':' + this.url;
    }

    public String getToolbarName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + "#PPD=" + this.pixelPerDegree;
        }
        return res;
    }

    public String getMenuName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + " (" + this.pixelPerDegree + ')';
        }
        return res;
    }

    public boolean hasAttribution() {
        return this.attributionText != null;
    }

    public void copyAttribution(ImageryInfo i) {
        this.attributionImage = i.attributionImage;
        this.attributionImageURL = i.attributionImageURL;
        this.attributionText = i.attributionText;
        this.attributionLinkURL = i.attributionLinkURL;
        this.termsOfUseText = i.termsOfUseText;
        this.termsOfUseURL = i.termsOfUseURL;
    }

    public void setAttribution(AbstractTileSource s) {
        ImageIcon i;
        if (this.attributionText != null) {
            if ("osm".equals(this.attributionText)) {
                s.setAttributionText(new OsmTileSource.Mapnik().getAttributionText(0, null, null));
            } else {
                s.setAttributionText(this.attributionText);
            }
        }
        if (this.attributionLinkURL != null) {
            if ("osm".equals(this.attributionLinkURL)) {
                s.setAttributionLinkURL(new OsmTileSource.Mapnik().getAttributionLinkURL());
            } else {
                s.setAttributionLinkURL(this.attributionLinkURL);
            }
        }
        if (this.attributionImage != null && (i = ImageProvider.getIfAvailable(null, this.attributionImage)) != null) {
            s.setAttributionImage(i.getImage());
        }
        if (this.attributionImageURL != null) {
            s.setAttributionImageURL(this.attributionImageURL);
        }
        if (this.termsOfUseText != null) {
            s.setTermsOfUseText(this.termsOfUseText);
        }
        if (this.termsOfUseURL != null) {
            if ("osm".equals(this.termsOfUseURL)) {
                s.setTermsOfUseURL(new OsmTileSource.Mapnik().getTermsOfUseURL());
            } else {
                s.setTermsOfUseURL(this.termsOfUseURL);
            }
        }
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    public void setImageryType(ImageryType imageryType) {
        this.imageryType = imageryType;
    }

    public ImageryCategory getImageryCategory() {
        return this.category;
    }

    public void setImageryCategory(ImageryCategory category) {
        this.category = category;
    }

    public String getImageryCategoryOriginalString() {
        return this.categoryOriginalString;
    }

    public void setImageryCategoryOriginalString(String categoryOriginalString) {
        this.categoryOriginalString = categoryOriginalString;
    }

    public boolean isBlacklisted() {
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        return capabilities != null && capabilities.isOnImageryBlacklist(this.url);
    }

    public void setNoTileHeaders(MultiMap<String, String> noTileHeaders) {
        this.noTileHeaders = noTileHeaders == null || noTileHeaders.isEmpty() ? null : noTileHeaders.toMap();
    }

    @Override
    public Map<String, Set<String>> getNoTileHeaders() {
        return this.noTileHeaders;
    }

    public void setNoTileChecksums(MultiMap<String, String> noTileChecksums) {
        this.noTileChecksums = noTileChecksums == null || noTileChecksums.isEmpty() ? null : noTileChecksums.toMap();
    }

    @Override
    public Map<String, Set<String>> getNoTileChecksums() {
        return this.noTileChecksums;
    }

    public void setMetadataHeaders(Map<String, String> metadataHeaders) {
        this.metadataHeaders = metadataHeaders == null || metadataHeaders.isEmpty() ? null : metadataHeaders;
    }

    public boolean isGeoreferenceValid() {
        return this.isGeoreferenceValid;
    }

    public void setGeoreferenceValid(boolean isGeoreferenceValid) {
        this.isGeoreferenceValid = isGeoreferenceValid;
    }

    public boolean isBestMarked() {
        return this.bestMarked;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setBestMarked(boolean bestMarked) {
        this.bestMarked = bestMarked;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public void addOldId(String id) {
        if (this.oldIds == null) {
            this.oldIds = new ArrayList<String>();
        }
        this.oldIds.add(id);
    }

    public Collection<String> getOldIds() {
        return this.oldIds;
    }

    public void addMirror(ImageryInfo entry) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<ImageryInfo>();
        }
        this.mirrors.add(entry);
    }

    public List<ImageryInfo> getMirrors() {
        ArrayList<ImageryInfo> l = new ArrayList<ImageryInfo>();
        if (this.mirrors != null) {
            int num = 1;
            for (ImageryInfo i : this.mirrors) {
                ImageryInfo n = new ImageryInfo(this);
                if (i.defaultMaxZoom != 0) {
                    n.defaultMaxZoom = i.defaultMaxZoom;
                }
                if (i.defaultMinZoom != 0) {
                    n.defaultMinZoom = i.defaultMinZoom;
                }
                n.setServerProjections(i.getServerProjections());
                n.url = i.url;
                n.imageryType = i.imageryType;
                if (i.getTileSize() != 0) {
                    n.setTileSize(i.getTileSize());
                }
                if (n.id != null) {
                    n.id = n.id + "_mirror" + num;
                }
                if (num > 1) {
                    n.name = I18n.tr("{0} mirror server {1}", n.name, num);
                    if (n.origName != null) {
                        n.origName = n.origName + " mirror server " + num;
                    }
                } else {
                    n.name = I18n.tr("{0} mirror server", n.name);
                    if (n.origName != null) {
                        n.origName = n.origName + " mirror server";
                    }
                }
                l.add(n);
                ++num;
            }
        }
        return l;
    }

    public List<DefaultLayer> getDefaultLayers() {
        return this.defaultLayers;
    }

    public void setDefaultLayers(List<DefaultLayer> layers) {
        this.defaultLayers = layers;
    }

    public Map<String, String> getCustomHttpHeaders() {
        if (this.customHttpHeaders == null) {
            return Collections.emptyMap();
        }
        return this.customHttpHeaders;
    }

    public void setCustomHttpHeaders(Map<String, String> customHttpHeaders) {
        this.customHttpHeaders = customHttpHeaders;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public int getMinimumTileExpire() {
        return this.minimumTileExpire;
    }

    public void setMinimumTileExpire(int minimumTileExpire) {
        this.minimumTileExpire = minimumTileExpire;
    }

    public String getSourceName() {
        Optional<ImageryInfo> infoEn;
        if (ImageryType.BING == this.getImageryType()) {
            return "Bing";
        }
        if (this.id != null && (infoEn = ImageryLayerInfo.allDefaultLayers.stream().filter(x -> this.id.equals(x.getId())).findAny()).isPresent()) {
            return infoEn.get().getOriginalName();
        }
        return this.getOriginalName();
    }

    static {
        localizedCountriesCache.put("", I18n.tr("Worldwide", new Object[0]));
    }

    public static class ImageryPreferenceEntry {
        @StructUtils.StructEntry
        String name;
        @StructUtils.StructEntry
        String d;
        @StructUtils.StructEntry
        String id;
        @StructUtils.StructEntry
        String type;
        @StructUtils.StructEntry
        String url;
        @StructUtils.StructEntry
        double pixel_per_eastnorth;
        @StructUtils.StructEntry
        String eula;
        @StructUtils.StructEntry
        String attribution_text;
        @StructUtils.StructEntry
        String attribution_url;
        @StructUtils.StructEntry
        String permission_reference_url;
        @StructUtils.StructEntry
        String logo_image;
        @StructUtils.StructEntry
        String logo_url;
        @StructUtils.StructEntry
        String terms_of_use_text;
        @StructUtils.StructEntry
        String terms_of_use_url;
        @StructUtils.StructEntry
        String country_code = "";
        @StructUtils.StructEntry
        String date;
        @StructUtils.StructEntry
        int max_zoom;
        @StructUtils.StructEntry
        int min_zoom;
        @StructUtils.StructEntry
        String cookies;
        @StructUtils.StructEntry
        String bounds;
        @StructUtils.StructEntry
        String shapes;
        @StructUtils.StructEntry
        String projections;
        @StructUtils.StructEntry
        String icon;
        @StructUtils.StructEntry
        String description;
        @StructUtils.StructEntry
        MultiMap<String, String> noTileHeaders;
        @StructUtils.StructEntry
        MultiMap<String, String> noTileChecksums;
        @StructUtils.StructEntry
        int tileSize = -1;
        @StructUtils.StructEntry
        Map<String, String> metadataHeaders;
        @StructUtils.StructEntry
        boolean valid_georeference;
        @StructUtils.StructEntry
        boolean bestMarked;
        @StructUtils.StructEntry
        boolean modTileFeatures;
        @StructUtils.StructEntry
        boolean overlay;
        @StructUtils.StructEntry
        String default_layers;
        @StructUtils.StructEntry
        Map<String, String> customHttpHeaders;
        @StructUtils.StructEntry
        boolean transparent;
        @StructUtils.StructEntry
        int minimumTileExpire;
        @StructUtils.StructEntry
        String category;

        public ImageryPreferenceEntry() {
        }

        public ImageryPreferenceEntry(ImageryInfo i) {
            this.name = i.name;
            this.id = i.id;
            this.type = i.imageryType.getTypeString();
            this.url = i.url;
            this.pixel_per_eastnorth = i.pixelPerDegree;
            this.eula = i.eulaAcceptanceRequired;
            this.attribution_text = i.attributionText;
            this.attribution_url = i.attributionLinkURL;
            this.permission_reference_url = i.permissionReferenceURL;
            this.date = i.date;
            this.bestMarked = i.bestMarked;
            this.overlay = i.overlay;
            this.logo_image = i.attributionImage;
            this.logo_url = i.attributionImageURL;
            this.terms_of_use_text = i.termsOfUseText;
            this.terms_of_use_url = i.termsOfUseURL;
            this.country_code = i.countryCode;
            this.max_zoom = i.defaultMaxZoom;
            this.min_zoom = i.defaultMinZoom;
            this.cookies = i.cookies;
            this.icon = i.icon;
            this.description = i.description;
            String string = this.category = i.category != null ? i.category.getCategoryString() : null;
            if (i.bounds != null) {
                this.bounds = i.bounds.encodeAsString(",");
                StringBuilder shapesString = new StringBuilder();
                for (Shape s : i.bounds.getShapes()) {
                    if (shapesString.length() > 0) {
                        shapesString.append(';');
                    }
                    shapesString.append(s.encodeAsString(","));
                }
                if (shapesString.length() > 0) {
                    this.shapes = shapesString.toString();
                }
            }
            if (!i.serverProjections.isEmpty()) {
                this.projections = i.serverProjections.stream().collect(Collectors.joining(","));
            }
            if (i.noTileHeaders != null && !i.noTileHeaders.isEmpty()) {
                this.noTileHeaders = new MultiMap(i.noTileHeaders);
            }
            if (i.noTileChecksums != null && !i.noTileChecksums.isEmpty()) {
                this.noTileChecksums = new MultiMap(i.noTileChecksums);
            }
            if (i.metadataHeaders != null && !i.metadataHeaders.isEmpty()) {
                this.metadataHeaders = i.metadataHeaders;
            }
            this.tileSize = i.getTileSize();
            this.valid_georeference = i.isGeoreferenceValid();
            this.modTileFeatures = i.isModTileFeatures();
            if (!i.defaultLayers.isEmpty()) {
                this.default_layers = i.defaultLayers.stream().map(DefaultLayer::toJson).collect(JsonCollectors.toJsonArray()).toString();
            }
            this.customHttpHeaders = i.customHttpHeaders;
            this.transparent = i.isTransparent();
            this.minimumTileExpire = i.minimumTileExpire;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("ImageryPreferenceEntry [name=").append(this.name);
            if (this.id != null) {
                s.append(" id=").append(this.id);
            }
            s.append(']');
            return s.toString();
        }
    }

    public static class ImageryBounds
    extends Bounds {
        private List<Shape> shapes = new ArrayList<Shape>();

        public ImageryBounds(String asString, String separator) {
            super(asString, separator);
        }

        public final void addShape(Shape shape) {
            this.shapes.add(shape);
        }

        public final void setShapes(List<Shape> shapes) {
            this.shapes = shapes;
        }

        public final List<Shape> getShapes() {
            return this.shapes;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.shapes);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImageryBounds that = (ImageryBounds)o;
            return Objects.equals(this.shapes, that.shapes);
        }
    }

    public static enum ImageryCategory {
        PHOTO("photo", I18n.tr("Aerial or satellite photo", new Object[0])),
        MAP("map", I18n.tr("Map", new Object[0])),
        HISTORICMAP("historicmap", I18n.tr("Historic or otherwise outdated map", new Object[0])),
        OSMBASEDMAP("osmbasedmap", I18n.tr("Map based on OSM data", new Object[0])),
        HISTORICPHOTO("historicphoto", I18n.tr("Historic or otherwise outdated aerial or satellite photo", new Object[0])),
        OTHER("other", I18n.tr("Imagery not matching any other category", new Object[0]));

        private final String category;
        private final String description;
        private static final Map<ImageProvider.ImageSizes, Map<ImageryCategory, ImageIcon>> iconCache;

        private ImageryCategory(String category, String description) {
            this.category = category;
            this.description = description;
        }

        public final String getCategoryString() {
            return this.category;
        }

        public final String getDescription() {
            return this.description;
        }

        public final ImageIcon getIcon(ImageProvider.ImageSizes size) {
            return iconCache.computeIfAbsent(size, x -> Collections.synchronizedMap(new EnumMap(ImageryCategory.class))).computeIfAbsent(this, x -> ImageProvider.get("data/imagery", x.category, size));
        }

        public static ImageryCategory fromString(String s) {
            for (ImageryCategory category : ImageryCategory.values()) {
                if (!category.getCategoryString().equals(s)) continue;
                return category;
            }
            return null;
        }

        static {
            iconCache = Collections.synchronizedMap(new EnumMap(ImageProvider.ImageSizes.class));
        }
    }

    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        BING("bing"),
        SCANEX("scanex"),
        WMS_ENDPOINT("wms_endpoint"),
        WMTS("wmts");

        private final String typeString;

        private ImageryType(String typeString) {
            this.typeString = typeString;
        }

        public final String getTypeString() {
            return this.typeString;
        }

        public static ImageryType fromString(String s) {
            for (ImageryType type : ImageryType.values()) {
                if (!type.getTypeString().equals(s)) continue;
                return type;
            }
            return null;
        }
    }
}

