/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class SplitWayCommand
extends SequenceCommand {
    private static volatile Consumer<String> warningNotifier = Logging::warn;
    private final List<? extends PrimitiveId> newSelection;
    private final Way originalWay;
    private final List<Way> newWays;
    private static final Map<String, String> relationSpecialTypes = new HashMap<String, String>();

    public static void setWarningNotifier(Consumer<String> notifier) {
        warningNotifier = Objects.requireNonNull(notifier);
    }

    public SplitWayCommand(String name, Collection<Command> commandList, List<? extends PrimitiveId> newSelection, Way originalWay, List<Way> newWays) {
        super(name, commandList);
        this.newSelection = newSelection;
        this.originalWay = originalWay;
        this.newWays = newWays;
    }

    public List<? extends PrimitiveId> getNewSelection() {
        return this.newSelection;
    }

    public Way getOriginalWay() {
        return this.originalWay;
    }

    public List<Way> getNewWays() {
        return this.newWays;
    }

    public static List<List<Node>> buildSplitChunks(Way wayToSplit, List<Node> splitPoints) {
        CheckParameterUtil.ensureParameterNotNull(wayToSplit, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(splitPoints, "splitPoints");
        HashSet<Node> nodeSet = new HashSet<Node>(splitPoints);
        LinkedList<List<Node>> wayChunks = new LinkedList<List<Node>>();
        ArrayList<Node> currentWayChunk = new ArrayList<Node>();
        wayChunks.add(currentWayChunk);
        Iterator<Node> it = wayToSplit.getNodes().iterator();
        while (it.hasNext()) {
            Node currentNode = it.next();
            boolean atEndOfWay = currentWayChunk.isEmpty() || !it.hasNext();
            currentWayChunk.add(currentNode);
            if (!nodeSet.contains(currentNode) || atEndOfWay) continue;
            currentWayChunk = new ArrayList();
            currentWayChunk.add(currentNode);
            wayChunks.add(currentWayChunk);
        }
        List lastWayChunk = (List)wayChunks.get(wayChunks.size() - 1);
        if (wayChunks.size() >= 2 && ((List)wayChunks.get(0)).get(0) == lastWayChunk.get(lastWayChunk.size() - 1) && !nodeSet.contains(((List)wayChunks.get(0)).get(0))) {
            if (wayChunks.size() == 2) {
                warningNotifier.accept(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0]));
                return null;
            }
            lastWayChunk.remove(lastWayChunk.size() - 1);
            lastWayChunk.addAll((Collection)wayChunks.get(0));
            wayChunks.remove(wayChunks.size() - 1);
            wayChunks.set(0, lastWayChunk);
        }
        if (wayChunks.size() < 2) {
            if (((List)wayChunks.get(0)).get(0) == ((List)wayChunks.get(0)).get(((List)wayChunks.get(0)).size() - 1)) {
                warningNotifier.accept(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0]));
            } else {
                warningNotifier.accept(I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)", new Object[0]));
            }
            return null;
        }
        return wayChunks;
    }

    public static List<Way> createNewWaysFromChunks(Way way, Iterable<List<Node>> wayChunks) {
        ArrayList<Way> newWays = new ArrayList<Way>();
        for (List<Node> wayChunk : wayChunks) {
            Way wayToAdd = new Way();
            wayToAdd.setKeys(way.getKeys());
            wayToAdd.setNodes(wayChunk);
            newWays.add(wayToAdd);
        }
        return newWays;
    }

    public static SplitWayCommand splitWay(Way way, List<List<Node>> wayChunks, Collection<? extends OsmPrimitive> selection) {
        return SplitWayCommand.splitWay(way, wayChunks, selection, Strategy.keepLongestChunk());
    }

    public static SplitWayCommand splitWay(Way way, List<List<Node>> wayChunks, Collection<? extends OsmPrimitive> selection, Strategy splitStrategy) {
        ArrayList<OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(selection.size() + wayChunks.size());
        newSelection.addAll(selection);
        List<Way> newWays = SplitWayCommand.createNewWaysFromChunks(way, wayChunks);
        Way wayToKeep = splitStrategy.determineWayToKeep(newWays);
        return wayToKeep != null ? SplitWayCommand.doSplitWay(way, wayToKeep, newWays, newSelection) : null;
    }

    public static SplitWayCommand doSplitWay(Way way, Way wayToKeep, List<Way> newWays, List<OsmPrimitive> newSelection) {
        ArrayList<Command> commandList = new ArrayList<Command>(newWays.size());
        List<String> nowarnroles = Config.getPref().getList("way.split.roles.nowarn", Arrays.asList("outer", "inner", "forward", "backward", "north", "south", "east", "west"));
        Way changedWay = new Way(way);
        changedWay.setNodes(wayToKeep.getNodes());
        commandList.add(new ChangeCommand(way, changedWay));
        if (newSelection != null && !newSelection.contains(way)) {
            newSelection.add(way);
        }
        int indexOfWayToKeep = newWays.indexOf(wayToKeep);
        newWays.remove(wayToKeep);
        if (newSelection != null) {
            newSelection.addAll(newWays);
        }
        for (Way wayToAdd : newWays) {
            commandList.add(new AddCommand(way.getDataSet(), wayToAdd));
        }
        boolean warnmerole = false;
        boolean warnme = false;
        for (Relation r : OsmPrimitive.getParentRelations(Collections.singleton(way))) {
            if (!r.isUsable()) continue;
            Relation c = null;
            String type = Optional.ofNullable(r.get("type")).orElse("");
            int ic = 0;
            int ir = 0;
            List<RelationMember> relationMembers = r.getMembers();
            for (RelationMember rm : relationMembers) {
                if (rm.isWay() && rm.getMember() == way) {
                    boolean insert = true;
                    if (relationSpecialTypes.containsKey(type) && "restriction".equals(relationSpecialTypes.get(type))) {
                        RelationInformation rValue = SplitWayCommand.treatAsRestriction(r, rm, c, newWays, way, changedWay);
                        warnme = rValue.warnme;
                        insert = rValue.insert;
                        c = rValue.relation;
                    } else if (!"route".equals(type) && !"multipolygon".equals(type)) {
                        warnme = true;
                    }
                    if (c == null) {
                        c = new Relation(r);
                    }
                    if (insert) {
                        if (rm.hasRole() && !nowarnroles.contains(rm.getRole())) {
                            warnmerole = true;
                        }
                        Boolean backwards = null;
                        int k = 1;
                        while (ir - k >= 0 || ir + k < relationMembers.size()) {
                            if (ir - k >= 0 && relationMembers.get(ir - k).isWay()) {
                                Way w = relationMembers.get(ir - k).getWay();
                                if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                    backwards = Boolean.FALSE;
                                    break;
                                }
                                if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                                backwards = Boolean.TRUE;
                                break;
                            }
                            if (ir + k < relationMembers.size() && relationMembers.get(ir + k).isWay()) {
                                Way w = relationMembers.get(ir + k).getWay();
                                if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                    backwards = Boolean.TRUE;
                                    break;
                                }
                                if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                                backwards = Boolean.FALSE;
                                break;
                            }
                            ++k;
                        }
                        int j = ic;
                        List<Way> waysToAddBefore = newWays.subList(0, indexOfWayToKeep);
                        for (Way wayToAdd : waysToAddBefore) {
                            RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
                            ++j;
                            if (Boolean.TRUE.equals(backwards)) {
                                c.addMember(ic + 1, em);
                                continue;
                            }
                            c.addMember(j - 1, em);
                        }
                        List<Way> waysToAddAfter = newWays.subList(indexOfWayToKeep, newWays.size());
                        for (Way wayToAdd : waysToAddAfter) {
                            RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
                            ++j;
                            if (Boolean.TRUE.equals(backwards)) {
                                c.addMember(ic, em);
                                continue;
                            }
                            c.addMember(j, em);
                        }
                        ic = j;
                    }
                }
                ++ic;
                ++ir;
            }
            if (c == null) continue;
            commandList.add(new ChangeCommand(r.getDataSet(), r, c));
        }
        if (warnmerole) {
            warningNotifier.accept(I18n.tr("A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0]));
        } else if (warnme) {
            warningNotifier.accept(I18n.tr("A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0]));
        }
        return new SplitWayCommand(I18n.trn("Split way {0} into {1} part", "Split way {0} into {1} parts", newWays.size() + 1, way.getDisplayName(DefaultNameFormatter.getInstance()), newWays.size() + 1), commandList, newSelection, way, newWays);
    }

    private static RelationInformation treatAsRestriction(Relation r, RelationMember rm, Relation c, Collection<Way> newWays, Way way, Way changedWay) {
        RelationInformation relationInformation = new RelationInformation();
        String role = rm.getRole();
        String type = Optional.ofNullable(r.get("type")).orElse("");
        if ("from".equals(role) || "to".equals(role)) {
            OsmPrimitive via = SplitWayCommand.findVia(r, type);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (via != null) {
                if (via instanceof Node) {
                    nodes.add((Node)via);
                } else if (via instanceof Way) {
                    nodes.add(((Way)via).lastNode());
                    nodes.add(((Way)via).firstNode());
                }
            }
            Way res = null;
            for (Node n : nodes) {
                if (!changedWay.isFirstLastNode(n)) continue;
                res = way;
            }
            if (res == null) {
                for (Way wayToAdd : newWays) {
                    for (Node n : nodes) {
                        if (!wayToAdd.isFirstLastNode(n)) continue;
                        res = wayToAdd;
                    }
                }
                if (res != null) {
                    if (c == null) {
                        c = new Relation(r);
                    }
                    c.addMember(new RelationMember(role, res));
                    c.removeMembersFor(way);
                    relationInformation.insert = false;
                }
            } else {
                relationInformation.insert = false;
            }
        } else if (!"via".equals(role)) {
            relationInformation.warnme = true;
        }
        relationInformation.relation = c;
        return relationInformation;
    }

    static OsmPrimitive findVia(Relation r, String type) {
        if (type != null) {
            switch (type) {
                case "restriction": {
                    return SplitWayCommand.findRelationMember(r, "via").orElse(null);
                }
                case "destination_sign": {
                    return SplitWayCommand.findRelationMember(r, "intersection").orElse(SplitWayCommand.findRelationMember(r, "sign").orElse(null));
                }
            }
            return null;
        }
        return null;
    }

    static Optional<OsmPrimitive> findRelationMember(Relation r, String role) {
        return r.getMembers().stream().filter(rmv -> role.equals(rmv.getRole())).map(RelationMember::getMember).findAny();
    }

    public static SplitWayCommand split(Way way, List<Node> atNodes, Collection<? extends OsmPrimitive> selection) {
        List<List<Node>> chunks = SplitWayCommand.buildSplitChunks(way, atNodes);
        return chunks != null ? SplitWayCommand.splitWay(way, chunks, selection) : null;
    }

    public static String addSpecialRelationType(String relationType, String treatAs) {
        return relationSpecialTypes.put(relationType, treatAs);
    }

    public static Map<String, String> getSpecialRelationTypes() {
        return relationSpecialTypes;
    }

    static {
        relationSpecialTypes.put("restriction", "restriction");
        relationSpecialTypes.put("destination_sign", "restriction");
    }

    @FunctionalInterface
    public static interface Strategy {
        public Way determineWayToKeep(Iterable<Way> var1);

        public static Strategy keepLongestChunk() {
            return wayChunks -> {
                Way wayToKeep = null;
                for (Way i : wayChunks) {
                    if (wayToKeep != null && i.getNodesCount() <= wayToKeep.getNodesCount()) continue;
                    wayToKeep = i;
                }
                return wayToKeep;
            };
        }

        public static Strategy keepFirstChunk() {
            return wayChunks -> (Way)wayChunks.iterator().next();
        }
    }

    private static final class RelationInformation {
        boolean warnme;
        boolean insert;
        Relation relation;

        private RelationInformation() {
        }
    }
}

