/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.codegen.CodeWriter;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import java.util.List;

public class CodeGenUtils {
    public static void addComments(CodeWriter code, AttrNode node) {
        List comments = node.getAll(AType.COMMENTS);
        if (!comments.isEmpty()) {
            comments.stream().distinct().forEach(comment -> code.startLine("/* ").addMultiLine((String)comment).add(" */"));
        }
    }

    public static void addRenamedComment(CodeWriter code, AttrNode node, String origName) {
        code.startLine("/* renamed from: ").add(origName);
        RenameReasonAttr renameReasonAttr = node.get(AType.RENAME_REASON);
        if (renameReasonAttr != null) {
            code.add(" reason: ");
            code.add(renameReasonAttr.getDescription());
        }
        code.add(" */");
    }

    public static void addSourceFileInfo(CodeWriter code, AttrNode node) {
        SourceFileAttr sourceFileAttr = node.get(AType.SOURCE_FILE);
        if (sourceFileAttr != null) {
            code.startLine("/* compiled from: ").add(sourceFileAttr.getFileName()).add(" */");
        }
    }

    private CodeGenUtils() {
    }
}

