#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tree-diff
version: 0.1
id: tree-diff-0.1-MaeDBbkWsp3aXEPEvZsz0
key: tree-diff-0.1-MaeDBbkWsp3aXEPEvZsz0
license: GPL-2.0-or-later
copyright: (c) 2017-2019 Oleg Grenrus
maintainer: Oleg.Grenrus <oleg.grenrus@iki.fi>
author: Oleg Grenrus <oleg.grenrus@iki.fi>
homepage: https://github.com/phadej/tree-diff
synopsis: Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:
    .
    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @
    .
    This package works on trees.
    .
    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @
    .
    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.
    .
    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.
    .
    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @
category: Data, Testing
abi: 4f787076d36b4b1ade6d0046fd95bc0e
exposed: True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.Parser
    Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck Data.TreeDiff.Tree
import-dirs: /usr/lib/ghc-8.6.5/site-local/tree-diff-0.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/tree-diff-0.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/tree-diff-0.1
hs-libraries: HStree-diff-0.1-MaeDBbkWsp3aXEPEvZsz0
depends:
    QuickCheck-2.13.2-C3chvSwT3GSBClgQ9bo1MW
    aeson-1.4.4.0-B759jesA16BBzbLoqI31GW
    ansi-terminal-0.9.1-JvtMBmSUh1eHKvsAMwthXj
    ansi-wl-pprint-0.6.9-37GARRLGI1c3EMKKxSVRl0 base-4.12.0.0
    base-compat-0.10.5-FRXoAxOVtbG2qLNIZm1tTr bytestring-0.10.8.2
    containers-0.6.0.1 hashable-1.2.7.0-KHvCgUH7dIl7mI8fl4akIo
    parsec-3.1.13.0 parsers-0.12.10-FPg5oiObu8yFZNrwSw8L5c
    pretty-1.1.3.6 scientific-0.3.6.2-L1dtV0bHm4E7J1We1UVw6b
    tagged-0.8.6-AoE7RQX12AwJxLvAxGYxtP text-1.2.3.1 time-1.8.0.2
    unordered-containers-0.2.10.0-8ZCNQorHEnr2Al0NbBIjXw
    uuid-types-1.0.3-1r1IBIU9fBZK1eE2MZEQJb
    vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
haddock-interfaces: /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html: /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

