#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: options
version: 1.2.1.1
id: options-1.2.1.1-FMpEp48m7Zu8qqR2BW81vr
key: options-1.2.1.1-FMpEp48m7Zu8qqR2BW81vr
license: MIT
maintainer: John Millikin <john@john-millikin.com>
author: John Millikin <john@john-millikin.com>
stability: stable
homepage: https://john-millikin.com/software/haskell-options/
synopsis: A powerful and easy-to-use command-line option parser.
description:
    The @options@ package lets library and application developers easily work
    with command-line options.
    .
    The following example is a full program that can accept two options,
    @--message@ and @--quiet@:
    .
    @
    import Control.Applicative
    import Options
    .
    data MainOptions = MainOptions
    &#x20;   &#x7b; optMessage :: String
    &#x20;   , optQuiet :: Bool
    &#x20;   &#x7d;
    .
    instance '\''Options'\'' MainOptions where
    &#x20;   defineOptions = pure MainOptions
    &#x20;       \<*\> simpleOption \"message\" \"Hello world!\"
    &#x20;           \"A message to show the user.\"
    &#x20;       \<*\> simpleOption \"quiet\" False
    &#x20;           \"Whether to be quiet.\"
    .
    main :: IO ()
    main = runCommand $ \\opts args -> do
    &#x20;   if optQuiet opts
    &#x20;       then return ()
    &#x20;       else putStrLn (optMessage opts)
    @
    .
    >$ ./hello
    >Hello world!
    >$ ./hello --message='\''ciao mondo'\''
    >ciao mondo
    >$ ./hello --quiet
    >$
    .
    In addition, this library will automatically create documentation options
    such as @--help@ and @--help-all@:
    .
    >$ ./hello --help
    >Help Options:
    >  -h, --help
    >    Show option summary.
    >  --help-all
    >    Show all help options.
    >
    >Application Options:
    >  --message :: text
    >    A message to show the user.
    >    default: "Hello world!"
    >  --quiet :: bool
    >    Whether to be quiet.
    >    default: false
category: Console
abi: 597d41a8b6228758f0c3abf398e86fad
exposed: True
exposed-modules:
    Options
hidden-modules: Options.Help Options.Tokenize Options.Types
                Options.Util
import-dirs: /usr/lib/ghc-8.6.5/site-local/options-1.2.1.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/options-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/options-1.2.1.1
hs-libraries: HSoptions-1.2.1.1-FMpEp48m7Zu8qqR2BW81vr
depends:
    base-4.12.0.0 containers-0.6.0.1
    monads-tf-0.1.0.3-KfvB5lplvTy3onJzEY5Ljt transformers-0.5.6.2
haddock-interfaces: /usr/share/doc/haskell-options/html/options.haddock
haddock-html: /usr/share/doc/haskell-options/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

