/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.DefaultBeanIntrospector;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface BeanIntrospector {
    public static final BeanIntrospector SHARED = new DefaultBeanIntrospector();

    @Nonnull
    public Collection<BeanIntrospection<Object>> findIntrospections(@Nonnull Predicate<? super BeanIntrospectionReference> var1);

    @Nonnull
    public <T> Optional<BeanIntrospection<T>> findIntrospection(@Nonnull Class<T> var1);

    @Nonnull
    default public Collection<BeanIntrospection<Object>> findIntrospections(@Nonnull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.findIntrospections((? super BeanIntrospectionReference ref) -> ref.getAnnotationMetadata().hasStereotype(stereotype));
    }

    @Nonnull
    default public Collection<BeanIntrospection<Object>> findIntrospections(@Nonnull Class<? extends Annotation> stereotype, String ... packageNames) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        ArgumentUtils.requireNonNull("packageNames", packageNames);
        return this.findIntrospections((? super BeanIntrospectionReference ref) -> ref.getAnnotationMetadata().hasStereotype(stereotype) && Arrays.stream(packageNames).anyMatch(s -> ref.getName().startsWith(s + ".")));
    }

    @Nonnull
    default public <T> BeanIntrospection<T> getIntrospection(@Nonnull Class<T> beanType) {
        return this.findIntrospection(beanType).orElseThrow(() -> new IntrospectionException("No bean introspection available for type [" + beanType + "]. Ensure the class is annotated with io.micronaut.core.annotation.Introspected"));
    }
}

