/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugin.devel.PluginDeclaration;

public class GradlePluginDevelopmentExtension {
    private SourceSet pluginSourceSet;
    private Set<SourceSet> testSourceSets = Collections.emptySet();
    private final NamedDomainObjectContainer<PluginDeclaration> plugins;
    private boolean automatedPublishing = true;

    public GradlePluginDevelopmentExtension(Project project, SourceSet pluginSourceSet, SourceSet testSourceSet) {
        this(project, pluginSourceSet, new SourceSet[]{testSourceSet});
    }

    public GradlePluginDevelopmentExtension(Project project, SourceSet pluginSourceSet, SourceSet[] testSourceSets) {
        this.plugins = project.getObjects().domainObjectContainer(PluginDeclaration.class);
        this.pluginSourceSet = pluginSourceSet;
        this.testSourceSets(testSourceSets);
    }

    public void pluginSourceSet(SourceSet pluginSourceSet) {
        this.pluginSourceSet = pluginSourceSet;
    }

    public void testSourceSets(SourceSet ... testSourceSets) {
        this.testSourceSets = Collections.unmodifiableSet(new HashSet<SourceSet>(Arrays.asList(testSourceSets)));
    }

    public SourceSet getPluginSourceSet() {
        return this.pluginSourceSet;
    }

    public Set<SourceSet> getTestSourceSets() {
        return this.testSourceSets;
    }

    public NamedDomainObjectContainer<PluginDeclaration> getPlugins() {
        return this.plugins;
    }

    public void plugins(Action<? super NamedDomainObjectContainer<PluginDeclaration>> action) {
        action.execute(this.plugins);
    }

    public boolean isAutomatedPublishing() {
        return this.automatedPublishing;
    }

    public void setAutomatedPublishing(boolean automatedPublishing) {
        this.automatedPublishing = automatedPublishing;
    }
}

