define(["idbcore"],function(idb){"use strict";var indexedDB=self.indexedDB,libraryDbVersion=3,databases={};function getLibraryDb(serverId){return function(dbName){return new Promise(function(resolve,reject){if(dbName in databases)resolve(databases[dbName]);else{var request=indexedDB.open(dbName,libraryDbVersion);request.onerror=reject,request.onblocked=reject,request.onupgradeneeded=function(event){var db=request.result;if(event.oldVersion<1&&db.createObjectStore(dbName),event.oldVersion<3){var objectStore=request.transaction.objectStore(dbName);objectStore.createIndex("Index_ItemType","Item.Type"),objectStore.createIndex("Index_SyncStatus","SyncStatus")}},request.onsuccess=function(event){var db=event.target.result;db.onversionchange=function(){db.close(),delete databases[dbName]},databases[dbName]=db,resolve(db)}}})}("items_"+serverId)}return{getLibarytemTypes:function(serverId){return getLibraryDb(serverId).then(function(db){return idb.getDistinctndexKeys(db,"Index_ItemType")})},getLibraryItemsByIds:function(serverId,ids){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByKeys(db,ids).then(function(items){return items.sort(function(a,b){var indexA=ids.indexOf(a.Id),indexB=ids.indexOf(b.Id);return indexedDB.cmp(indexA,indexB)}),Promise.resolve(items)})})},getLibraryItemsBySyncStatus:function(serverId,syncStati){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByIndexKeys(db,"Index_SyncStatus",syncStati)})},getLibraryItemsByType:function(serverId,itemTypes){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByIndexKeys(db,"Index_ItemType",itemTypes)})},getAllLibraryItems:function(serverId){return getLibraryDb(serverId).then(function(db){return idb.getAllObjects(db)})},getLibraryItem:function(serverId,key){return getLibraryDb(serverId).then(function(db){return idb.getObjectByKey(db,key)})},addLibraryItem:function(serverId,key,val){return getLibraryDb(serverId).then(function(db){return idb.addObject(db,key,val)})},updateLibraryItem:function(serverId,key,val){return getLibraryDb(serverId).then(function(db){return idb.updateObject(db,key,val)})},deleteLibraryItem:function(serverId,key){return getLibraryDb(serverId).then(function(db){return idb.deleteObject(db,key)})},clearLibrary:function(serverId){return getLibraryDb(serverId).then(function(db){return idb.clearObjects(db)})}}});