/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IMoveToLine;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.IMoveToLineTarget;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class MoveToLineAdapter
implements IMoveToLineTarget {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void moveToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = ActionMessages.getString("MoveToLineAdapter.3");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = ActionMessages.getString("MoveToLineAdapter.0");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = ActionMessages.getString("MoveToLineAdapter.1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        String fileName = this.getFileName(input);
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        if (!(target instanceof IAdaptable)) return;
        Path path = new Path(fileName);
        final IMoveToLine moveToLine = (IMoveToLine)((IAdaptable)target).getAdapter(IMoveToLine.class);
        if (moveToLine == null) return;
        if (!moveToLine.canMoveToLine(path.toPortableString(), lineNumber)) return;
        Runnable r = new Runnable((IPath)path, lineNumber){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ int val$lineNumber;
            {
                this.val$path = iPath;
                this.val$lineNumber = n;
            }

            @Override
            public void run() {
                try {
                    moveToLine.moveToLine(this.val$path.toPortableString(), this.val$lineNumber);
                }
                catch (DebugException e) {
                    MoveToLineAdapter.this.failed(e);
                }
            }
        };
        this.runInBackground(r);
    }

    @Override
    public boolean canMoveToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IEditorPart) {
            IMoveToLine moveToLine = (IMoveToLine)((IAdaptable)target).getAdapter(IMoveToLine.class);
            if (moveToLine == null) {
                return false;
            }
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                return false;
            }
            if (!(editorPart instanceof ITextEditor)) {
                return false;
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                return false;
            }
            String fileName = null;
            try {
                fileName = this.getFileName(input);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (fileName == null) {
                return false;
            }
            Path path = new Path(fileName);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            return moveToLine.canMoveToLine(path.toPortableString(), lineNumber);
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        return CDebugUIUtils.getEditorFilePath(input);
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("MoveToLineAdapter.4"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)this);
    }
}

