/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.index.IQMakeEnv;
import org.eclipse.cdt.internal.qt.core.index.IQMakeEnvProvider;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class QMakeEnvProviderDescriptor
implements Comparable<QMakeEnvProviderDescriptor> {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private static final String VAR_PROJECTNATURES = "projectNatures";
    private final IConfigurationElement element;
    private final String id;
    private final int priority;
    private final AtomicReference<Boolean> evaluation = new AtomicReference();
    private final Expression enablementExpression;

    QMakeEnvProviderDescriptor(IConfigurationElement element) {
        this.element = element;
        this.id = element.getContributor().getName();
        int prio = 0;
        String priorityString = element.getAttribute(ATTR_PRIORITY);
        if (priorityString != null) {
            try {
                prio = Integer.parseInt(priorityString);
            }
            catch (NumberFormatException e) {
                Activator.log("Invalid priority value of " + this.id, e);
            }
        }
        this.priority = prio;
        Expression expr = null;
        IConfigurationElement[] children = element.getChildren("enablement");
        switch (children.length) {
            case 0: {
                this.evaluation.set(Boolean.TRUE);
                break;
            }
            case 1: {
                try {
                    ExpressionConverter parser = ExpressionConverter.getDefault();
                    expr = parser.perform(children[0]);
                }
                catch (CoreException e) {
                    Activator.log("Error in enablement expression of " + this.id, e);
                }
                break;
            }
            default: {
                Activator.log("Too many enablement expressions for " + this.id);
                this.evaluation.set(Boolean.FALSE);
            }
        }
        this.enablementExpression = expr;
    }

    @Override
    public int compareTo(QMakeEnvProviderDescriptor that) {
        if (that == null) {
            return -1;
        }
        return this.priority - that.priority;
    }

    public IQMakeEnv createEnv(IQMakeEnvProvider.IController controller) {
        IQMakeEnvProvider provider;
        if (!this.matches(controller)) {
            return null;
        }
        try {
            provider = (IQMakeEnvProvider)this.element.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException e) {
            Activator.log("Error in class attribute of " + this.id, e);
            return null;
        }
        return provider.createEnv(controller);
    }

    private boolean matches(IQMakeEnvProvider.IController controller) {
        Boolean eval = this.evaluation.get();
        if (eval != null) {
            return eval;
        }
        if (this.enablementExpression != null) {
            ICConfigurationDescription configuration = controller != null ? controller.getConfiguration() : null;
            IProject project = configuration != null ? configuration.getProjectDescription().getProject() : null;
            EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
            try {
                if (project != null) {
                    String[] natures = project.getDescription().getNatureIds();
                    evalContext.addVariable(VAR_PROJECTNATURES, Arrays.asList(natures));
                }
                return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                Activator.log("Error while evaluating enablement expression for " + this.id, e);
            }
        }
        this.evaluation.set(Boolean.FALSE);
        return false;
    }
}

