/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCalculator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCommands;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyInfo;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyPreBuild;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuDependencyGroupInfo;
import org.eclipse.cdt.managedbuilder.makegen.gnu.IManagedBuildGnuToolInfo;
import org.eclipse.cdt.managedbuilder.makegen.gnu.ManagedBuildGnuToolInfo;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GnuMakefileGenerator
implements IManagedBuilderMakefileGenerator2 {
    private static final IPath DOT_SLASH_PATH = new Path("./");
    private static final String COMMENT = "MakefileGenerator.comment";
    private static final String HEADER = "MakefileGenerator.comment.header";
    protected static final String MESSAGE_FINISH_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.build");
    protected static final String MESSAGE_FINISH_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.file");
    protected static final String MESSAGE_START_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.build");
    protected static final String MESSAGE_START_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.file");
    protected static final String MESSAGE_START_DEPENDENCY = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.dependency");
    protected static final String MESSAGE_NO_TARGET_TOOL = ManagedMakeMessages.getResourceString("MakefileGenerator.message.no.target");
    private static final String MOD_LIST = "MakefileGenerator.comment.module.list";
    private static final String MOD_VARS = "MakefileGenerator.comment.module.variables";
    private static final String MOD_RULES = "MakefileGenerator.comment.build.rule";
    private static final String BUILD_TOP = "MakefileGenerator.comment.build.toprules";
    private static final String ALL_TARGET = "MakefileGenerator.comment.build.alltarget";
    private static final String MAINBUILD_TARGET = "MakefileGenerator.comment.build.mainbuildtarget";
    private static final String BUILD_TARGETS = "MakefileGenerator.comment.build.toptargets";
    private static final String SRC_LISTS = "MakefileGenerator.comment.source.list";
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String OBJS_MACRO = "OBJS";
    private static final String MACRO_ADDITION_ADDPREFIX_HEADER = "${addprefix ";
    private static final String MACRO_ADDITION_ADDPREFIX_SUFFIX = ", \\\n";
    private static final String MACRO_ADDITION_PREFIX_SUFFIX = "+= \\\n";
    private static final String PREBUILD = "pre-build";
    private static final String MAINBUILD = "main-build";
    private static final String POSTBUILD = "post-build";
    private static final String SECONDARY_OUTPUTS = "secondary-outputs";
    public static final int PROJECT_RELATIVE = 1;
    public static final int PROJECT_SUBDIR_RELATIVE = 2;
    public static final int ABSOLUTE = 3;
    private String buildTargetName;
    private String buildTargetExt;
    private IConfiguration config;
    private IBuilder builder;
    private PathSettingsContainer toolInfos;
    private Vector<IResource> deletedFileList;
    private Vector<IResource> deletedDirList;
    private Vector<IResource> invalidDirList;
    private Collection<IContainer> modifiedList;
    private IProgressMonitor monitor;
    private IProject project;
    private IResource[] projectResources;
    private Vector<String> ruleList;
    private Vector<String> depLineList;
    private Vector<String> depRuleList;
    private Collection<IContainer> subdirList;
    private IPath topBuildDir;
    private final HashMap<String, List<IPath>> buildSrcVars = new HashMap();
    private final HashMap<String, List<IPath>> buildOutVars = new HashMap();
    private final HashMap<String, GnuDependencyGroupInfo> buildDepVars = new HashMap();
    private final LinkedHashMap<String, String> topBuildOutVars = new LinkedHashMap();
    private ICSourceEntry[] srcEntries;
    public static String ECHO_BLANK_LINE = "echo ' '" + NEWLINE;

    @Override
    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        try {
            this.projectResources = project.members();
        }
        catch (CoreException e) {
            this.projectResources = null;
        }
        this.monitor = monitor;
        this.buildTargetName = info.getBuildArtifactName();
        this.buildTargetExt = info.getBuildArtifactExtension();
        try {
            this.buildTargetExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetExt, EMPTY_STRING, " ", 3, info.getDefaultConfiguration());
        }
        catch (BuildMacroException e) {
            // empty catch block
        }
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetName, EMPTY_STRING, " ", 3, info.getDefaultConfiguration());
            if (resolved != null && (resolved = resolved.trim()).length() > 0) {
                this.buildTargetName = resolved;
            }
        }
        catch (BuildMacroException buildMacroException) {
            // empty catch block
        }
        if (this.buildTargetExt == null) {
            this.buildTargetExt = EMPTY_STRING;
        }
        this.config = info.getDefaultConfiguration();
        this.builder = this.config.getEditableBuilder();
        this.initToolInfos();
        this.initializeTopBuildDir(info.getConfigurationName());
    }

    private void callDependencyPostProcessors(IResourceInfo rcInfo, ToolInfoHolder h, IFile depFile, IManagedDependencyGenerator2[] postProcessors, boolean callPopulateDummyTargets, boolean force) throws CoreException {
        try {
            this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", depFile.getName()));
            if (postProcessors != null) {
                Path absolutePath = new Path(EFSExtensionManager.getDefault().getPathFromURI(depFile.getLocationURI()));
                IPath depPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), (IPath)absolutePath);
                int i = 0;
                while (i < postProcessors.length) {
                    IManagedDependencyGenerator2 depGen = postProcessors[i];
                    if (depGen != null) {
                        depGen.postProcessDependencyFile(depPath, this.config, h.buildTools[i], this.getTopBuildDir());
                    }
                    ++i;
                }
            }
            if (callPopulateDummyTargets) {
                GnuMakefileGenerator.populateDummyTargets(rcInfo, depFile, force);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean collectDependencyGeneratorInformation(ToolInfoHolder h, Vector<String> depExts, IManagedDependencyGenerator2[] postProcessors) {
        boolean callPopulateDummyTargets = false;
        int i = 0;
        while (i < h.buildTools.length) {
            ITool tool = h.buildTools[i];
            IManagedDependencyGeneratorType depType = tool.getDependencyGeneratorForExtension(tool.getDefaultInputExtension());
            if (depType != null) {
                IManagedDependencyGenerator2 depGen;
                String depExt;
                int calcType = depType.getCalculatorType();
                if (calcType <= 3) {
                    if (calcType == 1) {
                        callPopulateDummyTargets = true;
                        depExts.add("d");
                    }
                } else if ((calcType == 5 || calcType == 6) && (depExt = (depGen = (IManagedDependencyGenerator2)depType).getDependencyFileExtension(this.config, tool)) != null) {
                    postProcessors[i] = depGen;
                    depExts.add(depExt);
                }
            }
            ++i;
        }
        return callPopulateDummyTargets;
    }

    protected boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    @Override
    public void generateDependencies() throws CoreException {
        final PathSettingsContainer postProcs = PathSettingsContainer.createRootContainer();
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                IManagedDependencyGenerator2[] postProcessors;
                Vector depExts;
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                boolean callPopulateDummyTargets = GnuMakefileGenerator.this.collectDependencyGeneratorInformation(h, depExts = new Vector(), postProcessors = new IManagedDependencyGenerator2[h.buildTools.length]);
                if (!callPopulateDummyTargets) {
                    int i = 0;
                    while (i < postProcessors.length) {
                        if (postProcessors[i] != null) break;
                        ++i;
                    }
                    if (i == postProcessors.length) {
                        return true;
                    }
                }
                PathSettingsContainer child = postProcs.getChildContainer(container.getPath(), true, true);
                DepInfo di = new DepInfo();
                di.depExts = depExts;
                di.postProcessors = postProcessors;
                di.callPopulateDummyTargets = callPopulateDummyTargets;
                child.setValue((Object)di);
                return true;
            }
        });
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        for (IResource iResource : this.getSubdirList()) {
            IResource[] files;
            IContainer subDir = (IContainer)iResource;
            IPath projectRelativePath = subDir.getProjectRelativePath();
            IResourceInfo rcInfo = this.config.getResourceInfo(projectRelativePath, false);
            PathSettingsContainer cr = postProcs.getChildContainer(rcInfo.getPath(), false, true);
            if (cr == null || cr.getValue() == null) continue;
            DepInfo di = (DepInfo)cr.getValue();
            ToolInfoHolder h = this.getToolInfo(projectRelativePath);
            IPath buildRelativePath = this.topBuildDir.append(projectRelativePath);
            IFolder buildFolder = root.getFolder(buildRelativePath);
            if (buildFolder == null) continue;
            IResource[] iResourceArray = files = buildFolder.members();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IResource file = iResourceArray[n2];
                String fileExt = file.getFileExtension();
                for (String ext : di.depExts) {
                    IFile depFile;
                    if (!ext.equals(fileExt) || (depFile = root.getFile(file.getFullPath())) == null) continue;
                    this.callDependencyPostProcessors(rcInfo, h, depFile, di.postProcessors, di.callPopulateDummyTargets, false);
                }
                ++n2;
            }
        }
    }

    @Override
    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        MultiStatus status;
        IContainer subDir;
        IFolder folder = this.project.getFolder(this.computeTopBuildDir(this.config.getName()));
        if (!folder.exists()) {
            return this.regenerateMakefiles();
        }
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.calc.delta", this.project.getName()));
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.config);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.finding.sources", this.project.getName()));
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, this.config);
        this.project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        this.checkCancel();
        this.getSubdirList().addAll(this.getModifiedList());
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, EMPTY_STRING, null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        this.ensureTopBuildDir();
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.buildDepVars.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        for (IResource iResource : this.getSubdirList()) {
            IContainer subdirectory = (IContainer)iResource;
            if (this.getModifiedList().contains(subdirectory)) continue;
            if (!subdirectory.exists()) {
                this.appendDeletedSubdirectory(subdirectory);
                continue;
            }
            IPath fragmentPath = this.getBuildWorkingDir().append(subdirectory.getProjectRelativePath()).append("subdir.mk");
            IFile makeFragment = this.project.getFile(fragmentPath);
            if (makeFragment.exists()) continue;
            this.getModifiedList().add(subdirectory);
        }
        for (IResource iResource : this.getDeletedFileList()) {
            this.deleteDepFile(iResource);
            this.deleteBuildTarget(iResource);
        }
        for (IResource iResource : this.getModifiedList()) {
            IContainer subDir2 = (IContainer)iResource;
            if (!subDir2.exists()) {
                this.appendDeletedSubdirectory(subDir2);
                continue;
            }
            this.checkCancel();
        }
        for (IResource iResource : this.getSubdirList()) {
            IContainer subDir2 = (IContainer)iResource;
            try {
                this.populateFragmentMakefile(subDir2);
            }
            catch (CoreException e) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath iPath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(iPath);
        this.populateTopMakefile(makefileHandle, false);
        this.checkCancel();
        for (IResource res : this.getDeletedDirList()) {
            subDir = (IContainer)res;
            this.removeGeneratedDirectory(subDir);
            this.checkCancel();
        }
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, EMPTY_STRING, null);
            for (IResource res : this.getInvalidDirList()) {
                subDir = (IContainer)res;
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, subDir.getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, EMPTY_STRING, null);
        }
        return status;
    }

    @Override
    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    @Override
    public String getMakefileName() {
        return "makefile";
    }

    @Override
    public boolean isGeneratedResource(IResource resource) {
        String[] configNames;
        IPath path = resource.getProjectRelativePath();
        String[] stringArray = configNames = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IPath pathOfConfig = this.computeTopBuildDir(name);
            if (pathOfConfig.isPrefixOf(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void save(StringBuffer buffer, IFile file) throws CoreException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        byte[] bytes = null;
        if (encoding != null) {
            try {
                bytes = buffer.toString().getBytes(encoding);
            }
            catch (Exception exception) {}
        } else {
            bytes = buffer.toString().getBytes();
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        boolean force = true;
        file.setContents((InputStream)stream, force, false, null);
    }

    @Override
    public void regenerateDependencies(boolean force) throws CoreException {
        final IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        final CoreException[] es = new CoreException[1];
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                IManagedDependencyGenerator2[] postProcessors;
                Vector depExts;
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                boolean callPopulateDummyTargets = GnuMakefileGenerator.this.collectDependencyGeneratorInformation(h, depExts = new Vector(), postProcessors = new IManagedDependencyGenerator2[h.buildTools.length]);
                if (!callPopulateDummyTargets) {
                    int i = 0;
                    while (i < postProcessors.length) {
                        if (postProcessors[i] != null) break;
                        ++i;
                    }
                    if (i == postProcessors.length) {
                        return true;
                    }
                }
                IResourceInfo rcInfo = GnuMakefileGenerator.this.config.getResourceInfo(container.getPath(), false);
                for (IPath path : GnuMakefileGenerator.this.getDependencyMakefiles(h)) {
                    IPath relDepFilePath = GnuMakefileGenerator.this.topBuildDir.append(path);
                    IFile depFile = root.getFile(relDepFilePath);
                    if (depFile == null || !depFile.isAccessible()) continue;
                    try {
                        GnuMakefileGenerator.this.callDependencyPostProcessors(rcInfo, h, depFile, postProcessors, callPopulateDummyTargets, true);
                    }
                    catch (CoreException e) {
                        es[0] = e;
                        return false;
                    }
                }
                return true;
            }
        });
        if (es[0] != null) {
            throw es[0];
        }
    }

    @Override
    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status;
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.config);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, EMPTY_STRING, null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        this.ensureTopBuildDir();
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.buildDepVars.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        for (IResource iResource : this.getSubdirList()) {
            IContainer subDir = (IContainer)iResource;
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException e) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath iPath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(iPath);
        this.populateTopMakefile(makefileHandle, true);
        this.checkCancel();
        IPath objFilePath = this.topBuildDir.append("objects.mk");
        IFile objsFileHandle = this.createFile(objFilePath);
        this.populateObjectsMakefile(objsFileHandle);
        this.checkCancel();
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, EMPTY_STRING, null);
            for (IResource dir : this.getInvalidDirList()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, dir.getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, EMPTY_STRING, null);
        }
        return status;
    }

    protected void populateFragmentMakefile(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.gen.source.makefile", moduleOutputPath.toString()));
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile modMakefile = this.createFile(moduleOutputDir.append("subdir.mk"));
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append(this.addFragmentMakefileHeader());
        makeBuf.append(this.addSources(module));
        GnuMakefileGenerator.save(makeBuf, modMakefile);
    }

    protected void populateObjectsMakefile(IFile fileHandle) throws CoreException {
        String[] libs;
        StringBuffer macroBuffer = new StringBuffer();
        macroBuffer.append(GnuMakefileGenerator.addDefaultHeader());
        HashMap outputMacros = new HashMap();
        List valueList = new ArrayList<String>();
        String[] stringArray = libs = this.config.getLibs(this.buildTargetExt);
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            valueList.add(lib);
            ++n2;
        }
        outputMacros.put("LIBS", valueList);
        valueList = new ArrayList();
        String[] userObjs = this.config.getUserObjects(this.buildTargetExt);
        String[] stringArray2 = userObjs;
        int n3 = userObjs.length;
        n = 0;
        while (n < n3) {
            String obj = stringArray2[n];
            valueList.add(obj);
            ++n;
        }
        outputMacros.put("USER_OBJS", valueList);
        for (Map.Entry entry : outputMacros.entrySet()) {
            macroBuffer.append((String)entry.getKey()).append(" :=");
            valueList = (List)entry.getValue();
            for (String path : valueList) {
                path = path.replace('\\', '/');
                path = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(path);
                macroBuffer.append(" ");
                macroBuffer.append(path);
            }
            macroBuffer.append(NEWLINE);
            macroBuffer.append(NEWLINE);
        }
        GnuMakefileGenerator.save(macroBuffer, fileHandle);
    }

    protected void populateSourcesMakefile(IFile fileHandle) throws CoreException {
        StringBuffer buffer = GnuMakefileGenerator.addDefaultHeader();
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                ITool[] buildTools = h.buildTools;
                HashSet<String> handledInputExtensions = new HashSet<String>();
                ITool[] iToolArray = buildTools;
                int n = buildTools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool buildTool = iToolArray[n2];
                    if (!buildTool.getCustomBuildStep()) {
                        String buildMacro;
                        String[] extensionsList;
                        String[] stringArray = extensionsList = buildTool.getAllInputExtensions();
                        int n3 = extensionsList.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String ext = stringArray[n4];
                            String extensionName = ext;
                            if (!handledInputExtensions.contains(extensionName)) {
                                int calcType;
                                IManagedDependencyGeneratorType depType;
                                handledInputExtensions.add(extensionName);
                                buildMacro = GnuMakefileGenerator.this.getSourceMacroName(extensionName).toString();
                                if (!GnuMakefileGenerator.this.buildSrcVars.containsKey(buildMacro)) {
                                    GnuMakefileGenerator.this.buildSrcVars.put(buildMacro, new ArrayList());
                                }
                                if ((depType = buildTool.getDependencyGeneratorForExtension(extensionName)) != null && ((calcType = depType.getCalculatorType()) == 1 || calcType == 5 || calcType == 6)) {
                                    buildMacro = GnuMakefileGenerator.this.getDepMacroName(extensionName).toString();
                                    if (!GnuMakefileGenerator.this.buildDepVars.containsKey(buildMacro)) {
                                        GnuMakefileGenerator.this.buildDepVars.put(buildMacro, new GnuDependencyGroupInfo(buildMacro, calcType != 6));
                                    }
                                    if (!GnuMakefileGenerator.this.buildOutVars.containsKey(buildMacro)) {
                                        GnuMakefileGenerator.this.buildOutVars.put(buildMacro, new ArrayList());
                                    }
                                }
                            }
                            ++n4;
                        }
                        IOutputType[] outTypes = buildTool.getOutputTypes();
                        if (outTypes != null && outTypes.length > 0) {
                            IOutputType[] iOutputTypeArray = outTypes;
                            int n5 = outTypes.length;
                            n3 = 0;
                            while (n3 < n5) {
                                IOutputType outputType = iOutputTypeArray[n3];
                                buildMacro = outputType.getBuildVariable();
                                if (!GnuMakefileGenerator.this.buildOutVars.containsKey(buildMacro)) {
                                    GnuMakefileGenerator.this.buildOutVars.put(buildMacro, new ArrayList());
                                }
                                ++n3;
                            }
                        } else {
                            buildMacro = GnuMakefileGenerator.OBJS_MACRO;
                            if (!GnuMakefileGenerator.this.buildOutVars.containsKey(buildMacro)) {
                                GnuMakefileGenerator.this.buildOutVars.put(buildMacro, new ArrayList());
                            }
                        }
                    }
                    ++n2;
                }
                return true;
            }
        });
        for (Map.Entry<String, List<IPath>> entry : this.buildSrcVars.entrySet()) {
            String macroName = entry.getKey();
            buffer.append(macroName).append(" ").append(":=").append(" ").append(NEWLINE);
        }
        Set<Map.Entry<String, List<IPath>>> set = this.buildOutVars.entrySet();
        for (Map.Entry<String, List<IPath>> entry : set) {
            String macroName = entry.getKey();
            buffer.append(macroName).append(" ").append(":=").append(" ").append(NEWLINE);
        }
        buffer.append(NEWLINE).append(this.addSubdirectories());
        GnuMakefileGenerator.save(buffer, fileHandle);
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addTopHeader());
        buffer.append(this.addMacros());
        ArrayList<String> outputVarsAdditionsList = new ArrayList<String>();
        StringBuffer targetRules = this.addTargets(outputVarsAdditionsList, rebuild);
        buffer.append(this.writeTopAdditionMacros(outputVarsAdditionsList, this.getTopBuildOutputVars()));
        buffer.append(targetRules);
        GnuMakefileGenerator.save(buffer, fileHandle);
    }

    protected StringBuffer addTopHeader() {
        return GnuMakefileGenerator.addDefaultHeader();
    }

    private StringBuffer addMacros() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-include " + this.reachProjectRoot() + "/" + "makefile.init").append(NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("RM := ");
        String cleanCommand = this.config.getCleanCommand();
        try {
            cleanCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.config.getCleanCommand(), EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {
            // empty catch block
        }
        buffer.append(cleanCommand).append(NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(SRC_LISTS)).append(NEWLINE);
        buffer.append("-include sources.mk").append(NEWLINE);
        ArrayList<String> subDirList = new ArrayList<String>();
        for (IContainer iContainer : this.getSubdirList()) {
            String projectRelativePath = iContainer.getProjectRelativePath().toString();
            if (projectRelativePath.isEmpty()) continue;
            subDirList.add(0, projectRelativePath);
        }
        Collections.sort(subDirList, Collections.reverseOrder());
        for (String string : subDirList) {
            buffer.append("-include ").append(GnuMakefileGenerator.escapeWhitespaces(string)).append("/").append("subdir.mk").append(NEWLINE);
        }
        buffer.append("-include subdir.mk").append(NEWLINE);
        buffer.append("-include objects.mk").append(NEWLINE).append(NEWLINE);
        if (!this.buildDepVars.isEmpty()) {
            buffer.append("ifneq ($(MAKECMDGOALS),clean)").append(NEWLINE);
            for (Map.Entry entry : this.buildDepVars.entrySet()) {
                String depsMacro = (String)entry.getKey();
                GnuDependencyGroupInfo info = (GnuDependencyGroupInfo)entry.getValue();
                buffer.append("ifneq ($(strip $(").append(depsMacro).append(")),)").append(NEWLINE);
                if (info.conditionallyInclude) {
                    buffer.append("-include $(").append(depsMacro).append(')').append(NEWLINE);
                } else {
                    buffer.append("include $(").append(depsMacro).append(')').append(NEWLINE);
                }
                buffer.append("endif").append(NEWLINE);
            }
            buffer.append("endif").append(NEWLINE).append(NEWLINE);
        }
        buffer.append("-include ").append(this.reachProjectRoot()).append("/").append("makefile.defs").append(NEWLINE);
        return buffer.append(NEWLINE);
    }

    private StringBuffer addTargets(List<String> outputVarsAdditionsList, boolean rebuild) {
        IOutputType[] secondaryOutputs;
        StringBuffer buffer = new StringBuffer();
        String prebuildStep = this.config.getPrebuildStep();
        try {
            prebuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prebuildStep, EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {
            // empty catch block
        }
        prebuildStep = prebuildStep.trim();
        String postbuildStep = this.config.getPostbuildStep();
        try {
            postbuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(postbuildStep, EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {
            // empty catch block
        }
        postbuildStep = postbuildStep.trim();
        String preannouncebuildStep = this.config.getPreannouncebuildStep();
        String postannouncebuildStep = this.config.getPostannouncebuildStep();
        String targets = rebuild ? "clean all" : "all";
        ITool targetTool = this.config.calculateTargetTool();
        IConfiguration[] refConfigs = new IConfiguration[]{};
        if (this.config.getBuildArtefactType() == null || !"org.eclipse.cdt.build.core.buildArtefactType.staticLib".equals(this.config.getBuildArtefactType().getId())) {
            refConfigs = ManagedBuildManager.getReferencedConfigurations(this.config);
        }
        String defaultTarget = "all:";
        if (prebuildStep.length() > 0) {
            buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(ALL_TARGET)).append(NEWLINE);
            buffer.append(defaultTarget).append(NEWLINE);
            buffer.append("\t").append("$(MAKE)").append(" ").append("--no-print-directory").append(" ").append(PREBUILD).append(NEWLINE);
            buffer.append("\t").append("$(MAKE)").append(" ").append("--no-print-directory").append(" ").append(MAINBUILD).append(NEWLINE);
            buffer.append(NEWLINE);
            defaultTarget = MAINBUILD.concat(":");
            buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(MAINBUILD_TARGET)).append(NEWLINE);
        } else {
            buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(ALL_TARGET)).append(NEWLINE);
        }
        String outputPrefix = EMPTY_STRING;
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(defaultTarget).append(" ").append(outputPrefix).append(this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(this.buildTargetName));
        if (this.buildTargetExt.length() > 0) {
            buffer.append(".").append(this.buildTargetExt);
        }
        if ((secondaryOutputs = this.config.getToolChain().getSecondaryOutputs()).length > 0) {
            buffer.append(" ").append(SECONDARY_OUTPUTS);
        }
        buffer.append(NEWLINE).append(NEWLINE);
        Vector<String> managedProjectOutputs = new Vector<String>(refConfigs.length);
        if (refConfigs.length > 0) {
            boolean addDeps = true;
            IConfiguration[] iConfigurationArray = refConfigs;
            int n = refConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration depCfg = iConfigurationArray[n2];
                if (depCfg.isManagedBuildOn()) {
                    if (addDeps) {
                        buffer.append("dependents:").append(NEWLINE);
                        addDeps = false;
                    }
                    String buildDir = depCfg.getOwner().getLocation().toString();
                    String depTargets = targets;
                    buildDir = String.valueOf(buildDir) + "/" + depCfg.getName();
                    String depTarget = depCfg.getArtifactName();
                    String depExt = depCfg.getArtifactExtension();
                    try {
                        depExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depExt, EMPTY_STRING, " ", 3, depCfg);
                    }
                    catch (BuildMacroException buildMacroException) {
                        // empty catch block
                    }
                    try {
                        String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depTarget, EMPTY_STRING, " ", 3, depCfg);
                        resolved = resolved.trim();
                        if (resolved.length() > 0) {
                            depTarget = resolved;
                        }
                    }
                    catch (BuildMacroException resolved) {
                        // empty catch block
                    }
                    String depPrefix = depCfg.getOutputPrefix(depExt);
                    if (depCfg.needsRebuild()) {
                        depTargets = "clean all";
                    }
                    String dependency = String.valueOf(buildDir) + "/" + depPrefix + depTarget;
                    if (depExt.length() > 0) {
                        dependency = String.valueOf(dependency) + "." + depExt;
                    }
                    dependency = GnuMakefileGenerator.escapeWhitespaces(dependency);
                    managedProjectOutputs.add(dependency);
                    buffer.append("\t").append("-cd").append(" ").append(GnuMakefileGenerator.escapeWhitespaces(buildDir)).append(" ").append("&&").append(" ").append("$(MAKE) ").append(depTargets).append(NEWLINE);
                }
                ++n2;
            }
            buffer.append(NEWLINE);
        }
        buffer.append(this.addTargetsRules(targetTool, outputVarsAdditionsList, managedProjectOutputs, postbuildStep.length() > 0));
        if (prebuildStep.length() > 0) {
            buffer.append(PREBUILD).append(":").append(NEWLINE);
            if (preannouncebuildStep.length() > 0) {
                buffer.append("\t").append("-").append("@").append(GnuMakefileGenerator.escapedEcho(preannouncebuildStep));
            }
            buffer.append("\t").append("-").append(prebuildStep).append(NEWLINE);
            buffer.append("\t").append("-").append("@").append(ECHO_BLANK_LINE).append(NEWLINE);
        }
        if (postbuildStep.length() > 0) {
            buffer.append(POSTBUILD).append(":").append(NEWLINE);
            if (postannouncebuildStep.length() > 0) {
                buffer.append("\t").append("-").append("@").append(GnuMakefileGenerator.escapedEcho(postannouncebuildStep));
            }
            buffer.append("\t").append("-").append(postbuildStep).append(NEWLINE);
            buffer.append("\t").append("-").append("@").append(ECHO_BLANK_LINE).append(NEWLINE);
        }
        if (secondaryOutputs.length > 0) {
            buffer.append(SECONDARY_OUTPUTS).append(":");
            Vector<String> outs2 = this.calculateSecondaryOutputs(secondaryOutputs);
            int i = 0;
            while (i < outs2.size()) {
                buffer.append(" ").append("$(").append(outs2.get(i)).append(')');
                ++i;
            }
            buffer.append(NEWLINE).append(NEWLINE);
        }
        buffer.append(".PHONY: all clean dependents");
        if (prebuildStep.length() > 0) {
            buffer.append(" ").append(MAINBUILD).append(" ").append(PREBUILD);
        }
        if (postbuildStep.length() > 0) {
            buffer.append(" ").append(POSTBUILD);
        }
        buffer.append(NEWLINE);
        for (String output : managedProjectOutputs) {
            buffer.append(output).append(":").append(NEWLINE);
        }
        buffer.append(NEWLINE);
        buffer.append("-include ").append(this.reachProjectRoot()).append("/").append("makefile.targets").append(NEWLINE);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuffer addTargetsRules(ITool targetTool, List<String> outputVarsAdditionsList, Vector<String> managedProjectOutputs, boolean postbuildStep) {
        void var9_16;
        void var9_12;
        StringBuffer buffer = new StringBuffer();
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(BUILD_TOP)).append(NEWLINE);
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        boolean[] buildToolsUsed = h.buildToolsUsed;
        if (targetTool != null) {
            if (this.addRuleForTool(targetTool, buffer, true, this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(this.buildTargetName), this.buildTargetExt, outputVarsAdditionsList, managedProjectOutputs, postbuildStep)) {
                void var9_10;
                boolean bl = false;
                while (var9_10 < buildTools.length) {
                    if (targetTool == buildTools[var9_10]) {
                        buildToolsUsed[var9_10] = true;
                    }
                    ++var9_10;
                }
            }
        } else {
            buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_NO_TARGET_TOOL) + " " + "$@"));
        }
        boolean bl = false;
        while (var9_12 < buildTools.length) {
            ITool tool = buildTools[var9_12];
            IInputType type = tool.getPrimaryInputType();
            if (type != null && type.getMultipleOfType() && !buildToolsUsed[var9_12]) {
                this.addRuleForTool(tool, buffer, false, null, null, outputVarsAdditionsList, null, false);
                buildToolsUsed[var9_12] = true;
                this.generateRulesForConsumers(tool, outputVarsAdditionsList, buffer);
            }
            ++var9_12;
        }
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(BUILD_TARGETS)).append(NEWLINE);
        buffer.append("clean:").append(NEWLINE);
        buffer.append("\t").append("-$(RM)").append(" ");
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            String macroName = (String)entry.getKey();
            buffer.append("$(").append(macroName).append(')');
        }
        String string = EMPTY_STRING;
        if (targetTool != null) {
            String string2 = targetTool.getOutputPrefix();
        }
        String completeBuildTargetName = String.valueOf(var9_16) + this.buildTargetName;
        if (this.buildTargetExt.length() > 0) {
            completeBuildTargetName = String.valueOf(completeBuildTargetName) + "." + this.buildTargetExt;
        }
        if (completeBuildTargetName.contains(" ")) {
            buffer.append(" ").append('\"').append(completeBuildTargetName).append('\"');
        } else {
            buffer.append(" ").append(completeBuildTargetName);
        }
        buffer.append(NEWLINE);
        buffer.append("\t").append("-").append("@").append(ECHO_BLANK_LINE).append(NEWLINE);
        return buffer;
    }

    protected boolean addRuleForTool(ITool tool, StringBuffer buffer, boolean bTargetTool, String targetName, String targetExt, List<String> outputVarsAdditionsList, Vector<String> managedProjectOutputs, boolean bEmitPostBuildStepCall) {
        Vector<String> inputs = new Vector<String>();
        Vector<String> dependencies = new Vector<String>();
        Vector<String> outputs = new Vector<String>();
        Vector<String> enumeratedPrimaryOutputs = new Vector<String>();
        Vector<String> enumeratedSecondaryOutputs = new Vector<String>();
        Vector<String> outputVariables = new Vector<String>();
        Vector<String> additionalTargets = new Vector<String>();
        String outputPrefix = EMPTY_STRING;
        if (!this.getToolInputsOutputs(tool, inputs, dependencies, outputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputVariables, additionalTargets, bTargetTool, managedProjectOutputs)) {
            return false;
        }
        if (enumeratedPrimaryOutputs.size() == 0) {
            enumeratedPrimaryOutputs = enumeratedSecondaryOutputs;
            enumeratedSecondaryOutputs.clear();
        }
        outputVarsAdditionsList.addAll(outputVariables);
        String buildRule = EMPTY_STRING;
        String outflag = tool.getOutputFlag();
        String primaryOutputs = EMPTY_STRING;
        String primaryOutputsQuoted = EMPTY_STRING;
        boolean first = true;
        int i = 0;
        while (i < enumeratedPrimaryOutputs.size()) {
            String output = enumeratedPrimaryOutputs.get(i);
            if (!first) {
                primaryOutputs = String.valueOf(primaryOutputs) + " ";
                primaryOutputsQuoted = String.valueOf(primaryOutputsQuoted) + " ";
            }
            first = false;
            primaryOutputs = String.valueOf(primaryOutputs) + output;
            primaryOutputsQuoted = String.valueOf(primaryOutputsQuoted) + this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(output);
            ++i;
        }
        buildRule = String.valueOf(buildRule) + primaryOutputsQuoted + ":" + " ";
        first = true;
        String calculatedDependencies = EMPTY_STRING;
        int i2 = 0;
        while (i2 < dependencies.size()) {
            String input = dependencies.get(i2);
            if (!first) {
                calculatedDependencies = String.valueOf(calculatedDependencies) + " ";
            }
            first = false;
            calculatedDependencies = String.valueOf(calculatedDependencies) + input;
            ++i2;
        }
        buildRule = String.valueOf(buildRule) + calculatedDependencies;
        if (!this.getRuleList().contains(buildRule)) {
            String[] flags;
            this.getRuleList().add(buildRule);
            buffer.append(buildRule).append(NEWLINE);
            if (bTargetTool) {
                buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_START_BUILD) + " " + "$@"));
            }
            buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(tool.getAnnouncement()));
            try {
                flags = tool.getToolCommandFlags(null, null);
            }
            catch (BuildException ex) {
                flags = EMPTY_STRING_ARRAY;
            }
            String command = tool.getToolCommand();
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(command, EMPTY_STRING, " ", 1, new FileContextData(null, null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    command = resolvedCommand;
                }
            }
            catch (BuildMacroException resolvedCommand) {
                // empty catch block
            }
            String[] cmdInputs = inputs.toArray(new String[inputs.size()]);
            IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
            IManagedCommandLineInfo cmdLInfo = gen.generateCommandLineInfo(tool, command, flags, outflag, outputPrefix, primaryOutputs, cmdInputs, tool.getCommandLinePattern());
            String buildCmd = null;
            if (cmdLInfo == null) {
                String toolFlags;
                try {
                    toolFlags = tool.getToolCommandFlagsString(null, null);
                }
                catch (BuildException ex) {
                    toolFlags = EMPTY_STRING;
                }
                buildCmd = String.valueOf(command) + " " + toolFlags + " " + outflag + " " + outputPrefix + primaryOutputs + " " + "$<";
            } else {
                buildCmd = cmdLInfo.getCommandLine();
            }
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(null, null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    buildCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
            buffer.append("\t").append(buildCmd);
            buffer.append(NEWLINE);
            buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(String.valueOf(bTargetTool ? MESSAGE_FINISH_BUILD : MESSAGE_FINISH_FILE) + " " + "$@"));
            buffer.append("\t").append("@").append(ECHO_BLANK_LINE);
            if (bEmitPostBuildStepCall) {
                buffer.append("\t").append("$(MAKE)").append(" ").append("--no-print-directory").append(" ").append(POSTBUILD).append(NEWLINE).append(NEWLINE);
            } else {
                buffer.append(NEWLINE);
            }
        }
        if (enumeratedSecondaryOutputs.size() > 0 || additionalTargets.size() > 0) {
            String primaryOutput = enumeratedPrimaryOutputs.get(0);
            Vector<String> addlOutputs = new Vector<String>();
            addlOutputs.addAll(enumeratedSecondaryOutputs);
            addlOutputs.addAll(additionalTargets);
            int i3 = 0;
            while (i3 < addlOutputs.size()) {
                String output = (String)addlOutputs.get(i3);
                String depLine = String.valueOf(output) + ":" + " " + primaryOutput + " " + calculatedDependencies + NEWLINE;
                if (!this.getDepLineList().contains(depLine)) {
                    this.getDepLineList().add(depLine);
                    buffer.append(depLine);
                }
                ++i3;
            }
            buffer.append(NEWLINE);
        }
        return true;
    }

    private void generateRulesForConsumers(ITool generatingTool, List<String> outputVarsAdditionsList, StringBuffer buffer) {
        IOutputType[] outTypes;
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        boolean[] buildToolsUsed = h.buildToolsUsed;
        IOutputType[] iOutputTypeArray = outTypes = generatingTool.getOutputTypes();
        int n = outTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IOutputType outType = iOutputTypeArray[n2];
            String[] outExts = outType.getOutputExtensions(generatingTool);
            String outVariable = outType.getBuildVariable();
            if (outExts != null) {
                String[] stringArray = outExts;
                int n3 = outExts.length;
                int n4 = 0;
                while (n4 < n3) {
                    String outExt = stringArray[n4];
                    int k = 0;
                    while (k < buildTools.length) {
                        IInputType inType;
                        ITool tool = buildTools[k];
                        if (!buildToolsUsed[k] && (inType = tool.getInputType(outExt)) != null) {
                            String inVariable = inType.getBuildVariable();
                            if ((outVariable == null && inVariable == null || outVariable != null && inVariable != null && outVariable.equals(inVariable)) && this.addRuleForTool(buildTools[k], buffer, false, null, null, outputVarsAdditionsList, null, false)) {
                                buildToolsUsed[k] = true;
                                this.generateRulesForConsumers(buildTools[k], outputVarsAdditionsList, buffer);
                            }
                        }
                        ++k;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected boolean getToolInputsOutputs(ITool tool, Vector<String> inputs, Vector<String> dependencies, Vector<String> outputs, Vector<String> enumeratedPrimaryOutputs, Vector<String> enumeratedSecondaryOutputs, Vector<String> outputVariables, Vector<String> additionalTargets, boolean bTargetTool, Vector<String> managedProjectOutputs) {
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        ManagedBuildGnuToolInfo[] gnuToolInfos = h.gnuToolInfos;
        IManagedBuildGnuToolInfo toolInfo = null;
        int i = 0;
        while (i < buildTools.length) {
            if (tool == buildTools[i]) {
                toolInfo = gnuToolInfos[i];
                break;
            }
            ++i;
        }
        if (toolInfo == null) {
            return false;
        }
        inputs.addAll(toolInfo.getCommandInputs());
        outputs.addAll(toolInfo.getCommandOutputs());
        enumeratedPrimaryOutputs.addAll(toolInfo.getEnumeratedPrimaryOutputs());
        enumeratedSecondaryOutputs.addAll(toolInfo.getEnumeratedSecondaryOutputs());
        outputVariables.addAll(toolInfo.getOutputVariables());
        Vector<String> unprocessedDependencies = toolInfo.getCommandDependencies();
        for (String path : unprocessedDependencies) {
            dependencies.add(this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(path));
        }
        additionalTargets.addAll(toolInfo.getAdditionalTargets());
        if (bTargetTool && managedProjectOutputs != null) {
            for (String output : managedProjectOutputs) {
                dependencies.add(output);
            }
        }
        return true;
    }

    protected Vector<String> calculateSecondaryOutputs(IOutputType[] secondaryOutputs) {
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        Vector<String> buildVars = new Vector<String>();
        int i = 0;
        while (i < buildTools.length) {
            IOutputType[] outTypes = buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    block2: while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId())) continue;
                            buildVars.add(outType.getBuildVariable());
                            break block2;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return buildVars;
    }

    protected boolean isSecondaryOutputVar(ToolInfoHolder h, IOutputType[] secondaryOutputs, String varName) {
        ITool[] buildTools;
        ITool[] iToolArray = buildTools = h.buildTools;
        int n = buildTools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool buildTool = iToolArray[n2];
            IOutputType[] outTypes = buildTool.getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                IOutputType[] iOutputTypeArray = outTypes;
                int n3 = outTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOutputType outType = iOutputTypeArray[n4];
                    IOutputType[] iOutputTypeArray2 = secondaryOutputs;
                    int n5 = secondaryOutputs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IOutputType secondaryOutput = iOutputTypeArray2[n6];
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutput.getId()) || !outType.getBuildVariable().equals(varName)) continue;
                            return true;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    private StringBuffer addSubdirectories() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(MOD_LIST)).append(NEWLINE);
        buffer.append("SUBDIRS := ").append("\\\n");
        for (IResource iResource : this.getSubdirList()) {
            this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.adding.source.folder", iResource.getFullPath().toString()));
            if (iResource.getFullPath() == this.project.getFullPath()) {
                buffer.append(".").append(" ").append("\\\n");
                continue;
            }
            IPath path = iResource.getProjectRelativePath();
            buffer.append(GnuMakefileGenerator.escapeWhitespaces(path.toString())).append(" ").append("\\\n");
        }
        buffer.append(NEWLINE);
        return buffer;
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return GnuMakefileGenerator.addDefaultHeader();
    }

    protected StringBuffer addSources(IContainer module) throws CoreException {
        String macroName;
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? EMPTY_STRING : "/");
        LinkedHashMap<String, String> buildVarToRuleStringMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<IPath>> entry : this.buildSrcVars.entrySet()) {
            macroName = entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, null, false);
        }
        for (Map.Entry<String, List<IPath>> entry : this.buildOutVars.entrySet()) {
            macroName = entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, "./" + relativePath, false);
        }
        StringBuffer buffer = new StringBuffer();
        StringBuffer ruleBuffer = new StringBuffer("# " + ManagedMakeMessages.getResourceString(MOD_RULES) + NEWLINE);
        IResource[] resources = module.members();
        IFolder folder = this.project.getFolder(this.computeTopBuildDir(this.config.getName()));
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath rcProjRelPath;
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1 && this.isSource(rcProjRelPath = resource.getProjectRelativePath())) {
                IResourceInfo rcInfo = this.config.getResourceInfo(rcProjRelPath, false);
                this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, resource, this.getPathForResource(resource), rcInfo, null, false);
            }
            ++n2;
        }
        buffer.append(this.writeAdditionMacros(buildVarToRuleStringMap));
        return buffer.append(ruleBuffer).append(NEWLINE);
    }

    protected void addFragmentMakefileEntriesForSource(LinkedHashMap<String, String> buildVarToRuleStringMap, StringBuffer ruleBuffer, IFolder folder, String relativePath, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, String varName, boolean generatedSource) {
        ITool buildTool;
        int n;
        int n2;
        ITool[] iToolArray;
        IFileInfo fi;
        ITool[] tools;
        String ext = sourceLocation.getFileExtension();
        ITool tool = null;
        if (rcInfo instanceof IFileInfo && (tools = (fi = (IFileInfo)rcInfo).getToolsToInvoke()) != null && tools.length > 0) {
            tool = tools[0];
            this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
        }
        ToolInfoHolder h = this.getToolInfo(rcInfo.getPath());
        ITool[] buildTools = h.buildTools;
        if (tool == null) {
            h = this.getToolInfo((IPath)Path.EMPTY);
            iToolArray = buildTools = h.buildTools;
            n2 = buildTools.length;
            n = 0;
            while (n < n2) {
                buildTool = iToolArray[n];
                if (buildTool.buildsFileType(ext)) {
                    tool = buildTool;
                    this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
                    break;
                }
                ++n;
            }
        }
        if (tool != null) {
            IInputType primaryInputType = tool.getPrimaryInputType();
            IInputType inputType = tool.getInputType(ext);
            if (primaryInputType != null && !primaryInputType.getMultipleOfType() || inputType == null && tool != this.config.calculateTargetTool()) {
                Vector<IPath> generatedOutputs = new Vector<IPath>();
                Vector<IPath> generatedDepFiles = new Vector<IPath>();
                this.addRuleForSource(relativePath, ruleBuffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, generatedOutputs);
                if (generatedDepFiles.size() > 0) {
                    int k = 0;
                    while (k < generatedDepFiles.size()) {
                        IPath generatedDepFile = generatedDepFiles.get(k);
                        this.addMacroAdditionFile(buildVarToRuleStringMap, this.getDepMacroName(ext).toString(), String.valueOf(generatedDepFile.isAbsolute() ? EMPTY_STRING : "./") + generatedDepFile.toString());
                        ++k;
                    }
                }
                IOutputType outType = tool.getPrimaryOutputType();
                String buildVariable = null;
                if (outType != null) {
                    if (tool.getCustomBuildStep()) {
                        if (generatedOutputs.size() > 0) {
                            ITool[] tmpBuildTools;
                            IPath firstOutput = generatedOutputs.get(0);
                            String firstExt = firstOutput.getFileExtension();
                            ToolInfoHolder tmpH = this.getFolderToolInfo(rcInfo.getPath());
                            ITool[] iToolArray2 = tmpBuildTools = tmpH.buildTools;
                            int n3 = tmpBuildTools.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String bV;
                                ITool tmpBuildTool = iToolArray2[n4];
                                if (tmpBuildTool.buildsFileType(firstExt) && (bV = tmpBuildTool.getPrimaryInputType().getBuildVariable()).length() > 0) {
                                    buildVariable = bV;
                                    break;
                                }
                                ++n4;
                            }
                        }
                    } else {
                        buildVariable = outType.getBuildVariable();
                    }
                } else {
                    buildVariable = OBJS_MACRO;
                }
                int k = 0;
                while (k < generatedOutputs.size()) {
                    IFile generateOutputResource;
                    IPath generatedOutput;
                    if (generatedOutputs.get(k).isAbsolute()) {
                        generatedOutput = generatedOutputs.get(k);
                        generateOutputResource = this.project.getFile(generatedOutput);
                    } else {
                        generatedOutput = this.getPathForResource((IResource)this.project).append(this.getBuildWorkingDir()).append(generatedOutputs.get(k));
                        generateOutputResource = this.project.getFile(this.getBuildWorkingDir().append(generatedOutputs.get(k)));
                    }
                    IResourceInfo nextRcInfo = rcInfo instanceof IFileInfo ? this.config.getResourceInfo(rcInfo.getPath().removeLastSegments(1), false) : rcInfo;
                    this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, (IResource)generateOutputResource, generatedOutput, nextRcInfo, buildVariable, true);
                    ++k;
                }
            }
        } else if (varName == null) {
            iToolArray = buildTools;
            n2 = buildTools.length;
            n = 0;
            while (n < n2) {
                buildTool = iToolArray[n];
                if (buildTool.isInputFileType(ext)) {
                    this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
                    break;
                }
                ++n;
            }
        } else {
            IOutputType[] secondaryOutputs = this.config.getToolChain().getSecondaryOutputs();
            if (secondaryOutputs.length > 0 && this.isSecondaryOutputVar(h, secondaryOutputs, varName)) {
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
            }
        }
    }

    protected IPath getPathForResource(IResource resource) {
        return new Path(resource.getLocationURI().getPath());
    }

    protected void addToBuildVar(LinkedHashMap<String, String> buildVarToRuleStringMap, String ext, String varName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        List<IPath> varList = null;
        if (varName == null) {
            varName = this.getSourceMacroName(ext).toString();
            varList = this.buildSrcVars.get(varName);
        } else {
            varList = this.buildOutVars.get(varName);
        }
        if (varList != null && !varList.contains(sourceLocation)) {
            varList.add(sourceLocation);
            if (buildVarToRuleStringMap.containsKey(varName)) {
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
            }
        }
    }

    private IManagedCommandLineInfo generateToolCommandLineInfo(ITool tool, String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = inputLocation != null && inputLocation.toString().indexOf(" ") != -1 || outputLocation != null && outputLocation.toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, EMPTY_STRING, " ", 1, new FileContextData(inputLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(inputLocation, outputLocation, null, tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException resolvedCommand) {
            // empty catch block
        }
        IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
        return gen.generateCommandLineInfo(tool, cmd, flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
    }

    protected void addRuleForSource(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, boolean generatedSource, Vector<IPath> generatedDepFiles, Vector<IPath> enumeratedOutputs) {
        String depLine;
        Object[] depCmds2;
        String[] addlPath2;
        IPath[] addlDepPaths;
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String inputExtension = sourceLocation.getFileExtension();
        String outputExtension = null;
        ITool tool = null;
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)rcInfo;
            ITool[] tools = fi.getToolsToInvoke();
            if (tools != null && tools.length > 0) {
                tool = tools[0];
            }
        } else {
            IFolderInfo foInfo = (IFolderInfo)rcInfo;
            tool = foInfo.getToolFromInputExtension(inputExtension);
        }
        ToolInfoHolder h = this.getToolInfo(rcInfo.getPath());
        if (tool != null) {
            outputExtension = tool.getOutputExtension(inputExtension);
        }
        if (outputExtension == null) {
            outputExtension = EMPTY_STRING;
        }
        IManagedDependencyGenerator oldDepGen = null;
        IManagedDependencyGenerator2 depGen = null;
        IManagedDependencyInfo depInfo = null;
        IManagedDependencyCommands depCommands = null;
        IManagedDependencyPreBuild depPreBuild = null;
        IPath[] depFiles = null;
        boolean doDepGen = false;
        IManagedDependencyGeneratorType t = null;
        if (tool != null) {
            t = tool.getDependencyGeneratorForExtension(inputExtension);
        }
        if (t != null) {
            int calcType = t.getCalculatorType();
            if (calcType <= 3) {
                oldDepGen = (IManagedDependencyGenerator)t;
                boolean bl = doDepGen = calcType == 1;
                if (doDepGen) {
                    IPath depFile = Path.fromOSString((String)(String.valueOf(relativePath) + fileName + "." + "d"));
                    this.getDependencyMakefiles(h).add(depFile);
                    generatedDepFiles.add(depFile);
                }
            } else {
                depGen = (IManagedDependencyGenerator2)t;
                doDepGen = calcType == 5;
                IResourceInfo buildContext = rcInfo;
                depInfo = depGen.getDependencySourceInfo(resource.getProjectRelativePath(), resource, buildContext, tool, this.getBuildWorkingDir());
                if (calcType == 5) {
                    depCommands = (IManagedDependencyCommands)depInfo;
                    depFiles = depCommands.getDependencyFiles();
                } else if (calcType == 6) {
                    depPreBuild = (IManagedDependencyPreBuild)depInfo;
                    depFiles = depPreBuild.getDependencyFiles();
                }
                if (depFiles != null) {
                    IPath[] iPathArray = depFiles;
                    int n = depFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath depFile = iPathArray[n2];
                        this.getDependencyMakefiles(h).add(depFile);
                        generatedDepFiles.add(depFile);
                        ++n2;
                    }
                }
            }
        }
        String optDotExt = EMPTY_STRING;
        if (outputExtension.length() > 0) {
            optDotExt = "." + outputExtension;
        }
        Vector<IPath> ruleOutputs = new Vector<IPath>();
        Vector<IPath> enumeratedPrimaryOutputs = new Vector<IPath>();
        Vector<IPath> enumeratedSecondaryOutputs = new Vector<IPath>();
        this.calculateOutputsForSource(tool, relativePath, resource, sourceLocation, ruleOutputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs);
        enumeratedOutputs.addAll(enumeratedPrimaryOutputs);
        enumeratedOutputs.addAll(enumeratedSecondaryOutputs);
        String primaryOutputName = null;
        primaryOutputName = enumeratedPrimaryOutputs.size() > 0 ? GnuMakefileGenerator.escapeWhitespaces(enumeratedPrimaryOutputs.get(0).toString()) : GnuMakefileGenerator.escapeWhitespaces(String.valueOf(relativePath) + fileName + optDotExt);
        String otherPrimaryOutputs = EMPTY_STRING;
        int i = 1;
        while (i < enumeratedPrimaryOutputs.size()) {
            otherPrimaryOutputs = String.valueOf(otherPrimaryOutputs) + " " + GnuMakefileGenerator.escapeWhitespaces(enumeratedPrimaryOutputs.get(i).toString());
            ++i;
        }
        IPath outputLocation = Path.fromOSString((String)primaryOutputName);
        if (!outputLocation.isAbsolute()) {
            outputLocation = this.getPathForResource((IResource)this.project).append(this.getBuildWorkingDir()).append(primaryOutputName);
        }
        boolean resourceNameRequiresExplicitRule = resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) || !resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(resource.getProjectRelativePath().toString());
        boolean needExplicitRuleForFile = resourceNameRequiresExplicitRule || BuildMacroProvider.getReferencedExplitFileMacros(tool).length > 0 || BuildMacroProvider.getReferencedExplitFileMacros(tool.getToolCommand(), 1, new FileContextData(sourceLocation, outputLocation, null, tool)).length > 0;
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = !needExplicitRuleForFile ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException resolvedCommand) {
            // empty catch block
        }
        String defaultOutputName = EMPTY_STRING;
        String primaryDependencyName = EMPTY_STRING;
        String patternPrimaryDependencyName = EMPTY_STRING;
        String home = generatedSource ? "." : this.reachProjectRoot();
        String resourcePath = null;
        boolean patternRule = true;
        boolean isItLinked = false;
        if (resource.isLinked(512)) {
            isItLinked = true;
            resourcePath = sourceLocation.toString();
            defaultOutputName = GnuMakefileGenerator.escapeWhitespaces(String.valueOf(relativePath) + fileName + optDotExt);
            primaryDependencyName = GnuMakefileGenerator.escapeWhitespaces(resourcePath);
            patternRule = false;
        } else {
            resourcePath = relativePath;
            if (rcInfo instanceof IFileInfo || needExplicitRuleForFile) {
                defaultOutputName = GnuMakefileGenerator.escapeWhitespaces(String.valueOf(resourcePath) + fileName + optDotExt);
                patternRule = false;
            } else {
                defaultOutputName = String.valueOf(relativePath) + "%" + optDotExt;
            }
            primaryDependencyName = GnuMakefileGenerator.escapeWhitespaces(String.valueOf(home) + "/" + resourcePath + fileName + "." + inputExtension);
            patternPrimaryDependencyName = String.valueOf(home) + "/" + resourcePath + "%" + "." + inputExtension;
        }
        boolean needExplicitDependencyCommands = false;
        if (depCommands != null) {
            boolean bl = needExplicitDependencyCommands = !depCommands.areCommandsGeneric();
        }
        if (patternRule) {
            patternRule = false;
            int i2 = 0;
            while (i2 < ruleOutputs.size()) {
                String ruleOutput = ruleOutputs.get(i2).toString();
                if (ruleOutput.indexOf(37) >= 0) {
                    patternRule = true;
                    break;
                }
                ++i2;
            }
            if (patternRule) {
                patternRule = !needExplicitDependencyCommands;
            }
        }
        String buildRule = EMPTY_STRING;
        if (patternRule) {
            if (ruleOutputs.size() == 0) {
                buildRule = String.valueOf(buildRule) + defaultOutputName;
            } else {
                boolean first = true;
                int i3 = 0;
                while (i3 < ruleOutputs.size()) {
                    String ruleOutput = ruleOutputs.get(i3).toString();
                    if (ruleOutput.indexOf(37) >= 0) {
                        if (first) {
                            first = false;
                        } else {
                            buildRule = String.valueOf(buildRule) + " ";
                        }
                        buildRule = String.valueOf(buildRule) + ruleOutput;
                    }
                    ++i3;
                }
            }
        } else {
            buildRule = String.valueOf(buildRule) + primaryOutputName;
        }
        String buildRuleDependencies = primaryDependencyName;
        String patternBuildRuleDependencies = patternPrimaryDependencyName;
        IPath[] iPathArray = addlDepPaths = tool.getAdditionalDependencies();
        int n = addlDepPaths.length;
        int n3 = 0;
        while (n3 < n) {
            IPath tempPath;
            String[] addlDepPath = iPathArray[n3];
            addlPath2 = addlDepPath;
            if (!addlPath2.toString().startsWith("$(") && !addlPath2.isAbsolute() && (tempPath = this.project.getLocation().append((IPath)new Path(GnuMakefileGenerator.ensureUnquoted(addlPath2.toString())))) != null) {
                addlPath2 = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
            }
            String suitablePath = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(addlPath2.toString());
            buildRuleDependencies = String.valueOf(buildRuleDependencies) + " " + suitablePath;
            patternBuildRuleDependencies = String.valueOf(patternBuildRuleDependencies) + " " + suitablePath;
            ++n3;
        }
        buildRule = String.valueOf(buildRule) + ": " + (patternRule ? patternBuildRuleDependencies : buildRuleDependencies);
        if (!this.getRuleList().contains(buildRule)) {
            int n4;
            int n5;
            String[] stringArray;
            String buildCmd;
            IPath[] addlInputPaths;
            Object resolvedCommand2;
            String[] preToolCommands;
            this.getRuleList().add(buildRule);
            buffer.append(buildRule).append(NEWLINE);
            buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_START_FILE) + " " + "$<"));
            buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(tool.getAnnouncement()));
            if (depCommands != null && (preToolCommands = depCommands.getPreToolDependencyCommands()) != null && preToolCommands.length > 0) {
                addlPath2 = preToolCommands;
                int n6 = preToolCommands.length;
                n = 0;
                while (n < n6) {
                    String preCmd = addlPath2[n];
                    try {
                        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
                        resolvedCommand2 = !needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(preCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : provider.resolveValue(preCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                        if (resolvedCommand2 != null) {
                            buffer.append((String)resolvedCommand2).append(NEWLINE);
                        }
                    }
                    catch (BuildMacroException resolvedCommand2) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            Vector<String> inputs = new Vector<String>();
            inputs.add("$<");
            resolvedCommand2 = addlInputPaths = this.getAdditionalResourcesForSource(tool);
            int addlPath2 = addlInputPaths.length;
            int n7 = 0;
            while (n7 < addlPath2) {
                IPath tempPath;
                IPath addlInputPath = resolvedCommand2[n7];
                IPath addlPath3 = addlInputPath;
                if (!addlPath3.toString().startsWith("$(") && !addlPath3.isAbsolute() && (tempPath = this.getPathForResource((IResource)this.project).append(addlPath3)) != null) {
                    addlPath3 = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
                }
                inputs.add(addlPath3.toString());
                ++n7;
            }
            String[] inputStrings = inputs.toArray(new String[inputs.size()]);
            String[] flags = null;
            try {
                flags = tool.getToolCommandFlags(sourceLocation, outputLocation);
            }
            catch (BuildException ex) {
                flags = EMPTY_STRING_ARRAY;
            }
            if (depCommands != null) {
                flags = this.addDependencyOptions(depCommands, flags);
            }
            IManagedCommandLineInfo cmdLInfo = null;
            String outflag = null;
            String outputPrefix = null;
            if (rcInfo instanceof IFileInfo || needExplicitRuleForFile || needExplicitDependencyCommands) {
                outflag = tool.getOutputFlag();
                outputPrefix = tool.getOutputPrefix();
                IManagedCommandLineGenerator cmdLGen = tool.getCommandLineGenerator();
                cmdLInfo = cmdLGen.generateCommandLineInfo(tool, cmd, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputStrings, tool.getCommandLinePattern());
            } else {
                outflag = tool.getOutputFlag();
                outputPrefix = tool.getOutputPrefix();
                cmdLInfo = this.generateToolCommandLineInfo(tool, inputExtension, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputStrings, sourceLocation, outputLocation);
            }
            if (cmdLInfo != null) {
                buildCmd = cmdLInfo.getCommandLine();
            } else {
                StringBuffer buildFlags = new StringBuffer();
                stringArray = flags;
                n5 = flags.length;
                n4 = 0;
                while (n4 < n5) {
                    String flag = stringArray[n4];
                    if (flag != null) {
                        buildFlags.append(flag).append(" ");
                    }
                    ++n4;
                }
                buildCmd = String.valueOf(cmd) + " " + buildFlags.toString().trim() + " " + outflag + " " + outputPrefix + "$@" + otherPrimaryOutputs + " " + "$<";
            }
            try {
                IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
                String resolvedCommand3 = !needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : provider.resolveValue(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                resolvedCommand3 = resolvedCommand3.trim();
                if (resolvedCommand3.length() > 0) {
                    buildCmd = resolvedCommand3;
                }
            }
            catch (BuildMacroException resolvedCommand4) {
                // empty catch block
            }
            buffer.append("\t").append(buildCmd);
            if (doDepGen) {
                depCmds2 = null;
                if (oldDepGen != null) {
                    depCmds2 = new String[]{oldDepGen.getDependencyCommand(resource, ManagedBuildManager.getBuildInfo((IResource)this.project))};
                } else if (depCommands != null) {
                    depCmds2 = depCommands.getPostToolDependencyCommands();
                }
                if (depCmds2 != null) {
                    stringArray = depCmds2;
                    n5 = depCmds2.length;
                    n4 = 0;
                    while (n4 < n5) {
                        String depCmd = stringArray[n4];
                        buffer.append(" ").append("&&").append(" ").append("\\\n");
                        try {
                            depCmd = !needExplicitRuleForFile ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValue(depCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                        }
                        catch (BuildMacroException buildMacroException) {
                            // empty catch block
                        }
                        buffer.append(depCmd);
                        ++n4;
                    }
                }
            }
            buffer.append(NEWLINE);
            buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_FINISH_FILE) + " " + "$<"));
            buffer.append("\t").append("@").append(ECHO_BLANK_LINE).append(NEWLINE);
        }
        IPath[] addlDeps = null;
        IPath[] addlTargets = null;
        String calculatedDependencies = null;
        boolean addedDepLines = false;
        if (oldDepGen != null && oldDepGen.getCalculatorType() != 1) {
            addlDeps = this.oldCalculateDependenciesForSource(oldDepGen, tool, relativePath, resource);
        } else if (depGen != null && depGen.getCalculatorType() == 7 && depInfo instanceof IManagedDependencyCalculator) {
            IManagedDependencyCalculator depCalculator = (IManagedDependencyCalculator)depInfo;
            addlDeps = this.calculateDependenciesForSource(depCalculator);
            addlTargets = depCalculator.getAdditionalTargets();
        }
        if (addlDeps != null && addlDeps.length > 0) {
            calculatedDependencies = EMPTY_STRING;
            depCmds2 = addlDeps;
            int buildCmd = addlDeps.length;
            int outputPrefix = 0;
            while (outputPrefix < buildCmd) {
                IPath addlDep = depCmds2[outputPrefix];
                calculatedDependencies = String.valueOf(calculatedDependencies) + " " + GnuMakefileGenerator.escapeWhitespaces(addlDep.toString());
                ++outputPrefix;
            }
        }
        if (calculatedDependencies != null) {
            depLine = String.valueOf(primaryOutputName) + ":" + calculatedDependencies + NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
        }
        Vector<IPath> addlOutputs = new Vector<IPath>();
        if (enumeratedPrimaryOutputs.size() > 1) {
            int i4 = 1;
            while (i4 < enumeratedPrimaryOutputs.size()) {
                addlOutputs.add(enumeratedPrimaryOutputs.get(i4));
                ++i4;
            }
        }
        addlOutputs.addAll(enumeratedSecondaryOutputs);
        if (addlTargets != null) {
            IPath[] iPathArray2 = addlTargets;
            int depCmds2 = addlTargets.length;
            int buildCmd = 0;
            while (buildCmd < depCmds2) {
                IPath addlTarget = iPathArray2[buildCmd];
                addlOutputs.add(addlTarget);
                ++buildCmd;
            }
        }
        int i5 = 0;
        while (i5 < addlOutputs.size()) {
            depLine = String.valueOf(GnuMakefileGenerator.escapeWhitespaces(((IPath)addlOutputs.get(i5)).toString())) + ":" + " " + primaryOutputName;
            if (calculatedDependencies != null) {
                depLine = String.valueOf(depLine) + calculatedDependencies;
            }
            depLine = String.valueOf(depLine) + NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
            ++i5;
        }
        if (addedDepLines) {
            buffer.append(NEWLINE);
        }
        if (depPreBuild != null && depFiles != null) {
            addedDepLines = false;
            String[] preBuildCommands = depPreBuild.getDependencyCommands();
            if (preBuildCommands != null) {
                depLine = EMPTY_STRING;
                patternRule = !isItLinked && !needExplicitRuleForFile && depPreBuild.areCommandsGeneric();
                int i6 = 0;
                while (i6 < depFiles.length) {
                    if (i6 > 0) {
                        depLine = String.valueOf(depLine) + " ";
                    }
                    if (patternRule) {
                        optDotExt = EMPTY_STRING;
                        String depExt = depFiles[i6].getFileExtension();
                        if (depExt != null && depExt.length() > 0) {
                            optDotExt = "." + depExt;
                        }
                        depLine = String.valueOf(depLine) + GnuMakefileGenerator.escapeWhitespaces(String.valueOf(relativePath) + "%" + optDotExt);
                    } else {
                        depLine = String.valueOf(depLine) + GnuMakefileGenerator.escapeWhitespaces(depFiles[i6].toString());
                    }
                    ++i6;
                }
                depLine = String.valueOf(depLine) + ": " + (patternRule ? patternBuildRuleDependencies : buildRuleDependencies);
                if (!this.getDepRuleList().contains(depLine)) {
                    this.getDepRuleList().add(depLine);
                    addedDepLines = true;
                    buffer.append(depLine).append(NEWLINE);
                    buffer.append("\t").append("@").append(GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_START_DEPENDENCY) + " " + "$@"));
                    String[] stringArray = preBuildCommands;
                    int n8 = preBuildCommands.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        String preBuildCommand;
                        depLine = preBuildCommand = stringArray[n9];
                        try {
                            depLine = !needExplicitRuleForFile ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depLine, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValue(depLine, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                        }
                        catch (BuildMacroException buildMacroException) {
                            // empty catch block
                        }
                        buffer.append("\t").append(depLine).append(NEWLINE);
                        ++n9;
                    }
                }
                if (addedDepLines) {
                    buffer.append("\t").append("@").append(ECHO_BLANK_LINE).append(NEWLINE);
                }
            }
        }
    }

    private String[] addDependencyOptions(IManagedDependencyCommands depCommands, String[] flags) {
        String[] depOptions = depCommands.getDependencyCommandOptions();
        if (depOptions != null && depOptions.length > 0) {
            int flagsLen = flags.length;
            String[] flagsCopy = new String[flags.length + depOptions.length];
            int i = 0;
            while (i < flags.length) {
                flagsCopy[i] = flags[i];
                ++i;
            }
            i = 0;
            while (i < depOptions.length) {
                flagsCopy[i + flagsLen] = depOptions[i];
                ++i;
            }
            flags = flagsCopy;
        }
        return flags;
    }

    protected IPath[] getAdditionalResourcesForSource(ITool tool) {
        IInputType[] types;
        ArrayList<IPath> allRes = new ArrayList<IPath>();
        IInputType[] iInputTypeArray = types = tool.getInputTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IPath[] res;
            IInputType type = iInputTypeArray[n2];
            IPath[] iPathArray = res = type.getAdditionalResources();
            int n3 = res.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath re = iPathArray[n4];
                allRes.add(re);
                ++n4;
            }
            if (!type.getPrimaryInput() && type != tool.getPrimaryInputType()) {
                String var = type.getBuildVariable();
                if (var != null && var.length() > 0) {
                    allRes.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
                } else {
                    String[] typeExts = type.getSourceExtensions(tool);
                    IResource[] iResourceArray = this.projectResources;
                    int n5 = this.projectResources.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IResource projectResource = iResourceArray[n6];
                        if (projectResource.getType() == 1) {
                            String fileExt = projectResource.getFileExtension();
                            if (fileExt == null) {
                                fileExt = EMPTY_STRING;
                            }
                            String[] stringArray = typeExts;
                            int n7 = typeExts.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String typeExt = stringArray[n8];
                                if (fileExt.equals(typeExt)) {
                                    allRes.add(projectResource.getProjectRelativePath());
                                    break;
                                }
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                }
                IOption assignToOption = tool.getOptionBySuperClassId(type.getAssignToOptionId());
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                if (assignToOption != null && option == null) {
                    try {
                        int optType = assignToOption.getValueType();
                        IResourceInfo rcInfo = tool.getParentResourceInfo();
                        if (rcInfo != null) {
                            if (optType == 2) {
                                String optVal = EMPTY_STRING;
                                int j = 0;
                                while (j < allRes.size()) {
                                    IPath addlPath;
                                    IFile addlResource;
                                    String resPath;
                                    if (j != 0) {
                                        optVal = String.valueOf(optVal) + " ";
                                    }
                                    if (!(resPath = ((IPath)allRes.get(j)).toString()).startsWith("$(") && (addlResource = this.project.getFile(resPath)) != null && (addlPath = addlResource.getLocation()) != null) {
                                        resPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath).toString();
                                    }
                                    optVal = String.valueOf(optVal) + ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), Path.fromOSString((String)resPath)).toString();
                                    ++j;
                                }
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, optVal);
                            } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                                String[] paths = new String[allRes.size()];
                                int j = 0;
                                while (j < allRes.size()) {
                                    IPath addlPath;
                                    IFile addlResource;
                                    paths[j] = ((IPath)allRes.get(j)).toString();
                                    if (!paths[j].startsWith("$(") && (addlResource = this.project.getFile(paths[j])) != null && (addlPath = addlResource.getLocation()) != null) {
                                        paths[j] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath).toString();
                                    }
                                    ++j;
                                }
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, paths);
                            } else if (optType == 0) {
                                boolean b = false;
                                if (allRes.size() > 0) {
                                    b = true;
                                }
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, b);
                            } else if ((optType == 1 || optType == 12) && allRes.size() > 0) {
                                String s = ((IPath)allRes.get(0)).toString();
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, s);
                            }
                            allRes.clear();
                        }
                    }
                    catch (BuildException buildException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        return allRes.toArray(new IPath[allRes.size()]);
    }

    protected void calculateOutputsForSource(ITool tool, String relativePath, IResource resource, IPath sourceLocation, Vector<IPath> ruleOutputs, Vector<IPath> enumeratedPrimaryOutputs, Vector<IPath> enumeratedSecondaryOutputs) {
        String inExt = sourceLocation.getFileExtension();
        String outExt = tool.getOutputExtension(inExt);
        IResourceInfo rcInfo = tool.getParentResourceInfo();
        IOutputType[] outTypes = tool.getOutputTypes();
        if (outTypes != null && outTypes.length > 0) {
            IOutputType[] iOutputTypeArray = outTypes;
            int n = outTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IOutputType type = iOutputTypeArray[n2];
                boolean primaryOutput = type == tool.getPrimaryOutputType();
                String outputPrefix = type.getOutputPrefix();
                try {
                    outputPrefix = GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputPrefix, EMPTY_STRING, " ", 3, this.config) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputPrefix, EMPTY_STRING, " ", 3, this.config);
                }
                catch (BuildMacroException buildMacroException) {
                    // empty catch block
                }
                boolean multOfType = type.getMultipleOfType();
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                IManagedOutputNameProvider nameProvider = type.getNameProvider();
                String[] outputNames = type.getOutputNames();
                if (option != null) {
                    try {
                        ArrayList<String> outputList = new ArrayList<String>();
                        int optType = option.getValueType();
                        if (optType == 2) {
                            outputList.add(String.valueOf(outputPrefix) + option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                            List value = (List)option.getValue();
                            outputList = value;
                            ((Tool)tool).filterValues(optType, outputList);
                            if (outputPrefix.length() > 0) {
                                int j = 0;
                                while (j < outputList.size()) {
                                    outputList.set(j, String.valueOf(outputPrefix) + (String)outputList.get(j));
                                    ++j;
                                }
                            }
                        }
                        int j = 0;
                        while (j < outputList.size()) {
                            IPath outPath;
                            String outputName = (String)outputList.get(j);
                            try {
                                String resolved = null;
                                resolved = GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputName, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, null, option, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, null, option, tool));
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    outputName = resolved;
                                }
                            }
                            catch (BuildMacroException resolved) {
                                // empty catch block
                            }
                            if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                                outPath = Path.fromOSString((String)(String.valueOf(relativePath) + (String)outputList.get(j)));
                            }
                            if (primaryOutput) {
                                ruleOutputs.add(j, outPath);
                                enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                            } else {
                                ruleOutputs.add(outPath);
                                enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                            }
                            ++j;
                        }
                    }
                    catch (BuildException outputList) {}
                } else if (nameProvider != null) {
                    IPath[] inPaths = new IPath[]{sourceLocation};
                    IPath[] outPaths = nameProvider.getOutputNames(tool, inPaths);
                    if (outPaths != null) {
                        int j = 0;
                        while (j < outPaths.length) {
                            IPath outPath = outPaths[j];
                            String outputName = outPaths[j].toString();
                            try {
                                String resolved = null;
                                resolved = GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputName, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, null, option, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, null, option, tool));
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    outputName = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {
                                // empty catch block
                            }
                            if (outPath.segmentCount() == 1) {
                                outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                            }
                            if (primaryOutput) {
                                ruleOutputs.add(j, outPath);
                                enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                            } else {
                                ruleOutputs.add(outPath);
                                enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                            }
                            ++j;
                        }
                    }
                } else if (outputNames != null) {
                    int j = 0;
                    while (j < outputNames.length) {
                        IPath outPath;
                        String outputName = outputNames[j];
                        try {
                            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, null, option, tool));
                            resolved = resolved.trim();
                            if (resolved.length() > 0) {
                                outputName = resolved;
                            }
                        }
                        catch (BuildMacroException resolved) {
                            // empty catch block
                        }
                        if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j, outPath);
                            enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                        }
                        ++j;
                    }
                } else if (!multOfType) {
                    String namePattern = type.getNamePattern();
                    IPath namePatternPath = null;
                    if (namePattern == null || namePattern.length() == 0) {
                        namePattern = String.valueOf(relativePath) + outputPrefix + "%";
                        if (outExt != null && outExt.length() > 0) {
                            namePattern = String.valueOf(namePattern) + "." + outExt;
                        }
                        namePatternPath = Path.fromOSString((String)namePattern);
                    } else {
                        if (outputPrefix.length() > 0) {
                            namePattern = String.valueOf(outputPrefix) + namePattern;
                        }
                        if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                            namePatternPath = Path.fromOSString((String)(String.valueOf(relativePath) + namePatternPath.toString()));
                        }
                    }
                    if (primaryOutput) {
                        ruleOutputs.add(0, namePatternPath);
                        enumeratedPrimaryOutputs.add(0, this.resolvePercent(namePatternPath, sourceLocation));
                    } else {
                        ruleOutputs.add(namePatternPath);
                        enumeratedSecondaryOutputs.add(this.resolvePercent(namePatternPath, sourceLocation));
                    }
                }
                ++n2;
            }
        } else {
            String outPrefix = tool.getOutputPrefix();
            IPath outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPrefix + "%"));
            outPath = outPath.addFileExtension(outExt);
            ruleOutputs.add(0, outPath);
            enumeratedPrimaryOutputs.add(0, this.resolvePercent(outPath, sourceLocation));
        }
    }

    protected IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll("%", fileName);
        IPath result = Path.fromOSString((String)outName);
        return DOT_SLASH_PATH.isPrefixOf(outPath) ? DOT_SLASH_PATH.append(result) : result;
    }

    protected IPath[] oldCalculateDependenciesForSource(IManagedDependencyGenerator depGen, ITool tool, String relativePath, IResource resource) {
        Vector<IPath> deps = new Vector<IPath>();
        int type = depGen.getCalculatorType();
        switch (type) {
            case 2: 
            case 3: {
                IResource[] res = depGen.findDependencies(resource, this.project);
                if (res == null) break;
                IResource[] iResourceArray = res;
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath addlPath;
                    IResource re = iResourceArray[n2];
                    IPath dep = null;
                    if (re != null && (addlPath = re.getLocation()) != null) {
                        dep = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath);
                    }
                    if (dep != null) {
                        deps.add(dep);
                    }
                    ++n2;
                }
                break;
            }
        }
        return deps.toArray(new IPath[deps.size()]);
    }

    protected IPath[] calculateDependenciesForSource(IManagedDependencyCalculator depCalculator) {
        IPath[] addlDeps = depCalculator.getDependencies();
        if (addlDeps != null) {
            int i = 0;
            while (i < addlDeps.length) {
                if (!addlDeps[i].isAbsolute()) {
                    IPath absolutePath = this.project.getLocation().append(addlDeps[i]);
                    addlDeps[i] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), absolutePath);
                }
                ++i;
            }
        }
        return addlDeps;
    }

    public StringBuffer getSourceMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(extensionName.toUpperCase()).append("_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_SRCS");
        return macroName;
    }

    public StringBuffer getDepMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(extensionName.toUpperCase()).append("_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_DEPS");
        return macroName;
    }

    public Set<String> getOutputExtensions(ToolInfoHolder h) {
        if (h.outputExtensionsSet == null) {
            h.outputExtensionsSet = new HashSet<String>();
            ITool[] iToolArray = h.buildTools;
            int n = h.buildTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                String[] outputs = tool.getAllOutputExtensions();
                if (outputs != null) {
                    h.outputExtensionsSet.addAll(Arrays.asList(outputs));
                }
                ++n2;
            }
        }
        return h.outputExtensionsSet;
    }

    public static boolean populateDummyTargets(IConfiguration cfg, IFile makefile, boolean force) throws CoreException, IOException {
        return GnuMakefileGenerator.populateDummyTargets(cfg.getRootFolderInfo(), makefile, force);
    }

    public static boolean populateDummyTargets(IResourceInfo rcInfo, IFile makefile, boolean force) throws CoreException, IOException {
        String firstToken;
        String[] bufferLines;
        if (makefile == null || !makefile.exists()) {
            return false;
        }
        InputStream contentStream = makefile.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        StringBuffer inBuffer = null;
        int chunkSize = contentStream.available();
        inBuffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            inBuffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        String inBufferString = inBuffer.toString();
        if (!force && inBufferString.startsWith("#")) {
            return false;
        }
        String[] stringArray = bufferLines = inBufferString.split("[\\r\\n]");
        int n2 = bufferLines.length;
        int n3 = 0;
        while (n3 < n2) {
            String bufferLine = stringArray[n3];
            if (bufferLine.endsWith(":")) {
                StringBuffer outBuffer = GnuMakefileGenerator.addDefaultHeader();
                outBuffer.append(inBuffer);
                GnuMakefileGenerator.save(outBuffer, makefile);
                return true;
            }
            ++n3;
        }
        Vector<String> bufferTokens = new Vector<String>(Arrays.asList(inBufferString.split("\\s")));
        Vector<String> deps = new Vector<String>(bufferTokens.size());
        Iterator<String> tokenIter = bufferTokens.iterator();
        while (tokenIter.hasNext()) {
            String token = tokenIter.next();
            if (token.lastIndexOf("\\") == token.length() - 1 && token.length() > 1) {
                while (tokenIter.hasNext()) {
                    String nextToken = tokenIter.next();
                    token = String.valueOf(token) + " " + nextToken;
                    if (!nextToken.endsWith("\\")) break;
                }
            }
            deps.add(token);
        }
        deps.trimToSize();
        boolean save = false;
        StringBuffer outBuffer = null;
        try {
            firstToken = (String)deps.get(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        outBuffer = !firstToken.startsWith("#") ? GnuMakefileGenerator.addDefaultHeader() : new StringBuffer();
        if (firstToken.startsWith("-n")) {
            String fourthToken;
            String thirdToken;
            String secondToken;
            try {
                secondToken = (String)deps.get(1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                secondToken = EMPTY_STRING;
            }
            if (secondToken.startsWith("'")) {
                outBuffer.append(secondToken.substring(1)).append(" ");
            } else {
                outBuffer.append(secondToken).append(" ");
            }
            try {
                thirdToken = (String)deps.get(2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                thirdToken = EMPTY_STRING;
            }
            int lastIndex = thirdToken.lastIndexOf("'");
            if (lastIndex != -1) {
                if (lastIndex == 0) {
                    outBuffer.append(" ");
                } else {
                    outBuffer.append(thirdToken.substring(0, lastIndex - 1));
                }
            } else {
                outBuffer.append(thirdToken);
            }
            int nToken = 3;
            try {
                while ((fourthToken = (String)deps.get(nToken++)).length() == 0) {
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                fourthToken = EMPTY_STRING;
            }
            outBuffer.append(fourthToken).append(" ");
            try {
                for (String nextElement : deps) {
                    if (nextElement.endsWith("\\")) {
                        outBuffer.append(nextElement).append(NEWLINE).append(" ");
                        continue;
                    }
                    outBuffer.append(nextElement).append(" ");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            outBuffer.append(inBuffer);
        }
        outBuffer.append(NEWLINE);
        save = true;
        IFolderInfo fo = null;
        if (rcInfo instanceof IFolderInfo) {
            fo = (IFolderInfo)rcInfo;
        } else {
            IConfiguration c = rcInfo.getParent();
            fo = (IFolderInfo)c.getResourceInfo(rcInfo.getPath().removeLastSegments(1), false);
        }
        for (String dummy : deps) {
            Path dep = new Path(dummy);
            String extension = dep.getFileExtension();
            if (!fo.isHeaderFile(extension)) continue;
            outBuffer.append(dummy).append(":").append(NEWLINE).append(NEWLINE);
        }
        if (save) {
            GnuMakefileGenerator.save(outBuffer, makefile);
            return true;
        }
        return false;
    }

    public static String escapedEcho(String string) {
        String escapedString = string.replaceAll("'", "'\"'\"'");
        return "echo '" + escapedString + "'" + NEWLINE;
    }

    protected static StringBuffer addDefaultHeader() {
        StringBuffer buffer = new StringBuffer();
        GnuMakefileGenerator.outputCommentLine(buffer);
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(HEADER)).append(NEWLINE);
        GnuMakefileGenerator.outputCommentLine(buffer);
        buffer.append(NEWLINE);
        return buffer;
    }

    protected static void outputCommentLine(StringBuffer buffer) {
        int i = 0;
        while (i < 80) {
            buffer.append("#");
            ++i;
        }
        buffer.append(NEWLINE);
    }

    public static boolean containsSpecialCharacters(String path) {
        return path.matches(".*(\\s|[\\{\\}\\(\\)\\$\\@%=;]).*");
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = path.split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    protected void addMacroAdditionPrefix(LinkedHashMap<String, String> map, String macroName, String relativePath, boolean addPrefix) {
        StringBuffer tempBuffer = new StringBuffer();
        tempBuffer.append(macroName).append(" ").append(MACRO_ADDITION_PREFIX_SUFFIX);
        if (addPrefix) {
            tempBuffer.append(MACRO_ADDITION_ADDPREFIX_HEADER).append(relativePath).append(MACRO_ADDITION_ADDPREFIX_SUFFIX);
        }
        map.put(macroName, tempBuffer.toString());
    }

    protected void addMacroAdditionFile(HashMap<String, String> map, String macroName, String filename) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        filename = GnuMakefileGenerator.escapeWhitespaces(filename);
        buffer.append(filename).append(" ").append("\\\n");
        map.put(macroName, buffer.toString());
    }

    protected void addMacroAdditionFile(HashMap<String, String> map, String macroName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        String srcName;
        IPath projectLocation;
        IPath dirLocation = projectLocation = this.getPathForResource((IResource)this.project);
        if (generatedSource) {
            dirLocation = dirLocation.append(this.getBuildWorkingDir());
        }
        if (dirLocation.isPrefixOf(sourceLocation)) {
            IPath srcPath = sourceLocation.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
            srcName = generatedSource ? "./" + srcPath.toString() : String.valueOf(this.reachProjectRoot()) + "/" + srcPath.toString();
        } else {
            srcName = generatedSource && !sourceLocation.isAbsolute() ? "./" + relativePath + sourceLocation.lastSegment().toString() : sourceLocation.toString();
        }
        this.addMacroAdditionFile(map, macroName, srcName);
    }

    public void addMacroAdditionFiles(HashMap<String, String> map, String macroName, Vector<String> filenames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        int i = 0;
        while (i < filenames.size()) {
            String filename = filenames.get(i);
            if (filename.length() > 0) {
                filename = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(filename);
                buffer.append(filename).append(" ").append("\\\n");
            }
            ++i;
        }
        map.put(macroName, buffer.toString());
    }

    protected StringBuffer writeAdditionMacros(LinkedHashMap<String, String> map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(MOD_VARS)).append(NEWLINE);
        for (String macroString : map.values()) {
            if (macroString.endsWith(MACRO_ADDITION_PREFIX_SUFFIX)) continue;
            StringBuffer currentBuffer = new StringBuffer();
            if (macroString.endsWith("\\\n")) {
                macroString = String.valueOf(macroString.substring(0, macroString.length() - 2)) + NEWLINE;
            }
            currentBuffer.append(macroString);
            currentBuffer.append(NEWLINE);
            buffer.append(currentBuffer);
        }
        return buffer.append(NEWLINE);
    }

    protected StringBuffer writeTopAdditionMacros(List<String> varList, HashMap<String, String> varMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#").append(" ").append(ManagedMakeMessages.getResourceString(MOD_VARS)).append(NEWLINE);
        int i = 0;
        while (i < varList.size()) {
            String addition = varMap.get(varList.get(i));
            StringBuffer currentBuffer = new StringBuffer();
            currentBuffer.append(addition);
            currentBuffer.append(NEWLINE);
            buffer.append(currentBuffer);
            ++i;
        }
        return buffer.append(NEWLINE);
    }

    protected void calculateToolInputsOutputs() {
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                ITool[] buildTools = h.buildTools;
                ManagedBuildGnuToolInfo[] gnuToolInfos = h.gnuToolInfos;
                boolean done = false;
                boolean lastChance = false;
                int[] doneState = new int[buildTools.length];
                ITool targetTool = GnuMakefileGenerator.this.config.calculateTargetTool();
                if (buildTools.length != 0 && buildTools[0].getCustomBuildStep()) {
                    return true;
                }
                int i = 0;
                while (i < buildTools.length) {
                    if (buildTools[i] == targetTool) {
                        String ext = GnuMakefileGenerator.this.config.getArtifactExtension();
                        try {
                            ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, GnuMakefileGenerator.EMPTY_STRING, " ", 3, GnuMakefileGenerator.this.config);
                        }
                        catch (BuildMacroException buildMacroException) {
                            // empty catch block
                        }
                        Object name = GnuMakefileGenerator.this.config.getArtifactName();
                        try {
                            Object resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat((String)name, GnuMakefileGenerator.EMPTY_STRING, " ", 3, GnuMakefileGenerator.this.config);
                            resolved = ((String)resolved).trim();
                            if (((String)resolved).length() > 0) {
                                name = resolved;
                            }
                        }
                        catch (BuildMacroException resolved) {
                            // empty catch block
                        }
                        gnuToolInfos[i] = new ManagedBuildGnuToolInfo(GnuMakefileGenerator.this.project, buildTools[i], true, (String)name, ext);
                    } else {
                        gnuToolInfos[i] = new ManagedBuildGnuToolInfo(GnuMakefileGenerator.this.project, buildTools[i], false, null, null);
                    }
                    doneState[i] = 0;
                    ++i;
                }
                LinkedHashMap<String, String> map = GnuMakefileGenerator.this.getTopBuildOutputVars();
                Set set = GnuMakefileGenerator.this.buildOutVars.entrySet();
                for (Map.Entry entry : set) {
                    String macroName = (String)entry.getKey();
                    if (map.containsKey(macroName)) continue;
                    GnuMakefileGenerator.this.addMacroAdditionPrefix(map, macroName, GnuMakefileGenerator.EMPTY_STRING, false);
                }
                HashSet<String> handledDepsInputExtensions = new HashSet<String>();
                HashSet<String> handledOutsInputExtensions = new HashSet<String>();
                while (!done) {
                    int[] testState = new int[doneState.length];
                    int i2 = 0;
                    while (i2 < testState.length) {
                        testState[i2] = 0;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < gnuToolInfos.length) {
                        if (gnuToolInfos[i2].areInputsCalculated()) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        } else if (gnuToolInfos[i2].calculateInputs(GnuMakefileGenerator.this, GnuMakefileGenerator.this.config, GnuMakefileGenerator.this.projectResources, h, lastChance)) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < gnuToolInfos.length) {
                        if (gnuToolInfos[i2].areDependenciesCalculated()) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        } else if (gnuToolInfos[i2].calculateDependencies(GnuMakefileGenerator.this, GnuMakefileGenerator.this.config, handledDepsInputExtensions, h, lastChance)) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < gnuToolInfos.length) {
                        if (gnuToolInfos[i2].areOutputsCalculated()) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        } else if (gnuToolInfos[i2].calculateOutputs(GnuMakefileGenerator.this, GnuMakefileGenerator.this.config, handledOutsInputExtensions, lastChance)) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        }
                        ++i2;
                    }
                    done = true;
                    int[] nArray = testState;
                    int n = testState.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int element = nArray[n2];
                        if (element != 3) {
                            done = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!done) {
                        done = true;
                        i2 = 0;
                        while (i2 < testState.length) {
                            if (testState[i2] != doneState[i2]) {
                                done = false;
                                break;
                            }
                            ++i2;
                        }
                    }
                    if (done && !lastChance) {
                        lastChance = true;
                        done = false;
                    }
                    if (done) continue;
                    doneState = testState;
                }
                return true;
            }
        });
    }

    public List<String> getBuildVariableList(ToolInfoHolder h, String variable, int locationType, IPath directory, boolean getAll) {
        ManagedBuildGnuToolInfo[] gnuToolInfos = h.gnuToolInfos;
        boolean done = true;
        int i = 0;
        while (i < gnuToolInfos.length) {
            if (!gnuToolInfos[i].areOutputVariablesCalculated()) {
                done = false;
            }
            ++i;
        }
        if (!done && getAll) {
            return null;
        }
        List<IPath> list = this.buildSrcVars.get(variable);
        if (list == null) {
            list = this.buildOutVars.get(variable);
        }
        Vector<String> fileList = null;
        if (list != null) {
            IPath dirLocation = null;
            if (locationType != 3) {
                dirLocation = this.project.getLocation();
                if (locationType == 2) {
                    dirLocation = dirLocation.append(directory);
                }
            }
            int i2 = 0;
            while (i2 < list.size()) {
                IPath path = list.get(i2);
                if (locationType != 3 && dirLocation != null && dirLocation.isPrefixOf(path)) {
                    path = path.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
                }
                if (fileList == null) {
                    fileList = new Vector<String>();
                }
                fileList.add(path.toString());
                ++i2;
            }
        }
        return fileList;
    }

    public HashMap<String, List<IPath>> getBuildOutputVars() {
        return this.buildOutVars;
    }

    public LinkedHashMap<String, String> getTopBuildOutputVars() {
        return this.topBuildOutVars;
    }

    protected Vector<String> getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new Vector();
        }
        return this.ruleList;
    }

    protected Vector<String> getDepLineList() {
        if (this.depLineList == null) {
            this.depLineList = new Vector();
        }
        return this.depLineList;
    }

    protected Vector<String> getDepRuleList() {
        if (this.depRuleList == null) {
            this.depRuleList = new Vector();
        }
        return this.depRuleList;
    }

    protected void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    protected void appendDeletedSubdirectory(IContainer container) {
        IContainer parent = container.getParent();
        if (!this.getDeletedDirList().contains(container) && !this.getDeletedDirList().contains(parent)) {
            this.getDeletedDirList().add((IResource)container);
        }
    }

    protected void appendDeletedFile(IResource resource) {
        this.getDeletedFileList().add(resource);
    }

    protected void appendModifiedSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getModifiedList().contains(container)) {
            this.getModifiedList().add(container);
        }
    }

    protected void cancel(String message) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            throw new OperationCanceledException(message);
        }
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true, null);
            }
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true, null);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private void deleteBuildTarget(IResource deletedFile) {
        String targetExtension;
        String fileName = this.getFileName(deletedFile);
        String srcExtension = deletedFile.getFileExtension();
        Object folderPath = this.inFullPathFromOutFullPath(deletedFile.getFullPath().removeLastSegments(1));
        folderPath = folderPath != null ? folderPath.removeFirstSegments(1) : new Path(EMPTY_STRING);
        IResourceInfo rcInfo = this.config.getResourceInfo((IPath)folderPath, false);
        if (rcInfo instanceof IFileInfo) {
            rcInfo = this.config.getResourceInfo(folderPath.removeLastSegments(1), false);
        }
        if (!(targetExtension = ((IFolderInfo)rcInfo).getOutputExtension(srcExtension)).isEmpty()) {
            fileName = String.valueOf(fileName) + "." + targetExtension;
        }
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath targetFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(targetFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private IPath inFullPathFromOutFullPath(IPath path) {
        IPath inPath = null;
        if (this.topBuildDir.isPrefixOf(path)) {
            inPath = path.removeFirstSegments(this.topBuildDir.segmentCount());
            inPath = this.project.getFullPath().append(path);
        }
        return inPath;
    }

    private void deleteDepFile(IResource deletedFile) {
        IPath[] depFilePaths = null;
        ITool tool = null;
        IManagedDependencyGeneratorType depType = null;
        String sourceExtension = deletedFile.getFileExtension();
        Object folderPath = this.inFullPathFromOutFullPath(deletedFile.getFullPath().removeLastSegments(1));
        folderPath = folderPath != null ? folderPath.removeFirstSegments(1) : new Path(EMPTY_STRING);
        ToolInfoHolder h = this.getToolInfo((IPath)folderPath);
        ITool[] tools = h.buildTools;
        int index = 0;
        while (index < tools.length) {
            if (tools[index].buildsFileType(sourceExtension)) {
                tool = tools[index];
                depType = tool.getDependencyGeneratorForExtension(sourceExtension);
                break;
            }
            ++index;
        }
        if (depType != null) {
            IManagedDependencyGenerator2 depGen;
            IManagedDependencyInfo depInfo;
            int calcType = depType.getCalculatorType();
            if (calcType == 1) {
                depFilePaths = new IPath[1];
                IPath absolutePath = deletedFile.getLocation();
                depFilePaths[0] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), absolutePath);
                depFilePaths[0] = depFilePaths[0].removeFileExtension().addFileExtension("d");
            } else if ((calcType == 5 || calcType == 6) && (depInfo = (depGen = (IManagedDependencyGenerator2)depType).getDependencySourceInfo(deletedFile.getProjectRelativePath(), deletedFile, this.config, tool, this.getBuildWorkingDir())) != null) {
                if (calcType == 5) {
                    IManagedDependencyCommands depCommands = (IManagedDependencyCommands)depInfo;
                    depFilePaths = depCommands.getDependencyFiles();
                } else if (calcType == 6) {
                    IManagedDependencyPreBuild depPreBuild = (IManagedDependencyPreBuild)depInfo;
                    depFilePaths = depPreBuild.getDependencyFiles();
                }
            }
        }
        if (depFilePaths != null) {
            IPath[] iPathArray = depFilePaths;
            int n = depFilePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath dfp = iPathArray[n2];
                IPath depFilePath = this.getBuildWorkingDir().append(dfp);
                IResource depFile = this.project.findMember(depFilePath);
                if (depFile != null && depFile.exists()) {
                    try {
                        depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }

    protected IConfiguration getConfig() {
        return this.config;
    }

    protected String getBuildTargetExt() {
        return this.buildTargetExt;
    }

    protected String getBuildTargetName() {
        return this.buildTargetName;
    }

    private Vector<IResource> getDeletedDirList() {
        if (this.deletedDirList == null) {
            this.deletedDirList = new Vector();
        }
        return this.deletedDirList;
    }

    private Vector<IResource> getDeletedFileList() {
        if (this.deletedFileList == null) {
            this.deletedFileList = new Vector();
        }
        return this.deletedFileList;
    }

    private List<IPath> getDependencyMakefiles(ToolInfoHolder h) {
        if (h.dependencyMakefiles == null) {
            h.dependencyMakefiles = new ArrayList<IPath>();
        }
        return h.dependencyMakefiles;
    }

    private String getFileName(IResource file) {
        String answer = EMPTY_STRING;
        String lastSegment = file.getName();
        int extensionSeparator = lastSegment.lastIndexOf(".");
        if (extensionSeparator != -1) {
            answer = lastSegment.substring(0, extensionSeparator);
        }
        return answer;
    }

    private Vector<IResource> getInvalidDirList() {
        if (this.invalidDirList == null) {
            this.invalidDirList = new Vector();
        }
        return this.invalidDirList;
    }

    private Collection<IContainer> getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new LinkedHashSet<IContainer>();
        }
        return this.modifiedList;
    }

    private Collection<IContainer> getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new LinkedHashSet<IContainer>();
        }
        return this.subdirList;
    }

    private void removeGeneratedDirectory(IContainer subDir) {
        try {
            if (subDir.exists() && subDir.members().length > 0) {
                return;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        IPath moduleRelativePath = subDir.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        IFolder folder = this.project.getFolder(moduleOutputPath);
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    protected void updateMonitor(String msg) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            this.monitor.subTask(msg);
            this.monitor.worked(1);
        }
    }

    public IPath getTopBuildDir() {
        return this.getPathForResource((IResource)this.project).append(this.getBuildWorkingDir());
    }

    public String ensurePathIsGNUMakeTargetRuleCompatibleSyntax(String path) {
        return GnuMakefileGenerator.escapeWhitespaces(GnuMakefileGenerator.ensureUnquoted(path));
    }

    public static String ensureUnquoted(String path) {
        boolean doubleQuoted = path.startsWith("\"") && path.endsWith("\"");
        boolean singleQuoted = path.startsWith("'") && path.endsWith("'");
        return doubleQuoted || singleQuoted ? path.substring(1, path.length() - 1) : path;
    }

    @Override
    public void initialize(int buildKind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        this.project = cfg.getOwner().getProject();
        if (builder == null) {
            builder = cfg.getEditableBuilder();
        }
        try {
            this.projectResources = this.project.members();
        }
        catch (CoreException e) {
            this.projectResources = null;
        }
        this.monitor = monitor;
        this.buildTargetName = cfg.getArtifactName();
        this.buildTargetExt = cfg.getArtifactExtension();
        try {
            this.buildTargetExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetExt, EMPTY_STRING, " ", 3, builder);
        }
        catch (BuildMacroException e) {
            // empty catch block
        }
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetName, EMPTY_STRING, " ", 3, builder);
            if (resolved != null && (resolved = resolved.trim()).length() > 0) {
                this.buildTargetName = resolved;
            }
        }
        catch (BuildMacroException resolved) {
            // empty catch block
        }
        if (this.buildTargetExt == null) {
            this.buildTargetExt = EMPTY_STRING;
        }
        this.config = cfg;
        this.builder = builder;
        this.initToolInfos();
        this.initializeTopBuildDir(cfg.getName());
        this.srcEntries = this.config.getSourceEntries();
        if (this.srcEntries.length == 0) {
            this.srcEntries = new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        } else {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.config);
            this.srcEntries = CDataUtil.resolveEntries((ICSourceEntry[])this.srcEntries, (ICConfigurationDescription)cfgDes);
        }
    }

    private void initToolInfos() {
        IResourceInfo[] rcInfos;
        this.toolInfos = PathSettingsContainer.createRootContainer();
        IResourceInfo[] iResourceInfoArray = rcInfos = this.config.getResourceInfos();
        int n = rcInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceInfo rcInfo = iResourceInfoArray[n2];
            if (!rcInfo.isExcluded()) {
                ToolInfoHolder h = this.getToolInfo(rcInfo.getPath(), true);
                if (rcInfo instanceof IFolderInfo) {
                    IFolderInfo fo = (IFolderInfo)rcInfo;
                    h.buildTools = fo.getFilteredTools();
                    h.buildToolsUsed = new boolean[h.buildTools.length];
                    h.gnuToolInfos = new ManagedBuildGnuToolInfo[h.buildTools.length];
                } else {
                    IFileInfo fi = (IFileInfo)rcInfo;
                    h.buildTools = fi.getToolsToInvoke();
                    h.buildToolsUsed = new boolean[h.buildTools.length];
                    h.gnuToolInfos = new ManagedBuildGnuToolInfo[h.buildTools.length];
                }
            }
            ++n2;
        }
    }

    private ToolInfoHolder getToolInfo(IPath path) {
        return this.getToolInfo(path, false);
    }

    private ToolInfoHolder getFolderToolInfo(IPath path) {
        IResourceInfo rcInfo = this.config.getResourceInfo(path, false);
        while (rcInfo instanceof IFileInfo) {
            path = path.removeLastSegments(1);
            rcInfo = this.config.getResourceInfo(path, false);
        }
        return this.getToolInfo(path, false);
    }

    private ToolInfoHolder getToolInfo(IPath path, boolean create) {
        PathSettingsContainer child = this.toolInfos.getChildContainer(path, create, create);
        ToolInfoHolder h = null;
        if (child != null && (h = (ToolInfoHolder)child.getValue()) == null && create) {
            h = new ToolInfoHolder();
            child.setValue((Object)h);
        }
        return h;
    }

    private void ensureTopBuildDir() throws CoreException {
        IPath buildWorkingDir = this.getBuildWorkingDir();
        if (buildWorkingDir != null) {
            this.createDirectory(buildWorkingDir.toString());
        }
    }

    private void initializeTopBuildDir(String configName) {
        this.topBuildDir = this.project.getFolder(this.computeTopBuildDir(configName)).getFullPath();
    }

    protected IPath computeTopBuildDir(String configName) {
        return new Path(configName);
    }

    public String reachProjectRoot() {
        IPath buildWorkingDir = this.getBuildWorkingDir();
        if (buildWorkingDir == null) {
            return "..";
        }
        String root = "..";
        int segCnt = buildWorkingDir.segmentCount();
        int i = 1;
        while (i < segCnt) {
            root = String.valueOf(root) + "/..";
            ++i;
        }
        return root;
    }

    private class DepInfo {
        Vector<String> depExts;
        IManagedDependencyGenerator2[] postProcessors;
        boolean callPopulateDummyTargets;

        private DepInfo() {
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final GnuMakefileGenerator generator;
        private final IConfiguration config;

        public ResourceDeltaVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.config = info.getDefaultConfiguration();
        }

        public ResourceDeltaVisitor(GnuMakefileGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean keepLooking = false;
            IResource resource = delta.getResource();
            IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
            IFolderInfo fo = null;
            boolean isSource = GnuMakefileGenerator.this.isSource(resource.getProjectRelativePath());
            if (rcInfo instanceof IFolderInfo) {
                fo = (IFolderInfo)rcInfo;
            }
            if (isSource) {
                if (resource.getType() == 1) {
                    String ext = resource.getFileExtension();
                    switch (delta.getKind()) {
                        case 1: {
                            if (this.generator.isGeneratedResource(resource) || fo != null && !fo.buildsFileType(ext)) break;
                            this.generator.appendModifiedSubdirectory(resource);
                            break;
                        }
                        case 2: {
                            if (this.generator.isGeneratedResource(resource) || fo != null && !fo.buildsFileType(ext)) break;
                            this.generator.appendDeletedFile(resource);
                            this.generator.appendModifiedSubdirectory(resource);
                            break;
                        }
                        default: {
                            keepLooking = true;
                        }
                    }
                }
                if (resource.getType() == 2) {
                    switch (delta.getKind()) {
                        case 2: {
                            if (this.generator.isGeneratedResource(resource)) break;
                            this.generator.appendDeletedSubdirectory((IContainer)resource);
                        }
                    }
                }
            }
            if (resource.getType() == 4) {
                IResourceDelta[] children = delta.getAffectedChildren();
                if (children != null && children.length > 0) {
                    keepLooking = true;
                }
            } else if (resource.getType() == 8 || isSource && !this.generator.isGeneratedResource(resource)) {
                keepLooking = true;
            }
            return keepLooking;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private final GnuMakefileGenerator generator;
        private final IConfiguration config;

        public ResourceProxyVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.config = info.getDefaultConfiguration();
        }

        public ResourceProxyVisitor(GnuMakefileGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            IResource resource = proxy.requestResource();
            boolean isSource = GnuMakefileGenerator.this.isSource(resource.getProjectRelativePath());
            if (proxy.getType() == 1) {
                IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
                if (isSource) {
                    boolean willBuild = false;
                    if (rcInfo instanceof IFolderInfo) {
                        String ext = resource.getFileExtension();
                        if (((IFolderInfo)rcInfo).buildsFileType(ext) && !this.generator.isGeneratedResource(resource)) {
                            willBuild = true;
                        }
                    } else {
                        willBuild = true;
                    }
                    if (willBuild) {
                        this.generator.appendBuildSubdirectory(resource);
                    }
                }
                return false;
            }
            if (proxy.getType() == 2) {
                return isSource && !this.generator.isGeneratedResource(resource);
            }
            return true;
        }
    }

    class ToolInfoHolder {
        ITool[] buildTools;
        boolean[] buildToolsUsed;
        ManagedBuildGnuToolInfo[] gnuToolInfos;
        Set<String> outputExtensionsSet;
        List<IPath> dependencyMakefiles;

        ToolInfoHolder() {
        }
    }
}

