/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreAvailableExtension
implements PostgreObject {
    private final PostgreDatabase database;
    private final String name;
    private final long oid;
    private final String description;
    private final String version;
    private final String installed_version;
    private final boolean installed;

    public PostgreAvailableExtension(PostgreDatabase database, ResultSet dbResult) {
        this.database = database;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"default_version");
        this.installed_version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"installed_version");
        this.installed = this.installed_version != null;
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
    }

    public DBSObject getParentObject() {
        return null;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, order=3)
    public String getInstalledVersion() {
        return this.installed_version;
    }

    @Property(viewable=true, order=4)
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    public boolean isInstalled() {
        return this.installed;
    }
}

