/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.AbstractObjectManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.CreateConnectionDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionWizard;

public class DataSourceDescriptorManager
extends AbstractObjectManager<DataSourceDescriptor>
implements DBEObjectMaker<DataSourceDescriptor, DBPObject> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 0L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DataSourceDescriptor> getObjectsCache(DataSourceDescriptor object) {
        return null;
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(DataSourceDescriptor object) {
        return true;
    }

    public DataSourceDescriptor createNewObject(DBRProgressMonitor monitor, DBECommandContext commandContext, Object container, Object copyFrom, Map<String, Object> options) {
        if (copyFrom != null) {
            String origName;
            DBPDataSourceRegistry registry;
            DataSourceDescriptor dsTpl = (DataSourceDescriptor)copyFrom;
            DBPDataSourceFolder folder = null;
            if (container instanceof DataSourceRegistry) {
                registry = (DBPDataSourceRegistry)container;
            } else if (container instanceof DBPProject) {
                registry = ((DBPProject)container).getDataSourceRegistry();
            } else if (container instanceof DBPDataSourceFolder) {
                folder = (DBPDataSourceFolder)container;
                registry = folder.getDataSourceRegistry();
            } else {
                registry = dsTpl.getRegistry();
            }
            DataSourceDescriptor dataSource = new DataSourceDescriptor(registry, DataSourceDescriptor.generateNewId((DBPDriver)dsTpl.getDriver()), dsTpl.getDriver(), new DBPConnectionConfiguration(dsTpl.getConnectionConfiguration()));
            dataSource.copyFrom(dsTpl);
            if (folder != null) {
                dataSource.setFolder(folder);
            } else {
                dataSource.setFolder((DBPDataSourceFolder)dsTpl.getFolder());
            }
            String newName = origName = dsTpl.getName();
            int i = 0;
            while (registry.findDataSourceByName(newName) != null) {
                newName = String.valueOf(origName) + " " + (i + 1);
                ++i;
            }
            dataSource.setName(newName);
            registry.addDataSource((DBPDataSourceContainer)dataSource);
        } else {
            UIUtils.asyncExec(() -> {
                CreateConnectionDialog dialog = new CreateConnectionDialog(UIUtils.getActiveWorkbenchWindow(), new NewConnectionWizard());
                dialog.open();
            });
        }
        return null;
    }

    public void deleteObject(DBECommandContext commandContext, DataSourceDescriptor object, Map<String, Object> options) {
        Runnable remover = () -> object.getRegistry().removeDataSource((DBPDataSourceContainer)object);
        if (object.isConnected()) {
            DataSourceHandler.disconnectDataSource((DBPDataSourceContainer)object, remover);
        } else {
            remover.run();
        }
    }
}

