/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.page;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class StreamConsumerPageSettings
extends ActiveWizardPage<DataTransferWizard> {
    private static final int EXTRACT_LOB_SKIP = 0;
    private static final int EXTRACT_LOB_FILES = 1;
    private static final int EXTRACT_LOB_INLINE = 2;
    private static final int LOB_ENCODING_BASE64 = 0;
    private static final int LOB_ENCODING_HEX = 1;
    private static final int LOB_ENCODING_BINARY = 2;
    private static final int LOB_ENCODING_NATIVE = 3;
    private PropertyTreeViewer propsEditor;
    private Combo lobExtractType;
    private Label lobEncodingLabel;
    private Combo lobEncodingCombo;
    private Combo formatProfilesCombo;
    private PropertySourceCustom propertySource;

    public StreamConsumerPageSettings() {
        super(DTMessages.data_transfer_wizard_settings_name);
        this.setTitle("Format settings");
        this.setDescription("File format settings");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        final DBPDataFormatterRegistry dataFormatterRegistry = DBWorkbench.getPlatform().getDataFormatterRegistry();
        this.initializeDialogUnits((Control)parent);
        final StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Group generalSettings = new Group(composite, 0);
        generalSettings.setText(DTMessages.data_transfer_wizard_settings_group_general);
        gl = new GridLayout(4, false);
        generalSettings.setLayout((Layout)gl);
        generalSettings.setLayoutData((Object)new GridData(768));
        Composite formattingGroup = UIUtils.createPlaceholder((Composite)generalSettings, (int)3);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        formattingGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)formattingGroup, (String)DTMessages.data_transfer_wizard_settings_label_formatting);
        this.formatProfilesCombo = new Combo(formattingGroup, 12);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.formatProfilesCombo.setLayoutData((Object)gd);
        this.formatProfilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StreamConsumerPageSettings.this.formatProfilesCombo.getSelectionIndex() > 0) {
                    settings.setFormatterProfile(dataFormatterRegistry.getCustomProfile(UIUtils.getComboSelection((Combo)StreamConsumerPageSettings.this.formatProfilesCombo)));
                } else {
                    settings.setFormatterProfile(null);
                }
            }
        });
        Button profilesManageButton = new Button(formattingGroup, 8);
        profilesManageButton.setText(DTMessages.data_transfer_wizard_settings_button_edit);
        profilesManageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog propDialog = PreferencesUtil.createPropertyDialogOn((Shell)StreamConsumerPageSettings.this.getShell(), (Object)dataFormatterRegistry, (String)"org.jkiss.dbeaver.preferences.main.dataformat", null, (Object)StreamConsumerPageSettings.this.getSelectedFormatterProfile(), (int)0);
                if (propDialog != null) {
                    propDialog.open();
                    StreamConsumerPageSettings.this.reloadFormatProfiles();
                }
            }
        });
        this.reloadFormatProfiles();
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_settings_label_binaries);
        this.lobExtractType = new Combo((Composite)generalSettings, 12);
        this.lobExtractType.setItems(new String[]{DTMessages.data_transfer_wizard_settings_binaries_item_set_to_null, DTMessages.data_transfer_wizard_settings_binaries_item_save_to_file, DTMessages.data_transfer_wizard_settings_binaries_item_inline});
        this.lobExtractType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (StreamConsumerPageSettings.this.lobExtractType.getSelectionIndex()) {
                    case 0: {
                        settings.setLobExtractType(StreamConsumerSettings.LobExtractType.SKIP);
                        break;
                    }
                    case 1: {
                        settings.setLobExtractType(StreamConsumerSettings.LobExtractType.FILES);
                        break;
                    }
                    case 2: {
                        settings.setLobExtractType(StreamConsumerSettings.LobExtractType.INLINE);
                    }
                }
                StreamConsumerPageSettings.this.updatePageCompletion();
            }
        });
        this.lobEncodingLabel = UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_settings_label_encoding);
        this.lobEncodingCombo = new Combo((Composite)generalSettings, 12);
        this.lobEncodingCombo.setItems(new String[]{"Base64", "Hex", "Binary", "Native"});
        this.lobEncodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (StreamConsumerPageSettings.this.lobEncodingCombo.getSelectionIndex()) {
                    case 0: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.BASE64);
                        break;
                    }
                    case 1: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.HEX);
                        break;
                    }
                    case 2: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.BINARY);
                        break;
                    }
                    case 3: {
                        settings.setLobEncoding(StreamConsumerSettings.LobEncoding.NATIVE);
                    }
                }
            }
        });
        Group exporterSettings = new Group(composite, 0);
        exporterSettings.setText(DTMessages.data_transfer_wizard_settings_group_exporter);
        exporterSettings.setLayoutData((Object)new GridData(1808));
        exporterSettings.setLayout((Layout)new GridLayout(1, false));
        this.propsEditor = new PropertyTreeViewer((Composite)exporterSettings, 2048);
        this.setControl((Control)composite);
    }

    private Object getSelectedFormatterProfile() {
        DBPDataFormatterRegistry registry = DBWorkbench.getPlatform().getDataFormatterRegistry();
        int selectionIndex = this.formatProfilesCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        if (selectionIndex == 0) {
            return registry.getGlobalProfile();
        }
        return registry.getCustomProfile(UIUtils.getComboSelection((Combo)this.formatProfilesCombo));
    }

    private void reloadFormatProfiles() {
        DBPDataFormatterRegistry registry = DBWorkbench.getPlatform().getDataFormatterRegistry();
        this.formatProfilesCombo.removeAll();
        this.formatProfilesCombo.add(DTMessages.data_transfer_wizard_settings_listbox_formatting_item_default);
        for (DBDDataFormatterProfile profile : registry.getCustomProfiles()) {
            this.formatProfilesCombo.add(profile.getProfileName());
        }
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        DBDDataFormatterProfile formatterProfile = settings.getFormatterProfile();
        if (formatterProfile != null) {
            if (!UIUtils.setComboSelection((Combo)this.formatProfilesCombo, (String)formatterProfile.getProfileName())) {
                this.formatProfilesCombo.select(0);
            }
        } else {
            this.formatProfilesCombo.select(0);
        }
    }

    public void activatePage() {
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        this.propertySource = new PropertySourceCustom(processor.getProperties(), ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        switch (settings.getLobExtractType()) {
            case SKIP: {
                this.lobExtractType.select(0);
                break;
            }
            case FILES: {
                this.lobExtractType.select(1);
                break;
            }
            case INLINE: {
                this.lobExtractType.select(2);
            }
        }
        switch (settings.getLobEncoding()) {
            case BASE64: {
                this.lobEncodingCombo.select(0);
                break;
            }
            case HEX: {
                this.lobEncodingCombo.select(1);
                break;
            }
            case BINARY: {
                this.lobEncodingCombo.select(2);
                break;
            }
            case NATIVE: {
                this.lobEncodingCombo.select(3);
            }
        }
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        ((DataTransferWizard)this.getWizard()).getSettings().setProcessorProperties(this.propertySource.getPropertiesWithDefaults());
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        int selectionIndex = this.lobExtractType.getSelectionIndex();
        if (selectionIndex == 2) {
            this.lobEncodingLabel.setVisible(true);
            this.lobEncodingCombo.setVisible(true);
        } else {
            this.lobEncodingLabel.setVisible(false);
            this.lobEncodingCombo.setVisible(false);
        }
        return true;
    }
}

