/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializerLegacy;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializerModern;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.XMLBuilder;

public class DBVModel
extends DBVContainer {
    private DBPDataSourceContainer dataSourceContainer;
    @NotNull
    private String id;

    public DBVModel(@NotNull String id, @NotNull Map<String, Object> map) {
        super(null, id, map);
        this.id = id;
    }

    public DBVModel(@NotNull DBPDataSourceContainer dataSourceContainer) {
        super(null, "model");
        this.dataSourceContainer = dataSourceContainer;
        this.id = dataSourceContainer.getId();
    }

    public DBVModel(@NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBVModel source) {
        super(null, source);
        this.dataSourceContainer = dataSourceContainer;
        this.id = dataSourceContainer.getId();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public void setDataSourceContainer(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    @Override
    public DBSObjectContainer getRealContainer(DBRProgressMonitor monitor) throws DBException {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (dataSource instanceof DBSObjectContainer) {
            return (DBSObjectContainer)((Object)dataSource);
        }
        log.warn("Datasource '" + dataSource + "' is not an object container");
        return null;
    }

    @Override
    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSourceContainer == null ? null : this.dataSourceContainer.getDataSource();
    }

    public DBVEntity findEntity(DBSEntity entity, boolean createNew) {
        DBSObject[] path = DBUtils.getObjectPath(entity, false);
        if (path.length == 0) {
            log.warn("Empty entity path");
            return null;
        }
        if (path[0] != this.dataSourceContainer) {
            log.warn("Entity's root must be datasource container '" + this.dataSourceContainer.getName() + "'");
            return null;
        }
        DBVContainer container = this;
        int i = 1;
        while (i < path.length) {
            DBSObject item = path[i];
            if ((container = container.getContainer(item.getName(), createNew)) == null) {
                return null;
            }
            ++i;
        }
        return container.getEntity(entity.getName(), createNew);
    }

    public void serialize(DBRProgressMonitor monitor, JsonWriter json) throws IOException, DBException {
        DBVModelSerializerModern.serializeContainer(monitor, json, this);
    }

    @Deprecated
    public void serialize(XMLBuilder xml) throws IOException {
        DBVModelSerializerLegacy.serializeContainer(xml, this);
    }

    @Deprecated
    public SAXListener getModelParser() {
        return new DBVModelSerializerLegacy.ModelParser(this);
    }

    public void copyFrom(DBVModel model) {
        super.copyFrom(model);
    }
}

