/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNDatabaseFolder
extends DBNDatabaseNode
implements DBNContainer,
DBSFolder {
    private DBXTreeFolder meta;

    DBNDatabaseFolder(DBNDatabaseNode parent, DBXTreeFolder meta) {
        super(parent);
        this.meta = meta;
        this.registerNode();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.unregisterNode(reflect);
        super.dispose(reflect);
    }

    @Override
    public DBXTreeFolder getMeta() {
        return this.meta;
    }

    @Override
    protected void reloadObject(DBRProgressMonitor monitor, DBSObject object) {
    }

    @Override
    public DBSObject getObject() {
        return this;
    }

    @Override
    public Object getValueObject() {
        return ((DBNDatabaseNode)this.getParentNode()).getValueObject();
    }

    @Override
    public String getChildrenType() {
        List<DBXTreeNode> metaChildren = this.meta.getChildren(this);
        if (CommonUtils.isEmpty(metaChildren)) {
            return "?";
        }
        return metaChildren.get(0).getChildrenType(this.getDataSource(), null);
    }

    @Override
    @Property(viewable=true)
    @NotNull
    public String getName() {
        return this.meta.getChildrenType(this.getDataSource(), null);
    }

    @Override
    public String getLocalizedName(String locale) {
        return this.meta.getChildrenType(this.getDataSource(), locale);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.meta.getDescription();
    }

    @Override
    public DBSObject getParentObject() {
        return ((DBNDatabaseNode)this.getParentNode()).getObject();
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return ((DBNDatabaseNode)this.parentNode).getDataSource();
    }

    @Override
    public boolean isPersisted() {
        return this.getParentNode() != null && this.getParentNode().isPersisted();
    }

    public Class<? extends DBSObject> getChildrenClass() {
        return DBNDatabaseFolder.getFolderChildrenClass(this.meta);
    }

    @Override
    public Collection<DBSObject> getChildrenObjects(DBRProgressMonitor monitor) throws DBException {
        Object[] children = this.getChildren(monitor);
        ArrayList<DBSObject> childObjects = new ArrayList<DBSObject>();
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                childObjects.add(child.getObject());
                ++n2;
            }
        }
        return childObjects;
    }

    public String toString() {
        return this.meta.getChildrenType(this.getDataSource(), null);
    }
}

