/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.edit;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBECommandWithOptions;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class AbstractObjectManager<OBJECT_TYPE extends DBSObject>
implements DBEObjectManager<OBJECT_TYPE> {
    protected static final Log log = Log.getLog(AbstractObjectManager.class);

    @Override
    public void executePersistAction(DBCSession session, DBECommand<OBJECT_TYPE> command, DBEPersistAction action) throws DBException {
        String script = action.getScript();
        if (script == null) {
            action.afterExecute(session, null);
        } else {
            try (DBCStatement dbStat = DBUtils.createStatement(session, script, false);){
                try {
                    action.beforeExecute(session);
                    dbStat.executeStatement();
                    action.afterExecute(session, null);
                }
                catch (DBCException e) {
                    action.afterExecute(session, e);
                    throw e;
                }
            }
        }
    }

    public static abstract class AbstractObjectReflector<OBJECT_TYPE extends DBSObject>
    implements DBECommandReflector<OBJECT_TYPE, DBECommand<OBJECT_TYPE>> {
        private final DBEObjectMaker<OBJECT_TYPE, ? extends DBSObject> objectMaker;

        protected AbstractObjectReflector(DBEObjectMaker<OBJECT_TYPE, ? extends DBSObject> objectMaker) {
            this.objectMaker = objectMaker;
        }

        protected void cacheModelObject(OBJECT_TYPE object) {
            DBSObjectCache<DBSObject, OBJECT_TYPE> cache = this.objectMaker.getObjectsCache(object);
            if (cache != null) {
                cache.cacheObject(object);
            }
        }

        protected void removeModelObject(OBJECT_TYPE object) {
            DBSObjectCache<DBSObject, OBJECT_TYPE> cache = this.objectMaker.getObjectsCache(object);
            if (cache != null) {
                cache.removeObject(object, false);
            }
        }
    }

    public static class CreateObjectReflector<OBJECT_TYPE extends DBSObject>
    extends AbstractObjectReflector<OBJECT_TYPE> {
        public CreateObjectReflector(DBEObjectMaker<OBJECT_TYPE, ? extends DBSObject> objectMaker) {
            super(objectMaker);
        }

        @Override
        public void redoCommand(DBECommand<OBJECT_TYPE> command) {
            this.cacheModelObject((DBSObject)command.getObject());
            Map<String, Object> options = null;
            if (command instanceof DBECommandWithOptions) {
                options = ((DBECommandWithOptions)((Object)command)).getOptions();
            }
            DBUtils.fireObjectAdd((DBSObject)command.getObject(), options);
        }

        @Override
        public void undoCommand(DBECommand<OBJECT_TYPE> command) {
            DBUtils.fireObjectRemove((DBSObject)command.getObject());
            this.removeModelObject((DBSObject)command.getObject());
        }
    }

    public static class DeleteObjectReflector<OBJECT_TYPE extends DBSObject>
    extends AbstractObjectReflector<OBJECT_TYPE> {
        public DeleteObjectReflector(DBEObjectMaker<OBJECT_TYPE, ? extends DBSObject> objectMaker) {
            super(objectMaker);
        }

        @Override
        public void redoCommand(DBECommand<OBJECT_TYPE> command) {
            DBUtils.fireObjectRemove((DBSObject)command.getObject());
            this.removeModelObject((DBSObject)command.getObject());
        }

        @Override
        public void undoCommand(DBECommand<OBJECT_TYPE> command) {
            this.cacheModelObject((DBSObject)command.getObject());
            Map<String, Object> options = null;
            if (command instanceof DBECommandWithOptions) {
                options = ((DBECommandWithOptions)((Object)command)).getOptions();
            }
            DBUtils.fireObjectAdd((DBSObject)command.getObject(), options);
        }
    }
}

