/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.EntrySource;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class InflaterEntrySource
implements EntrySource {
    private EntrySource mDeflatedSource;
    private long mUncompressedSize;

    InflaterEntrySource(EntrySource deflatedSource, long uncompressedSize) {
        Preconditions.checkArgument((uncompressedSize >= 0L ? 1 : 0) != 0, (String)"uncompressedSize (%s) < 0", (Object[])new Object[]{uncompressedSize});
        this.mDeflatedSource = deflatedSource;
        this.mUncompressedSize = uncompressedSize;
    }

    @Override
    public InputStream open() throws IOException {
        InputStream rawStream = this.mDeflatedSource.open();
        ByteArrayInputStream hackByte = new ByteArrayInputStream(new byte[]{0});
        return new InflaterInputStream(new SequenceInputStream(rawStream, hackByte), new Inflater(true));
    }

    @Override
    public long size() {
        return this.mUncompressedSize;
    }

    @Override
    public EntrySource innerCompressed() {
        return this.mDeflatedSource;
    }
}

