/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.utils;

import com.sun.tools.visualvm.heapviewer.utils.Bundle;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class HeapUtils {
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";

    public static Collection<JavaClass> getSubclasses(Heap heap, String baseClass) {
        HashSet<JavaClass> subclasses = new HashSet<JavaClass>();
        String escapedClassName = "\\Q" + baseClass + "\\E";
        Collection jClasses = heap.getJavaClassesByRegExp(escapedClassName);
        for (JavaClass jClass : jClasses) {
            subclasses.add(jClass);
            subclasses.addAll(jClass.getSubClasses());
        }
        return subclasses;
    }

    public static String classToHtml(JavaClass javaClass) {
        return HeapUtils.classToHtml(javaClass, null);
    }

    private static String classToHtml(JavaClass javaClass, String prefix) {
        if (javaClass == null) {
            return Bundle.HeapUtils_UnknownClass();
        }
        long id = javaClass.getJavaClassId();
        return "<a href='file://class/" + id + "' name='" + id + "'>" + (prefix == null ? "" : prefix) + javaClass.getName() + "</a>";
    }

    public static boolean isClass(String html) {
        return html.startsWith(CLASS_URL_PREFIX);
    }

    public static JavaClass classFromHtml(String html, Heap heap) {
        String classIdS = html.substring(CLASS_URL_PREFIX.length());
        try {
            long classId = Long.parseLong(classIdS);
            return heap.getJavaClassByID(classId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String instanceToHtml(Instance instance, boolean logicalValue, Heap heap, JavaClass javaClassClass) {
        JavaClass javaClass;
        if (instance == null) {
            return Bundle.HeapUtils_UnknownInstance();
        }
        JavaClass jcls = instance.getJavaClass();
        if (jcls == null) {
            return Bundle.HeapUtils_UnknownInstance() + " #" + instance.getInstanceId();
        }
        if (jcls.equals(javaClassClass) && (javaClass = heap.getJavaClassByID(instance.getInstanceId())) != null) {
            return HeapUtils.classToHtml(javaClass, Bundle.HeapUtils_Class() + " ");
        }
        long id = instance.getInstanceId();
        String instanceHtml = "<a href='file://instance/" + id + "' name='" + id + "'>" + jcls.getName() + '#' + instance.getInstanceNumber() + "</a>";
        if (!logicalValue) {
            return instanceHtml;
        }
        String details = DetailsUtils.getInstanceString((Instance)instance, (Heap)heap);
        if (details == null) {
            return instanceHtml;
        }
        details = "<span style=\"color: #666666\"> : " + HeapUtils.htmlize(details) + "</span>";
        return instanceHtml + details;
    }

    public static boolean isInstance(String html) {
        return html.startsWith(INSTANCE_URL_PREFIX);
    }

    public static Instance instanceFromHtml(String html, Heap heap) {
        String classIdS = html.substring(INSTANCE_URL_PREFIX.length());
        try {
            long classId = Long.parseLong(classIdS);
            return heap.getInstanceByID(classId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String htmlize(String text) {
        if (text == null) {
            return null;
        }
        return text.replace(">", "&gt;").replace("<", "&lt;");
    }

    private HeapUtils() {
    }
}

