/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.Bundle;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public class SearchScopeBrowse {
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final Icon ICON;
    private static FileObject[] roots;
    private SearchScopeDefinition browseScope = new BrowseScope();
    private SearchScopeDefinition getLastScope = new GetLastScope();

    private FileObject[] chooseRoots() {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(SearchScopeBrowse.class);
        fileChooserBuilder.setTitle(UiUtils.getText("LBL_ScopeBrowseFileChooserTitle"));
        fileChooserBuilder.setApproveText(UiUtils.getText("LBL_ScopeBrowseFileChooserApprove"));
        File[] fileArray = fileChooserBuilder.showMultiOpenDialog();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        List<File> list = this.selectExistingFiles(fileArray);
        FileObject[] fileObjectArray = new FileObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            fileObjectArray[i] = FileUtil.toFileObject((File)list.get(i));
        }
        if (fileObjectArray.length > 0) {
            roots = fileObjectArray;
        }
        return fileObjectArray;
    }

    private List<File> selectExistingFiles(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].exists()) {
                arrayList.add(fileArray[i]);
                continue;
            }
            if (bl) continue;
            DialogDisplayer.getDefault().notifyLater(new NotifyDescriptor((Object)Bundle.MSG_FileDoesNotExist(fileArray[i]), Bundle.TTL_FileDoesNotExist(), -1, 0, null, NotifyDescriptor.OK_OPTION));
            bl = true;
        }
        return arrayList;
    }

    public SearchScopeDefinition getBrowseScope() {
        return this.browseScope;
    }

    public SearchScopeDefinition getGetLastScope() {
        return this.getLastScope;
    }

    static {
        roots = null;
        Icon icon = UIManager.getIcon(ICON_KEY_UIMANAGER_NB);
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/openide/loaders/defaultFolder.gif", (boolean)false);
        }
        ICON = icon;
    }

    private class BrowseSearchInfo
    extends SearchInfoDefinition {
        private SearchInfo delegate;

        private BrowseSearchInfo() {
        }

        @Override
        public boolean canSearch() {
            return true;
        }

        @Override
        public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
            return this.getDelegate().getFilesToSearch(searchScopeOptions, searchListener, atomicBoolean).iterator();
        }

        @Override
        public List<SearchRoot> getSearchRoots() {
            return this.getDelegate().getSearchRoots();
        }

        private synchronized SearchInfo getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }

        private SearchInfo createDelegate() {
            FileObject[] fileObjectArray = SearchScopeBrowse.this.chooseRoots();
            return SearchInfoUtils.createSearchInfoForRoots(fileObjectArray);
        }
    }

    private class GetLastScope
    extends SearchScopeDefinition {
        private GetLastScope() {
        }

        @Override
        public String getTypeId() {
            return "browse";
        }

        @Override
        public String getDisplayName() {
            if (roots != null && roots.length > 0) {
                return UiUtils.getText("LBL_ScopeBrowseName") + " [" + roots[0].getName() + (roots.length > 1 ? "..." : "") + "]";
            }
            return "no files selected";
        }

        @Override
        public boolean isApplicable() {
            return roots != null && roots.length > 0;
        }

        @Override
        public SearchInfo getSearchInfo() {
            return SearchInfoUtils.createSearchInfoForRoots(roots);
        }

        @Override
        public int getPriority() {
            return 500;
        }

        @Override
        public void clean() {
        }

        @Override
        public Icon getIcon() {
            return ICON;
        }
    }

    private class BrowseScope
    extends SearchScopeDefinition {
        private SearchInfo searchInfo;

        private BrowseScope() {
            this.searchInfo = SearchInfoUtils.createForDefinition(new BrowseSearchInfo());
        }

        @Override
        public String getTypeId() {
            return "browse";
        }

        @Override
        public String getDisplayName() {
            return UiUtils.getText("LBL_ScopeBrowseName");
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public SearchInfo getSearchInfo() {
            return this.searchInfo;
        }

        @Override
        public int getPriority() {
            return 501;
        }

        @Override
        public void clean() {
        }

        @Override
        public void selected() {
            SearchScopeBrowse.this.chooseRoots();
            this.notifyListeners();
        }

        @Override
        public Icon getIcon() {
            return ICON;
        }
    }
}

