/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AdjacencyList;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.CertPathChecker;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.PKIXRevocationChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.ReverseBuilder;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.RevocationChecker;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.provider.certpath.SunCertPathBuilderResult;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;

public final class SunCertPathBuilder
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private PKIX.BuilderParams buildParams;
    private CertificateFactory cf;
    private boolean pathCompleted = false;
    private PolicyNode policyTreeResult;
    private TrustAnchor trustAnchor;
    private PublicKey finalPublicKey;

    public SunCertPathBuilder() throws CertPathBuilderException {
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CertPathBuilderException(e);
        }
    }

    public CertPathChecker engineGetRevocationChecker() {
        return new RevocationChecker();
    }

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.engineBuild(" + params + ")");
        }
        this.buildParams = PKIX.checkBuilderParams(params);
        return this.build();
    }

    private PKIXCertPathBuilderResult build() throws CertPathBuilderException {
        ArrayList<List<Vertex>> adjList = new ArrayList<List<Vertex>>();
        PKIXCertPathBuilderResult result = this.buildCertPath(false, adjList);
        if (result == null) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild: 2nd pass");
            }
            adjList.clear();
            result = this.buildCertPath(true, adjList);
            if (result == null) {
                throw new SunCertPathBuilderException("unable to find valid certification path to requested target", new AdjacencyList(adjList));
            }
        }
        return result;
    }

    private PKIXCertPathBuilderResult buildCertPath(boolean searchAllCertStores, List<List<Vertex>> adjList) throws CertPathBuilderException {
        this.pathCompleted = false;
        this.trustAnchor = null;
        this.finalPublicKey = null;
        this.policyTreeResult = null;
        LinkedList<X509Certificate> certPathList = new LinkedList<X509Certificate>();
        try {
            if (this.buildParams.buildForward()) {
                this.buildForward(adjList, certPathList, searchAllCertStores);
            } else {
                this.buildReverse(adjList, certPathList);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in build");
                e.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", e, new AdjacencyList(adjList));
        }
        try {
            if (this.pathCompleted) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.engineBuild() pathCompleted");
                }
                Collections.reverse(certPathList);
                return new SunCertPathBuilderResult(this.cf.generateCertPath(certPathList), this.trustAnchor, this.policyTreeResult, this.finalPublicKey, new AdjacencyList(adjList));
            }
        }
        catch (CertificateException e) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in wrap-up");
                e.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", e, new AdjacencyList(adjList));
        }
        return null;
    }

    private void buildReverse(List<List<Vertex>> adjacencyList, LinkedList<X509Certificate> certPathList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse()...");
            debug.println("SunCertPathBuilder.buildReverse() InitialPolicies: " + this.buildParams.initialPolicies());
        }
        ReverseState currentState = new ReverseState();
        adjacencyList.clear();
        adjacencyList.add(new LinkedList());
        Iterator<TrustAnchor> iter = this.buildParams.trustAnchors().iterator();
        while (iter.hasNext()) {
            PublicKey pubKey;
            TrustAnchor anchor = iter.next();
            if (SunCertPathBuilder.anchorIsTarget(anchor, this.buildParams.targetCertConstraints())) {
                this.trustAnchor = anchor;
                this.pathCompleted = true;
                this.finalPublicKey = anchor.getTrustedCert().getPublicKey();
                break;
            }
            X509Certificate trustedCert = anchor.getTrustedCert();
            PublicKey publicKey = pubKey = trustedCert != null ? trustedCert.getPublicKey() : anchor.getCAPublicKey();
            if (PKIX.isDSAPublicKeyWithoutParams(pubKey)) continue;
            currentState.initState(this.buildParams);
            currentState.updateState(anchor, this.buildParams);
            currentState.algorithmChecker = new AlgorithmChecker(anchor, this.buildParams.date(), null);
            currentState.untrustedChecker = new UntrustedChecker();
            try {
                this.depthFirstSearchReverse(null, currentState, new ReverseBuilder(this.buildParams), adjacencyList, certPathList);
            }
            catch (IOException | GeneralSecurityException e) {
                if (iter.hasNext()) continue;
                throw e;
            }
            if (!this.pathCompleted) continue;
            break;
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse() returned from depthFirstSearchReverse()");
            debug.println("SunCertPathBuilder.buildReverse() certPathList.size: " + certPathList.size());
        }
    }

    private void buildForward(List<List<Vertex>> adjacencyList, LinkedList<X509Certificate> certPathList, boolean searchAllCertStores) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward()...");
        }
        ForwardState currentState = new ForwardState();
        currentState.initState(this.buildParams.certPathCheckers());
        adjacencyList.clear();
        adjacencyList.add(new LinkedList());
        currentState.untrustedChecker = new UntrustedChecker();
        this.depthFirstSearchForward(this.buildParams.targetSubject(), currentState, new ForwardBuilder(this.buildParams, searchAllCertStores), adjacencyList, certPathList);
    }

    private void depthFirstSearchForward(X500Principal dN, ForwardState currentState, ForwardBuilder builder, List<List<Vertex>> adjList, LinkedList<X509Certificate> cpList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(" + dN + ", " + currentState.toString() + ")");
        }
        Collection<X509Certificate> certs = builder.getMatchingCerts(currentState, this.buildParams.certStores());
        List<Vertex> vertices = SunCertPathBuilder.addVertices(certs, adjList);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(): certs.size=" + vertices.size());
        }
        block4: for (Vertex vertex : vertices) {
            ForwardState nextState = (ForwardState)currentState.clone();
            X509Certificate cert = vertex.getCertificate();
            try {
                builder.verifyCert(cert, nextState, cpList);
            }
            catch (GeneralSecurityException gse) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): validation failed: " + gse);
                    gse.printStackTrace();
                }
                vertex.setThrowable(gse);
                continue;
            }
            if (builder.isPathCompleted(cert)) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): commencing final verification");
                }
                ArrayList<X509Certificate> appendedCerts = new ArrayList<X509Certificate>(cpList);
                if (builder.trustAnchor.getTrustedCert() == null) {
                    appendedCerts.add(0, cert);
                }
                Set<String> initExpPolSet = Collections.singleton("2.5.29.32.0");
                PolicyNodeImpl rootNode = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, initExpPolSet, false);
                ArrayList<PKIXCertPathChecker> checkers = new ArrayList<PKIXCertPathChecker>();
                PolicyChecker policyChecker = new PolicyChecker(this.buildParams.initialPolicies(), appendedCerts.size(), this.buildParams.explicitPolicyRequired(), this.buildParams.policyMappingInhibited(), this.buildParams.anyPolicyInhibited(), this.buildParams.policyQualifiersRejected(), rootNode);
                checkers.add(policyChecker);
                checkers.add(new AlgorithmChecker(builder.trustAnchor, this.buildParams.date(), this.buildParams.variant()));
                BasicChecker basicChecker = null;
                if (nextState.keyParamsNeeded()) {
                    PublicKey rootKey = cert.getPublicKey();
                    if (builder.trustAnchor.getTrustedCert() == null) {
                        rootKey = builder.trustAnchor.getCAPublicKey();
                        if (debug != null) {
                            debug.println("SunCertPathBuilder.depthFirstSearchForward using buildParams public key: " + rootKey.toString());
                        }
                    }
                    TrustAnchor anchor = new TrustAnchor(cert.getSubjectX500Principal(), rootKey, null);
                    basicChecker = new BasicChecker(anchor, this.buildParams.date(), this.buildParams.sigProvider(), true);
                    checkers.add(basicChecker);
                }
                this.buildParams.setCertPath(this.cf.generateCertPath(appendedCerts));
                boolean revCheckerAdded = false;
                List<PKIXCertPathChecker> ckrs = this.buildParams.certPathCheckers();
                for (PKIXCertPathChecker ckr : ckrs) {
                    if (!(ckr instanceof PKIXRevocationChecker)) continue;
                    revCheckerAdded = true;
                    if (!(ckr instanceof RevocationChecker)) continue;
                    ((RevocationChecker)ckr).init(builder.trustAnchor, this.buildParams);
                }
                if (this.buildParams.revocationEnabled() && !revCheckerAdded) {
                    checkers.add(new RevocationChecker(builder.trustAnchor, this.buildParams));
                }
                checkers.addAll(ckrs);
                for (int i = 0; i < appendedCerts.size(); ++i) {
                    Set<String> unresCritExts;
                    X509Certificate currCert = (X509Certificate)appendedCerts.get(i);
                    if (debug != null) {
                        debug.println("current subject = " + currCert.getSubjectX500Principal());
                    }
                    if ((unresCritExts = currCert.getCriticalExtensionOIDs()) == null) {
                        unresCritExts = Collections.emptySet();
                    }
                    for (PKIXCertPathChecker currChecker : checkers) {
                        if (currChecker.isForwardCheckingSupported()) continue;
                        if (i == 0) {
                            currChecker.init(false);
                            if (currChecker instanceof AlgorithmChecker) {
                                ((AlgorithmChecker)currChecker).trySetTrustAnchor(builder.trustAnchor);
                            }
                        }
                        try {
                            currChecker.check(currCert, unresCritExts);
                        }
                        catch (CertPathValidatorException cpve) {
                            if (debug != null) {
                                debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification failed: " + cpve);
                            }
                            if (this.buildParams.targetCertConstraints().match(currCert) && cpve.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                                throw cpve;
                            }
                            vertex.setThrowable(cpve);
                            continue block4;
                        }
                    }
                    for (PKIXCertPathChecker checker : this.buildParams.certPathCheckers()) {
                        Set<String> suppExts;
                        if (!checker.isForwardCheckingSupported() || (suppExts = checker.getSupportedExtensions()) == null) continue;
                        unresCritExts.removeAll(suppExts);
                    }
                    if (unresCritExts.isEmpty()) continue;
                    unresCritExts.remove(PKIXExtensions.BasicConstraints_Id.toString());
                    unresCritExts.remove(PKIXExtensions.NameConstraints_Id.toString());
                    unresCritExts.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                    unresCritExts.remove(PKIXExtensions.PolicyMappings_Id.toString());
                    unresCritExts.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                    unresCritExts.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                    unresCritExts.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                    unresCritExts.remove(PKIXExtensions.KeyUsage_Id.toString());
                    unresCritExts.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                    if (unresCritExts.isEmpty()) continue;
                    throw new CertPathValidatorException("unrecognized critical extension(s)", null, null, -1, PKIXReason.UNRECOGNIZED_CRIT_EXT);
                }
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification succeeded - path completed!");
                }
                this.pathCompleted = true;
                if (builder.trustAnchor.getTrustedCert() == null) {
                    builder.addCertToPath(cert, cpList);
                }
                this.trustAnchor = builder.trustAnchor;
                if (basicChecker != null) {
                    this.finalPublicKey = basicChecker.getPublicKey();
                } else {
                    Certificate finalCert = cpList.isEmpty() ? builder.trustAnchor.getTrustedCert() : (Certificate)cpList.getLast();
                    this.finalPublicKey = finalCert.getPublicKey();
                }
                this.policyTreeResult = policyChecker.getPolicyTree();
                return;
            }
            builder.addCertToPath(cert, cpList);
            nextState.updateState(cert);
            adjList.add(new LinkedList());
            vertex.setIndex(adjList.size() - 1);
            this.depthFirstSearchForward(cert.getIssuerX500Principal(), nextState, builder, adjList, cpList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchForward(): backtracking");
            }
            builder.removeFinalCertFromPath(cpList);
        }
    }

    private void depthFirstSearchReverse(X500Principal dN, ReverseState currentState, ReverseBuilder builder, List<List<Vertex>> adjList, LinkedList<X509Certificate> cpList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(" + dN + ", " + currentState.toString() + ")");
        }
        Collection<X509Certificate> certs = builder.getMatchingCerts(currentState, this.buildParams.certStores());
        List<Vertex> vertices = SunCertPathBuilder.addVertices(certs, adjList);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(): certs.size=" + vertices.size());
        }
        for (Vertex vertex : vertices) {
            ReverseState nextState = (ReverseState)currentState.clone();
            X509Certificate cert = vertex.getCertificate();
            try {
                builder.verifyCert(cert, nextState, cpList);
            }
            catch (GeneralSecurityException gse) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): validation failed: " + gse);
                }
                vertex.setThrowable(gse);
                continue;
            }
            if (!currentState.isInitial()) {
                builder.addCertToPath(cert, cpList);
            }
            this.trustAnchor = currentState.trustAnchor;
            if (builder.isPathCompleted(cert)) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): path completed!");
                }
                this.pathCompleted = true;
                PolicyNodeImpl rootNode = nextState.rootNode;
                if (rootNode == null) {
                    this.policyTreeResult = null;
                } else {
                    this.policyTreeResult = rootNode.copyTree();
                    ((PolicyNodeImpl)this.policyTreeResult).setImmutable();
                }
                this.finalPublicKey = cert.getPublicKey();
                if (PKIX.isDSAPublicKeyWithoutParams(this.finalPublicKey)) {
                    this.finalPublicKey = BasicChecker.makeInheritedParamsKey(this.finalPublicKey, currentState.pubKey);
                }
                return;
            }
            nextState.updateState(cert);
            adjList.add(new LinkedList());
            vertex.setIndex(adjList.size() - 1);
            this.depthFirstSearchReverse(cert.getSubjectX500Principal(), nextState, builder, adjList, cpList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchReverse(): backtracking");
            }
            if (currentState.isInitial()) continue;
            builder.removeFinalCertFromPath(cpList);
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse() all certs in this adjacency list checked");
        }
    }

    private static List<Vertex> addVertices(Collection<X509Certificate> certs, List<List<Vertex>> adjList) {
        List<Vertex> l = adjList.get(adjList.size() - 1);
        for (X509Certificate cert : certs) {
            Vertex v = new Vertex(cert);
            l.add(v);
        }
        return l;
    }

    private static boolean anchorIsTarget(TrustAnchor anchor, CertSelector sel) {
        X509Certificate anchorCert = anchor.getTrustedCert();
        if (anchorCert != null) {
            return sel.match(anchorCert);
        }
        return false;
    }
}

