/*
 * Decompiled with CFR 0.152.
 */
package org.sagemath.sage3d;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.net.URL;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class ObjectViewer
extends JPanel {
    protected BranchGroup scene;
    protected TransformGroup transform;
    protected TransformGroup viewStart;
    protected Canvas3D canvas;

    public ObjectViewer(URL url) {
        this.setLayout(new BorderLayout());
        Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.add("Center", (Component)canvas3D);
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 1000.0);
        BranchGroup root = new BranchGroup();
        BranchGroup scene = this.createSceneGraph(url);
        scene.setBoundsAutoCompute(true);
        System.out.println(scene.getBounds());
        BoundingSphere sceneBounds = new BoundingSphere(scene.getBounds());
        SimpleUniverse univ = new SimpleUniverse(canvas3D);
        ViewingPlatform view = univ.getViewingPlatform();
        view.setNominalViewingTransform();
        Transform3D t = new Transform3D();
        TransformGroup viewTransform = view.getViewPlatformTransform();
        t.set(new Vector3d(0.0, 0.0, 3.0 * sceneBounds.getRadius()));
        viewTransform.setTransform(t);
        BranchGroup lights = new BranchGroup();
        AmbientLight light = new AmbientLight();
        light.setInfluencingBounds((Bounds)bounds);
        lights.addChild((Node)light);
        light = new DirectionalLight();
        light.setInfluencingBounds((Bounds)bounds);
        lights.addChild((Node)light);
        root.addChild((Node)lights);
        TransformGroup tg = new TransformGroup();
        tg.setCapability(17);
        tg.setCapability(18);
        tg.addChild((Node)scene);
        root.addChild((Node)tg);
        MouseRotate mouse = new MouseRotate();
        mouse.setTransformGroup(tg);
        mouse.setSchedulingBounds((Bounds)bounds);
        root.addChild((Node)mouse);
        MouseZoom mousezoom = new MouseZoom();
        mousezoom.setTransformGroup(tg);
        mousezoom.setSchedulingBounds((Bounds)bounds);
        root.addChild((Node)mousezoom);
        Background background = new Background(1.0f, 1.0f, 1.0f);
        background.setApplicationBounds((Bounds)bounds);
        root.addChild((Node)background);
        root.compile();
        univ.addBranchGraph(root);
    }

    public BranchGroup createSceneGraph(URL url) {
        try {
            ObjectFile loader = new ObjectFile();
            Scene scene = loader.load(url);
            BranchGroup bg = scene.getSceneGroup();
            System.out.println(bg);
            TransformGroup[] views = scene.getViewGroups();
            if (views != null) {
                for (int i = 0; i < views.length; ++i) {
                    System.out.print(views[i]);
                }
                if (views.length > 0) {
                    this.viewStart = views[0];
                }
            }
            return bg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.add("South", new Label(ex.toString()));
            System.out.println("URL: " + url);
            BranchGroup bg = new BranchGroup();
            bg.addChild((Node)new ColorCube());
            System.out.println(bg);
            return bg;
        }
    }
}

