/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Hashtable;
import sun.awt.X11.Native;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;
import sun.util.logging.PlatformLogger;

public class XKeysym {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static Hashtable<Long, Keysym2JavaKeycode> keysym2JavaKeycodeHash = new Hashtable();
    static Hashtable<Long, Character> keysym2UCSHash = new Hashtable();
    static Hashtable<Long, Long> uppercaseHash = new Hashtable();
    static Hashtable<Integer, Long> javaKeycode2KeysymHash = new Hashtable();
    static long keysym_lowercase = unsafe.allocateMemory(Native.getLongSize());
    static long keysym_uppercase = unsafe.allocateMemory(Native.getLongSize());
    static Keysym2JavaKeycode kanaLock = new Keysym2JavaKeycode(262, 1);
    private static PlatformLogger keyEventLog = PlatformLogger.getLogger("sun.awt.X11.kye.XKeysym");

    public static void main(String[] args) {
        System.out.println("Cyrillc zhe:" + XKeysym.convertKeysym(1750L, 0));
        System.out.println("Arabic sheen:" + XKeysym.convertKeysym(1492L, 0));
        System.out.println("Latin a breve:" + XKeysym.convertKeysym(483L, 0));
        System.out.println("Latin f:" + XKeysym.convertKeysym(102L, 0));
        System.out.println("Backspace:" + Integer.toHexString(XKeysym.convertKeysym(65288L, 0)));
        System.out.println("Ctrl+f:" + Integer.toHexString(XKeysym.convertKeysym(102L, 4)));
    }

    private XKeysym() {
    }

    public static char convertKeysym(long ks, int state) {
        if (ks >= 32L && ks <= 126L || ks >= 160L && ks <= 255L) {
            if ((state & 4) != 0 && (ks >= 65L && ks <= 93L || ks == 95L || ks >= 97L && ks <= 122L)) {
                ks &= 0x1FL;
            }
            return (char)ks;
        }
        if ((ks & 0xFFFFFFFFFF000000L) == 0x1000000L) {
            return (char)(ks & 0xFFFFFFL);
        }
        Character ch = keysym2UCSHash.get(ks);
        return ch == null ? (char)'\u0000' : ch.charValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long xkeycode2keysym_noxkb(XKeyEvent ev, int ndx) {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.XKeycodeToKeysym(ev.get_display(), ev.get_keycode(), ndx);
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long xkeycode2keysym_xkb(XKeyEvent ev, int ndx) {
        XToolkit.awtLock();
        try {
            long kbdDesc;
            int mods = ev.get_state();
            if (ndx == 0 && (mods & 1) != 0) {
                mods ^= 1;
            }
            if ((kbdDesc = XToolkit.getXKBKbdDesc()) == 0L) {
                keyEventLog.fine("Thread race: Toolkit shutdown before the end of a key event processing.");
                long l = 0L;
                return l;
            }
            XlibWrapper.XkbTranslateKeyCode(kbdDesc, ev.get_keycode(), mods, XlibWrapper.iarg1, XlibWrapper.larg3);
            long l = Native.getLong(XlibWrapper.larg3);
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long xkeycode2keysym(XKeyEvent ev, int ndx) {
        XToolkit.awtLock();
        try {
            if (XToolkit.canUseXKBCalls()) {
                long l = XKeysym.xkeycode2keysym_xkb(ev, ndx);
                return l;
            }
            long l = XKeysym.xkeycode2keysym_noxkb(ev, ndx);
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static long xkeycode2primary_keysym(XKeyEvent ev) {
        return XKeysym.xkeycode2keysym(ev, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKPEvent(XKeyEvent ev) {
        int ndx = XToolkit.isXsunKPBehavior() && !XToolkit.isXKBenabled() ? 2 : 1;
        XToolkit.awtLock();
        try {
            boolean bl = XlibWrapper.IsKeypadKey(XlibWrapper.XKeycodeToKeysym(ev.get_display(), ev.get_keycode(), ndx)) || XlibWrapper.IsKeypadKey(XlibWrapper.XKeycodeToKeysym(ev.get_display(), ev.get_keycode(), 0));
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUppercaseAlphabetic(long keysym) {
        long lc = -1L;
        long uc = -1L;
        Long stored = uppercaseHash.get(keysym);
        if (stored != null) {
            return stored;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XConvertCase(keysym, keysym_lowercase, keysym_uppercase);
            lc = Native.getLong(keysym_lowercase);
            uc = Native.getLong(keysym_uppercase);
            if (lc == uc) {
                uc = -1L;
            }
            uppercaseHash.put(keysym, uc);
        }
        finally {
            XToolkit.awtUnlock();
        }
        return uc;
    }

    private static long getKeypadKeysym(XKeyEvent ev) {
        int ndx = 0;
        long keysym = 0L;
        if (XToolkit.isXsunKPBehavior() && !XToolkit.isXKBenabled()) {
            if ((ev.get_state() & 1) != 0) {
                ndx = 3;
                keysym = XKeysym.xkeycode2keysym(ev, ndx);
            } else {
                ndx = 2;
                keysym = XKeysym.xkeycode2keysym(ev, ndx);
            }
        } else if ((ev.get_state() & 1) != 0 || (ev.get_state() & 2) != 0 && XToolkit.modLockIsShiftLock != 0) {
            ndx = 0;
            keysym = XKeysym.xkeycode2keysym(ev, ndx);
        } else {
            ndx = 1;
            keysym = XKeysym.xkeycode2keysym(ev, ndx);
        }
        return keysym;
    }

    static Keysym2JavaKeycode getJavaKeycode(long keysym) {
        if (keysym == 65406L) {
            if (XToolkit.isKanaKeyboard()) {
                return kanaLock;
            }
        } else if (keysym == 65480L) {
            if (XToolkit.isSunKeyboard()) {
                keysym = 65385L;
            }
        } else if (keysym == 65481L && XToolkit.isSunKeyboard()) {
            keysym = 65382L;
        }
        return keysym2JavaKeycodeHash.get(keysym);
    }

    static Keysym2JavaKeycode getJavaKeycode(XKeyEvent ev) {
        long keysym = 0L;
        int ndx = 0;
        if ((ev.get_state() & XToolkit.numLockMask) != 0 && XKeysym.isKPEvent(ev)) {
            keysym = XKeysym.getKeypadKeysym(ev);
        } else {
            ndx = 0;
            keysym = XKeysym.xkeycode2keysym(ev, ndx);
        }
        Keysym2JavaKeycode jkc = XKeysym.getJavaKeycode(keysym);
        return jkc;
    }

    static int getJavaKeycodeOnly(XKeyEvent ev) {
        Keysym2JavaKeycode jkc = XKeysym.getJavaKeycode(ev);
        return jkc == null ? 0 : jkc.getJavaKeycode();
    }

    static int getLegacyJavaKeycodeOnly(XKeyEvent ev) {
        long keysym = 0L;
        int ndx = 0;
        if ((ev.get_state() & XToolkit.numLockMask) != 0 && XKeysym.isKPEvent(ev)) {
            keysym = XKeysym.getKeypadKeysym(ev);
        } else {
            ndx = 0;
            keysym = XKeysym.xkeycode2keysym_noxkb(ev, ndx);
        }
        Keysym2JavaKeycode jkc = XKeysym.getJavaKeycode(keysym);
        return jkc == null ? 0 : jkc.getJavaKeycode();
    }

    static long javaKeycode2Keysym(int jkey) {
        Long ks = javaKeycode2KeysymHash.get(jkey);
        return ks == null ? 0L : ks;
    }

    static long getKeysym(XKeyEvent ev) {
        long keysym = 0L;
        long uppercaseKeysym = 0L;
        int ndx = 0;
        boolean getUppercase = false;
        if ((ev.get_state() & XToolkit.numLockMask) != 0 && XKeysym.isKPEvent(ev)) {
            keysym = XKeysym.getKeypadKeysym(ev);
        } else {
            if ((ev.get_state() & 1) == 0) {
                if ((ev.get_state() & 2) == 0) {
                    ndx = 0;
                    getUppercase = false;
                } else if ((ev.get_state() & 2) != 0 && XToolkit.modLockIsShiftLock == 0) {
                    ndx = 0;
                    getUppercase = true;
                } else if ((ev.get_state() & 2) != 0 && XToolkit.modLockIsShiftLock != 0) {
                    ndx = 1;
                    getUppercase = false;
                }
            } else if ((ev.get_state() & 2) != 0 && XToolkit.modLockIsShiftLock == 0) {
                ndx = 1;
                getUppercase = true;
            } else {
                ndx = 1;
                getUppercase = false;
            }
            keysym = XKeysym.xkeycode2keysym(ev, ndx);
            if (getUppercase && (uppercaseKeysym = XKeysym.getUppercaseAlphabetic(keysym)) != -1L) {
                keysym = uppercaseKeysym;
            }
        }
        return keysym;
    }

    static {
        keysym2UCSHash.put(65288L, Character.valueOf('\b'));
        keysym2UCSHash.put(65289L, Character.valueOf('\t'));
        keysym2UCSHash.put(65290L, Character.valueOf('\n'));
        keysym2UCSHash.put(65291L, Character.valueOf('\u000b'));
        keysym2UCSHash.put(65293L, Character.valueOf('\n'));
        keysym2UCSHash.put(65307L, Character.valueOf('\u001b'));
        keysym2UCSHash.put(65535L, Character.valueOf('\u007f'));
        keysym2UCSHash.put(65408L, Character.valueOf(' '));
        keysym2UCSHash.put(65417L, Character.valueOf('\t'));
        keysym2UCSHash.put(65421L, Character.valueOf('\n'));
        keysym2UCSHash.put(65439L, Character.valueOf('\u007f'));
        keysym2UCSHash.put(65469L, Character.valueOf('='));
        keysym2UCSHash.put(65450L, Character.valueOf('*'));
        keysym2UCSHash.put(65451L, Character.valueOf('+'));
        keysym2UCSHash.put(65452L, Character.valueOf(','));
        keysym2UCSHash.put(65453L, Character.valueOf('-'));
        keysym2UCSHash.put(65454L, Character.valueOf('.'));
        keysym2UCSHash.put(65455L, Character.valueOf('/'));
        keysym2UCSHash.put(65456L, Character.valueOf('0'));
        keysym2UCSHash.put(65457L, Character.valueOf('1'));
        keysym2UCSHash.put(65458L, Character.valueOf('2'));
        keysym2UCSHash.put(65459L, Character.valueOf('3'));
        keysym2UCSHash.put(65460L, Character.valueOf('4'));
        keysym2UCSHash.put(65461L, Character.valueOf('5'));
        keysym2UCSHash.put(65462L, Character.valueOf('6'));
        keysym2UCSHash.put(65463L, Character.valueOf('7'));
        keysym2UCSHash.put(65464L, Character.valueOf('8'));
        keysym2UCSHash.put(65465L, Character.valueOf('9'));
        keysym2UCSHash.put(65056L, Character.valueOf('\t'));
        keysym2UCSHash.put(65104L, Character.valueOf('\u02cb'));
        keysym2UCSHash.put(65105L, Character.valueOf('\u02ca'));
        keysym2UCSHash.put(65106L, Character.valueOf('\u02c6'));
        keysym2UCSHash.put(65107L, Character.valueOf('\u02dc'));
        keysym2UCSHash.put(65108L, Character.valueOf('\u02c9'));
        keysym2UCSHash.put(65109L, Character.valueOf('\u02d8'));
        keysym2UCSHash.put(65110L, Character.valueOf('\u02d9'));
        keysym2UCSHash.put(65111L, Character.valueOf('\u00a8'));
        keysym2UCSHash.put(65112L, Character.valueOf('\u02da'));
        keysym2UCSHash.put(65113L, Character.valueOf('\u02dd'));
        keysym2UCSHash.put(65114L, Character.valueOf('\u02c7'));
        keysym2UCSHash.put(65115L, Character.valueOf('\u00b8'));
        keysym2UCSHash.put(65116L, Character.valueOf('\u02db'));
        keysym2UCSHash.put(65117L, Character.valueOf('\u0269'));
        keysym2UCSHash.put(65118L, Character.valueOf('\u3099'));
        keysym2UCSHash.put(65119L, Character.valueOf('\u309a'));
        keysym2UCSHash.put(65120L, Character.valueOf('\u0323'));
        keysym2UCSHash.put(65121L, Character.valueOf('\u0321'));
        keysym2UCSHash.put(65122L, Character.valueOf('\u031b'));
        keysym2UCSHash.put(417L, Character.valueOf('\u0104'));
        keysym2UCSHash.put(418L, Character.valueOf('\u02d8'));
        keysym2UCSHash.put(419L, Character.valueOf('\u0141'));
        keysym2UCSHash.put(421L, Character.valueOf('\u013d'));
        keysym2UCSHash.put(422L, Character.valueOf('\u015a'));
        keysym2UCSHash.put(425L, Character.valueOf('\u0160'));
        keysym2UCSHash.put(426L, Character.valueOf('\u015e'));
        keysym2UCSHash.put(427L, Character.valueOf('\u0164'));
        keysym2UCSHash.put(428L, Character.valueOf('\u0179'));
        keysym2UCSHash.put(430L, Character.valueOf('\u017d'));
        keysym2UCSHash.put(431L, Character.valueOf('\u017b'));
        keysym2UCSHash.put(433L, Character.valueOf('\u0105'));
        keysym2UCSHash.put(434L, Character.valueOf('\u02db'));
        keysym2UCSHash.put(435L, Character.valueOf('\u0142'));
        keysym2UCSHash.put(437L, Character.valueOf('\u013e'));
        keysym2UCSHash.put(438L, Character.valueOf('\u015b'));
        keysym2UCSHash.put(439L, Character.valueOf('\u02c7'));
        keysym2UCSHash.put(441L, Character.valueOf('\u0161'));
        keysym2UCSHash.put(442L, Character.valueOf('\u015f'));
        keysym2UCSHash.put(443L, Character.valueOf('\u0165'));
        keysym2UCSHash.put(444L, Character.valueOf('\u017a'));
        keysym2UCSHash.put(445L, Character.valueOf('\u02dd'));
        keysym2UCSHash.put(446L, Character.valueOf('\u017e'));
        keysym2UCSHash.put(447L, Character.valueOf('\u017c'));
        keysym2UCSHash.put(448L, Character.valueOf('\u0154'));
        keysym2UCSHash.put(451L, Character.valueOf('\u0102'));
        keysym2UCSHash.put(453L, Character.valueOf('\u0139'));
        keysym2UCSHash.put(454L, Character.valueOf('\u0106'));
        keysym2UCSHash.put(456L, Character.valueOf('\u010c'));
        keysym2UCSHash.put(458L, Character.valueOf('\u0118'));
        keysym2UCSHash.put(460L, Character.valueOf('\u011a'));
        keysym2UCSHash.put(463L, Character.valueOf('\u010e'));
        keysym2UCSHash.put(464L, Character.valueOf('\u0110'));
        keysym2UCSHash.put(465L, Character.valueOf('\u0143'));
        keysym2UCSHash.put(466L, Character.valueOf('\u0147'));
        keysym2UCSHash.put(469L, Character.valueOf('\u0150'));
        keysym2UCSHash.put(472L, Character.valueOf('\u0158'));
        keysym2UCSHash.put(473L, Character.valueOf('\u016e'));
        keysym2UCSHash.put(475L, Character.valueOf('\u0170'));
        keysym2UCSHash.put(478L, Character.valueOf('\u0162'));
        keysym2UCSHash.put(480L, Character.valueOf('\u0155'));
        keysym2UCSHash.put(483L, Character.valueOf('\u0103'));
        keysym2UCSHash.put(485L, Character.valueOf('\u013a'));
        keysym2UCSHash.put(486L, Character.valueOf('\u0107'));
        keysym2UCSHash.put(488L, Character.valueOf('\u010d'));
        keysym2UCSHash.put(490L, Character.valueOf('\u0119'));
        keysym2UCSHash.put(492L, Character.valueOf('\u011b'));
        keysym2UCSHash.put(495L, Character.valueOf('\u010f'));
        keysym2UCSHash.put(496L, Character.valueOf('\u0111'));
        keysym2UCSHash.put(497L, Character.valueOf('\u0144'));
        keysym2UCSHash.put(498L, Character.valueOf('\u0148'));
        keysym2UCSHash.put(501L, Character.valueOf('\u0151'));
        keysym2UCSHash.put(507L, Character.valueOf('\u0171'));
        keysym2UCSHash.put(504L, Character.valueOf('\u0159'));
        keysym2UCSHash.put(505L, Character.valueOf('\u016f'));
        keysym2UCSHash.put(510L, Character.valueOf('\u0163'));
        keysym2UCSHash.put(511L, Character.valueOf('\u02d9'));
        keysym2UCSHash.put(673L, Character.valueOf('\u0126'));
        keysym2UCSHash.put(678L, Character.valueOf('\u0124'));
        keysym2UCSHash.put(681L, Character.valueOf('\u0130'));
        keysym2UCSHash.put(683L, Character.valueOf('\u011e'));
        keysym2UCSHash.put(684L, Character.valueOf('\u0134'));
        keysym2UCSHash.put(689L, Character.valueOf('\u0127'));
        keysym2UCSHash.put(694L, Character.valueOf('\u0125'));
        keysym2UCSHash.put(697L, Character.valueOf('\u0131'));
        keysym2UCSHash.put(699L, Character.valueOf('\u011f'));
        keysym2UCSHash.put(700L, Character.valueOf('\u0135'));
        keysym2UCSHash.put(709L, Character.valueOf('\u010a'));
        keysym2UCSHash.put(710L, Character.valueOf('\u0108'));
        keysym2UCSHash.put(725L, Character.valueOf('\u0120'));
        keysym2UCSHash.put(728L, Character.valueOf('\u011c'));
        keysym2UCSHash.put(733L, Character.valueOf('\u016c'));
        keysym2UCSHash.put(734L, Character.valueOf('\u015c'));
        keysym2UCSHash.put(741L, Character.valueOf('\u010b'));
        keysym2UCSHash.put(742L, Character.valueOf('\u0109'));
        keysym2UCSHash.put(757L, Character.valueOf('\u0121'));
        keysym2UCSHash.put(760L, Character.valueOf('\u011d'));
        keysym2UCSHash.put(765L, Character.valueOf('\u016d'));
        keysym2UCSHash.put(766L, Character.valueOf('\u015d'));
        keysym2UCSHash.put(930L, Character.valueOf('\u0138'));
        keysym2UCSHash.put(931L, Character.valueOf('\u0156'));
        keysym2UCSHash.put(933L, Character.valueOf('\u0128'));
        keysym2UCSHash.put(934L, Character.valueOf('\u013b'));
        keysym2UCSHash.put(938L, Character.valueOf('\u0112'));
        keysym2UCSHash.put(939L, Character.valueOf('\u0122'));
        keysym2UCSHash.put(940L, Character.valueOf('\u0166'));
        keysym2UCSHash.put(947L, Character.valueOf('\u0157'));
        keysym2UCSHash.put(949L, Character.valueOf('\u0129'));
        keysym2UCSHash.put(950L, Character.valueOf('\u013c'));
        keysym2UCSHash.put(954L, Character.valueOf('\u0113'));
        keysym2UCSHash.put(955L, Character.valueOf('\u0123'));
        keysym2UCSHash.put(956L, Character.valueOf('\u0167'));
        keysym2UCSHash.put(957L, Character.valueOf('\u014a'));
        keysym2UCSHash.put(959L, Character.valueOf('\u014b'));
        keysym2UCSHash.put(960L, Character.valueOf('\u0100'));
        keysym2UCSHash.put(967L, Character.valueOf('\u012e'));
        keysym2UCSHash.put(972L, Character.valueOf('\u0116'));
        keysym2UCSHash.put(975L, Character.valueOf('\u012a'));
        keysym2UCSHash.put(977L, Character.valueOf('\u0145'));
        keysym2UCSHash.put(978L, Character.valueOf('\u014c'));
        keysym2UCSHash.put(979L, Character.valueOf('\u0136'));
        keysym2UCSHash.put(985L, Character.valueOf('\u0172'));
        keysym2UCSHash.put(989L, Character.valueOf('\u0168'));
        keysym2UCSHash.put(990L, Character.valueOf('\u016a'));
        keysym2UCSHash.put(992L, Character.valueOf('\u0101'));
        keysym2UCSHash.put(999L, Character.valueOf('\u012f'));
        keysym2UCSHash.put(1004L, Character.valueOf('\u0117'));
        keysym2UCSHash.put(1007L, Character.valueOf('\u012b'));
        keysym2UCSHash.put(1009L, Character.valueOf('\u0146'));
        keysym2UCSHash.put(1010L, Character.valueOf('\u014d'));
        keysym2UCSHash.put(1011L, Character.valueOf('\u0137'));
        keysym2UCSHash.put(1017L, Character.valueOf('\u0173'));
        keysym2UCSHash.put(1021L, Character.valueOf('\u0169'));
        keysym2UCSHash.put(1022L, Character.valueOf('\u016b'));
        keysym2UCSHash.put(4769L, Character.valueOf('\u1e02'));
        keysym2UCSHash.put(4770L, Character.valueOf('\u1e03'));
        keysym2UCSHash.put(4774L, Character.valueOf('\u1e0a'));
        keysym2UCSHash.put(4776L, Character.valueOf('\u1e80'));
        keysym2UCSHash.put(4778L, Character.valueOf('\u1e82'));
        keysym2UCSHash.put(4779L, Character.valueOf('\u1e0b'));
        keysym2UCSHash.put(4780L, Character.valueOf('\u1ef2'));
        keysym2UCSHash.put(4784L, Character.valueOf('\u1e1e'));
        keysym2UCSHash.put(4785L, Character.valueOf('\u1e1f'));
        keysym2UCSHash.put(4788L, Character.valueOf('\u1e40'));
        keysym2UCSHash.put(4789L, Character.valueOf('\u1e41'));
        keysym2UCSHash.put(4791L, Character.valueOf('\u1e56'));
        keysym2UCSHash.put(4792L, Character.valueOf('\u1e81'));
        keysym2UCSHash.put(4793L, Character.valueOf('\u1e57'));
        keysym2UCSHash.put(4794L, Character.valueOf('\u1e83'));
        keysym2UCSHash.put(4795L, Character.valueOf('\u1e60'));
        keysym2UCSHash.put(4796L, Character.valueOf('\u1ef3'));
        keysym2UCSHash.put(4797L, Character.valueOf('\u1e84'));
        keysym2UCSHash.put(4798L, Character.valueOf('\u1e85'));
        keysym2UCSHash.put(4799L, Character.valueOf('\u1e61'));
        keysym2UCSHash.put(4816L, Character.valueOf('\u0017'));
        keysym2UCSHash.put(4823L, Character.valueOf('\u1e6a'));
        keysym2UCSHash.put(4830L, Character.valueOf('\u0176'));
        keysym2UCSHash.put(4848L, Character.valueOf('\u0175'));
        keysym2UCSHash.put(4855L, Character.valueOf('\u1e6b'));
        keysym2UCSHash.put(4862L, Character.valueOf('\u0177'));
        keysym2UCSHash.put(5052L, Character.valueOf('\u0152'));
        keysym2UCSHash.put(5053L, Character.valueOf('\u0153'));
        keysym2UCSHash.put(5054L, Character.valueOf('\u0178'));
        keysym2UCSHash.put(1150L, Character.valueOf('\u203e'));
        keysym2UCSHash.put(1185L, Character.valueOf('\u3002'));
        keysym2UCSHash.put(1186L, Character.valueOf('\u300c'));
        keysym2UCSHash.put(1187L, Character.valueOf('\u300d'));
        keysym2UCSHash.put(1188L, Character.valueOf('\u3001'));
        keysym2UCSHash.put(1189L, Character.valueOf('\u30fb'));
        keysym2UCSHash.put(1190L, Character.valueOf('\u30f2'));
        keysym2UCSHash.put(1191L, Character.valueOf('\u30a1'));
        keysym2UCSHash.put(1192L, Character.valueOf('\u30a3'));
        keysym2UCSHash.put(1193L, Character.valueOf('\u30a5'));
        keysym2UCSHash.put(1194L, Character.valueOf('\u30a7'));
        keysym2UCSHash.put(1195L, Character.valueOf('\u30a9'));
        keysym2UCSHash.put(1196L, Character.valueOf('\u30e3'));
        keysym2UCSHash.put(1197L, Character.valueOf('\u30e5'));
        keysym2UCSHash.put(1198L, Character.valueOf('\u30e7'));
        keysym2UCSHash.put(1199L, Character.valueOf('\u30c3'));
        keysym2UCSHash.put(1200L, Character.valueOf('\u30fc'));
        keysym2UCSHash.put(1201L, Character.valueOf('\u30a2'));
        keysym2UCSHash.put(1202L, Character.valueOf('\u30a4'));
        keysym2UCSHash.put(1203L, Character.valueOf('\u30a6'));
        keysym2UCSHash.put(1204L, Character.valueOf('\u30a8'));
        keysym2UCSHash.put(1205L, Character.valueOf('\u30aa'));
        keysym2UCSHash.put(1206L, Character.valueOf('\u30ab'));
        keysym2UCSHash.put(1207L, Character.valueOf('\u30ad'));
        keysym2UCSHash.put(1208L, Character.valueOf('\u30af'));
        keysym2UCSHash.put(1209L, Character.valueOf('\u30b1'));
        keysym2UCSHash.put(1210L, Character.valueOf('\u30b3'));
        keysym2UCSHash.put(1211L, Character.valueOf('\u30b5'));
        keysym2UCSHash.put(1212L, Character.valueOf('\u30b7'));
        keysym2UCSHash.put(1213L, Character.valueOf('\u30b9'));
        keysym2UCSHash.put(1214L, Character.valueOf('\u30bb'));
        keysym2UCSHash.put(1215L, Character.valueOf('\u30bd'));
        keysym2UCSHash.put(1216L, Character.valueOf('\u30bf'));
        keysym2UCSHash.put(1217L, Character.valueOf('\u30c1'));
        keysym2UCSHash.put(1218L, Character.valueOf('\u30c4'));
        keysym2UCSHash.put(1219L, Character.valueOf('\u30c6'));
        keysym2UCSHash.put(1220L, Character.valueOf('\u30c8'));
        keysym2UCSHash.put(1221L, Character.valueOf('\u30ca'));
        keysym2UCSHash.put(1222L, Character.valueOf('\u30cb'));
        keysym2UCSHash.put(1223L, Character.valueOf('\u30cc'));
        keysym2UCSHash.put(1224L, Character.valueOf('\u30cd'));
        keysym2UCSHash.put(1225L, Character.valueOf('\u30ce'));
        keysym2UCSHash.put(1226L, Character.valueOf('\u30cf'));
        keysym2UCSHash.put(1227L, Character.valueOf('\u30d2'));
        keysym2UCSHash.put(1228L, Character.valueOf('\u30d5'));
        keysym2UCSHash.put(1229L, Character.valueOf('\u30d8'));
        keysym2UCSHash.put(1230L, Character.valueOf('\u30db'));
        keysym2UCSHash.put(1231L, Character.valueOf('\u30de'));
        keysym2UCSHash.put(1232L, Character.valueOf('\u30df'));
        keysym2UCSHash.put(1233L, Character.valueOf('\u30e0'));
        keysym2UCSHash.put(1234L, Character.valueOf('\u30e1'));
        keysym2UCSHash.put(1235L, Character.valueOf('\u30e2'));
        keysym2UCSHash.put(1236L, Character.valueOf('\u30e4'));
        keysym2UCSHash.put(1237L, Character.valueOf('\u30e6'));
        keysym2UCSHash.put(1238L, Character.valueOf('\u30e8'));
        keysym2UCSHash.put(1239L, Character.valueOf('\u30e9'));
        keysym2UCSHash.put(1240L, Character.valueOf('\u30ea'));
        keysym2UCSHash.put(1241L, Character.valueOf('\u30eb'));
        keysym2UCSHash.put(1242L, Character.valueOf('\u30ec'));
        keysym2UCSHash.put(1243L, Character.valueOf('\u30ed'));
        keysym2UCSHash.put(1244L, Character.valueOf('\u30ef'));
        keysym2UCSHash.put(1245L, Character.valueOf('\u30f3'));
        keysym2UCSHash.put(1246L, Character.valueOf('\u309b'));
        keysym2UCSHash.put(1247L, Character.valueOf('\u309c'));
        keysym2UCSHash.put(1424L, Character.valueOf('\u0670'));
        keysym2UCSHash.put(1425L, Character.valueOf('\u06f1'));
        keysym2UCSHash.put(1426L, Character.valueOf('\u06f2'));
        keysym2UCSHash.put(1427L, Character.valueOf('\u06f3'));
        keysym2UCSHash.put(1428L, Character.valueOf('\u06f4'));
        keysym2UCSHash.put(1429L, Character.valueOf('\u06f5'));
        keysym2UCSHash.put(1430L, Character.valueOf('\u06f6'));
        keysym2UCSHash.put(1431L, Character.valueOf('\u06f7'));
        keysym2UCSHash.put(1432L, Character.valueOf('\u06f8'));
        keysym2UCSHash.put(1433L, Character.valueOf('\u06f9'));
        keysym2UCSHash.put(1445L, Character.valueOf('\u066a'));
        keysym2UCSHash.put(1446L, Character.valueOf('\u0670'));
        keysym2UCSHash.put(1447L, Character.valueOf('\u0679'));
        keysym2UCSHash.put(1448L, Character.valueOf('\u067e'));
        keysym2UCSHash.put(1449L, Character.valueOf('\u0686'));
        keysym2UCSHash.put(1450L, Character.valueOf('\u0688'));
        keysym2UCSHash.put(1451L, Character.valueOf('\u0691'));
        keysym2UCSHash.put(1452L, Character.valueOf('\u060c'));
        keysym2UCSHash.put(1454L, Character.valueOf('\u06d4'));
        keysym2UCSHash.put(1456L, Character.valueOf('\u0660'));
        keysym2UCSHash.put(1457L, Character.valueOf('\u0661'));
        keysym2UCSHash.put(1458L, Character.valueOf('\u0662'));
        keysym2UCSHash.put(1459L, Character.valueOf('\u0663'));
        keysym2UCSHash.put(1460L, Character.valueOf('\u0664'));
        keysym2UCSHash.put(1461L, Character.valueOf('\u0665'));
        keysym2UCSHash.put(1462L, Character.valueOf('\u0666'));
        keysym2UCSHash.put(1463L, Character.valueOf('\u0667'));
        keysym2UCSHash.put(1464L, Character.valueOf('\u0668'));
        keysym2UCSHash.put(1465L, Character.valueOf('\u0669'));
        keysym2UCSHash.put(1467L, Character.valueOf('\u061b'));
        keysym2UCSHash.put(1471L, Character.valueOf('\u061f'));
        keysym2UCSHash.put(1473L, Character.valueOf('\u0621'));
        keysym2UCSHash.put(1474L, Character.valueOf('\u0622'));
        keysym2UCSHash.put(1475L, Character.valueOf('\u0623'));
        keysym2UCSHash.put(1476L, Character.valueOf('\u0624'));
        keysym2UCSHash.put(1477L, Character.valueOf('\u0625'));
        keysym2UCSHash.put(1478L, Character.valueOf('\u0626'));
        keysym2UCSHash.put(1479L, Character.valueOf('\u0627'));
        keysym2UCSHash.put(1480L, Character.valueOf('\u0628'));
        keysym2UCSHash.put(1481L, Character.valueOf('\u0629'));
        keysym2UCSHash.put(1482L, Character.valueOf('\u062a'));
        keysym2UCSHash.put(1483L, Character.valueOf('\u062b'));
        keysym2UCSHash.put(1484L, Character.valueOf('\u062c'));
        keysym2UCSHash.put(1485L, Character.valueOf('\u062d'));
        keysym2UCSHash.put(1486L, Character.valueOf('\u062e'));
        keysym2UCSHash.put(1487L, Character.valueOf('\u062f'));
        keysym2UCSHash.put(1488L, Character.valueOf('\u0630'));
        keysym2UCSHash.put(1489L, Character.valueOf('\u0631'));
        keysym2UCSHash.put(1490L, Character.valueOf('\u0632'));
        keysym2UCSHash.put(1491L, Character.valueOf('\u0633'));
        keysym2UCSHash.put(1492L, Character.valueOf('\u0634'));
        keysym2UCSHash.put(1493L, Character.valueOf('\u0635'));
        keysym2UCSHash.put(1494L, Character.valueOf('\u0636'));
        keysym2UCSHash.put(1495L, Character.valueOf('\u0637'));
        keysym2UCSHash.put(1496L, Character.valueOf('\u0638'));
        keysym2UCSHash.put(1497L, Character.valueOf('\u0639'));
        keysym2UCSHash.put(1498L, Character.valueOf('\u063a'));
        keysym2UCSHash.put(1504L, Character.valueOf('\u0640'));
        keysym2UCSHash.put(1505L, Character.valueOf('\u0641'));
        keysym2UCSHash.put(1506L, Character.valueOf('\u0642'));
        keysym2UCSHash.put(1507L, Character.valueOf('\u0643'));
        keysym2UCSHash.put(1508L, Character.valueOf('\u0644'));
        keysym2UCSHash.put(1509L, Character.valueOf('\u0645'));
        keysym2UCSHash.put(1510L, Character.valueOf('\u0646'));
        keysym2UCSHash.put(1511L, Character.valueOf('\u0647'));
        keysym2UCSHash.put(1512L, Character.valueOf('\u0648'));
        keysym2UCSHash.put(1513L, Character.valueOf('\u0649'));
        keysym2UCSHash.put(1514L, Character.valueOf('\u064a'));
        keysym2UCSHash.put(1515L, Character.valueOf('\u064b'));
        keysym2UCSHash.put(1516L, Character.valueOf('\u064c'));
        keysym2UCSHash.put(1517L, Character.valueOf('\u064d'));
        keysym2UCSHash.put(1518L, Character.valueOf('\u064e'));
        keysym2UCSHash.put(1519L, Character.valueOf('\u064f'));
        keysym2UCSHash.put(1520L, Character.valueOf('\u0650'));
        keysym2UCSHash.put(1521L, Character.valueOf('\u0651'));
        keysym2UCSHash.put(1522L, Character.valueOf('\u0652'));
        keysym2UCSHash.put(1523L, Character.valueOf('\u0653'));
        keysym2UCSHash.put(1524L, Character.valueOf('\u0654'));
        keysym2UCSHash.put(1525L, Character.valueOf('\u0655'));
        keysym2UCSHash.put(1526L, Character.valueOf('\u0698'));
        keysym2UCSHash.put(1527L, Character.valueOf('\u06a4'));
        keysym2UCSHash.put(1528L, Character.valueOf('\u06a9'));
        keysym2UCSHash.put(1529L, Character.valueOf('\u06af'));
        keysym2UCSHash.put(1530L, Character.valueOf('\u06ba'));
        keysym2UCSHash.put(1531L, Character.valueOf('\u06be'));
        keysym2UCSHash.put(1532L, Character.valueOf('\u06cc'));
        keysym2UCSHash.put(1533L, Character.valueOf('\u06d2'));
        keysym2UCSHash.put(1534L, Character.valueOf('\u06c1'));
        keysym2UCSHash.put(1664L, Character.valueOf('\u0492'));
        keysym2UCSHash.put(1680L, Character.valueOf('\u0493'));
        keysym2UCSHash.put(1665L, Character.valueOf('\u0496'));
        keysym2UCSHash.put(1681L, Character.valueOf('\u0497'));
        keysym2UCSHash.put(1666L, Character.valueOf('\u049a'));
        keysym2UCSHash.put(1682L, Character.valueOf('\u049b'));
        keysym2UCSHash.put(1667L, Character.valueOf('\u049c'));
        keysym2UCSHash.put(1683L, Character.valueOf('\u049d'));
        keysym2UCSHash.put(1668L, Character.valueOf('\u04a2'));
        keysym2UCSHash.put(1684L, Character.valueOf('\u04a3'));
        keysym2UCSHash.put(1669L, Character.valueOf('\u04ae'));
        keysym2UCSHash.put(1685L, Character.valueOf('\u04af'));
        keysym2UCSHash.put(1670L, Character.valueOf('\u04b0'));
        keysym2UCSHash.put(1686L, Character.valueOf('\u04b1'));
        keysym2UCSHash.put(1671L, Character.valueOf('\u04b2'));
        keysym2UCSHash.put(1687L, Character.valueOf('\u04b3'));
        keysym2UCSHash.put(1672L, Character.valueOf('\u04b6'));
        keysym2UCSHash.put(1688L, Character.valueOf('\u04b7'));
        keysym2UCSHash.put(1673L, Character.valueOf('\u04b8'));
        keysym2UCSHash.put(1689L, Character.valueOf('\u04b9'));
        keysym2UCSHash.put(1674L, Character.valueOf('\u04ba'));
        keysym2UCSHash.put(1690L, Character.valueOf('\u04bb'));
        keysym2UCSHash.put(1676L, Character.valueOf('\u04d8'));
        keysym2UCSHash.put(1692L, Character.valueOf('\u04d9'));
        keysym2UCSHash.put(1677L, Character.valueOf('\u04e2'));
        keysym2UCSHash.put(1693L, Character.valueOf('\u04e3'));
        keysym2UCSHash.put(1678L, Character.valueOf('\u04e8'));
        keysym2UCSHash.put(1694L, Character.valueOf('\u04e9'));
        keysym2UCSHash.put(1679L, Character.valueOf('\u04ee'));
        keysym2UCSHash.put(1695L, Character.valueOf('\u04ef'));
        keysym2UCSHash.put(1697L, Character.valueOf('\u0452'));
        keysym2UCSHash.put(1698L, Character.valueOf('\u0453'));
        keysym2UCSHash.put(1699L, Character.valueOf('\u0451'));
        keysym2UCSHash.put(1700L, Character.valueOf('\u0454'));
        keysym2UCSHash.put(1701L, Character.valueOf('\u0455'));
        keysym2UCSHash.put(1702L, Character.valueOf('\u0456'));
        keysym2UCSHash.put(1703L, Character.valueOf('\u0457'));
        keysym2UCSHash.put(1704L, Character.valueOf('\u0458'));
        keysym2UCSHash.put(1705L, Character.valueOf('\u0459'));
        keysym2UCSHash.put(1706L, Character.valueOf('\u045a'));
        keysym2UCSHash.put(1707L, Character.valueOf('\u045b'));
        keysym2UCSHash.put(1708L, Character.valueOf('\u045c'));
        keysym2UCSHash.put(1709L, Character.valueOf('\u0491'));
        keysym2UCSHash.put(1710L, Character.valueOf('\u045e'));
        keysym2UCSHash.put(1711L, Character.valueOf('\u045f'));
        keysym2UCSHash.put(1712L, Character.valueOf('\u2116'));
        keysym2UCSHash.put(1713L, Character.valueOf('\u0402'));
        keysym2UCSHash.put(1714L, Character.valueOf('\u0403'));
        keysym2UCSHash.put(1715L, Character.valueOf('\u0401'));
        keysym2UCSHash.put(1716L, Character.valueOf('\u0404'));
        keysym2UCSHash.put(1717L, Character.valueOf('\u0405'));
        keysym2UCSHash.put(1718L, Character.valueOf('\u0406'));
        keysym2UCSHash.put(1719L, Character.valueOf('\u0407'));
        keysym2UCSHash.put(1720L, Character.valueOf('\u0408'));
        keysym2UCSHash.put(1721L, Character.valueOf('\u0409'));
        keysym2UCSHash.put(1722L, Character.valueOf('\u040a'));
        keysym2UCSHash.put(1723L, Character.valueOf('\u040b'));
        keysym2UCSHash.put(1724L, Character.valueOf('\u040c'));
        keysym2UCSHash.put(1725L, Character.valueOf('\u0490'));
        keysym2UCSHash.put(1726L, Character.valueOf('\u040e'));
        keysym2UCSHash.put(1727L, Character.valueOf('\u040f'));
        keysym2UCSHash.put(1728L, Character.valueOf('\u044e'));
        keysym2UCSHash.put(1729L, Character.valueOf('\u0430'));
        keysym2UCSHash.put(1730L, Character.valueOf('\u0431'));
        keysym2UCSHash.put(1731L, Character.valueOf('\u0446'));
        keysym2UCSHash.put(1732L, Character.valueOf('\u0434'));
        keysym2UCSHash.put(1733L, Character.valueOf('\u0435'));
        keysym2UCSHash.put(1734L, Character.valueOf('\u0444'));
        keysym2UCSHash.put(1735L, Character.valueOf('\u0433'));
        keysym2UCSHash.put(1736L, Character.valueOf('\u0445'));
        keysym2UCSHash.put(1737L, Character.valueOf('\u0438'));
        keysym2UCSHash.put(1738L, Character.valueOf('\u0439'));
        keysym2UCSHash.put(1739L, Character.valueOf('\u043a'));
        keysym2UCSHash.put(1740L, Character.valueOf('\u043b'));
        keysym2UCSHash.put(1741L, Character.valueOf('\u043c'));
        keysym2UCSHash.put(1742L, Character.valueOf('\u043d'));
        keysym2UCSHash.put(1743L, Character.valueOf('\u043e'));
        keysym2UCSHash.put(1744L, Character.valueOf('\u043f'));
        keysym2UCSHash.put(1745L, Character.valueOf('\u044f'));
        keysym2UCSHash.put(1746L, Character.valueOf('\u0440'));
        keysym2UCSHash.put(1747L, Character.valueOf('\u0441'));
        keysym2UCSHash.put(1748L, Character.valueOf('\u0442'));
        keysym2UCSHash.put(1749L, Character.valueOf('\u0443'));
        keysym2UCSHash.put(1750L, Character.valueOf('\u0436'));
        keysym2UCSHash.put(1751L, Character.valueOf('\u0432'));
        keysym2UCSHash.put(1752L, Character.valueOf('\u044c'));
        keysym2UCSHash.put(1753L, Character.valueOf('\u044b'));
        keysym2UCSHash.put(1754L, Character.valueOf('\u0437'));
        keysym2UCSHash.put(1755L, Character.valueOf('\u0448'));
        keysym2UCSHash.put(1756L, Character.valueOf('\u044d'));
        keysym2UCSHash.put(1757L, Character.valueOf('\u0449'));
        keysym2UCSHash.put(1758L, Character.valueOf('\u0447'));
        keysym2UCSHash.put(1759L, Character.valueOf('\u044a'));
        keysym2UCSHash.put(1760L, Character.valueOf('\u042e'));
        keysym2UCSHash.put(1761L, Character.valueOf('\u0410'));
        keysym2UCSHash.put(1762L, Character.valueOf('\u0411'));
        keysym2UCSHash.put(1763L, Character.valueOf('\u0426'));
        keysym2UCSHash.put(1764L, Character.valueOf('\u0414'));
        keysym2UCSHash.put(1765L, Character.valueOf('\u0415'));
        keysym2UCSHash.put(1766L, Character.valueOf('\u0424'));
        keysym2UCSHash.put(1767L, Character.valueOf('\u0413'));
        keysym2UCSHash.put(1768L, Character.valueOf('\u0425'));
        keysym2UCSHash.put(1769L, Character.valueOf('\u0418'));
        keysym2UCSHash.put(1770L, Character.valueOf('\u0419'));
        keysym2UCSHash.put(1771L, Character.valueOf('\u041a'));
        keysym2UCSHash.put(1772L, Character.valueOf('\u041b'));
        keysym2UCSHash.put(1773L, Character.valueOf('\u041c'));
        keysym2UCSHash.put(1774L, Character.valueOf('\u041d'));
        keysym2UCSHash.put(1775L, Character.valueOf('\u041e'));
        keysym2UCSHash.put(1776L, Character.valueOf('\u041f'));
        keysym2UCSHash.put(1777L, Character.valueOf('\u042f'));
        keysym2UCSHash.put(1778L, Character.valueOf('\u0420'));
        keysym2UCSHash.put(1779L, Character.valueOf('\u0421'));
        keysym2UCSHash.put(1780L, Character.valueOf('\u0422'));
        keysym2UCSHash.put(1781L, Character.valueOf('\u0423'));
        keysym2UCSHash.put(1782L, Character.valueOf('\u0416'));
        keysym2UCSHash.put(1783L, Character.valueOf('\u0412'));
        keysym2UCSHash.put(1784L, Character.valueOf('\u042c'));
        keysym2UCSHash.put(1785L, Character.valueOf('\u042b'));
        keysym2UCSHash.put(1786L, Character.valueOf('\u0417'));
        keysym2UCSHash.put(1787L, Character.valueOf('\u0428'));
        keysym2UCSHash.put(1788L, Character.valueOf('\u042d'));
        keysym2UCSHash.put(1789L, Character.valueOf('\u0429'));
        keysym2UCSHash.put(1790L, Character.valueOf('\u0427'));
        keysym2UCSHash.put(1791L, Character.valueOf('\u042a'));
        keysym2UCSHash.put(1953L, Character.valueOf('\u0386'));
        keysym2UCSHash.put(1954L, Character.valueOf('\u0388'));
        keysym2UCSHash.put(1955L, Character.valueOf('\u0389'));
        keysym2UCSHash.put(1956L, Character.valueOf('\u038a'));
        keysym2UCSHash.put(1957L, Character.valueOf('\u03aa'));
        keysym2UCSHash.put(1959L, Character.valueOf('\u038c'));
        keysym2UCSHash.put(1960L, Character.valueOf('\u038e'));
        keysym2UCSHash.put(1961L, Character.valueOf('\u03ab'));
        keysym2UCSHash.put(1963L, Character.valueOf('\u038f'));
        keysym2UCSHash.put(1966L, Character.valueOf('\u0385'));
        keysym2UCSHash.put(1967L, Character.valueOf('\u2015'));
        keysym2UCSHash.put(1969L, Character.valueOf('\u03ac'));
        keysym2UCSHash.put(1970L, Character.valueOf('\u03ad'));
        keysym2UCSHash.put(1971L, Character.valueOf('\u03ae'));
        keysym2UCSHash.put(1972L, Character.valueOf('\u03af'));
        keysym2UCSHash.put(1973L, Character.valueOf('\u03ca'));
        keysym2UCSHash.put(1974L, Character.valueOf('\u0390'));
        keysym2UCSHash.put(1975L, Character.valueOf('\u03cc'));
        keysym2UCSHash.put(1976L, Character.valueOf('\u03cd'));
        keysym2UCSHash.put(1977L, Character.valueOf('\u03cb'));
        keysym2UCSHash.put(1978L, Character.valueOf('\u03b0'));
        keysym2UCSHash.put(1979L, Character.valueOf('\u03ce'));
        keysym2UCSHash.put(1985L, Character.valueOf('\u0391'));
        keysym2UCSHash.put(1986L, Character.valueOf('\u0392'));
        keysym2UCSHash.put(1987L, Character.valueOf('\u0393'));
        keysym2UCSHash.put(1988L, Character.valueOf('\u0394'));
        keysym2UCSHash.put(1989L, Character.valueOf('\u0395'));
        keysym2UCSHash.put(1990L, Character.valueOf('\u0396'));
        keysym2UCSHash.put(1991L, Character.valueOf('\u0397'));
        keysym2UCSHash.put(1992L, Character.valueOf('\u0398'));
        keysym2UCSHash.put(1993L, Character.valueOf('\u0399'));
        keysym2UCSHash.put(1994L, Character.valueOf('\u039a'));
        keysym2UCSHash.put(1995L, Character.valueOf('\u039b'));
        keysym2UCSHash.put(1996L, Character.valueOf('\u039c'));
        keysym2UCSHash.put(1997L, Character.valueOf('\u039d'));
        keysym2UCSHash.put(1998L, Character.valueOf('\u039e'));
        keysym2UCSHash.put(1999L, Character.valueOf('\u039f'));
        keysym2UCSHash.put(2000L, Character.valueOf('\u03a0'));
        keysym2UCSHash.put(2001L, Character.valueOf('\u03a1'));
        keysym2UCSHash.put(2002L, Character.valueOf('\u03a3'));
        keysym2UCSHash.put(2004L, Character.valueOf('\u03a4'));
        keysym2UCSHash.put(2005L, Character.valueOf('\u03a5'));
        keysym2UCSHash.put(2006L, Character.valueOf('\u03a6'));
        keysym2UCSHash.put(2007L, Character.valueOf('\u03a7'));
        keysym2UCSHash.put(2008L, Character.valueOf('\u03a8'));
        keysym2UCSHash.put(2009L, Character.valueOf('\u03a9'));
        keysym2UCSHash.put(2017L, Character.valueOf('\u03b1'));
        keysym2UCSHash.put(2018L, Character.valueOf('\u03b2'));
        keysym2UCSHash.put(2019L, Character.valueOf('\u03b3'));
        keysym2UCSHash.put(2020L, Character.valueOf('\u03b4'));
        keysym2UCSHash.put(2021L, Character.valueOf('\u03b5'));
        keysym2UCSHash.put(2022L, Character.valueOf('\u03b6'));
        keysym2UCSHash.put(2023L, Character.valueOf('\u03b7'));
        keysym2UCSHash.put(2024L, Character.valueOf('\u03b8'));
        keysym2UCSHash.put(2025L, Character.valueOf('\u03b9'));
        keysym2UCSHash.put(2026L, Character.valueOf('\u03ba'));
        keysym2UCSHash.put(2027L, Character.valueOf('\u03bb'));
        keysym2UCSHash.put(2028L, Character.valueOf('\u03bc'));
        keysym2UCSHash.put(2029L, Character.valueOf('\u03bd'));
        keysym2UCSHash.put(2030L, Character.valueOf('\u03be'));
        keysym2UCSHash.put(2031L, Character.valueOf('\u03bf'));
        keysym2UCSHash.put(2032L, Character.valueOf('\u03c0'));
        keysym2UCSHash.put(2033L, Character.valueOf('\u03c1'));
        keysym2UCSHash.put(2034L, Character.valueOf('\u03c3'));
        keysym2UCSHash.put(2035L, Character.valueOf('\u03c2'));
        keysym2UCSHash.put(2036L, Character.valueOf('\u03c4'));
        keysym2UCSHash.put(2037L, Character.valueOf('\u03c5'));
        keysym2UCSHash.put(2038L, Character.valueOf('\u03c6'));
        keysym2UCSHash.put(2039L, Character.valueOf('\u03c7'));
        keysym2UCSHash.put(2040L, Character.valueOf('\u03c8'));
        keysym2UCSHash.put(2041L, Character.valueOf('\u03c9'));
        keysym2UCSHash.put(2209L, Character.valueOf('\u23b7'));
        keysym2UCSHash.put(2210L, Character.valueOf('\u250c'));
        keysym2UCSHash.put(2211L, Character.valueOf('\u2500'));
        keysym2UCSHash.put(2212L, Character.valueOf('\u2320'));
        keysym2UCSHash.put(2213L, Character.valueOf('\u2321'));
        keysym2UCSHash.put(2214L, Character.valueOf('\u2502'));
        keysym2UCSHash.put(2215L, Character.valueOf('\u23a1'));
        keysym2UCSHash.put(2216L, Character.valueOf('\u23a3'));
        keysym2UCSHash.put(2217L, Character.valueOf('\u23a4'));
        keysym2UCSHash.put(2218L, Character.valueOf('\u23a6'));
        keysym2UCSHash.put(2219L, Character.valueOf('\u239b'));
        keysym2UCSHash.put(2220L, Character.valueOf('\u239d'));
        keysym2UCSHash.put(2221L, Character.valueOf('\u239e'));
        keysym2UCSHash.put(2222L, Character.valueOf('\u23a0'));
        keysym2UCSHash.put(2223L, Character.valueOf('\u23a8'));
        keysym2UCSHash.put(2224L, Character.valueOf('\u23ac'));
        keysym2UCSHash.put(2236L, Character.valueOf('\u2264'));
        keysym2UCSHash.put(2237L, Character.valueOf('\u2260'));
        keysym2UCSHash.put(2238L, Character.valueOf('\u2265'));
        keysym2UCSHash.put(2239L, Character.valueOf('\u222b'));
        keysym2UCSHash.put(2240L, Character.valueOf('\u2234'));
        keysym2UCSHash.put(2241L, Character.valueOf('\u221d'));
        keysym2UCSHash.put(2242L, Character.valueOf('\u221e'));
        keysym2UCSHash.put(2245L, Character.valueOf('\u2207'));
        keysym2UCSHash.put(2248L, Character.valueOf('\u223c'));
        keysym2UCSHash.put(2249L, Character.valueOf('\u2243'));
        keysym2UCSHash.put(2253L, Character.valueOf('\u2104'));
        keysym2UCSHash.put(2254L, Character.valueOf('\u21d2'));
        keysym2UCSHash.put(2255L, Character.valueOf('\u2261'));
        keysym2UCSHash.put(2262L, Character.valueOf('\u221a'));
        keysym2UCSHash.put(2266L, Character.valueOf('\u2282'));
        keysym2UCSHash.put(2267L, Character.valueOf('\u2283'));
        keysym2UCSHash.put(2268L, Character.valueOf('\u2229'));
        keysym2UCSHash.put(2269L, Character.valueOf('\u222a'));
        keysym2UCSHash.put(2270L, Character.valueOf('\u2227'));
        keysym2UCSHash.put(2271L, Character.valueOf('\u2228'));
        keysym2UCSHash.put(2287L, Character.valueOf('\u2202'));
        keysym2UCSHash.put(2294L, Character.valueOf('\u0192'));
        keysym2UCSHash.put(2299L, Character.valueOf('\u2190'));
        keysym2UCSHash.put(2300L, Character.valueOf('\u2191'));
        keysym2UCSHash.put(2301L, Character.valueOf('\u2192'));
        keysym2UCSHash.put(2302L, Character.valueOf('\u2193'));
        keysym2UCSHash.put(2528L, Character.valueOf('\u25c6'));
        keysym2UCSHash.put(2529L, Character.valueOf('\u2592'));
        keysym2UCSHash.put(2530L, Character.valueOf('\u2409'));
        keysym2UCSHash.put(2531L, Character.valueOf('\u240c'));
        keysym2UCSHash.put(2532L, Character.valueOf('\u240d'));
        keysym2UCSHash.put(2533L, Character.valueOf('\u240a'));
        keysym2UCSHash.put(2536L, Character.valueOf('\u2424'));
        keysym2UCSHash.put(2537L, Character.valueOf('\u240b'));
        keysym2UCSHash.put(2538L, Character.valueOf('\u2518'));
        keysym2UCSHash.put(2539L, Character.valueOf('\u2510'));
        keysym2UCSHash.put(2540L, Character.valueOf('\u250c'));
        keysym2UCSHash.put(2541L, Character.valueOf('\u2514'));
        keysym2UCSHash.put(2542L, Character.valueOf('\u253c'));
        keysym2UCSHash.put(2543L, Character.valueOf('\u23ba'));
        keysym2UCSHash.put(2544L, Character.valueOf('\u23bb'));
        keysym2UCSHash.put(2545L, Character.valueOf('\u2500'));
        keysym2UCSHash.put(2546L, Character.valueOf('\u23bc'));
        keysym2UCSHash.put(2547L, Character.valueOf('\u23bd'));
        keysym2UCSHash.put(2548L, Character.valueOf('\u251c'));
        keysym2UCSHash.put(2549L, Character.valueOf('\u2524'));
        keysym2UCSHash.put(2550L, Character.valueOf('\u2534'));
        keysym2UCSHash.put(2551L, Character.valueOf('\u242c'));
        keysym2UCSHash.put(2552L, Character.valueOf('\u2502'));
        keysym2UCSHash.put(2721L, Character.valueOf('\u2003'));
        keysym2UCSHash.put(2722L, Character.valueOf('\u2002'));
        keysym2UCSHash.put(2723L, Character.valueOf('\u2004'));
        keysym2UCSHash.put(2724L, Character.valueOf('\u2005'));
        keysym2UCSHash.put(2725L, Character.valueOf('\u2007'));
        keysym2UCSHash.put(2726L, Character.valueOf('\u2008'));
        keysym2UCSHash.put(2727L, Character.valueOf('\u2009'));
        keysym2UCSHash.put(2728L, Character.valueOf('\u200a'));
        keysym2UCSHash.put(2729L, Character.valueOf('\u2014'));
        keysym2UCSHash.put(2730L, Character.valueOf('\u2013'));
        keysym2UCSHash.put(2732L, Character.valueOf('\u2423'));
        keysym2UCSHash.put(2734L, Character.valueOf('\u2026'));
        keysym2UCSHash.put(2735L, Character.valueOf('\u2025'));
        keysym2UCSHash.put(2736L, Character.valueOf('\u2153'));
        keysym2UCSHash.put(2737L, Character.valueOf('\u2154'));
        keysym2UCSHash.put(2738L, Character.valueOf('\u2155'));
        keysym2UCSHash.put(2739L, Character.valueOf('\u2156'));
        keysym2UCSHash.put(2740L, Character.valueOf('\u2157'));
        keysym2UCSHash.put(2741L, Character.valueOf('\u2158'));
        keysym2UCSHash.put(2742L, Character.valueOf('\u2159'));
        keysym2UCSHash.put(2743L, Character.valueOf('\u215a'));
        keysym2UCSHash.put(2744L, Character.valueOf('\u2105'));
        keysym2UCSHash.put(2747L, Character.valueOf('\u2012'));
        keysym2UCSHash.put(2748L, Character.valueOf('\u27e8'));
        keysym2UCSHash.put(2749L, Character.valueOf('.'));
        keysym2UCSHash.put(2750L, Character.valueOf('\u27e9'));
        keysym2UCSHash.put(2755L, Character.valueOf('\u215b'));
        keysym2UCSHash.put(2756L, Character.valueOf('\u215c'));
        keysym2UCSHash.put(2757L, Character.valueOf('\u215d'));
        keysym2UCSHash.put(2758L, Character.valueOf('\u215e'));
        keysym2UCSHash.put(2761L, Character.valueOf('\u2122'));
        keysym2UCSHash.put(2762L, Character.valueOf('\u2613'));
        keysym2UCSHash.put(2764L, Character.valueOf('\u25c1'));
        keysym2UCSHash.put(2765L, Character.valueOf('\u25b7'));
        keysym2UCSHash.put(2766L, Character.valueOf('\u25cb'));
        keysym2UCSHash.put(2767L, Character.valueOf('\u25af'));
        keysym2UCSHash.put(2768L, Character.valueOf('\u2018'));
        keysym2UCSHash.put(2769L, Character.valueOf('\u2019'));
        keysym2UCSHash.put(2770L, Character.valueOf('\u201c'));
        keysym2UCSHash.put(2771L, Character.valueOf('\u201d'));
        keysym2UCSHash.put(2772L, Character.valueOf('\u211e'));
        keysym2UCSHash.put(2774L, Character.valueOf('\u2032'));
        keysym2UCSHash.put(2775L, Character.valueOf('\u2033'));
        keysym2UCSHash.put(2777L, Character.valueOf('\u271d'));
        keysym2UCSHash.put(2779L, Character.valueOf('\u25ac'));
        keysym2UCSHash.put(2780L, Character.valueOf('\u25c0'));
        keysym2UCSHash.put(2781L, Character.valueOf('\u25b6'));
        keysym2UCSHash.put(2782L, Character.valueOf('\u25cf'));
        keysym2UCSHash.put(2783L, Character.valueOf('\u25ae'));
        keysym2UCSHash.put(2784L, Character.valueOf('\u25e6'));
        keysym2UCSHash.put(2785L, Character.valueOf('\u25ab'));
        keysym2UCSHash.put(2786L, Character.valueOf('\u25ad'));
        keysym2UCSHash.put(2787L, Character.valueOf('\u25b3'));
        keysym2UCSHash.put(2788L, Character.valueOf('\u25bd'));
        keysym2UCSHash.put(2789L, Character.valueOf('\u2606'));
        keysym2UCSHash.put(2790L, Character.valueOf('\u2022'));
        keysym2UCSHash.put(2791L, Character.valueOf('\u25aa'));
        keysym2UCSHash.put(2792L, Character.valueOf('\u25b2'));
        keysym2UCSHash.put(2793L, Character.valueOf('\u25bc'));
        keysym2UCSHash.put(2794L, Character.valueOf('\u261c'));
        keysym2UCSHash.put(2795L, Character.valueOf('\u261e'));
        keysym2UCSHash.put(2796L, Character.valueOf('\u2663'));
        keysym2UCSHash.put(2797L, Character.valueOf('\u2666'));
        keysym2UCSHash.put(2798L, Character.valueOf('\u2665'));
        keysym2UCSHash.put(2800L, Character.valueOf('\u2720'));
        keysym2UCSHash.put(2801L, Character.valueOf('\u2020'));
        keysym2UCSHash.put(2802L, Character.valueOf('\u2021'));
        keysym2UCSHash.put(2803L, Character.valueOf('\u2713'));
        keysym2UCSHash.put(2804L, Character.valueOf('\u2717'));
        keysym2UCSHash.put(2805L, Character.valueOf('\u266f'));
        keysym2UCSHash.put(2806L, Character.valueOf('\u266d'));
        keysym2UCSHash.put(2807L, Character.valueOf('\u2642'));
        keysym2UCSHash.put(2808L, Character.valueOf('\u2640'));
        keysym2UCSHash.put(2809L, Character.valueOf('\u260e'));
        keysym2UCSHash.put(2810L, Character.valueOf('\u2315'));
        keysym2UCSHash.put(2811L, Character.valueOf('\u2117'));
        keysym2UCSHash.put(2812L, Character.valueOf('\u2038'));
        keysym2UCSHash.put(2813L, Character.valueOf('\u201a'));
        keysym2UCSHash.put(2814L, Character.valueOf('\u201e'));
        keysym2UCSHash.put(2979L, Character.valueOf('<'));
        keysym2UCSHash.put(2982L, Character.valueOf('>'));
        keysym2UCSHash.put(2984L, Character.valueOf('\u2228'));
        keysym2UCSHash.put(2985L, Character.valueOf('\u2227'));
        keysym2UCSHash.put(3008L, Character.valueOf('\u00af'));
        keysym2UCSHash.put(3010L, Character.valueOf('\u22a5'));
        keysym2UCSHash.put(3011L, Character.valueOf('\u2229'));
        keysym2UCSHash.put(3012L, Character.valueOf('\u230a'));
        keysym2UCSHash.put(3014L, Character.valueOf('_'));
        keysym2UCSHash.put(3018L, Character.valueOf('\u2218'));
        keysym2UCSHash.put(3020L, Character.valueOf('\u2395'));
        keysym2UCSHash.put(3022L, Character.valueOf('\u22a4'));
        keysym2UCSHash.put(3023L, Character.valueOf('\u25cb'));
        keysym2UCSHash.put(3027L, Character.valueOf('\u2308'));
        keysym2UCSHash.put(3030L, Character.valueOf('\u222a'));
        keysym2UCSHash.put(3032L, Character.valueOf('\u2283'));
        keysym2UCSHash.put(3034L, Character.valueOf('\u2282'));
        keysym2UCSHash.put(3036L, Character.valueOf('\u22a2'));
        keysym2UCSHash.put(3068L, Character.valueOf('\u22a3'));
        keysym2UCSHash.put(3295L, Character.valueOf('\u2017'));
        keysym2UCSHash.put(3296L, Character.valueOf('\u05d0'));
        keysym2UCSHash.put(3297L, Character.valueOf('\u05d1'));
        keysym2UCSHash.put(3298L, Character.valueOf('\u05d2'));
        keysym2UCSHash.put(3299L, Character.valueOf('\u05d3'));
        keysym2UCSHash.put(3300L, Character.valueOf('\u05d4'));
        keysym2UCSHash.put(3301L, Character.valueOf('\u05d5'));
        keysym2UCSHash.put(3302L, Character.valueOf('\u05d6'));
        keysym2UCSHash.put(3303L, Character.valueOf('\u05d7'));
        keysym2UCSHash.put(3304L, Character.valueOf('\u05d8'));
        keysym2UCSHash.put(3305L, Character.valueOf('\u05d9'));
        keysym2UCSHash.put(3306L, Character.valueOf('\u05da'));
        keysym2UCSHash.put(3307L, Character.valueOf('\u05db'));
        keysym2UCSHash.put(3308L, Character.valueOf('\u05dc'));
        keysym2UCSHash.put(3309L, Character.valueOf('\u05dd'));
        keysym2UCSHash.put(3310L, Character.valueOf('\u05de'));
        keysym2UCSHash.put(3311L, Character.valueOf('\u05df'));
        keysym2UCSHash.put(3312L, Character.valueOf('\u05e0'));
        keysym2UCSHash.put(3313L, Character.valueOf('\u05e1'));
        keysym2UCSHash.put(3314L, Character.valueOf('\u05e2'));
        keysym2UCSHash.put(3315L, Character.valueOf('\u05e3'));
        keysym2UCSHash.put(3316L, Character.valueOf('\u05e4'));
        keysym2UCSHash.put(3317L, Character.valueOf('\u05e5'));
        keysym2UCSHash.put(3318L, Character.valueOf('\u05e6'));
        keysym2UCSHash.put(3319L, Character.valueOf('\u05e7'));
        keysym2UCSHash.put(3320L, Character.valueOf('\u05e8'));
        keysym2UCSHash.put(3321L, Character.valueOf('\u05e9'));
        keysym2UCSHash.put(3322L, Character.valueOf('\u05ea'));
        keysym2UCSHash.put(3489L, Character.valueOf('\u0e01'));
        keysym2UCSHash.put(3490L, Character.valueOf('\u0e02'));
        keysym2UCSHash.put(3491L, Character.valueOf('\u0e03'));
        keysym2UCSHash.put(3492L, Character.valueOf('\u0e04'));
        keysym2UCSHash.put(3493L, Character.valueOf('\u0e05'));
        keysym2UCSHash.put(3494L, Character.valueOf('\u0e06'));
        keysym2UCSHash.put(3495L, Character.valueOf('\u0e07'));
        keysym2UCSHash.put(3496L, Character.valueOf('\u0e08'));
        keysym2UCSHash.put(3497L, Character.valueOf('\u0e09'));
        keysym2UCSHash.put(3498L, Character.valueOf('\u0e0a'));
        keysym2UCSHash.put(3499L, Character.valueOf('\u0e0b'));
        keysym2UCSHash.put(3500L, Character.valueOf('\u0e0c'));
        keysym2UCSHash.put(3501L, Character.valueOf('\u0e0d'));
        keysym2UCSHash.put(3502L, Character.valueOf('\u0e0e'));
        keysym2UCSHash.put(3503L, Character.valueOf('\u0e0f'));
        keysym2UCSHash.put(3504L, Character.valueOf('\u0e10'));
        keysym2UCSHash.put(3505L, Character.valueOf('\u0e11'));
        keysym2UCSHash.put(3506L, Character.valueOf('\u0e12'));
        keysym2UCSHash.put(3507L, Character.valueOf('\u0e13'));
        keysym2UCSHash.put(3508L, Character.valueOf('\u0e14'));
        keysym2UCSHash.put(3509L, Character.valueOf('\u0e15'));
        keysym2UCSHash.put(3510L, Character.valueOf('\u0e16'));
        keysym2UCSHash.put(3511L, Character.valueOf('\u0e17'));
        keysym2UCSHash.put(3512L, Character.valueOf('\u0e18'));
        keysym2UCSHash.put(3513L, Character.valueOf('\u0e19'));
        keysym2UCSHash.put(3514L, Character.valueOf('\u0e1a'));
        keysym2UCSHash.put(3515L, Character.valueOf('\u0e1b'));
        keysym2UCSHash.put(3516L, Character.valueOf('\u0e1c'));
        keysym2UCSHash.put(3517L, Character.valueOf('\u0e1d'));
        keysym2UCSHash.put(3518L, Character.valueOf('\u0e1e'));
        keysym2UCSHash.put(3519L, Character.valueOf('\u0e1f'));
        keysym2UCSHash.put(3520L, Character.valueOf('\u0e20'));
        keysym2UCSHash.put(3521L, Character.valueOf('\u0e21'));
        keysym2UCSHash.put(3522L, Character.valueOf('\u0e22'));
        keysym2UCSHash.put(3523L, Character.valueOf('\u0e23'));
        keysym2UCSHash.put(3524L, Character.valueOf('\u0e24'));
        keysym2UCSHash.put(3525L, Character.valueOf('\u0e25'));
        keysym2UCSHash.put(3526L, Character.valueOf('\u0e26'));
        keysym2UCSHash.put(3527L, Character.valueOf('\u0e27'));
        keysym2UCSHash.put(3528L, Character.valueOf('\u0e28'));
        keysym2UCSHash.put(3529L, Character.valueOf('\u0e29'));
        keysym2UCSHash.put(3530L, Character.valueOf('\u0e2a'));
        keysym2UCSHash.put(3531L, Character.valueOf('\u0e2b'));
        keysym2UCSHash.put(3532L, Character.valueOf('\u0e2c'));
        keysym2UCSHash.put(3533L, Character.valueOf('\u0e2d'));
        keysym2UCSHash.put(3534L, Character.valueOf('\u0e2e'));
        keysym2UCSHash.put(3535L, Character.valueOf('\u0e2f'));
        keysym2UCSHash.put(3536L, Character.valueOf('\u0e30'));
        keysym2UCSHash.put(3537L, Character.valueOf('\u0e31'));
        keysym2UCSHash.put(3538L, Character.valueOf('\u0e32'));
        keysym2UCSHash.put(3539L, Character.valueOf('\u0e33'));
        keysym2UCSHash.put(3540L, Character.valueOf('\u0e34'));
        keysym2UCSHash.put(3541L, Character.valueOf('\u0e35'));
        keysym2UCSHash.put(3542L, Character.valueOf('\u0e36'));
        keysym2UCSHash.put(3543L, Character.valueOf('\u0e37'));
        keysym2UCSHash.put(3544L, Character.valueOf('\u0e38'));
        keysym2UCSHash.put(3545L, Character.valueOf('\u0e39'));
        keysym2UCSHash.put(3546L, Character.valueOf('\u0e3a'));
        keysym2UCSHash.put(3551L, Character.valueOf('\u0e3f'));
        keysym2UCSHash.put(3552L, Character.valueOf('\u0e40'));
        keysym2UCSHash.put(3553L, Character.valueOf('\u0e41'));
        keysym2UCSHash.put(3554L, Character.valueOf('\u0e42'));
        keysym2UCSHash.put(3555L, Character.valueOf('\u0e43'));
        keysym2UCSHash.put(3556L, Character.valueOf('\u0e44'));
        keysym2UCSHash.put(3557L, Character.valueOf('\u0e45'));
        keysym2UCSHash.put(3558L, Character.valueOf('\u0e46'));
        keysym2UCSHash.put(3559L, Character.valueOf('\u0e47'));
        keysym2UCSHash.put(3560L, Character.valueOf('\u0e48'));
        keysym2UCSHash.put(3561L, Character.valueOf('\u0e49'));
        keysym2UCSHash.put(3562L, Character.valueOf('\u0e4a'));
        keysym2UCSHash.put(3563L, Character.valueOf('\u0e4b'));
        keysym2UCSHash.put(3564L, Character.valueOf('\u0e4c'));
        keysym2UCSHash.put(3565L, Character.valueOf('\u0e4d'));
        keysym2UCSHash.put(3568L, Character.valueOf('\u0e50'));
        keysym2UCSHash.put(3569L, Character.valueOf('\u0e51'));
        keysym2UCSHash.put(3570L, Character.valueOf('\u0e52'));
        keysym2UCSHash.put(3571L, Character.valueOf('\u0e53'));
        keysym2UCSHash.put(3572L, Character.valueOf('\u0e54'));
        keysym2UCSHash.put(3573L, Character.valueOf('\u0e55'));
        keysym2UCSHash.put(3574L, Character.valueOf('\u0e56'));
        keysym2UCSHash.put(3575L, Character.valueOf('\u0e57'));
        keysym2UCSHash.put(3576L, Character.valueOf('\u0e58'));
        keysym2UCSHash.put(3577L, Character.valueOf('\u0e59'));
        keysym2UCSHash.put(3745L, Character.valueOf('\u3131'));
        keysym2UCSHash.put(3746L, Character.valueOf('\u3132'));
        keysym2UCSHash.put(3747L, Character.valueOf('\u3133'));
        keysym2UCSHash.put(3748L, Character.valueOf('\u3134'));
        keysym2UCSHash.put(3749L, Character.valueOf('\u3135'));
        keysym2UCSHash.put(3750L, Character.valueOf('\u3136'));
        keysym2UCSHash.put(3751L, Character.valueOf('\u3137'));
        keysym2UCSHash.put(3752L, Character.valueOf('\u3138'));
        keysym2UCSHash.put(3753L, Character.valueOf('\u3139'));
        keysym2UCSHash.put(3754L, Character.valueOf('\u313a'));
        keysym2UCSHash.put(3755L, Character.valueOf('\u313b'));
        keysym2UCSHash.put(3756L, Character.valueOf('\u313c'));
        keysym2UCSHash.put(3757L, Character.valueOf('\u313d'));
        keysym2UCSHash.put(3758L, Character.valueOf('\u313e'));
        keysym2UCSHash.put(3759L, Character.valueOf('\u313f'));
        keysym2UCSHash.put(3760L, Character.valueOf('\u3140'));
        keysym2UCSHash.put(3761L, Character.valueOf('\u3141'));
        keysym2UCSHash.put(3762L, Character.valueOf('\u3142'));
        keysym2UCSHash.put(3763L, Character.valueOf('\u3143'));
        keysym2UCSHash.put(3764L, Character.valueOf('\u3144'));
        keysym2UCSHash.put(3765L, Character.valueOf('\u3145'));
        keysym2UCSHash.put(3766L, Character.valueOf('\u3146'));
        keysym2UCSHash.put(3767L, Character.valueOf('\u3147'));
        keysym2UCSHash.put(3768L, Character.valueOf('\u3148'));
        keysym2UCSHash.put(3769L, Character.valueOf('\u3149'));
        keysym2UCSHash.put(3770L, Character.valueOf('\u314a'));
        keysym2UCSHash.put(3771L, Character.valueOf('\u314b'));
        keysym2UCSHash.put(3772L, Character.valueOf('\u314c'));
        keysym2UCSHash.put(3773L, Character.valueOf('\u314d'));
        keysym2UCSHash.put(3774L, Character.valueOf('\u314e'));
        keysym2UCSHash.put(3775L, Character.valueOf('\u314f'));
        keysym2UCSHash.put(3776L, Character.valueOf('\u3150'));
        keysym2UCSHash.put(3777L, Character.valueOf('\u3151'));
        keysym2UCSHash.put(3778L, Character.valueOf('\u3152'));
        keysym2UCSHash.put(3779L, Character.valueOf('\u3153'));
        keysym2UCSHash.put(3780L, Character.valueOf('\u3154'));
        keysym2UCSHash.put(3781L, Character.valueOf('\u3155'));
        keysym2UCSHash.put(3782L, Character.valueOf('\u3156'));
        keysym2UCSHash.put(3783L, Character.valueOf('\u3157'));
        keysym2UCSHash.put(3784L, Character.valueOf('\u3158'));
        keysym2UCSHash.put(3785L, Character.valueOf('\u3159'));
        keysym2UCSHash.put(3786L, Character.valueOf('\u315a'));
        keysym2UCSHash.put(3787L, Character.valueOf('\u315b'));
        keysym2UCSHash.put(3788L, Character.valueOf('\u315c'));
        keysym2UCSHash.put(3789L, Character.valueOf('\u315d'));
        keysym2UCSHash.put(3790L, Character.valueOf('\u315e'));
        keysym2UCSHash.put(3791L, Character.valueOf('\u315f'));
        keysym2UCSHash.put(3792L, Character.valueOf('\u3160'));
        keysym2UCSHash.put(3793L, Character.valueOf('\u3161'));
        keysym2UCSHash.put(3794L, Character.valueOf('\u3162'));
        keysym2UCSHash.put(3795L, Character.valueOf('\u3163'));
        keysym2UCSHash.put(3796L, Character.valueOf('\u11a8'));
        keysym2UCSHash.put(3797L, Character.valueOf('\u11a9'));
        keysym2UCSHash.put(3798L, Character.valueOf('\u11aa'));
        keysym2UCSHash.put(3799L, Character.valueOf('\u11ab'));
        keysym2UCSHash.put(3800L, Character.valueOf('\u11ac'));
        keysym2UCSHash.put(3801L, Character.valueOf('\u11ad'));
        keysym2UCSHash.put(3802L, Character.valueOf('\u11ae'));
        keysym2UCSHash.put(3803L, Character.valueOf('\u11af'));
        keysym2UCSHash.put(3804L, Character.valueOf('\u11b0'));
        keysym2UCSHash.put(3805L, Character.valueOf('\u11b1'));
        keysym2UCSHash.put(3806L, Character.valueOf('\u11b2'));
        keysym2UCSHash.put(3807L, Character.valueOf('\u11b3'));
        keysym2UCSHash.put(3808L, Character.valueOf('\u11b4'));
        keysym2UCSHash.put(3809L, Character.valueOf('\u11b5'));
        keysym2UCSHash.put(3810L, Character.valueOf('\u11b6'));
        keysym2UCSHash.put(3811L, Character.valueOf('\u11b7'));
        keysym2UCSHash.put(3812L, Character.valueOf('\u11b8'));
        keysym2UCSHash.put(3813L, Character.valueOf('\u11b9'));
        keysym2UCSHash.put(3814L, Character.valueOf('\u11ba'));
        keysym2UCSHash.put(3815L, Character.valueOf('\u11bb'));
        keysym2UCSHash.put(3816L, Character.valueOf('\u11bc'));
        keysym2UCSHash.put(3817L, Character.valueOf('\u11bd'));
        keysym2UCSHash.put(3818L, Character.valueOf('\u11be'));
        keysym2UCSHash.put(3819L, Character.valueOf('\u11bf'));
        keysym2UCSHash.put(3820L, Character.valueOf('\u11c0'));
        keysym2UCSHash.put(3821L, Character.valueOf('\u11c1'));
        keysym2UCSHash.put(3822L, Character.valueOf('\u11c2'));
        keysym2UCSHash.put(3823L, Character.valueOf('\u316d'));
        keysym2UCSHash.put(3824L, Character.valueOf('\u3171'));
        keysym2UCSHash.put(3825L, Character.valueOf('\u3178'));
        keysym2UCSHash.put(3826L, Character.valueOf('\u317f'));
        keysym2UCSHash.put(3827L, Character.valueOf('\u3181'));
        keysym2UCSHash.put(3828L, Character.valueOf('\u3184'));
        keysym2UCSHash.put(3829L, Character.valueOf('\u3186'));
        keysym2UCSHash.put(3830L, Character.valueOf('\u318d'));
        keysym2UCSHash.put(3831L, Character.valueOf('\u318e'));
        keysym2UCSHash.put(3832L, Character.valueOf('\u11eb'));
        keysym2UCSHash.put(3833L, Character.valueOf('\u11f0'));
        keysym2UCSHash.put(3834L, Character.valueOf('\u11f9'));
        keysym2UCSHash.put(3839L, Character.valueOf('\u20a9'));
        keysym2UCSHash.put(5795L, Character.valueOf('\u1e8a'));
        keysym2UCSHash.put(5798L, Character.valueOf('\u012c'));
        keysym2UCSHash.put(5801L, Character.valueOf('\u01b5'));
        keysym2UCSHash.put(5802L, Character.valueOf('\u01e6'));
        keysym2UCSHash.put(5807L, Character.valueOf('\u019f'));
        keysym2UCSHash.put(5811L, Character.valueOf('\u1e8b'));
        keysym2UCSHash.put(5814L, Character.valueOf('\u012d'));
        keysym2UCSHash.put(5817L, Character.valueOf('\u01b6'));
        keysym2UCSHash.put(5818L, Character.valueOf('\u01e7'));
        keysym2UCSHash.put(5821L, Character.valueOf('\u01d2'));
        keysym2UCSHash.put(5823L, Character.valueOf('\u0275'));
        keysym2UCSHash.put(5830L, Character.valueOf('\u018f'));
        keysym2UCSHash.put(5878L, Character.valueOf('\u0259'));
        keysym2UCSHash.put(7840L, Character.valueOf('\u1ea0'));
        keysym2UCSHash.put(7841L, Character.valueOf('\u1ea1'));
        keysym2UCSHash.put(7842L, Character.valueOf('\u1ea2'));
        keysym2UCSHash.put(7843L, Character.valueOf('\u1ea3'));
        keysym2UCSHash.put(7844L, Character.valueOf('\u1ea4'));
        keysym2UCSHash.put(7845L, Character.valueOf('\u1ea5'));
        keysym2UCSHash.put(7846L, Character.valueOf('\u1ea6'));
        keysym2UCSHash.put(7847L, Character.valueOf('\u1ea7'));
        keysym2UCSHash.put(7848L, Character.valueOf('\u1ea8'));
        keysym2UCSHash.put(7849L, Character.valueOf('\u1ea9'));
        keysym2UCSHash.put(7850L, Character.valueOf('\u1eaa'));
        keysym2UCSHash.put(7851L, Character.valueOf('\u1eab'));
        keysym2UCSHash.put(7852L, Character.valueOf('\u1eac'));
        keysym2UCSHash.put(7853L, Character.valueOf('\u1ead'));
        keysym2UCSHash.put(7854L, Character.valueOf('\u1eae'));
        keysym2UCSHash.put(7855L, Character.valueOf('\u1eaf'));
        keysym2UCSHash.put(7856L, Character.valueOf('\u1eb0'));
        keysym2UCSHash.put(7857L, Character.valueOf('\u1eb1'));
        keysym2UCSHash.put(7858L, Character.valueOf('\u1eb2'));
        keysym2UCSHash.put(7859L, Character.valueOf('\u1eb3'));
        keysym2UCSHash.put(7860L, Character.valueOf('\u1eb4'));
        keysym2UCSHash.put(7861L, Character.valueOf('\u1eb5'));
        keysym2UCSHash.put(7862L, Character.valueOf('\u1eb6'));
        keysym2UCSHash.put(7863L, Character.valueOf('\u1eb7'));
        keysym2UCSHash.put(7864L, Character.valueOf('\u1eb8'));
        keysym2UCSHash.put(7865L, Character.valueOf('\u1eb9'));
        keysym2UCSHash.put(7866L, Character.valueOf('\u1eba'));
        keysym2UCSHash.put(7867L, Character.valueOf('\u1ebb'));
        keysym2UCSHash.put(7868L, Character.valueOf('\u1ebc'));
        keysym2UCSHash.put(7869L, Character.valueOf('\u1ebd'));
        keysym2UCSHash.put(7870L, Character.valueOf('\u1ebe'));
        keysym2UCSHash.put(7871L, Character.valueOf('\u1ebf'));
        keysym2UCSHash.put(7872L, Character.valueOf('\u1ec0'));
        keysym2UCSHash.put(7873L, Character.valueOf('\u1ec1'));
        keysym2UCSHash.put(7874L, Character.valueOf('\u1ec2'));
        keysym2UCSHash.put(7875L, Character.valueOf('\u1ec3'));
        keysym2UCSHash.put(7876L, Character.valueOf('\u1ec4'));
        keysym2UCSHash.put(7877L, Character.valueOf('\u1ec5'));
        keysym2UCSHash.put(7878L, Character.valueOf('\u1ec6'));
        keysym2UCSHash.put(7879L, Character.valueOf('\u1ec7'));
        keysym2UCSHash.put(7880L, Character.valueOf('\u1ec8'));
        keysym2UCSHash.put(7881L, Character.valueOf('\u1ec9'));
        keysym2UCSHash.put(7882L, Character.valueOf('\u1eca'));
        keysym2UCSHash.put(7883L, Character.valueOf('\u1ecb'));
        keysym2UCSHash.put(7884L, Character.valueOf('\u1ecc'));
        keysym2UCSHash.put(7885L, Character.valueOf('\u1ecd'));
        keysym2UCSHash.put(7886L, Character.valueOf('\u1ece'));
        keysym2UCSHash.put(7887L, Character.valueOf('\u1ecf'));
        keysym2UCSHash.put(7888L, Character.valueOf('\u1ed0'));
        keysym2UCSHash.put(7889L, Character.valueOf('\u1ed1'));
        keysym2UCSHash.put(7890L, Character.valueOf('\u1ed2'));
        keysym2UCSHash.put(7891L, Character.valueOf('\u1ed3'));
        keysym2UCSHash.put(7892L, Character.valueOf('\u1ed4'));
        keysym2UCSHash.put(7893L, Character.valueOf('\u1ed5'));
        keysym2UCSHash.put(7894L, Character.valueOf('\u1ed6'));
        keysym2UCSHash.put(7895L, Character.valueOf('\u1ed7'));
        keysym2UCSHash.put(7896L, Character.valueOf('\u1ed8'));
        keysym2UCSHash.put(7897L, Character.valueOf('\u1ed9'));
        keysym2UCSHash.put(7898L, Character.valueOf('\u1eda'));
        keysym2UCSHash.put(7899L, Character.valueOf('\u1edb'));
        keysym2UCSHash.put(7900L, Character.valueOf('\u1edc'));
        keysym2UCSHash.put(7901L, Character.valueOf('\u1edd'));
        keysym2UCSHash.put(7902L, Character.valueOf('\u1ede'));
        keysym2UCSHash.put(7903L, Character.valueOf('\u1edf'));
        keysym2UCSHash.put(7904L, Character.valueOf('\u1ee0'));
        keysym2UCSHash.put(7905L, Character.valueOf('\u1ee1'));
        keysym2UCSHash.put(7906L, Character.valueOf('\u1ee2'));
        keysym2UCSHash.put(7907L, Character.valueOf('\u1ee3'));
        keysym2UCSHash.put(7908L, Character.valueOf('\u1ee4'));
        keysym2UCSHash.put(7909L, Character.valueOf('\u1ee5'));
        keysym2UCSHash.put(7910L, Character.valueOf('\u1ee6'));
        keysym2UCSHash.put(7911L, Character.valueOf('\u1ee7'));
        keysym2UCSHash.put(7912L, Character.valueOf('\u1ee8'));
        keysym2UCSHash.put(7913L, Character.valueOf('\u1ee9'));
        keysym2UCSHash.put(7914L, Character.valueOf('\u1eea'));
        keysym2UCSHash.put(7915L, Character.valueOf('\u1eeb'));
        keysym2UCSHash.put(7916L, Character.valueOf('\u1eec'));
        keysym2UCSHash.put(7917L, Character.valueOf('\u1eed'));
        keysym2UCSHash.put(7918L, Character.valueOf('\u1eee'));
        keysym2UCSHash.put(7919L, Character.valueOf('\u1eef'));
        keysym2UCSHash.put(7920L, Character.valueOf('\u1ef0'));
        keysym2UCSHash.put(7921L, Character.valueOf('\u1ef1'));
        keysym2UCSHash.put(7924L, Character.valueOf('\u1ef4'));
        keysym2UCSHash.put(7925L, Character.valueOf('\u1ef5'));
        keysym2UCSHash.put(7926L, Character.valueOf('\u1ef6'));
        keysym2UCSHash.put(7927L, Character.valueOf('\u1ef7'));
        keysym2UCSHash.put(7928L, Character.valueOf('\u1ef8'));
        keysym2UCSHash.put(7929L, Character.valueOf('\u1ef9'));
        keysym2UCSHash.put(7930L, Character.valueOf('\u01a0'));
        keysym2UCSHash.put(7931L, Character.valueOf('\u01a1'));
        keysym2UCSHash.put(7932L, Character.valueOf('\u01af'));
        keysym2UCSHash.put(7933L, Character.valueOf('\u01b0'));
        keysym2UCSHash.put(8352L, Character.valueOf('\u20a0'));
        keysym2UCSHash.put(8353L, Character.valueOf('\u20a1'));
        keysym2UCSHash.put(8354L, Character.valueOf('\u20a2'));
        keysym2UCSHash.put(8355L, Character.valueOf('\u20a3'));
        keysym2UCSHash.put(8356L, Character.valueOf('\u20a4'));
        keysym2UCSHash.put(8357L, Character.valueOf('\u20a5'));
        keysym2UCSHash.put(8358L, Character.valueOf('\u20a6'));
        keysym2UCSHash.put(8359L, Character.valueOf('\u20a7'));
        keysym2UCSHash.put(8360L, Character.valueOf('\u20a8'));
        keysym2UCSHash.put(8361L, Character.valueOf('\u20a9'));
        keysym2UCSHash.put(8362L, Character.valueOf('\u20aa'));
        keysym2UCSHash.put(8363L, Character.valueOf('\u20ab'));
        keysym2UCSHash.put(8364L, Character.valueOf('\u20ac'));
        keysym2UCSHash.put(268762888L, Character.valueOf('\b'));
        keysym2UCSHash.put(268762907L, Character.valueOf('\u001b'));
        keysym2UCSHash.put(268763135L, Character.valueOf('\u007f'));
        keysym2JavaKeycodeHash.put(97L, new Keysym2JavaKeycode(65, 1));
        keysym2JavaKeycodeHash.put(98L, new Keysym2JavaKeycode(66, 1));
        keysym2JavaKeycodeHash.put(99L, new Keysym2JavaKeycode(67, 1));
        keysym2JavaKeycodeHash.put(100L, new Keysym2JavaKeycode(68, 1));
        keysym2JavaKeycodeHash.put(101L, new Keysym2JavaKeycode(69, 1));
        keysym2JavaKeycodeHash.put(102L, new Keysym2JavaKeycode(70, 1));
        keysym2JavaKeycodeHash.put(103L, new Keysym2JavaKeycode(71, 1));
        keysym2JavaKeycodeHash.put(104L, new Keysym2JavaKeycode(72, 1));
        keysym2JavaKeycodeHash.put(105L, new Keysym2JavaKeycode(73, 1));
        keysym2JavaKeycodeHash.put(106L, new Keysym2JavaKeycode(74, 1));
        keysym2JavaKeycodeHash.put(107L, new Keysym2JavaKeycode(75, 1));
        keysym2JavaKeycodeHash.put(108L, new Keysym2JavaKeycode(76, 1));
        keysym2JavaKeycodeHash.put(109L, new Keysym2JavaKeycode(77, 1));
        keysym2JavaKeycodeHash.put(110L, new Keysym2JavaKeycode(78, 1));
        keysym2JavaKeycodeHash.put(111L, new Keysym2JavaKeycode(79, 1));
        keysym2JavaKeycodeHash.put(112L, new Keysym2JavaKeycode(80, 1));
        keysym2JavaKeycodeHash.put(113L, new Keysym2JavaKeycode(81, 1));
        keysym2JavaKeycodeHash.put(114L, new Keysym2JavaKeycode(82, 1));
        keysym2JavaKeycodeHash.put(115L, new Keysym2JavaKeycode(83, 1));
        keysym2JavaKeycodeHash.put(116L, new Keysym2JavaKeycode(84, 1));
        keysym2JavaKeycodeHash.put(117L, new Keysym2JavaKeycode(85, 1));
        keysym2JavaKeycodeHash.put(118L, new Keysym2JavaKeycode(86, 1));
        keysym2JavaKeycodeHash.put(119L, new Keysym2JavaKeycode(87, 1));
        keysym2JavaKeycodeHash.put(120L, new Keysym2JavaKeycode(88, 1));
        keysym2JavaKeycodeHash.put(121L, new Keysym2JavaKeycode(89, 1));
        keysym2JavaKeycodeHash.put(122L, new Keysym2JavaKeycode(90, 1));
        keysym2JavaKeycodeHash.put(65288L, new Keysym2JavaKeycode(8, 1));
        keysym2JavaKeycodeHash.put(65289L, new Keysym2JavaKeycode(9, 1));
        keysym2JavaKeycodeHash.put(65056L, new Keysym2JavaKeycode(9, 1));
        keysym2JavaKeycodeHash.put(65291L, new Keysym2JavaKeycode(12, 1));
        keysym2JavaKeycodeHash.put(65293L, new Keysym2JavaKeycode(10, 1));
        keysym2JavaKeycodeHash.put(65290L, new Keysym2JavaKeycode(10, 1));
        keysym2JavaKeycodeHash.put(65299L, new Keysym2JavaKeycode(19, 1));
        keysym2JavaKeycodeHash.put(65490L, new Keysym2JavaKeycode(19, 1));
        keysym2JavaKeycodeHash.put(65490L, new Keysym2JavaKeycode(19, 1));
        keysym2JavaKeycodeHash.put(65300L, new Keysym2JavaKeycode(145, 1));
        keysym2JavaKeycodeHash.put(65492L, new Keysym2JavaKeycode(145, 1));
        keysym2JavaKeycodeHash.put(65492L, new Keysym2JavaKeycode(145, 1));
        keysym2JavaKeycodeHash.put(65307L, new Keysym2JavaKeycode(27, 1));
        keysym2JavaKeycodeHash.put(268762888L, new Keysym2JavaKeycode(8, 1));
        keysym2JavaKeycodeHash.put(268762891L, new Keysym2JavaKeycode(12, 1));
        keysym2JavaKeycodeHash.put(268762907L, new Keysym2JavaKeycode(27, 1));
        keysym2JavaKeycodeHash.put(65505L, new Keysym2JavaKeycode(16, 2));
        keysym2JavaKeycodeHash.put(65506L, new Keysym2JavaKeycode(16, 3));
        keysym2JavaKeycodeHash.put(65507L, new Keysym2JavaKeycode(17, 2));
        keysym2JavaKeycodeHash.put(65508L, new Keysym2JavaKeycode(17, 3));
        keysym2JavaKeycodeHash.put(65513L, new Keysym2JavaKeycode(18, 2));
        keysym2JavaKeycodeHash.put(65514L, new Keysym2JavaKeycode(18, 3));
        keysym2JavaKeycodeHash.put(65511L, new Keysym2JavaKeycode(157, 2));
        keysym2JavaKeycodeHash.put(65512L, new Keysym2JavaKeycode(157, 3));
        keysym2JavaKeycodeHash.put(65509L, new Keysym2JavaKeycode(20, 1));
        keysym2JavaKeycodeHash.put(65377L, new Keysym2JavaKeycode(154, 1));
        keysym2JavaKeycodeHash.put(65491L, new Keysym2JavaKeycode(154, 1));
        keysym2JavaKeycodeHash.put(65491L, new Keysym2JavaKeycode(154, 1));
        keysym2JavaKeycodeHash.put(65385L, new Keysym2JavaKeycode(3, 1));
        keysym2JavaKeycodeHash.put(65386L, new Keysym2JavaKeycode(156, 1));
        keysym2JavaKeycodeHash.put(65407L, new Keysym2JavaKeycode(144, 4));
        keysym2JavaKeycodeHash.put(268762985L, new Keysym2JavaKeycode(3, 1));
        keysym2JavaKeycodeHash.put(268762986L, new Keysym2JavaKeycode(156, 1));
        keysym2JavaKeycodeHash.put(65360L, new Keysym2JavaKeycode(36, 1));
        keysym2JavaKeycodeHash.put(65496L, new Keysym2JavaKeycode(36, 1));
        keysym2JavaKeycodeHash.put(65365L, new Keysym2JavaKeycode(33, 1));
        keysym2JavaKeycodeHash.put(65365L, new Keysym2JavaKeycode(33, 1));
        keysym2JavaKeycodeHash.put(65498L, new Keysym2JavaKeycode(33, 1));
        keysym2JavaKeycodeHash.put(65366L, new Keysym2JavaKeycode(34, 1));
        keysym2JavaKeycodeHash.put(65366L, new Keysym2JavaKeycode(34, 1));
        keysym2JavaKeycodeHash.put(65504L, new Keysym2JavaKeycode(34, 1));
        keysym2JavaKeycodeHash.put(65367L, new Keysym2JavaKeycode(35, 1));
        keysym2JavaKeycodeHash.put(65502L, new Keysym2JavaKeycode(35, 1));
        keysym2JavaKeycodeHash.put(65379L, new Keysym2JavaKeycode(155, 1));
        keysym2JavaKeycodeHash.put(65535L, new Keysym2JavaKeycode(127, 1));
        keysym2JavaKeycodeHash.put(65429L, new Keysym2JavaKeycode(36, 4));
        keysym2JavaKeycodeHash.put(65434L, new Keysym2JavaKeycode(33, 4));
        keysym2JavaKeycodeHash.put(65434L, new Keysym2JavaKeycode(33, 4));
        keysym2JavaKeycodeHash.put(65435L, new Keysym2JavaKeycode(34, 4));
        keysym2JavaKeycodeHash.put(65435L, new Keysym2JavaKeycode(34, 4));
        keysym2JavaKeycodeHash.put(65436L, new Keysym2JavaKeycode(35, 4));
        keysym2JavaKeycodeHash.put(65438L, new Keysym2JavaKeycode(155, 4));
        keysym2JavaKeycodeHash.put(65439L, new Keysym2JavaKeycode(127, 4));
        keysym2JavaKeycodeHash.put(268762945L, new Keysym2JavaKeycode(33, 1));
        keysym2JavaKeycodeHash.put(268762965L, new Keysym2JavaKeycode(33, 1));
        keysym2JavaKeycodeHash.put(268762946L, new Keysym2JavaKeycode(34, 1));
        keysym2JavaKeycodeHash.put(268762966L, new Keysym2JavaKeycode(34, 1));
        keysym2JavaKeycodeHash.put(268762967L, new Keysym2JavaKeycode(35, 1));
        keysym2JavaKeycodeHash.put(268762979L, new Keysym2JavaKeycode(155, 1));
        keysym2JavaKeycodeHash.put(268763135L, new Keysym2JavaKeycode(127, 1));
        keysym2JavaKeycodeHash.put(65361L, new Keysym2JavaKeycode(37, 1));
        keysym2JavaKeycodeHash.put(65362L, new Keysym2JavaKeycode(38, 1));
        keysym2JavaKeycodeHash.put(65363L, new Keysym2JavaKeycode(39, 1));
        keysym2JavaKeycodeHash.put(65364L, new Keysym2JavaKeycode(40, 1));
        keysym2JavaKeycodeHash.put(65430L, new Keysym2JavaKeycode(226, 4));
        keysym2JavaKeycodeHash.put(65431L, new Keysym2JavaKeycode(224, 4));
        keysym2JavaKeycodeHash.put(65432L, new Keysym2JavaKeycode(227, 4));
        keysym2JavaKeycodeHash.put(65433L, new Keysym2JavaKeycode(225, 4));
        keysym2JavaKeycodeHash.put(268762961L, new Keysym2JavaKeycode(37, 1));
        keysym2JavaKeycodeHash.put(268762962L, new Keysym2JavaKeycode(38, 1));
        keysym2JavaKeycodeHash.put(268762963L, new Keysym2JavaKeycode(39, 1));
        keysym2JavaKeycodeHash.put(268762964L, new Keysym2JavaKeycode(40, 1));
        keysym2JavaKeycodeHash.put(65368L, new Keysym2JavaKeycode(65368, 1));
        keysym2JavaKeycodeHash.put(65437L, new Keysym2JavaKeycode(65368, 4));
        keysym2JavaKeycodeHash.put(48L, new Keysym2JavaKeycode(48, 1));
        keysym2JavaKeycodeHash.put(49L, new Keysym2JavaKeycode(49, 1));
        keysym2JavaKeycodeHash.put(50L, new Keysym2JavaKeycode(50, 1));
        keysym2JavaKeycodeHash.put(51L, new Keysym2JavaKeycode(51, 1));
        keysym2JavaKeycodeHash.put(52L, new Keysym2JavaKeycode(52, 1));
        keysym2JavaKeycodeHash.put(53L, new Keysym2JavaKeycode(53, 1));
        keysym2JavaKeycodeHash.put(54L, new Keysym2JavaKeycode(54, 1));
        keysym2JavaKeycodeHash.put(55L, new Keysym2JavaKeycode(55, 1));
        keysym2JavaKeycodeHash.put(56L, new Keysym2JavaKeycode(56, 1));
        keysym2JavaKeycodeHash.put(57L, new Keysym2JavaKeycode(57, 1));
        keysym2JavaKeycodeHash.put(32L, new Keysym2JavaKeycode(32, 1));
        keysym2JavaKeycodeHash.put(33L, new Keysym2JavaKeycode(517, 1));
        keysym2JavaKeycodeHash.put(34L, new Keysym2JavaKeycode(152, 1));
        keysym2JavaKeycodeHash.put(35L, new Keysym2JavaKeycode(520, 1));
        keysym2JavaKeycodeHash.put(36L, new Keysym2JavaKeycode(515, 1));
        keysym2JavaKeycodeHash.put(38L, new Keysym2JavaKeycode(150, 1));
        keysym2JavaKeycodeHash.put(39L, new Keysym2JavaKeycode(222, 1));
        keysym2JavaKeycodeHash.put(40L, new Keysym2JavaKeycode(519, 1));
        keysym2JavaKeycodeHash.put(41L, new Keysym2JavaKeycode(522, 1));
        keysym2JavaKeycodeHash.put(42L, new Keysym2JavaKeycode(151, 1));
        keysym2JavaKeycodeHash.put(43L, new Keysym2JavaKeycode(521, 1));
        keysym2JavaKeycodeHash.put(44L, new Keysym2JavaKeycode(44, 1));
        keysym2JavaKeycodeHash.put(45L, new Keysym2JavaKeycode(45, 1));
        keysym2JavaKeycodeHash.put(46L, new Keysym2JavaKeycode(46, 1));
        keysym2JavaKeycodeHash.put(47L, new Keysym2JavaKeycode(47, 1));
        keysym2JavaKeycodeHash.put(58L, new Keysym2JavaKeycode(513, 1));
        keysym2JavaKeycodeHash.put(59L, new Keysym2JavaKeycode(59, 1));
        keysym2JavaKeycodeHash.put(60L, new Keysym2JavaKeycode(153, 1));
        keysym2JavaKeycodeHash.put(61L, new Keysym2JavaKeycode(61, 1));
        keysym2JavaKeycodeHash.put(62L, new Keysym2JavaKeycode(160, 1));
        keysym2JavaKeycodeHash.put(64L, new Keysym2JavaKeycode(512, 1));
        keysym2JavaKeycodeHash.put(91L, new Keysym2JavaKeycode(91, 1));
        keysym2JavaKeycodeHash.put(92L, new Keysym2JavaKeycode(92, 1));
        keysym2JavaKeycodeHash.put(93L, new Keysym2JavaKeycode(93, 1));
        keysym2JavaKeycodeHash.put(94L, new Keysym2JavaKeycode(514, 1));
        keysym2JavaKeycodeHash.put(95L, new Keysym2JavaKeycode(523, 1));
        keysym2JavaKeycodeHash.put(65515L, new Keysym2JavaKeycode(524, 1));
        keysym2JavaKeycodeHash.put(65516L, new Keysym2JavaKeycode(524, 1));
        keysym2JavaKeycodeHash.put(65383L, new Keysym2JavaKeycode(525, 1));
        keysym2JavaKeycodeHash.put(96L, new Keysym2JavaKeycode(192, 1));
        keysym2JavaKeycodeHash.put(123L, new Keysym2JavaKeycode(161, 1));
        keysym2JavaKeycodeHash.put(125L, new Keysym2JavaKeycode(162, 1));
        keysym2JavaKeycodeHash.put(161L, new Keysym2JavaKeycode(518, 1));
        keysym2JavaKeycodeHash.put(65456L, new Keysym2JavaKeycode(96, 4));
        keysym2JavaKeycodeHash.put(65457L, new Keysym2JavaKeycode(97, 4));
        keysym2JavaKeycodeHash.put(65458L, new Keysym2JavaKeycode(98, 4));
        keysym2JavaKeycodeHash.put(65459L, new Keysym2JavaKeycode(99, 4));
        keysym2JavaKeycodeHash.put(65460L, new Keysym2JavaKeycode(100, 4));
        keysym2JavaKeycodeHash.put(65461L, new Keysym2JavaKeycode(101, 4));
        keysym2JavaKeycodeHash.put(65462L, new Keysym2JavaKeycode(102, 4));
        keysym2JavaKeycodeHash.put(65463L, new Keysym2JavaKeycode(103, 4));
        keysym2JavaKeycodeHash.put(65464L, new Keysym2JavaKeycode(104, 4));
        keysym2JavaKeycodeHash.put(65465L, new Keysym2JavaKeycode(105, 4));
        keysym2JavaKeycodeHash.put(65408L, new Keysym2JavaKeycode(32, 4));
        keysym2JavaKeycodeHash.put(65417L, new Keysym2JavaKeycode(9, 4));
        keysym2JavaKeycodeHash.put(65421L, new Keysym2JavaKeycode(10, 4));
        keysym2JavaKeycodeHash.put(65469L, new Keysym2JavaKeycode(61, 4));
        keysym2JavaKeycodeHash.put(65493L, new Keysym2JavaKeycode(61, 4));
        keysym2JavaKeycodeHash.put(65450L, new Keysym2JavaKeycode(106, 4));
        keysym2JavaKeycodeHash.put(65495L, new Keysym2JavaKeycode(106, 4));
        keysym2JavaKeycodeHash.put(65495L, new Keysym2JavaKeycode(106, 4));
        keysym2JavaKeycodeHash.put(65451L, new Keysym2JavaKeycode(107, 4));
        keysym2JavaKeycodeHash.put(65452L, new Keysym2JavaKeycode(108, 4));
        keysym2JavaKeycodeHash.put(65453L, new Keysym2JavaKeycode(109, 4));
        keysym2JavaKeycodeHash.put(65493L, new Keysym2JavaKeycode(109, 4));
        keysym2JavaKeycodeHash.put(65454L, new Keysym2JavaKeycode(110, 4));
        keysym2JavaKeycodeHash.put(65455L, new Keysym2JavaKeycode(111, 4));
        keysym2JavaKeycodeHash.put(65494L, new Keysym2JavaKeycode(111, 4));
        keysym2JavaKeycodeHash.put(65494L, new Keysym2JavaKeycode(111, 4));
        keysym2JavaKeycodeHash.put(65470L, new Keysym2JavaKeycode(112, 1));
        keysym2JavaKeycodeHash.put(65471L, new Keysym2JavaKeycode(113, 1));
        keysym2JavaKeycodeHash.put(65472L, new Keysym2JavaKeycode(114, 1));
        keysym2JavaKeycodeHash.put(65473L, new Keysym2JavaKeycode(115, 1));
        keysym2JavaKeycodeHash.put(65474L, new Keysym2JavaKeycode(116, 1));
        keysym2JavaKeycodeHash.put(65475L, new Keysym2JavaKeycode(117, 1));
        keysym2JavaKeycodeHash.put(65476L, new Keysym2JavaKeycode(118, 1));
        keysym2JavaKeycodeHash.put(65477L, new Keysym2JavaKeycode(119, 1));
        keysym2JavaKeycodeHash.put(65478L, new Keysym2JavaKeycode(120, 1));
        keysym2JavaKeycodeHash.put(65479L, new Keysym2JavaKeycode(121, 1));
        keysym2JavaKeycodeHash.put(65480L, new Keysym2JavaKeycode(122, 1));
        keysym2JavaKeycodeHash.put(65481L, new Keysym2JavaKeycode(123, 1));
        keysym2JavaKeycodeHash.put(268828432L, new Keysym2JavaKeycode(122, 1));
        keysym2JavaKeycodeHash.put(268828433L, new Keysym2JavaKeycode(123, 1));
        keysym2JavaKeycodeHash.put(65378L, new Keysym2JavaKeycode(30, 1));
        keysym2JavaKeycodeHash.put(65313L, new Keysym2JavaKeycode(28, 1));
        keysym2JavaKeycodeHash.put(65315L, new Keysym2JavaKeycode(263, 1));
        keysym2JavaKeycodeHash.put(65312L, new Keysym2JavaKeycode(65312, 1));
        keysym2JavaKeycodeHash.put(65406L, new Keysym2JavaKeycode(65406, 1));
        keysym2JavaKeycodeHash.put(65027L, new Keysym2JavaKeycode(65406, 1));
        keysym2JavaKeycodeHash.put(65382L, new Keysym2JavaKeycode(65481, 1));
        keysym2JavaKeycodeHash.put(65381L, new Keysym2JavaKeycode(65483, 1));
        keysym2JavaKeycodeHash.put(65483L, new Keysym2JavaKeycode(65483, 1));
        keysym2JavaKeycodeHash.put(65485L, new Keysym2JavaKeycode(65485, 1));
        keysym2JavaKeycodeHash.put(65487L, new Keysym2JavaKeycode(65487, 1));
        keysym2JavaKeycodeHash.put(65489L, new Keysym2JavaKeycode(65489, 1));
        keysym2JavaKeycodeHash.put(65384L, new Keysym2JavaKeycode(65488, 1));
        keysym2JavaKeycodeHash.put(65488L, new Keysym2JavaKeycode(65488, 1));
        keysym2JavaKeycodeHash.put(65482L, new Keysym2JavaKeycode(65482, 1));
        keysym2JavaKeycodeHash.put(65382L, new Keysym2JavaKeycode(65481, 1));
        keysym2JavaKeycodeHash.put(65381L, new Keysym2JavaKeycode(65483, 1));
        keysym2JavaKeycodeHash.put(268828530L, new Keysym2JavaKeycode(65485, 1));
        keysym2JavaKeycodeHash.put(268828532L, new Keysym2JavaKeycode(65487, 1));
        keysym2JavaKeycodeHash.put(268828533L, new Keysym2JavaKeycode(65489, 1));
        keysym2JavaKeycodeHash.put(65384L, new Keysym2JavaKeycode(65488, 1));
        keysym2JavaKeycodeHash.put(268828528L, new Keysym2JavaKeycode(65482, 1));
        keysym2JavaKeycodeHash.put(65385L, new Keysym2JavaKeycode(65480, 1));
        keysym2JavaKeycodeHash.put(268500738L, new Keysym2JavaKeycode(65485, 1));
        keysym2JavaKeycodeHash.put(268500739L, new Keysym2JavaKeycode(65489, 1));
        keysym2JavaKeycodeHash.put(268500740L, new Keysym2JavaKeycode(65487, 1));
        keysym2JavaKeycodeHash.put(268762882L, new Keysym2JavaKeycode(65485, 1));
        keysym2JavaKeycodeHash.put(268762883L, new Keysym2JavaKeycode(65489, 1));
        keysym2JavaKeycodeHash.put(268762884L, new Keysym2JavaKeycode(65487, 1));
        keysym2JavaKeycodeHash.put(268762981L, new Keysym2JavaKeycode(65483, 1));
        keysym2JavaKeycodeHash.put(65104L, new Keysym2JavaKeycode(128, 1));
        keysym2JavaKeycodeHash.put(65105L, new Keysym2JavaKeycode(129, 1));
        keysym2JavaKeycodeHash.put(65106L, new Keysym2JavaKeycode(130, 1));
        keysym2JavaKeycodeHash.put(65107L, new Keysym2JavaKeycode(131, 1));
        keysym2JavaKeycodeHash.put(65108L, new Keysym2JavaKeycode(132, 1));
        keysym2JavaKeycodeHash.put(65109L, new Keysym2JavaKeycode(133, 1));
        keysym2JavaKeycodeHash.put(65110L, new Keysym2JavaKeycode(134, 1));
        keysym2JavaKeycodeHash.put(65111L, new Keysym2JavaKeycode(135, 1));
        keysym2JavaKeycodeHash.put(65112L, new Keysym2JavaKeycode(136, 1));
        keysym2JavaKeycodeHash.put(65113L, new Keysym2JavaKeycode(137, 1));
        keysym2JavaKeycodeHash.put(65114L, new Keysym2JavaKeycode(138, 1));
        keysym2JavaKeycodeHash.put(65115L, new Keysym2JavaKeycode(139, 1));
        keysym2JavaKeycodeHash.put(65116L, new Keysym2JavaKeycode(140, 1));
        keysym2JavaKeycodeHash.put(65117L, new Keysym2JavaKeycode(141, 1));
        keysym2JavaKeycodeHash.put(65118L, new Keysym2JavaKeycode(142, 1));
        keysym2JavaKeycodeHash.put(65119L, new Keysym2JavaKeycode(143, 1));
        keysym2JavaKeycodeHash.put(268828416L, new Keysym2JavaKeycode(128, 1));
        keysym2JavaKeycodeHash.put(268828417L, new Keysym2JavaKeycode(130, 1));
        keysym2JavaKeycodeHash.put(268828418L, new Keysym2JavaKeycode(131, 1));
        keysym2JavaKeycodeHash.put(268828419L, new Keysym2JavaKeycode(129, 1));
        keysym2JavaKeycodeHash.put(268828420L, new Keysym2JavaKeycode(135, 1));
        keysym2JavaKeycodeHash.put(268828421L, new Keysym2JavaKeycode(139, 1));
        keysym2JavaKeycodeHash.put(268500656L, new Keysym2JavaKeycode(136, 1));
        keysym2JavaKeycodeHash.put(268500574L, new Keysym2JavaKeycode(130, 1));
        keysym2JavaKeycodeHash.put(268500524L, new Keysym2JavaKeycode(139, 1));
        keysym2JavaKeycodeHash.put(268500519L, new Keysym2JavaKeycode(129, 1));
        keysym2JavaKeycodeHash.put(268500576L, new Keysym2JavaKeycode(128, 1));
        keysym2JavaKeycodeHash.put(268500606L, new Keysym2JavaKeycode(131, 1));
        keysym2JavaKeycodeHash.put(268500514L, new Keysym2JavaKeycode(135, 1));
        keysym2JavaKeycodeHash.put(268435624L, new Keysym2JavaKeycode(129, 1));
        keysym2JavaKeycodeHash.put(268435625L, new Keysym2JavaKeycode(128, 1));
        keysym2JavaKeycodeHash.put(0x100000AAL, new Keysym2JavaKeycode(130, 1));
        keysym2JavaKeycodeHash.put(268435627L, new Keysym2JavaKeycode(135, 1));
        keysym2JavaKeycodeHash.put(268435628L, new Keysym2JavaKeycode(131, 1));
        keysym2JavaKeycodeHash.put(0L, new Keysym2JavaKeycode(0, 0));
        javaKeycode2KeysymHash.put(20, 65509L);
        javaKeycode2KeysymHash.put(144, 65407L);
        javaKeycode2KeysymHash.put(145, 65300L);
        javaKeycode2KeysymHash.put(262, 65325L);
    }

    static class Keysym2JavaKeycode {
        int jkeycode;
        int keyLocation;

        int getJavaKeycode() {
            return this.jkeycode;
        }

        int getKeyLocation() {
            return this.keyLocation;
        }

        Keysym2JavaKeycode(int jk, int loc) {
            this.jkeycode = jk;
            this.keyLocation = loc;
        }
    }
}

