/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.zaproxy.zap.utils.ExecutorTerminatedListener;
import org.zaproxy.zap.utils.PausableExecutorService;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor
implements PausableExecutorService {
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();
    private boolean paused;
    private List<ExecutorTerminatedListener> listeners = new ArrayList<ExecutorTerminatedListener>(1);

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory());
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.pauseLock.lock();
        try {
            while (this.paused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void resume() {
        this.pauseLock.lock();
        try {
            if (!this.paused) {
                return;
            }
            this.paused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.resume();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.resume();
        return super.shutdownNow();
    }

    @Override
    protected void terminated() {
        super.terminated();
        PausableThreadPoolExecutor.notifyListeners(new ArrayList<ExecutorTerminatedListener>(this.listeners));
    }

    private static void notifyListeners(List<ExecutorTerminatedListener> listeners) {
        for (ExecutorTerminatedListener listener : listeners) {
            listener.terminated();
        }
    }

    @Override
    public void addExecutorTerminatedListener(ExecutorTerminatedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeExecutorTerminatedListener(ExecutorTerminatedListener listener) {
        this.listeners.remove(listener);
    }
}

