S2 = Manifold(2, 'S^2', start_index=1)
polar = S2.chart('th ph'); th, ph = polar[:]
epolar = polar.frame()
g = S2.metric('g')
g[1,1], g[2,2] = 1, (sin(th))**2
t,tmin,tmax,th0,ph0,v_th0,v_ph0 = var('t tmin tmax th0 ph0 v_th0 v_ph0')
p = S2.point((th0, ph0), name='p')
Tp = S2.tangent_space(p)
v = Tp((v_th0, v_ph0), basis=epolar.at(p))
c = S2.integrated_geodesic(g, (t, tmin, tmax), v, chart=polar,
                                                       name='c')
dict_params={'equat':{tmin:0,tmax:3,th0:pi/2,ph0:0.1,v_th0:0,v_ph0:1},
             'longi':{tmin:0,tmax:3,th0:0.1,ph0:0.1,v_th0:1,v_ph0:0},
             'angle':{tmin:0,tmax:3,th0:pi/4,ph0:0.1,v_th0:1,v_ph0:1}}
R3 = Manifold(3, 'R3', start_index=1)
cart = R3.chart('X Y Z')
euclid_embedding = S2.diff_map(R3,
      {(polar, cart): [sin(th)*cos(ph),sin(th)*sin(ph),cos(th)]})
graph3D_embedded_geods = Graphics()
for key in dict_params:
    sol = c.solve(solution_key='sol-'+key,
                  parameters_values=dict_params[key])
    interp = c.interpolate(solution_key='sol-'+key,
                           interpolation_key='interp-'+key)
    graph3D_embedded_geods += c.plot_integrated(interpolation_key='interp-'+key,
                          mapping=euclid_embedding, thickness=5,
                          display_tangent=True, scale=0.3,
                          width_tangent=0.5)
graph3D_embedded_polar_coords = polar.plot(chart=cart,
                               mapping=euclid_embedding,
                               number_values=15, color='yellow')
graph = graph3D_embedded_geods + graph3D_embedded_polar_coords
sphinx_plot(graph)