/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect;

import org.logstash.dissect.ValueRef;

public final class ValueResolver {
    private final byte[] source;
    private final ValueRef[] fieldValues;

    ValueResolver(byte[] source, ValueRef[] fieldValues) {
        this.source = source;
        this.fieldValues = fieldValues;
    }

    public String get(int fieldId) {
        return this.fieldValues[fieldId].extract(this.source);
    }

    public String getOtherByName(String name, int notFieldId) {
        int found = -1;
        for (int i = 0; i < this.fieldValues.length; ++i) {
            ValueRef ref = this.fieldValues[i];
            if (i == notFieldId || ref == null || !name.contentEquals(ref.getFieldName())) continue;
            found = i;
            break;
        }
        if (found >= 0) {
            return this.get(found);
        }
        return "";
    }
}

