/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.smi.OctetString;

public class TsmSecurityParameters
extends OctetString
implements SecurityParameters {
    private int securityParametersPosition;
    private int decodedLength = -1;

    @Override
    public int getSecurityParametersPosition() {
        return this.securityParametersPosition;
    }

    @Override
    public void setSecurityParametersPosition(int pos) {
        this.securityParametersPosition = pos;
    }

    @Override
    public int getBERMaxLength(int securityLevel) {
        return this.getBERLength();
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        long startPos = inputStream.getPosition();
        super.decodeBER(inputStream);
        this.decodedLength = (int)(inputStream.getPosition() - startPos);
    }

    public int getScopedPduPosition() {
        if (this.decodedLength >= 0) {
            return this.decodedLength + this.getSecurityParametersPosition();
        }
        return this.getSecurityParametersPosition() + this.getBERLength();
    }
}

