/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J2\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J0\u0010'\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J/\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b4J\u0014\u00105\u001a\u00020\u0014*\u0002062\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "variableTypeAndInitializerResolver", "Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "checkLocalVariableDeclaration", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "initializeWithDefaultGetterSetter", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "process", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "property", "typingContext", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;", "resolveLocalVariableDescriptor", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveLocalVariableDescriptorWithType", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveLocalVariableDescriptorWithType$frontend", "updateAccessorFlagsFromResolvedCallForDelegatedProperty", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "frontend"})
public final class LocalVariableResolver {
    private final ModifiersChecker modifiersChecker;
    private final IdentifierChecker identifierChecker;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final AnnotationResolver annotationResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;

    @NotNull
    public final Pair<KotlinTypeInfo, VariableDescriptor> process(@NotNull KtProperty property, @NotNull ExpressionTypingContext typingContext, @NotNull LexicalScope scope, @NotNull ExpressionTypingFacade facade) {
        KtPropertyAccessor setter2;
        KtPropertyAccessor getter2;
        Intrinsics.checkParameterIsNotNull(property, "property");
        Intrinsics.checkParameterIsNotNull(typingContext, "typingContext");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        Object Context2 = ((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(scope);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "typingContext.replaceCon\u2026DENT).replaceScope(scope)");
        ExpressionTypingContext context2 = (ExpressionTypingContext)Context2;
        KtTypeReference receiverTypeRef = property.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context2.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on((KtTypeReference)((PsiElement)receiverTypeRef)));
        }
        if ((getter2 = property.getGetter()) != null) {
            context2.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
        }
        if ((setter2 = property.getSetter()) != null) {
            context2.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
        }
        KtVariableDeclaration ktVariableDeclaration = property;
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        InferenceSession inferenceSession = context2.inferenceSession;
        Intrinsics.checkExpressionValueIsNotNull(inferenceSession, "context.inferenceSession");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        VariableDescriptor propertyDescriptor2 = this.resolveLocalVariableDescriptor(scope, ktVariableDeclaration, dataFlowInfo, inferenceSession, bindingTrace);
        KtExpression delegateExpression = property.getDelegateExpression();
        if (delegateExpression != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.LocalDelegatedProperties)) {
                BindingTrace bindingTrace2 = context2.trace;
                KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
                if (ktPropertyDelegate == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace2.report(Errors.UNSUPPORTED_FEATURE.on(ktPropertyDelegate, TuplesKt.to(LanguageFeature.LocalDelegatedProperties, this.languageVersionSettings)));
            }
            if (propertyDescriptor2 instanceof VariableDescriptorWithAccessors) {
                DataFlowInfo dataFlowInfo2 = typingContext.dataFlowInfo;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo2, "typingContext.dataFlowInfo");
                VariableDescriptorWithAccessors variableDescriptorWithAccessors = (VariableDescriptorWithAccessors)propertyDescriptor2;
                LexicalScope lexicalScope = typingContext.scope;
                Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "typingContext.scope");
                InferenceSession inferenceSession2 = typingContext.inferenceSession;
                Intrinsics.checkExpressionValueIsNotNull(inferenceSession2, "typingContext.inferenceSession");
                BindingTrace bindingTrace3 = typingContext.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace3, "typingContext.trace");
                this.delegatedPropertyResolver.resolvePropertyDelegate(dataFlowInfo2, property, variableDescriptorWithAccessors, delegateExpression, lexicalScope, inferenceSession2, bindingTrace3);
                VariableAccessorDescriptor variableAccessorDescriptor = ((VariableDescriptorWithAccessors)propertyDescriptor2).getGetter();
                if (variableAccessorDescriptor != null) {
                    BindingTrace bindingTrace4 = typingContext.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace4, "typingContext.trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor, bindingTrace4);
                }
                VariableAccessorDescriptor variableAccessorDescriptor2 = ((VariableDescriptorWithAccessors)propertyDescriptor2).getSetter();
                if (variableAccessorDescriptor2 != null) {
                    BindingTrace bindingTrace5 = typingContext.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace5, "typingContext.trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor2, bindingTrace5);
                }
            }
        }
        KtExpression initializer2 = property.getInitializer();
        KotlinTypeInfo typeInfo = null;
        if (initializer2 != null) {
            KotlinType kotlinType2 = propertyDescriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "propertyDescriptor.type");
            KotlinType outType = kotlinType2;
            KotlinTypeInfo kotlinTypeInfo = facade.getTypeInfo(initializer2, (ExpressionTypingContext)context2.replaceExpectedType(outType));
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "facade.getTypeInfo(initi\u2026aceExpectedType(outType))");
            typeInfo = kotlinTypeInfo;
            DataFlowInfo dataFlowInfo3 = typeInfo.getDataFlowInfo();
            KotlinType type2 = typeInfo.getType();
            if (type2 != null) {
                DataFlowValue initializerDataFlowValue = this.dataFlowValueFactory.createDataFlowValue(initializer2, type2, context2);
                if (!propertyDescriptor2.isVar() && initializerDataFlowValue.getCanBeBound()) {
                    context2.trace.record(BindingContext.BOUND_INITIALIZER_VALUE, propertyDescriptor2, initializerDataFlowValue);
                }
                if (property.getTypeReference() == null) {
                    BindingTrace bindingTrace6 = context2.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace6, "context.trace");
                    BindingContext bindingContext = bindingTrace6.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
                    DataFlowValue variableDataFlowValue = this.dataFlowValueFactory.createDataFlowValueForProperty(property, propertyDescriptor2, bindingContext, DescriptorUtils.getContainingModuleOrNull(scope.getOwnerDescriptor()));
                    typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo3.assign(variableDataFlowValue, initializerDataFlowValue, this.languageVersionSettings));
                }
            }
        } else {
            typeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        }
        this.checkLocalVariableDeclaration(context2, propertyDescriptor2, property);
        return new Pair<KotlinTypeInfo, VariableDescriptor>(typeInfo.replaceType(this.dataFlowAnalyzer.checkStatementType(property, context2)), propertyDescriptor2);
    }

    private final void checkLocalVariableDeclaration(ExpressionTypingContext context2, VariableDescriptor descriptor2, KtProperty ktProperty) {
        ExpressionTypingUtils.checkVariableShadowing(context2.scope, context2.trace, descriptor2);
        this.modifiersChecker.withTrace(context2.trace).checkModifiersForLocalDeclaration(ktProperty, descriptor2);
        KtDeclaration ktDeclaration = ktProperty;
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        this.identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
        BindingTrace bindingTrace2 = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(bindingTrace2, ktProperty, descriptor2);
    }

    private final VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope, KtVariableDeclaration variable2, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession, BindingTrace trace) {
        DeclarationDescriptor containingDeclaration = scope.getOwnerDescriptor();
        VariableDescriptorWithInitializerImpl result2 = null;
        KotlinType type2 = null;
        if (KtPsiUtil.isScriptDeclaration(variable2)) {
            PropertyDescriptorImpl propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope, variable2.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable2.isVar(), KtPsiUtil.safeName(variable2.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variable2), false, false, false, false, false, variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegate());
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptorImpl, "PropertyDescriptorImpl.c\u2026sDelegate()\n            )");
            PropertyDescriptorImpl propertyDescriptor2 = propertyDescriptorImpl;
            type2 = this.variableTypeAndInitializerResolver.resolveType(propertyDescriptor2, scope, variable2, dataFlowInfo, inferenceSession, trace, true);
            DeclarationDescriptor declarationDescriptor = containingDeclaration;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ScriptDescriptor");
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ScriptDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "(containingDeclaration a\u2026).thisAsReceiverParameter");
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            propertyDescriptor2.setType(type2, CollectionsKt.emptyList(), receiverParameter, null);
            this.initializeWithDefaultGetterSetter(propertyDescriptor2);
            trace.record(BindingContext.VARIABLE, variable2, propertyDescriptor2);
            result2 = propertyDescriptor2;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType$frontend(scope, variable2, null, trace);
            type2 = this.variableTypeAndInitializerResolver.resolveType(variableDescriptor, scope, variable2, dataFlowInfo, inferenceSession, trace, true);
            variableDescriptor.setOutType(type2);
            result2 = variableDescriptor;
        }
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(result2, scope, variable2, dataFlowInfo, type2, inferenceSession, trace);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return result2;
    }

    private final void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor2) {
        PropertySetterDescriptor setter2;
        PropertyGetterDescriptorImpl getter2 = propertyDescriptor2.getGetter();
        if (getter2 == null && !Visibilities.isPrivate(propertyDescriptor2.getVisibility())) {
            getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor2, Annotations.Companion.getEMPTY());
            getter2.initialize(propertyDescriptor2.getType());
        }
        if ((setter2 = propertyDescriptor2.getSetter()) == null && propertyDescriptor2.isVar()) {
            setter2 = DescriptorFactory.createDefaultSetter(propertyDescriptor2, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY());
        }
        propertyDescriptor2.initialize(getter2, setter2);
    }

    @NotNull
    public final LocalVariableDescriptor resolveLocalVariableDescriptorWithType$frontend(@NotNull LexicalScope scope, @NotNull KtVariableDeclaration variable2, @Nullable KotlinType type2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(variable2, "variable");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        boolean hasDelegate = variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegate();
        boolean hasLateinit = variable2.hasModifier(KtTokens.LATEINIT_KEYWORD);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope, variable2.getModifierList(), trace), UnderscoreUtilKt.isSingleUnderscore(variable2) ? Name.special("<underscore local var>") : KtPsiUtil.safeName(variable2.getName()), type2, variable2.isVar(), hasDelegate, hasLateinit, KotlinSourceElementKt.toSourceElement(variable2));
        trace.record(BindingContext.VARIABLE, variable2, variableDescriptor);
        return variableDescriptor;
    }

    private final void updateAccessorFlagsFromResolvedCallForDelegatedProperty(@NotNull VariableAccessorDescriptor $this$updateAccessorFlagsFromResolvedCallForDelegatedProperty, BindingTrace trace) {
        if ($this$updateAccessorFlagsFromResolvedCallForDelegatedProperty instanceof FunctionDescriptorImpl) {
            FunctionDescriptor resultingDescriptor;
            ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, $this$updateAccessorFlagsFromResolvedCallForDelegatedProperty);
            FunctionDescriptor functionDescriptor = resultingDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getResultingDescriptor() : null;
            if (resultingDescriptor != null) {
                ((FunctionDescriptorImpl)((Object)$this$updateAccessorFlagsFromResolvedCallForDelegatedProperty)).setSuspend(resultingDescriptor.isSuspend());
            }
        }
    }

    public LocalVariableResolver(@NotNull ModifiersChecker modifiersChecker, @NotNull IdentifierChecker identifierChecker, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull AnnotationResolver annotationResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(variableTypeAndInitializerResolver, "variableTypeAndInitializerResolver");
        Intrinsics.checkParameterIsNotNull(delegatedPropertyResolver, "delegatedPropertyResolver");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(dataFlowValueFactory, "dataFlowValueFactory");
        this.modifiersChecker = modifiersChecker;
        this.identifierChecker = identifierChecker;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.annotationResolver = annotationResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }
}

