"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputList = InputList;

var _react = _interopRequireWildcard(require("react"));

var _eui = require("@elastic/eui");

var _react2 = require("@kbn/i18n/react");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var generateId = (0, _eui.htmlIdGenerator)();

function InputList(_ref) {
  var config = _ref.config,
      list = _ref.list,
      onChange = _ref.onChange,
      setValidity = _ref.setValidity;

  var _useState = (0, _react.useState)(list.length ? list.map(function (item) {
    return _objectSpread({
      id: generateId()
    }, config.getModelValue(item));
  }) : [_objectSpread({
    id: generateId()
  }, config.defaultValue)]),
      _useState2 = _slicedToArray(_useState, 2),
      models = _useState2[0],
      setModels = _useState2[1];

  var onUpdate = function onUpdate(modelList) {
    setModels(modelList);
    onChange(modelList.map(config.onChangeFn));
  };

  var onChangeValue = function onChangeValue(index, value, modelName) {
    var range = models[index][modelName];

    var _validateValue = validateValue(value),
        model = _validateValue.model,
        isInvalid = _validateValue.isInvalid;

    range.value = value;
    range.model = model;
    range.isInvalid = isInvalid;
    onUpdate(models);
  };

  var onDelete = function onDelete(id) {
    var newArray = models.filter(function (model) {
      return model.id !== id;
    });
    onUpdate(newArray);
  };

  var onAdd = function onAdd() {
    var newArray = [].concat(_toConsumableArray(models), [_objectSpread({
      id: generateId()
    }, config.defaultEmptyValue)]);
    onUpdate(newArray);
  };

  var getUpdatedModels = function getUpdatedModels(objList, modelList) {
    if (!objList.length) {
      return modelList;
    }

    return objList.map(function (item, index) {
      var model = modelList[index] || _objectSpread({
        id: generateId()
      }, config.getModelValue(item));

      config.validateModel(validateItem, item, model);
      return model;
    });
  };

  var validateItem = function validateItem(value, modelObj) {
    var _validateValue2 = validateValue(value),
        model = _validateValue2.model,
        isInvalid = _validateValue2.isInvalid;

    if (value !== modelObj.model) {
      modelObj.value = model;
    }

    modelObj.model = model;
    modelObj.isInvalid = isInvalid;
  };

  var validateValue = function validateValue(inputValue) {
    var result = {
      model: inputValue || '',
      isInvalid: false
    };

    if (!inputValue) {
      result.isInvalid = false;
      return result;
    }

    try {
      var _InputObject = config.validateClass;
      result.model = new _InputObject(inputValue).toString();
      result.isInvalid = false;
      return result;
    } catch (e) {
      result.isInvalid = true;
      return result;
    }
  };

  var hasInvalidValues = function hasInvalidValues(modelList) {
    return !!modelList.find(config.hasInvalidValuesFn);
  }; // responsible for discarding changes


  (0, _react.useEffect)(function () {
    setModels(getUpdatedModels(list, models));
  }, [list]);
  (0, _react.useEffect)(function () {
    setValidity(!hasInvalidValues(models));
  }, [models]); // resposible for setting up an initial value when there is no default value

  (0, _react.useEffect)(function () {
    onChange(models.map(config.onChangeFn));
  }, []);

  if (!list || !list.length) {
    return null;
  }

  return _react.default.createElement(_react.default.Fragment, null, models.map(function (item, index) {
    return _react.default.createElement(_react.Fragment, {
      key: item.id
    }, _react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, config.renderInputRow(item, index, onChangeValue), _react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": config.getRemoveBtnAriaLabel(item),
      title: config.getRemoveBtnAriaLabel(item),
      disabled: models.length === 1,
      color: "danger",
      iconType: "trash",
      onClick: function onClick() {
        return onDelete(item.id);
      }
    }))), _react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }));
  }), _react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), _react.default.createElement(_eui.EuiFlexItem, null, _react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, _react.default.createElement(_react2.FormattedMessage, {
    id: "common.ui.aggTypes.ipRanges.addRangeButtonLabel",
    defaultMessage: "Add range"
  }))));
}