"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_react_1 = require("mobx-react");
var react_1 = require("react");
var dark_theme_1 = require("../lib/themes/dark_theme");
var light_theme_1 = require("../lib/themes/light_theme");
var theme_1 = require("../lib/themes/theme");
var interactions_1 = require("../lib/utils/interactions");
exports.DEFAULT_TOOLTIP_TYPE = interactions_1.TooltipType.VerticalCursor;
exports.DEFAULT_TOOLTIP_SNAP = true;
function isTooltipProps(config) {
    return typeof config === 'object';
}
function isTooltipType(config) {
    return typeof config === 'string';
}
function getTheme(theme, baseThemeType) {
    if (baseThemeType === void 0) { baseThemeType = theme_1.BaseThemeTypes.Light; }
    if (theme) {
        var baseTheme = baseThemeType === theme_1.BaseThemeTypes.Light ? light_theme_1.LIGHT_THEME : dark_theme_1.DARK_THEME;
        return theme_1.mergeWithDefaultTheme(theme, baseTheme);
    }
    return light_theme_1.LIGHT_THEME;
}
function updateChartStore(props) {
    var chartStore = props.chartStore, theme = props.theme, baseThemeType = props.baseThemeType, rotation = props.rotation, rendering = props.rendering, animateData = props.animateData, showLegend = props.showLegend, tooltip = props.tooltip, legendPosition = props.legendPosition, showLegendDisplayValue = props.showLegendDisplayValue, onElementClick = props.onElementClick, onElementOver = props.onElementOver, onElementOut = props.onElementOut, onBrushEnd = props.onBrushEnd, onLegendItemOver = props.onLegendItemOver, onLegendItemOut = props.onLegendItemOut, onLegendItemClick = props.onLegendItemClick, onLegendItemMinusClick = props.onLegendItemMinusClick, onLegendItemPlusClick = props.onLegendItemPlusClick, debug = props.debug, xDomain = props.xDomain;
    if (!chartStore) {
        return;
    }
    chartStore.chartTheme = getTheme(theme, baseThemeType);
    chartStore.chartRotation = rotation;
    chartStore.chartRendering = rendering;
    chartStore.animateData = animateData;
    chartStore.debug = debug;
    if (tooltip && isTooltipProps(tooltip)) {
        var type = tooltip.type, snap = tooltip.snap, headerFormatter = tooltip.headerFormatter;
        chartStore.tooltipType.set(type);
        chartStore.tooltipSnap.set(snap);
        chartStore.tooltipHeaderFormatter = headerFormatter;
    }
    else if (tooltip && isTooltipType(tooltip)) {
        chartStore.tooltipType.set(tooltip);
    }
    chartStore.setShowLegend(showLegend);
    chartStore.legendPosition = legendPosition;
    chartStore.showLegendDisplayValue.set(showLegendDisplayValue);
    chartStore.xDomain = xDomain;
    if (onElementOver) {
        chartStore.setOnElementOverListener(onElementOver);
    }
    if (onElementClick) {
        chartStore.setOnElementClickListener(onElementClick);
    }
    if (onElementOut) {
        chartStore.setOnElementOutListener(onElementOut);
    }
    if (onBrushEnd) {
        chartStore.setOnBrushEndListener(onBrushEnd);
    }
    if (onLegendItemOver) {
        chartStore.setOnLegendItemOverListener(onLegendItemOver);
    }
    if (onLegendItemOut) {
        chartStore.setOnLegendItemOutListener(onLegendItemOut);
    }
    if (onLegendItemClick) {
        chartStore.setOnLegendItemClickListener(onLegendItemClick);
    }
    if (onLegendItemPlusClick) {
        chartStore.setOnLegendItemPlusClickListener(onLegendItemPlusClick);
    }
    if (onLegendItemMinusClick) {
        chartStore.setOnLegendItemMinusClickListener(onLegendItemMinusClick);
    }
}
var SettingsComponent = /** @class */ (function (_super) {
    __extends(SettingsComponent, _super);
    function SettingsComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SettingsComponent.prototype.componentDidMount = function () {
        updateChartStore(this.props);
    };
    SettingsComponent.prototype.componentDidUpdate = function () {
        updateChartStore(this.props);
    };
    SettingsComponent.prototype.render = function () {
        return null;
    };
    SettingsComponent.defaultProps = {
        rendering: 'canvas',
        rotation: 0,
        animateData: true,
        showLegend: false,
        debug: false,
        baseThemeType: theme_1.BaseThemeTypes.Light,
        tooltip: {
            type: exports.DEFAULT_TOOLTIP_TYPE,
            snap: exports.DEFAULT_TOOLTIP_SNAP,
        },
        showLegendDisplayValue: true,
    };
    return SettingsComponent;
}(react_1.PureComponent));
exports.SettingsComponent = SettingsComponent;
exports.Settings = mobx_react_1.inject('chartStore')(SettingsComponent);
//# sourceMappingURL=settings.js.map