import { constant } from './function';
export function fromApplicative(F) {
    const f = (a) => (b) => [a, b];
    return {
        URI: F.URI,
        map: F.map,
        unit: () => F.of(undefined),
        mult: (fa, fb) => F.ap(F.map(fa, f), fb)
    };
}
export function toApplicative(M) {
    return {
        URI: M.URI,
        map: M.map,
        of: a => M.map(M.unit(), constant(a)),
        ap: (fab, fa) => M.map(M.mult(fab, fa), ([f, a]) => f(a))
    };
}
