/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class CheckboxAction
extends ToggleAction
implements CustomComponentAction {
    protected CheckboxAction() {
    }

    protected CheckboxAction(String text) {
        super(text);
    }

    protected CheckboxAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            CheckboxAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            CheckboxAction.$$$reportNull$$$0(1);
        }
        JBCheckBox checkBox = new JBCheckBox();
        checkBox.setFocusable(false);
        this.updateCustomComponent(checkBox, presentation);
        JComponent jComponent = CheckboxAction.createCheckboxComponent(checkBox, this, place);
        if (jComponent == null) {
            CheckboxAction.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CheckboxAction.$$$reportNull$$$0(3);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        JComponent property = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (property instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)property;
            this.updateCustomComponent(checkBox, presentation);
        }
    }

    protected void updateCustomComponent(JCheckBox checkBox, Presentation presentation) {
        CheckboxAction.updateCheckboxPresentation(checkBox, presentation);
        checkBox.setSelected(Boolean.TRUE.equals(presentation.getClientProperty("selected")));
    }

    static void updateCheckboxPresentation(JCheckBox checkBox, Presentation presentation) {
        checkBox.setText(presentation.getText());
        checkBox.setToolTipText(presentation.getDescription());
        checkBox.setMnemonic(presentation.getMnemonic());
        checkBox.setDisplayedMnemonicIndex(presentation.getDisplayedMnemonicIndex());
        checkBox.setEnabled(presentation.isEnabled());
        checkBox.setVisible(presentation.isVisible());
    }

    @NotNull
    static JComponent createCheckboxComponent(@NotNull JCheckBox checkBox, final @NotNull AnAction action, final @NotNull String place) {
        if (checkBox == null) {
            CheckboxAction.$$$reportNull$$$0(4);
        }
        if (action == null) {
            CheckboxAction.$$$reportNull$$$0(5);
        }
        if (place == null) {
            CheckboxAction.$$$reportNull$$$0(6);
        }
        checkBox.setOpaque(false);
        checkBox.setBorder((Border)JBUI.Borders.emptyRight((int)9));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                ActionToolbar actionToolbar = (ActionToolbar)ComponentUtil.getParentOfType(ActionToolbar.class, (Component)checkBox);
                DataContext dataContext = actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext(checkBox);
                KeyEvent inputEvent = new KeyEvent(checkBox, 401, System.currentTimeMillis(), 0, 32, ' ');
                AnActionEvent event = AnActionEvent.createFromAnAction(action, inputEvent, place, dataContext);
                ActionUtil.performActionDumbAwareWithCallbacks(action, event, dataContext);
            }
        });
        JCheckBox jCheckBox = checkBox;
        if (jCheckBox == null) {
            CheckboxAction.$$$reportNull$$$0(7);
        }
        return jCheckBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/CheckboxAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/CheckboxAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckboxComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCheckboxComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

