/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxEventHandlerInspection
extends XmlSuppressableInspectionTool {
    public boolean myDetectNonVoidReturnType;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxEventHandlerInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue xmlAttributeValue) {
                PsiClassType declaredType;
                super.visitXmlAttributeValue(xmlAttributeValue);
                PsiElement valueParent = xmlAttributeValue.getParent();
                if (!(valueParent instanceof XmlAttribute)) {
                    return;
                }
                XmlAttribute attribute = (XmlAttribute)valueParent;
                List eventHandlerMethods = JavaFxEventHandlerInspection.getEventHandlerMethods(attribute);
                if (eventHandlerMethods.size() == 0) {
                    return;
                }
                if (eventHandlerMethods.size() != 1) {
                    holder.registerProblem((PsiElement)xmlAttributeValue, "Ambiguous event handler name: more than one matching method found", new LocalQuickFix[0]);
                }
                if (JavaFxEventHandlerInspection.this.myDetectNonVoidReturnType) {
                    eventHandlerMethods.stream().map(PsiMethod::getReturnType).filter(returnType -> !PsiType.VOID.equals(returnType)).findAny().ifPresent(ignored -> holder.registerProblem((PsiElement)xmlAttributeValue, "Return type of event handler should be void", new LocalQuickFix[0]));
                }
                if ((declaredType = JavaFxPsiUtil.getDeclaredEventType(attribute)) == null) {
                    return;
                }
                for (PsiMethod method : eventHandlerMethods) {
                    PsiClassType expectedRawType;
                    PsiType actualType;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != 1 || !((actualType = parameters[0].getType()) instanceof PsiClassType) || actualType.isAssignableFrom((PsiType)declaredType)) continue;
                    ChangeParameterTypeQuickFix parameterTypeFix = new ChangeParameterTypeQuickFix(attribute, method, (PsiType)declaredType);
                    PsiClassType actualRawType = ((PsiClassType)actualType).rawType();
                    if (actualRawType.isAssignableFrom((PsiType)(expectedRawType = declaredType.rawType()))) {
                        ArrayList<ChangeParameterTypeQuickFix> quickFixes = new ArrayList<ChangeParameterTypeQuickFix>();
                        quickFixes.add(parameterTypeFix);
                        JavaFxEventHandlerInspection.collectFieldTypeFixes(attribute, (PsiClassType)actualType, quickFixes);
                        holder.registerProblem((PsiElement)xmlAttributeValue, "Incompatible generic parameter of event handler argument: " + actualType.getCanonicalText() + " is not assignable from " + declaredType.getCanonicalText(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                        continue;
                    }
                    holder.registerProblem((PsiElement)xmlAttributeValue, "Incompatible event handler argument: " + actualRawType.getCanonicalText() + " is not assignable from " + expectedRawType.getCanonicalText(), new LocalQuickFix[]{parameterTypeFix});
                }
            }
        };
        if (xmlElementVisitor == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(3);
        }
        return xmlElementVisitor;
    }

    @NotNull
    private static List<PsiMethod> getEventHandlerMethods(@NotNull XmlAttribute attribute) {
        PsiClass controllerClass;
        if (attribute == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(4);
        }
        if ((controllerClass = JavaFxPsiUtil.getControllerClass(attribute.getContainingFile())) == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                JavaFxEventHandlerInspection.$$$reportNull$$$0(5);
            }
            return list;
        }
        String valueText = attribute.getValue();
        if (valueText == null || !valueText.startsWith("#")) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                JavaFxEventHandlerInspection.$$$reportNull$$$0(6);
            }
            return list;
        }
        String eventHandlerMethodName = valueText.substring(1);
        List<PsiMethod> list = Arrays.stream(controllerClass.findMethodsByName(eventHandlerMethodName, true)).filter(method -> !method.hasModifierProperty("static") && JavaFxPsiUtil.isVisibleInFxml((PsiMember)method)).filter(JavaFxEventHandlerInspection::hasEventArgument).collect(Collectors.toList());
        if (list == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean hasEventArgument(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(8);
        }
        return (parameters = method.getParameterList().getParameters()).length == 0 || parameters.length == 1 && InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"javafx.event.Event");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Detect event handler method having non-void return type", (InspectionProfileEntry)this, "myDetectNonVoidReturnType");
    }

    private static void collectFieldTypeFixes(@NotNull XmlAttribute attribute, @NotNull PsiClassType eventType, @NotNull List<LocalQuickFix> quickFixes) {
        XmlTag xmlTag;
        if (attribute == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(9);
        }
        if (eventType == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(11);
        }
        if ((xmlTag = attribute.getParent()) == null) {
            return;
        }
        XmlAttribute idAttribute = xmlTag.getAttribute("fx:id");
        if (idAttribute == null) {
            return;
        }
        XmlAttributeValue idValue = idAttribute.getValueElement();
        if (idValue == null) {
            return;
        }
        PsiReference reference = idValue.getReference();
        if (reference == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiField)) {
            return;
        }
        PsiField tagField = (PsiField)element;
        if (tagField.hasModifierProperty("static") || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)tagField)) {
            return;
        }
        PsiType tagFieldType = tagField.getType();
        if (!(tagFieldType instanceof PsiClassType)) {
            return;
        }
        PsiClassType rawFieldType = ((PsiClassType)tagFieldType).rawType();
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)eventType);
        PsiClass eventClass = resolveResult.getElement();
        if (eventClass == null) {
            return;
        }
        PsiSubstitutor eventSubstitutor = resolveResult.getSubstitutor();
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)eventClass)) {
            PsiType eventTypeArgument = eventSubstitutor.substitute(typeParameter);
            PsiClassType rawEventArgument = eventTypeArgument instanceof PsiClassType ? ((PsiClassType)eventTypeArgument).rawType() : null;
            if (!rawFieldType.equals((Object)rawEventArgument)) continue;
            List fixes = HighlightFixUtil.getChangeVariableTypeFixes((PsiVariable)tagField, (PsiType)eventTypeArgument);
            for (IntentionAction action : fixes) {
                if (!(action instanceof LocalQuickFix)) continue;
                quickFixes.add((LocalQuickFix)action);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventHandlerMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEventHandlerMethods";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasEventArgument";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldTypeFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeParameterTypeQuickFix
    extends LocalQuickFixOnPsiElement {
        final String myText;

        ChangeParameterTypeQuickFix(@NotNull XmlAttribute attribute, @NotNull PsiMethod method, @NotNull PsiType suggestedParameterType) {
            if (attribute == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (method == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (suggestedParameterType == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(2);
            }
            super((PsiElement)attribute);
            this.myText = "Change parameter type of '" + JavaHighlightUtil.formatMethod((PsiMethod)method) + "' to " + suggestedParameterType.getPresentableText();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Change parameter type of event handler method" == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(4);
            }
            return "Change parameter type of event handler method";
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (file == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(6);
            }
            if (startElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(7);
            }
            if (endElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(8);
            }
            return startElement instanceof XmlAttribute;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(9);
            }
            if (file == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(10);
            }
            if (startElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(11);
            }
            if (endElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(12);
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            if (!(startElement instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)startElement;
            List eventHandlerMethods = JavaFxEventHandlerInspection.getEventHandlerMethods(attribute);
            if (eventHandlerMethods.size() != 1) {
                return;
            }
            PsiMethod method = (PsiMethod)eventHandlerMethods.get(0);
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                return;
            }
            String parameterName = parameters[0].getName();
            PsiClassType declaredType = JavaFxPsiUtil.getDeclaredEventType(attribute);
            if (declaredType == null) {
                return;
            }
            ParameterInfoImpl parameterInfo = new ParameterInfoImpl(0, parameterName, (PsiType)declaredType);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), new ParameterInfoImpl[]{parameterInfo});
                processor.run();
            } else {
                List<ParameterInfoImpl> parameterInfos = Collections.singletonList(parameterInfo);
                JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew((Project)project, (PsiMethod)method, parameterInfos, (boolean)false, null);
                dialog.setParameterInfos(parameterInfos);
                dialog.show();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestedParameterType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

