/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtilRt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxEntryPoint
extends EntryPoint {
    public static final String INITIALIZE_METHOD_NAME = "initialize";
    public boolean ADD_JAVAFX_TO_ENTRIES = true;

    @NotNull
    public String getDisplayName() {
        if ("JavaFX Applications" == null) {
            JavaFxEntryPoint.$$$reportNull$$$0(0);
        }
        return "JavaFX Applications";
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            JavaFxEntryPoint.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            JavaFxEntryPoint.$$$reportNull$$$0(2);
        }
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaFxEntryPoint.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            int paramsCount = method.getParameterList().getParametersCount();
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (paramsCount == 1 && PsiType.VOID.equals((Object)method.getReturnType()) && "start".equals(methodName)) {
                return InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)true, (String)"javafx.application.Application");
            }
            if (paramsCount == 0 && INITIALIZE_METHOD_NAME.equals(methodName) && method.hasModifierProperty("public") && containingClass != null && JavaFxPsiUtil.isControllerClass(containingClass)) {
                return true;
            }
        } else if (psiElement instanceof PsiClass) {
            return InheritanceUtil.isInheritor((PsiClass)((PsiClass)psiElement), (boolean)true, (String)"javafx.application.Application");
        }
        return false;
    }

    public boolean isSelected() {
        return this.ADD_JAVAFX_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_JAVAFX_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_JAVAFX_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/JavaFxEntryPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/JavaFxEntryPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

