/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeConcatenationQuickFix
extends I18nizeQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeConcatenationQuickFix");
    @NonNls
    private static final String PARAMETERS_OPTION_KEY = "PARAMETERS";

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiFile, editor);
        if (concatenation != null) {
            return;
        }
        String message = CodeInsightBundle.message((String)"quickfix.i18n.concatentation.error", (Object[])new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiFile, editor);
        PsiLiteralExpression literalExpression = I18nizeConcatenationQuickFix.getContainingLiteral(concatenation);
        if (literalExpression == null) {
            return null;
        }
        return this.createDialog(project, psiFile, literalExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"quickfix.i18n.concatentation", (Object[])new Object[0]);
        if (string == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected PsiElement doReplacementInJava(@NotNull PsiFile psiFile, @NotNull Editor editor, @Nullable PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        if (psiFile == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(2);
        }
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiFile, editor);
        PsiExpression expression = JavaPsiFacade.getInstance((Project)psiFile.getProject()).getElementFactory().createExpressionFromText(i18nizedText, (PsiElement)concatenation);
        return concatenation.replace((PsiElement)expression);
    }

    private static String composeParametersText(List<PsiExpression> args) {
        return args.stream().map(PsiElement::getText).collect(Collectors.joining(","));
    }

    @Override
    protected JavaI18nizeQuickFixDialog createDialog(Project project, PsiFile context, PsiLiteralExpression literalExpression) {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation((PsiElement)literalExpression);
        StringBuilder formatString = new StringBuilder();
        final ArrayList args = new ArrayList();
        try {
            PsiConcatenationUtil.buildFormatString((PsiExpression)concatenation, (StringBuilder)formatString, args, (boolean)false);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return new JavaI18nizeQuickFixDialog(project, context, literalExpression, formatString.toString(), null, true, true){

            @Override
            @Nullable
            protected String getTemplateName() {
                return this.myResourceBundleManager.getConcatenationTemplateName();
            }

            @Override
            protected String generateText(I18nizedTextGenerator textGenerator, String propertyKey, PropertiesFile propertiesFile, PsiLiteralExpression literalExpression) {
                return textGenerator.getI18nizedConcatenationText(propertyKey, I18nizeConcatenationQuickFix.composeParametersText(args), propertiesFile, literalExpression);
            }

            @Override
            public PsiExpression[] getParameters() {
                return args.toArray(PsiExpression.EMPTY_ARRAY);
            }

            @Override
            protected void addAdditionalAttributes(Map<String, String> attributes) {
                attributes.put(I18nizeConcatenationQuickFix.PARAMETERS_OPTION_KEY, I18nizeConcatenationQuickFix.composeParametersText(args));
            }
        };
    }

    @Nullable
    private static PsiPolyadicExpression getEnclosingLiteralConcatenation(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(4);
        }
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        return I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(elementAt);
    }

    @Nullable
    static PsiPolyadicExpression getEnclosingLiteralConcatenation(PsiElement psiElement) {
        PsiPolyadicExpression element = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiPolyadicExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (element == null) {
            return null;
        }
        PsiPolyadicExpression concatenation = null;
        boolean stringLiteralOccured = false;
        while (element.getOperationTokenType() == JavaTokenType.PLUS) {
            PsiElement parent;
            for (PsiExpression operand : element.getOperands()) {
                if (stringLiteralOccured |= operand instanceof PsiLiteralExpression && ((PsiLiteralExpression)operand).getValue() instanceof String) break;
            }
            if (stringLiteralOccured) {
                concatenation = element;
            }
            if (!((parent = element.getParent()) instanceof PsiPolyadicExpression)) {
                return concatenation;
            }
            element = (PsiPolyadicExpression)parent;
        }
        return concatenation;
    }

    private static PsiLiteralExpression getContainingLiteral(PsiPolyadicExpression concatenation) {
        for (PsiExpression operand : concatenation.getOperands()) {
            if (!(operand instanceof PsiLiteralExpression)) continue;
            return (PsiLiteralExpression)operand;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doReplacementInJava";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingLiteralConcatenation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

