/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.externalAnnotation.NonNlsAnnotationProvider;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.SuppressByCommentOutAction;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nInspection
extends AbstractBaseJavaLocalInspectionTool
implements CustomSuppressableInspectionTool {
    public boolean ignoreForAssertStatements = true;
    public boolean ignoreForExceptionConstructors = true;
    @NonNls
    public String ignoreForSpecifiedExceptionConstructors = "";
    public boolean ignoreForJUnitAsserts = true;
    public boolean ignoreForClassReferences = true;
    public boolean ignoreForPropertyKeyReferences = true;
    public boolean ignoreForNonAlpha = true;
    public boolean ignoreAssignedToConstants;
    public boolean ignoreToString;
    @NonNls
    public String nonNlsCommentPattern = "NON-NLS";
    private boolean ignoreForEnumConstants;
    @Nullable
    private Pattern myCachedNonNlsPattern;
    @NonNls
    private static final String TO_STRING = "toString";
    private static final String SKIP_FOR_ENUM = "ignoreForEnumConstant";

    public I18nInspection() {
        this.cacheNonNlsCommentPattern();
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(PsiElement element) {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.getShortName());
        assert (key != null) : "No key for '" + this.getShortName() + "' / " + ((Object)((Object)this)).getClass();
        Object[] defaultSuppressors = SuppressManager.getInstance().createSuppressActions(key);
        if (this.myCachedNonNlsPattern == null) {
            if (defaultSuppressors == null) {
                I18nInspection.$$$reportNull$$$0(0);
            }
            return defaultSuppressors;
        }
        ArrayList<SuppressByCommentOutAction> suppressors = new ArrayList<SuppressByCommentOutAction>(defaultSuppressors.length + 1);
        suppressors.add(new SuppressByCommentOutAction(this.nonNlsCommentPattern));
        ContainerUtil.addAll(suppressors, (Object[])defaultSuppressors);
        SuppressIntentionAction[] suppressIntentionActionArray = suppressors.toArray(SuppressIntentionAction.EMPTY_ARRAY);
        if (suppressIntentionActionArray == null) {
            I18nInspection.$$$reportNull$$$0(1);
        }
        return suppressIntentionActionArray;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(2);
        }
        super.writeSettings(node);
        if (this.ignoreForEnumConstants) {
            Element e = new Element("option");
            e.setAttribute("name", SKIP_FOR_ENUM);
            e.setAttribute("value", Boolean.toString(this.ignoreForEnumConstants));
            node.addContent(e);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Object o : node.getChildren()) {
            if (!(o instanceof Element) || !Comparing.strEqual((String)((Element)o).getAttributeValue("name"), (String)SKIP_FOR_ENUM)) continue;
            String ignoreForConstantsAttr = ((Element)o).getAttributeValue("value");
            if (ignoreForConstantsAttr == null) break;
            this.ignoreForEnumConstants = Boolean.parseBoolean(ignoreForConstantsAttr);
            break;
        }
        this.cacheNonNlsCommentPattern();
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.INTERNATIONALIZATION_GROUP_NAME;
        if (string == null) {
            I18nInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = CodeInsightBundle.message((String)"inspection.i18n.display.name", (Object[])new Object[0]);
        if (string == null) {
            I18nInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HardCodedStringLiteral" == null) {
            I18nInspection.$$$reportNull$$$0(6);
        }
        return "HardCodedStringLiteral";
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        final JCheckBox assertStatementsCheckbox = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.assert", (Object[])new Object[0]), this.ignoreForAssertStatements);
        assertStatementsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForAssertStatements = assertStatementsCheckbox.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$1", "stateChanged"));
            }
        });
        final JCheckBox exceptionConstructorCheck = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.for.exception.constructor.arguments", (Object[])new Object[0]), this.ignoreForExceptionConstructors);
        exceptionConstructorCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForExceptionConstructors = exceptionConstructorCheck.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$2", "stateChanged"));
            }
        });
        final JTextField specifiedExceptions = new JTextField(this.ignoreForSpecifiedExceptionConstructors);
        specifiedExceptions.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForSpecifiedExceptionConstructors = specifiedExceptions.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$3", "textChanged"));
            }
        });
        final JCheckBox junitAssertCheckbox = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.for.junit.assert.arguments", (Object[])new Object[0]), this.ignoreForJUnitAsserts);
        junitAssertCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForJUnitAsserts = junitAssertCheckbox.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$4", "stateChanged"));
            }
        });
        final JCheckBox classRef = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.qualified.class.names", (Object[])new Object[0]), this.ignoreForClassReferences);
        classRef.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForClassReferences = classRef.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$5", "stateChanged"));
            }
        });
        final JCheckBox propertyRef = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.property.keys", (Object[])new Object[0]), this.ignoreForPropertyKeyReferences);
        propertyRef.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForPropertyKeyReferences = propertyRef.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$6", "stateChanged"));
            }
        });
        final JCheckBox nonAlpha = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.nonalphanumerics", (Object[])new Object[0]), this.ignoreForNonAlpha);
        nonAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForNonAlpha = nonAlpha.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$7", "stateChanged"));
            }
        });
        final JCheckBox assignedToConstants = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.assigned.to.constants", (Object[])new Object[0]), this.ignoreAssignedToConstants);
        assignedToConstants.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreAssignedToConstants = assignedToConstants.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$8", "stateChanged"));
            }
        });
        final JCheckBox chkToString = new JCheckBox(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.tostring", (Object[])new Object[0]), this.ignoreToString);
        chkToString.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreToString = chkToString.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$9", "stateChanged"));
            }
        });
        final JCheckBox ignoreEnumConstants = new JCheckBox("Ignore enum constants", this.ignoreForEnumConstants);
        ignoreEnumConstants.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForEnumConstants = ignoreEnumConstants.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$10", "stateChanged"));
            }
        });
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets.bottom = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panel.add((Component)assertStatementsCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)junitAssertCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)exceptionConstructorCheck, gc);
        ++gc.gridy;
        final Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        panel.add((Component)new FieldPanel(specifiedExceptions, null, CodeInsightBundle.message((String)"inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", (Object[])new Object[0]), openProjects.length == 0 ? null : new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                I18nInspection.this.createIgnoreExceptionsConfigurationDialog(openProjects[0], specifiedExceptions).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$11", "actionPerformed"));
            }
        }, null), gc);
        ++gc.gridy;
        panel.add((Component)classRef, gc);
        ++gc.gridy;
        panel.add((Component)propertyRef, gc);
        ++gc.gridy;
        panel.add((Component)assignedToConstants, gc);
        ++gc.gridy;
        panel.add((Component)chkToString, gc);
        ++gc.gridy;
        panel.add((Component)nonAlpha, gc);
        ++gc.gridy;
        panel.add((Component)ignoreEnumConstants, gc);
        ++gc.gridy;
        gc.anchor = 18;
        gc.weighty = 1.0;
        JTextField text = new JTextField(this.nonNlsCommentPattern);
        FieldPanel nonNlsCommentPatternComponent = new FieldPanel(text, CodeInsightBundle.message((String)"inspection.i18n.option.ignore.comment.pattern", (Object[])new Object[0]), CodeInsightBundle.message((String)"inspection.i18n.option.ignore.comment.title", (Object[])new Object[0]), null, () -> {
            this.nonNlsCommentPattern = text.getText();
            this.cacheNonNlsCommentPattern();
        });
        panel.add((Component)nonNlsCommentPatternComponent, gc);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        scrollPane.setPreferredSize(new Dimension(panel.getPreferredSize().width + scrollPane.getVerticalScrollBar().getPreferredSize().width, panel.getPreferredSize().height + scrollPane.getHorizontalScrollBar().getPreferredSize().height));
        return scrollPane;
    }

    private DialogWrapper createIgnoreExceptionsConfigurationDialog(final Project project, final JTextField specifiedExceptions) {
        return new DialogWrapper(true){
            private AddDeleteListPanel myPanel;
            {
                super(x0);
                this.setTitle(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", (Object[])new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                String[] ignored = I18nInspection.this.ignoreForSpecifiedExceptionConstructors.split(",");
                ArrayList<String> initialList = new ArrayList<String>();
                for (String e : ignored) {
                    if (e.isEmpty()) continue;
                    initialList.add(e);
                }
                this.myPanel = new AddDeleteListPanel<String>(null, initialList){

                    protected String findItemToAdd() {
                        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser(CodeInsightBundle.message((String)"inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", (Object[])new Object[0]), scope, JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Throwable", scope), true, true, null);
                        chooser.showDialog();
                        PsiClass selectedClass = chooser.getSelected();
                        return selectedClass != null ? selectedClass.getQualifiedName() : null;
                    }
                };
                return this.myPanel;
            }

            protected void doOKAction() {
                Object[] exceptions;
                StringBuilder buf = new StringBuilder();
                for (Object exception : exceptions = this.myPanel.getListItems()) {
                    buf.append(",").append(exception);
                }
                specifiedExceptions.setText(buf.length() > 0 ? buf.substring(1) : buf.toString());
                super.doOKAction();
            }
        };
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Object[] descriptors;
        PsiClass containingClass;
        if (method == null) {
            I18nInspection.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(8);
        }
        if ((containingClass = method.getContainingClass()) == null || I18nInspection.isClassNonNls(containingClass)) {
            return null;
        }
        ArrayList results = new ArrayList();
        PsiCodeBlock body = method.getBody();
        if (body != null && (descriptors = this.checkElement((PsiElement)body, manager, isOnTheFly)) != null) {
            ContainerUtil.addAll(results, (Object[])descriptors);
        }
        this.checkAnnotations((PsiModifierListOwner)method, manager, isOnTheFly, results);
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            this.checkAnnotations((PsiModifierListOwner)parameter, manager, isOnTheFly, results);
        }
        return results.isEmpty() ? null : results.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            I18nInspection.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(10);
        }
        if (I18nInspection.isClassNonNls(aClass)) {
            return null;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        ArrayList result = new ArrayList();
        for (PsiClassInitializer initializer : initializers) {
            Object[] descriptors = this.checkElement((PsiElement)initializer.getBody(), manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
        this.checkAnnotations((PsiModifierListOwner)aClass, manager, isOnTheFly, result);
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void checkAnnotations(PsiModifierListOwner member, @NotNull InspectionManager manager, boolean isOnTheFly, List<? super ProblemDescriptor> result) {
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(11);
        }
        for (PsiAnnotation annotation : member.getAnnotations()) {
            Object[] descriptors = this.checkElement((PsiElement)annotation, manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Object[] descriptors;
        PsiClass containingClass;
        if (field == null) {
            I18nInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(13);
        }
        if ((containingClass = field.getContainingClass()) == null || I18nInspection.isClassNonNls(containingClass)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)"org.jetbrains.annotations.NonNls", (int)2)) {
            return null;
        }
        ArrayList result = new ArrayList();
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            Object[] descriptors2 = this.checkElement((PsiElement)initializer, manager, isOnTheFly);
            if (descriptors2 != null) {
                ContainerUtil.addAll(result, (Object[])descriptors2);
            }
        } else if (field instanceof PsiEnumConstant && (descriptors = this.checkElement((PsiElement)((PsiEnumConstant)field).getArgumentList(), manager, isOnTheFly)) != null) {
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
        this.checkAnnotations((PsiModifierListOwner)field, manager, isOnTheFly, result);
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    public String getAlternativeID() {
        return "nls";
    }

    private ProblemDescriptor[] checkElement(@NotNull PsiElement element, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (element == null) {
            I18nInspection.$$$reportNull$$$0(14);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(15);
        }
        StringI18nVisitor visitor = new StringI18nVisitor(manager, isOnTheFly);
        element.accept((PsiElementVisitor)visitor);
        List problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private static LocalQuickFix createIntroduceConstantFix() {
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = IntroduceConstantHandler.REFACTORING_NAME;
                if (string == null) {
                    13.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project == null) {
                    13.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    13.$$$reportNull$$$0(2);
                }
                if (!((element = descriptor.getPsiElement()) instanceof PsiExpression)) {
                    return;
                }
                PsiExpression[] expressions = new PsiExpression[]{(PsiExpression)element};
                new IntroduceConstantHandler().invoke(project, expressions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection$13";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection$13";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (localQuickFix == null) {
            I18nInspection.$$$reportNull$$$0(16);
        }
        return localQuickFix;
    }

    private boolean canBeI18ned(@NotNull Project project, @NotNull PsiLiteralExpression expression, @NotNull String value, @NotNull Set<? super PsiModifierListOwner> nonNlsTargets) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(17);
        }
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(18);
        }
        if (value == null) {
            I18nInspection.$$$reportNull$$$0(19);
        }
        if (nonNlsTargets == null) {
            I18nInspection.$$$reportNull$$$0(20);
        }
        if (this.ignoreForNonAlpha && !StringUtil.containsAlphaCharacters((String)value)) {
            return false;
        }
        if (JavaI18nUtil.isPassedToAnnotatedParam((PsiExpression)expression, "org.jetbrains.annotations.NonNls", null, nonNlsTargets)) {
            return false;
        }
        if (I18nInspection.isInNonNlsCall((PsiExpression)expression, nonNlsTargets)) {
            return false;
        }
        if (I18nInspection.isInNonNlsEquals((PsiExpression)expression, nonNlsTargets)) {
            return false;
        }
        if (this.isPassedToNonNlsVariable(expression, nonNlsTargets)) {
            return false;
        }
        if (JavaI18nUtil.mustBePropertyKey((PsiExpression)expression, null)) {
            return false;
        }
        if (I18nInspection.isReturnedFromNonNlsMethod(expression, nonNlsTargets)) {
            return false;
        }
        if (this.ignoreForAssertStatements && I18nInspection.isArgOfAssertStatement((PsiExpression)expression)) {
            return false;
        }
        if (this.ignoreForExceptionConstructors && ExceptionUtils.isExceptionArgument((PsiExpression)expression)) {
            return false;
        }
        if (this.ignoreForEnumConstants && I18nInspection.isArgOfEnumConstant(expression)) {
            return false;
        }
        if (!this.ignoreForExceptionConstructors && I18nInspection.isArgOfSpecifiedExceptionConstructor((PsiExpression)expression, this.ignoreForSpecifiedExceptionConstructors.split(","))) {
            return false;
        }
        if (this.ignoreForJUnitAsserts && I18nInspection.isArgOfJUnitAssertion((PsiExpression)expression)) {
            return false;
        }
        if (this.ignoreForClassReferences && I18nInspection.isClassRef(expression, value)) {
            return false;
        }
        if (this.ignoreForPropertyKeyReferences && JavaI18nUtil.isPropertyRef((PsiExpression)expression, value, null)) {
            return false;
        }
        if (this.ignoreToString && I18nInspection.isToString(expression)) {
            return false;
        }
        Pattern pattern = this.myCachedNonNlsPattern;
        if (pattern != null) {
            PsiFile file = expression.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            int line = document.getLineNumber(expression.getTextRange().getStartOffset());
            int lineStartOffset = document.getLineStartOffset(line);
            CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line));
            Matcher matcher = pattern.matcher(lineText);
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.start();
                PsiElement element = file.findElementAt(lineStartOffset + start);
                if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return false;
                }
                if (start == lineText.length() - 1) break;
                ++start;
            }
        }
        return true;
    }

    private static boolean isArgOfEnumConstant(PsiLiteralExpression expression) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiExpressionList.class, PsiClass.class});
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandparent = parent.getParent();
        return grandparent instanceof PsiEnumConstant;
    }

    public void cacheNonNlsCommentPattern() {
        this.myCachedNonNlsPattern = this.nonNlsCommentPattern.trim().isEmpty() ? null : Pattern.compile(this.nonNlsCommentPattern);
    }

    private static boolean isClassRef(PsiLiteralExpression expression, String value) {
        if (StringUtil.startsWithChar((CharSequence)value, (char)'#')) {
            value = value.substring(1);
        }
        return JavaPsiFacade.getInstance((Project)expression.getProject()).findClass(value, GlobalSearchScope.allScope((Project)expression.getProject())) != null;
    }

    private static boolean isClassNonNls(@NotNull PsiClass clazz) {
        PsiDirectory directory;
        if (clazz == null) {
            I18nInspection.$$$reportNull$$$0(21);
        }
        return (directory = clazz.getContainingFile().getContainingDirectory()) != null && I18nInspection.isPackageNonNls(JavaDirectoryService.getInstance().getPackage(directory));
    }

    public static boolean isPackageNonNls(PsiPackage psiPackage) {
        if (psiPackage == null || psiPackage.getName() == null) {
            return false;
        }
        PsiModifierList pkgModifierList = psiPackage.getAnnotationList();
        return pkgModifierList != null && pkgModifierList.hasAnnotation("org.jetbrains.annotations.NonNls") || I18nInspection.isPackageNonNls(psiPackage.getParentPackage());
    }

    private boolean isPassedToNonNlsVariable(@NotNull PsiLiteralExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(22);
        }
        PsiExpression toplevel = JavaI18nUtil.getTopLevelExpression((PsiExpression)expression);
        PsiVariable var = null;
        if (toplevel instanceof PsiAssignmentExpression) {
            PsiElement resolved;
            PsiExpression lExpression = ((PsiAssignmentExpression)toplevel).getLExpression();
            while (lExpression instanceof PsiArrayAccessExpression) {
                lExpression = ((PsiArrayAccessExpression)lExpression).getArrayExpression();
            }
            if (lExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
                var = (PsiVariable)resolved;
            }
        }
        if (var == null) {
            PsiElement resolved;
            PsiExpression switchStatementExpression;
            PsiSwitchStatement switchStatement;
            PsiElement parent = toplevel.getParent();
            if (parent instanceof PsiVariable && toplevel.equals(((PsiVariable)parent).getInitializer())) {
                var = (PsiVariable)parent;
            } else if (parent instanceof PsiExpressionList && (parent = parent.getParent()) instanceof PsiSwitchLabelStatementBase && (switchStatement = ((PsiSwitchLabelStatementBase)parent).getEnclosingSwitchStatement()) != null && (switchStatementExpression = switchStatement.getExpression()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)switchStatementExpression).resolve()) instanceof PsiVariable) {
                var = (PsiVariable)resolved;
            }
        }
        if (var != null) {
            if (I18nInspection.annotatedAsNonNls(var)) {
                return true;
            }
            if (this.ignoreAssignedToConstants && var.hasModifierProperty("static") && var.hasModifierProperty("final")) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)var);
        }
        return false;
    }

    private static boolean annotatedAsNonNls(PsiModifierListOwner parent) {
        PsiParameter parameter;
        PsiElement declarationScope;
        if (parent instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            int index = method.getParameterList().getParameterIndex(parameter);
            return JavaI18nUtil.isMethodParameterAnnotatedWith(method, index, null, "org.jetbrains.annotations.NonNls", null, null);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)parent, (String)"org.jetbrains.annotations.NonNls", (int)2);
    }

    private static boolean isInNonNlsEquals(PsiExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiElement resolvedEntity;
        PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression);
        if (call == null || !MethodCallUtils.isEqualsCall((PsiMethodCallExpression)call)) {
            return false;
        }
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length != 1) {
            return false;
        }
        PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions[0]);
        PsiReferenceExpression ref = null;
        if (arg instanceof PsiReferenceExpression) {
            ref = (PsiReferenceExpression)arg;
        } else if (arg instanceof PsiMethodCallExpression) {
            ref = ((PsiMethodCallExpression)arg).getMethodExpression();
        }
        if (ref != null && (resolvedEntity = ref.resolve()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolvedEntity;
            if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
        }
        return false;
    }

    private static boolean isInNonNlsCall(@NotNull PsiExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiElement parent;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(23);
        }
        if ((parent = (expression = JavaI18nUtil.getTopLevelExpression(expression)).getParent()) instanceof PsiExpressionList) {
            PsiElement grParent = parent.getParent();
            if (grParent instanceof PsiMethodCallExpression) {
                return I18nInspection.isNonNlsCall((PsiMethodCallExpression)grParent, nonNlsTargets);
            }
            if (grParent instanceof PsiNewExpression) {
                PsiElement resolved;
                PsiExpression lExpression;
                PsiElement parentOfNew = PsiUtil.skipParenthesizedExprUp((PsiElement)grParent.getParent());
                if (parentOfNew instanceof PsiLocalVariable) {
                    PsiLocalVariable newVariable = (PsiLocalVariable)parentOfNew;
                    if (I18nInspection.annotatedAsNonNls((PsiModifierListOwner)newVariable)) {
                        return true;
                    }
                    nonNlsTargets.add((PsiModifierListOwner)newVariable);
                    return false;
                }
                if (parentOfNew instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parentOfNew).getLExpression()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiModifierListOwner) {
                    PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolved;
                    if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                        return true;
                    }
                    nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isNonNlsCall(PsiMethodCallExpression grParent, Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiType type;
        PsiReferenceExpression methodExpression = grParent.getMethodExpression();
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
        if (qualifier instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)qualifier).resolve();
            if (resolved instanceof PsiModifierListOwner) {
                PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolved;
                if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                    return true;
                }
                nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
                return false;
            }
        } else if (qualifier instanceof PsiMethodCallExpression && (type = qualifier.getType()) != null && type.equals(methodExpression.getType())) {
            return I18nInspection.isNonNlsCall((PsiMethodCallExpression)qualifier, nonNlsTargets);
        }
        return false;
    }

    private static boolean isReturnedFromNonNlsMethod(PsiLiteralExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiMethod method;
        PsiNameValuePair nameValuePair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiNameValuePair.class);
        if (nameValuePair != null) {
            method = AnnotationUtil.getAnnotationMethod((PsiNameValuePair)nameValuePair);
        } else {
            PsiElement returnStmt = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiReturnStatement.class, PsiMethodCallExpression.class});
            if (!(returnStmt instanceof PsiReturnStatement)) {
                return false;
            }
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
        }
        if (method == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.jetbrains.annotations.NonNls", (int)3)) {
            return true;
        }
        nonNlsTargets.add((PsiModifierListOwner)method);
        return false;
    }

    private static boolean isToString(PsiLiteralExpression expression) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
        if (method == null) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        return TO_STRING.equals(method.getName()) && method.getParameterList().isEmpty() && returnType != null && "java.lang.String".equals(returnType.getCanonicalText());
    }

    private static boolean isArgOfJUnitAssertion(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)grandparent;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (methodName == null) {
            return false;
        }
        if (!methodName.startsWith("assert") && !methodName.equals("fail")) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        Project project = expression.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass junitAssert = JavaPsiFacade.getInstance((Project)project).findClass("junit.framework.Assert", scope);
        return junitAssert != null && !containingClass.isInheritor(junitAssert, true);
    }

    private static boolean isArgOfSpecifiedExceptionConstructor(PsiExpression expression, String[] specifiedExceptions) {
        if (specifiedExceptions.length == 0) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiExpressionList.class, PsiClass.class});
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof PsiNewExpression)) {
            return false;
        }
        PsiJavaCodeReferenceElement reference = ((PsiNewExpression)grandparent).getClassReference();
        if (reference == null) {
            return false;
        }
        PsiElement referent = reference.resolve();
        if (!(referent instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)referent;
        for (String specifiedException : specifiedExceptions) {
            if (!specifiedException.equals(aClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isArgOfAssertStatement(PsiExpression expression) {
        return PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiAssertStatement.class, PsiClass.class}) instanceof PsiAssertStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonNlsTargets";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntroduceConstantFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canBeI18ned";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isClassNonNls";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPassedToNonNlsVariable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInNonNlsCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StringI18nVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final List<ProblemDescriptor> myProblems;
        private final InspectionManager myManager;
        private final boolean myOnTheFly;

        private StringI18nVisitor(InspectionManager manager, boolean onTheFly) {
            if (manager == null) {
                StringI18nVisitor.$$$reportNull$$$0(0);
            }
            this.myProblems = new ArrayList<ProblemDescriptor>();
            this.myManager = manager;
            this.myOnTheFly = onTheFly;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            this.visitElement((PsiElement)aClass);
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitField(PsiField field) {
        }

        public void visitMethod(PsiMethod method) {
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            Object value = expression.getValue();
            if (!(value instanceof String)) {
                return;
            }
            String stringValue = (String)value;
            if (stringValue.trim().isEmpty()) {
                return;
            }
            THashSet nonNlsTargets = new THashSet();
            if (I18nInspection.this.canBeI18ned(this.myManager.getProject(), expression, stringValue, (Set)nonNlsTargets)) {
                PsiField parentField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
                if (parentField != null) {
                    nonNlsTargets.add(parentField);
                }
                String description = CodeInsightBundle.message((String)"inspection.i18n.message.general.with.value", (Object[])new Object[]{"#ref"});
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation((PsiElement)expression) != null) {
                    fixes.add(new I18nizeConcatenationQuickFix());
                }
                fixes.add(new I18nizeQuickFix());
                if (!this.isNotConstantFieldInitializer((PsiExpression)expression)) {
                    fixes.add(I18nInspection.createIntroduceConstantFix());
                }
                Project project = expression.getManager().getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                    for (PsiModifierListOwner element : nonNlsTargets) {
                        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)element, (String)"org.jetbrains.annotations.Nls", (int)3) || element.getManager().isInProject((PsiElement)element) && facade.findClass("org.jetbrains.annotations.NonNls", element.getResolveScope()) == null) continue;
                        fixes.add(new NonNlsAnnotationProvider().createFix(element));
                    }
                }
                LocalQuickFix[] farr = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                ProblemDescriptor problem = this.myManager.createProblemDescriptor((PsiElement)expression, description, this.myOnTheFly, farr, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                this.myProblems.add(problem);
            }
        }

        private boolean isNotConstantFieldInitializer(PsiExpression expression) {
            PsiField parentField = expression.getParent() instanceof PsiField ? (PsiField)expression.getParent() : null;
            return parentField != null && expression == parentField.getInitializer() && parentField.hasModifierProperty("final") && parentField.hasModifierProperty("static");
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            if (!"java.lang.SuppressWarnings".equals(annotation.getQualifiedName())) {
                super.visitAnnotation(annotation);
            }
        }

        private List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/i18n/I18nInspection$StringI18nVisitor", "<init>"));
        }
    }
}

