/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            JUnitRunDashboardCustomizer.$$$reportNull$$$0(0);
        }
        return settings.getConfiguration() instanceof JUnitConfiguration;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull RunDashboardRunConfigurationNode node) {
        PsiMethod[] methods;
        RunConfiguration runConfiguration;
        if (node == null) {
            JUnitRunDashboardCustomizer.$$$reportNull$$$0(1);
        }
        if (!((runConfiguration = node.getConfigurationSettings().getConfiguration()) instanceof JUnitConfiguration)) {
            return null;
        }
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfiguration;
        String runClassName = jUnitConfiguration.getRunClass();
        if (runClassName == null) {
            return null;
        }
        PsiClass runClass = ((JavaRunConfigurationModule)jUnitConfiguration.getConfigurationModule()).findClass(runClassName);
        if (runClass == null) {
            return null;
        }
        PsiClass psiElement = runClass;
        String testMethod = jUnitConfiguration.getPersistentData().getMethodName();
        if (testMethod != null && (methods = runClass.findMethodsByName(testMethod, false)).length > 0) {
            psiElement = methods[0];
        }
        PsiClass elementToNavigate = psiElement;
        return new Navigatable((PsiElement)elementToNavigate){
            final /* synthetic */ PsiElement val$elementToNavigate;
            {
                this.val$elementToNavigate = psiElement;
            }

            public void navigate(boolean requestFocus) {
                PsiNavigateUtil.navigate((PsiElement)this.val$elementToNavigate, (boolean)requestFocus);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/JUnitRunDashboardCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

