/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcs.log.Hash;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitDiffFromHistoryHandler;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryUtils;
import git4idea.log.GitShowCommitInLogAction;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryProvider
implements VcsHistoryProviderEx,
VcsCacheableHistorySessionFactory<Boolean, VcsAbstractHistorySession>,
VcsBaseRevisionAdviser {
    private static final Logger LOG = Logger.getInstance((String)GitHistoryProvider.class.getName());
    @NotNull
    private final Project myProject;

    public GitHistoryProvider(@NotNull Project project) {
        if (project == null) {
            GitHistoryProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"), new GitShowCommitInLogAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public VcsAbstractHistorySession createFromCachedData(Boolean aBoolean, @NotNull List<? extends VcsFileRevision> revisions, @NotNull FilePath filePath, VcsRevisionNumber currentRevision) {
        if (revisions == null) {
            GitHistoryProvider.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            GitHistoryProvider.$$$reportNull$$$0(2);
        }
        return this.createSession(filePath, revisions, currentRevision);
    }

    @Nullable
    public VcsAbstractHistorySession createSessionFor(FilePath filePath) throws VcsException {
        List<VcsFileRevision> revisions;
        return this.createSession(filePath, revisions, (revisions = GitFileHistory.collectHistory(this.myProject, filePath, new String[0])).isEmpty() ? null : ((VcsFileRevision)ContainerUtil.getFirstItem(revisions)).getRevisionNumber());
    }

    private VcsAbstractHistorySession createSession(final FilePath filePath, List<? extends VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        return new VcsAbstractHistorySession(revisions, number){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                try {
                    return GitHistoryUtils.getCurrentRevision(GitHistoryProvider.this.myProject, filePath, "HEAD");
                }
                catch (VcsException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to retrieve the current revision number", (Throwable)e);
                    }
                    return null;
                }
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return GitHistoryProvider.this.createSession(filePath, this.getRevisionList(), this.getCurrentRevisionNumber());
            }
        };
    }

    @Nullable
    public VcsFileRevision getLastRevision(FilePath filePath) throws VcsException {
        List<VcsFileRevision> history = GitFileHistory.collectHistory(this.myProject, filePath, "--max-count=1");
        if (history.isEmpty()) {
            return null;
        }
        return history.get(0);
    }

    public boolean getBaseVersionContent(FilePath filePath, Processor<? super String> processor, String beforeVersionId) throws VcsException {
        if (StringUtil.isEmptyOrSpaces((String)beforeVersionId) || filePath.getVirtualFile() == null) {
            return false;
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(filePath);
        if (repository == null) {
            return false;
        }
        Hash hash = GitChangeUtils.commitExists(this.myProject, repository.getRoot(), beforeVersionId, null, "HEAD");
        if (hash == null) {
            throw new VcsException("Can not apply patch to " + filePath.getPath() + ".\nCan not find revision '" + beforeVersionId + "'.");
        }
        ContentRevision content = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)new GitRevisionNumber(hash.asString()), this.myProject);
        return !processor.process((Object)content.getContent());
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) {
        this.reportAppendableHistory(path, null, partner);
    }

    public void reportAppendableHistory(@NotNull FilePath path, @Nullable VcsRevisionNumber startingRevision, @NotNull VcsAppendableHistorySessionPartner partner) {
        String[] stringArray;
        if (path == null) {
            GitHistoryProvider.$$$reportNull$$$0(3);
        }
        if (partner == null) {
            GitHistoryProvider.$$$reportNull$$$0(4);
        }
        VcsAbstractHistorySession emptySession = this.createSession(path, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (vcsConfiguration.LIMIT_HISTORY) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--max-count=" + vcsConfiguration.MAXIMUM_HISTORY_ROWS;
        } else {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] additionalArgs = stringArray;
        GitFileHistory.loadHistory(this.myProject, path, startingRevision, (Consumer<? super GitFileRevision>)((Consumer)fileRevision -> partner.acceptRevision((VcsFileRevision)fileRevision)), (Consumer<? super VcsException>)((Consumer)exception -> partner.reportException(exception)), additionalArgs);
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new GitDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        GitRepositoryManager manager;
        GitRepository repository;
        if (file == null) {
            GitHistoryProvider.$$$reportNull$$$0(5);
        }
        return (repository = (GitRepository)(manager = GitUtil.getRepositoryManager(this.myProject)).getRepositoryForFileQuick(file)) != null && !repository.isFresh();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "git4idea/history/GitHistoryProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromCachedData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportAppendableHistory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowHistoryFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

